/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFMediaClipData;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;

class PDFRendition
extends PDFObject {
    boolean show_controls;
    PDFMediaClipData mcd;
    String policy;
    String duration;
    float pm;
    int volume;

    PDFRendition(IndirectObject indirectObject, boolean bl, String string, float f, int n) {
        super(indirectObject);
        this.show_controls = bl;
        this.duration = string;
        this.pm = f;
        this.volume = n;
    }

    void setClipData(PDFMediaClipData pDFMediaClipData) {
        this.mcd = pDFMediaClipData;
    }

    String getType() {
        return "Rendition";
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        if (this.mcd != null) {
            pDFOutputStream.print("/C " + this.mcd.getID().toStringR());
        }
        pDFOutputStream.print("/P<</BE<<");
        if (this.show_controls) {
            pDFOutputStream.print("/C true");
        }
        if (this.duration.equals("intrinsic")) {
            pDFOutputStream.print("/D <</S/I>>");
        } else if (this.duration.equals("infinity")) {
            pDFOutputStream.print("/D <</S/F>>");
        } else {
            pDFOutputStream.print("/D <</S/T/T<</S/S/V " + this.duration + ">>>>");
        }
        pDFOutputStream.print("/RC " + this.pm);
        pDFOutputStream.print("/V " + this.volume);
        pDFOutputStream.print(">>>>/S/MR");
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        if (this.mcd != null) {
            this.mcd.write(pDFOutputStream);
        }
    }
}

