/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.Encoding;
import com.renderx.fonts.FontDescriptor;
import com.renderx.fonts.Metric;
import com.renderx.pdflib.CMap;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFEncoding;
import com.renderx.pdflib.PDFException;
import com.renderx.pdflib.PDFFont;
import com.renderx.pdflib.PDFFontDescriptor;
import com.renderx.pdflib.PDFOutputStream;

public abstract class OneByteFont
extends PDFFont {
    CMap cmap;
    PDFFontDescriptor pdfFontDescriptor;
    PDFEncoding pdfEncoding;

    OneByteFont(IndirectObject indirectObject, FontDescriptor fontDescriptor, int n) {
        super(indirectObject, fontDescriptor);
        this.encoding = n;
        if (this.enableSubset && fontDescriptor.record.subset && fontDescriptor.record.embed) {
            this.subsetName();
        }
    }

    abstract String getSubType();

    String getEncoding(Encoding encoding) {
        String string = null;
        switch (encoding.encoding_type) {
            case 2: {
                string = "/WinAnsiEncoding";
                break;
            }
            case 3: {
                string = "/MacRomanEncoding";
                break;
            }
            case 4: {
                string = "/MacExpertEncoding";
                break;
            }
            case 0: {
                string = this.pdfEncoding.getID().toStringR();
                break;
            }
            case 1: {
                break;
            }
        }
        return string;
    }

    void writeEncoding(PDFOutputStream pDFOutputStream, Encoding encoding) {
        if (encoding.encoding_type != 1) {
            if (encoding.encoding_type == 0) {
                this.pdfEncoding = new PDFEncoding(pDFOutputStream.getNextID(), encoding);
            }
            pDFOutputStream.println("/Encoding " + this.getEncoding(encoding));
        }
    }

    void writeAddInfo(PDFOutputStream pDFOutputStream) {
        int n;
        int n2;
        int n3;
        Metric metric = this.descriptor.record.getMetric();
        Encoding encoding = (Encoding)this.descriptor.encodingTable.get(this.encoding);
        Encoding encoding2 = null;
        if (!this.descriptor.record.subset && this.encoding == 0) {
            encoding2 = encoding;
        } else {
            encoding2 = new Encoding();
            encoding2.encoding_type = encoding.encoding_type;
            n3 = 0;
            n2 = 0;
            while (n2 < 256) {
                n = encoding.byte2uni[n2];
                if (n != 0 && this.descriptor.used.checkGlyph((char)n)) {
                    encoding2.uni2byte.put((char)n, new Integer(n2));
                    encoding2.table[n2] = metric.ucm((char)n);
                    encoding2.byte2uni[n2] = n;
                    n3 = 1;
                }
                ++n2;
            }
            if (n3 == 0) {
                CharMetrics charMetrics = metric.ucm(' ');
                if (charMetrics != null || (charMetrics = metric.missingGlyph) == null) {
                    // empty if block
                }
                encoding2.assignCode(' ', charMetrics);
            }
        }
        n3 = encoding2.getFirstCode();
        n2 = encoding2.getLastCode();
        if (n3 == -1 || n2 == -1) {
            throw new PDFException("Internal error: empty encoding");
        }
        pDFOutputStream.println("/FirstChar " + n3);
        pDFOutputStream.println("/LastChar " + n2);
        pDFOutputStream.print("/Widths [");
        n = n3;
        while (n <= n2) {
            if (n % 16 == 15) {
                pDFOutputStream.println();
            } else if (n > 0) {
                pDFOutputStream.print(" ");
            }
            if (encoding2.table[n] == null) {
                pDFOutputStream.print("0");
            } else {
                pDFOutputStream.print(PDFOutputStream.pdf_float(encoding2.table[n].wx));
            }
            ++n;
        }
        pDFOutputStream.println("]");
        this.writeEncoding(pDFOutputStream, encoding2);
        this.pdfFontDescriptor = new PDFFontDescriptor(pDFOutputStream.getNextID(), this.descriptor, this.subsetName + metric.fontName, this.make_fontflags(), this.enableSubset);
        this.cmap = new CMap(pDFOutputStream.getNextID(), this.descriptor, encoding2, this.enableSubset);
        pDFOutputStream.println("/FontDescriptor " + this.pdfFontDescriptor.getID().toStringR());
        pDFOutputStream.println("/ToUnicode " + this.cmap.getID().toStringR());
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        if (this.pdfFontDescriptor != null) {
            if (this.pdfEncoding != null) {
                this.pdfEncoding.write(pDFOutputStream);
            }
            this.pdfFontDescriptor.write(pDFOutputStream);
            this.cmap.write(pDFOutputStream);
        }
    }
}

