/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.FontFileFormatError;
import com.renderx.fonts.KernVector;
import com.renderx.util.UnicodeTable;
import java.io.PrintStream;

public abstract class Metric {
    public static final float UNDEF = Float.MIN_VALUE;
    private static final char[] missing_glyph_candidates = new char[]{'\u00a0', ' '};
    public int numGlyphs = 0;
    public UnicodeTable uniTable = new UnicodeTable();
    public String fontName = null;
    public String fullName = null;
    public String family = null;
    public String weight = "Roman";
    public float italicAngle = 0.0f;
    public boolean isFixedPitch = false;
    public boolean isCIDFont = false;
    public boolean isTrueType = false;
    public boolean isCFF = false;
    public boolean isTTC = false;
    public boolean isAFP = false;
    public float[] fontBBox = null;
    public float underlinePosition = Float.MIN_VALUE;
    public float underlineThickness = Float.MIN_VALUE;
    public String version = "";
    public String notice = "";
    public float capHeight = Float.MIN_VALUE;
    public float xHeight = Float.MIN_VALUE;
    public float ascender = Float.MIN_VALUE;
    public float descender = Float.MIN_VALUE;
    public float wx = Float.MIN_VALUE;
    public float wy = Float.MIN_VALUE;
    public float stdHW = Float.MIN_VALUE;
    public float stdVW = Float.MIN_VALUE;
    public CharMetrics missingGlyph = null;

    public boolean embeddable() {
        return true;
    }

    public boolean subsettable() {
        return true;
    }

    public CharMetrics ucm(char c) {
        return (CharMetrics)this.uniTable.get(c);
    }

    public boolean exists(char c) {
        return this.uniTable.get(c) != null;
    }

    public KernVector kern(char c, char c2) {
        KernVector kernVector;
        CharMetrics charMetrics = this.ucm(c);
        if (charMetrics != null && charMetrics.kernTable != null && (kernVector = (KernVector)charMetrics.kernTable.get(c2)) != null) {
            return kernVector;
        }
        return new KernVector();
    }

    protected void checkData() throws FontFileFormatError {
        if (this.fontName == null) {
            throw new FontFileFormatError("font name missing");
        }
        if (this.fullName == null) {
            this.fullName = this.fontName;
        }
        if (this.family == null) {
            this.family = this.fontName;
        }
        if (this.fontBBox == null) {
            throw new FontFileFormatError("bounding box missing");
        }
        if (this.ascender == Float.MIN_VALUE) {
            this.ascender = this.fontBBox[3];
        }
        if (this.descender == Float.MIN_VALUE) {
            this.descender = this.fontBBox[1];
        }
        if (this.wx == Float.MIN_VALUE) {
            this.wx = this.fontBBox[2] - this.fontBBox[0];
        }
        if (this.wy == Float.MIN_VALUE) {
            this.wy = this.fontBBox[3] - this.fontBBox[1];
        }
        if (this.capHeight == Float.MIN_VALUE) {
            this.capHeight = this.ascender;
        }
        if (this.xHeight == Float.MIN_VALUE) {
            this.xHeight = this.capHeight;
        }
        if (this.underlinePosition == Float.MIN_VALUE) {
            this.underlinePosition = this.descender;
        }
        if (this.stdHW == Float.MIN_VALUE) {
            this.stdHW = 50.0f;
        }
        if (this.stdVW == Float.MIN_VALUE) {
            this.stdVW = 100.0f;
        }
        if (this.underlineThickness == Float.MIN_VALUE) {
            this.underlineThickness = this.stdHW;
        }
        if (this.missingGlyph == null) {
            int n = 0;
            while (n < missing_glyph_candidates.length) {
                this.missingGlyph = this.ucm(missing_glyph_candidates[n]);
                if (this.missingGlyph != null) break;
                ++n;
            }
        }
        if (this.missingGlyph != null) {
            this.uniTable.put('\u0000', this.missingGlyph);
        }
    }

    public void dump(PrintStream printStream) {
        printStream.println("System name: " + this.fontName);
        printStream.println("Full name: " + this.fullName);
        printStream.println("Version: " + this.version);
        printStream.println("Notice: " + this.notice);
        printStream.println("Family: " + this.family);
        printStream.println("Weight: " + this.weight);
        printStream.println("Italic angle: " + this.italicAngle);
        printStream.println("Fixed pitch: " + (this.isFixedPitch ? "yes" : "no"));
        printStream.println("CID font: " + (this.isCIDFont ? "yes" : "no"));
        printStream.println("TrueType font: " + (this.isTrueType ? "yes" : "no"));
        printStream.println("OpenType/CFF font: " + (this.isCFF ? "yes" : "no"));
        printStream.println("FontBBox: " + this.fontBBox[0] + " " + this.fontBBox[1] + " " + this.fontBBox[2] + " " + this.fontBBox[3]);
        printStream.println("Ascender: " + this.ascender);
        printStream.println("Descender: " + this.descender);
        printStream.println("CapHeight: " + this.capHeight);
        printStream.println("XHeight: " + this.xHeight);
        printStream.println("Default advance width - X axis: " + this.wx);
        printStream.println("Default advance width - Y axis: " + this.wy);
        printStream.println("Dominant horizontal stem thickness: " + this.stdHW);
        printStream.println("Dominant vertical stem thickness: " + this.stdVW);
        printStream.println("Underline thickness: " + this.underlineThickness);
        printStream.println("Underline position: " + this.underlinePosition);
        printStream.println("Missing glyph character: " + (this.missingGlyph == null ? "none" : "U+" + Integer.toHexString(this.missingGlyph.uc)));
        printStream.print("Policy: ");
        printStream.println(this.embeddable() ? (this.subsettable() ? "Embedding & subsetting enabled" : "Embedding enabled, subsetting disabled") : "Embedding disabled");
        printStream.println("Number of glyphs: " + this.numGlyphs);
        printStream.println();
        int n = 0;
        while (n < 65535) {
            CharMetrics charMetrics = this.ucm((char)n);
            if (charMetrics != null) {
                if (charMetrics.uc != (char)n) {
                    printStream.println("[U+" + Integer.toHexString(n).toUpperCase() + "]" + " --> [U+" + Integer.toHexString(charMetrics.uc).toUpperCase() + "]");
                } else {
                    charMetrics.dump(printStream);
                }
            }
            ++n;
        }
    }

    public String toString() {
        return this.fullName;
    }
}

