/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.FormDef;
import com.renderx.afplib.HighlightColorRegistry;
import com.renderx.afplib.Tag;
import com.renderx.afplib.Util;
import com.renderx.afplib.XBilevelShadingPattern;
import com.renderx.afplib.XGraphic;
import com.renderx.afplib.XImage;
import com.renderx.afplib.XPage;
import com.renderx.graphics.ImageFormatException;
import com.renderx.util.Applicator;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.Stack;
import com.renderx.util.URLSpec;
import com.renderx.xep.cmp.ImageFactory;
import com.renderx.xep.lib.LicenseException;
import com.renderx.xep.lib.Session;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;

public class AFPDocument {
    public AFP afp = null;
    public AFP res = null;
    private Set resourceSet = new HashSet();
    private Session session;
    public ErrorHandler logger;
    private FormDef formDef = null;
    private Stack pageGroups = new Stack();
    private List pendingBeginPageGroups = new List();
    private List pendingEndPageGroups = new List();
    private int tleSequence = 0;
    private ArrayList pagegroupTLE = new ArrayList();
    private Dictionary imageCache = new Hashtable();
    final String DOCUMENT_NAME = "DOC00001";

    public void processPageGroupBegin(String string) {
        if (string != null) {
            this.pendingBeginPageGroups = this.pendingBeginPageGroups.append(string);
        }
    }

    public void processPageGroupEnd(String string) {
        if (string != null) {
            this.pendingEndPageGroups = this.pendingEndPageGroups.append(string);
        }
    }

    public int genNewTleID() {
        return this.tleSequence++;
    }

    public XImage checkCache(URLSpec uRLSpec) {
        return (XImage)this.imageCache.get(uRLSpec);
    }

    public void addToCache(URLSpec uRLSpec, XImage xImage) {
        this.imageCache.put(uRLSpec, xImage);
    }

    public XImage checkCache(XBilevelShadingPattern.Key key) {
        return (XImage)this.imageCache.get(key);
    }

    public void addToCache(XBilevelShadingPattern.Key key, XImage xImage) {
        this.imageCache.put(key, xImage);
    }

    public AFPDocument(Session session, ErrorHandler errorHandler, OutputStream outputStream, OutputStream outputStream2, HighlightColorRegistry highlightColorRegistry, ConfigManager configManager) throws LicenseException {
        this.session = session;
        this.logger = errorHandler;
        if (!this.session.config.AFP) {
            this.session.error("AFP support is not licensed for this installation.");
            throw new LicenseException("AFP support is not licensed for this installation.");
        }
        this.afp = new AFP(outputStream, this.logger, highlightColorRegistry, configManager);
        if (outputStream2 != null) {
            this.res = new AFP(outputStream2, this.logger, highlightColorRegistry, configManager);
        }
    }

    public boolean isUsingResource() {
        return this.res != null;
    }

    public void begin() {
        try {
            this.afp.startAccumulation();
            this.afp.writeModcaSFNamed("BDT", "DOC00001");
            this.afp.writeAccumulatedLength(1);
            if (this.isUsingResource()) {
                this.res.writeSF_BeginResourceGroup();
            }
        }
        catch (Exception exception) {
            this.logger.exception("Can't begin AFP document", exception);
        }
    }

    public void end() {
        try {
            this.endAllPageGroups();
            this.afp.startAccumulation();
            this.afp.writeModcaSFNamed("EDT", "DOC00001");
            this.afp.writeAccumulatedLength(1);
            this.afp.flush();
            if (this.isUsingResource()) {
                if (this.formDef != null) {
                    this.formDef.writeToResource(this.res, this.logger);
                }
                this.res.writeSF_EndResourceGroup();
            }
        }
        catch (Exception exception) {
            this.logger.exception("Can't end AFP document", exception);
        }
    }

    public void beginPageGroup() throws IOException {
        if (!this.pendingBeginPageGroups.isEmpty()) {
            this.pendingBeginPageGroups.foreach(new Applicator(){

                public Object f(Object object) {
                    try {
                        String string = (String)object;
                        AFPDocument.this.afp.startAccumulation();
                        AFPDocument.this.afp.writeModcaSFNamed("BNG", Util.nameN(string, 8, false));
                        AFPDocument.this.afp.writeAccumulatedLength(1);
                        AFPDocument.this.pageGroups = AFPDocument.this.pageGroups.push(string);
                    }
                    catch (Exception exception) {
                        AFPDocument.this.logger.exception("Can't begin page group", exception);
                    }
                    return object;
                }
            });
            this.pendingBeginPageGroups = this.pendingBeginPageGroups.clear();
        }
    }

    public void endPageGroup() throws IOException {
        if (!this.pendingEndPageGroups.isEmpty()) {
            this.pendingEndPageGroups.foreach(new Applicator(){

                public Object f(Object object) {
                    if (AFPDocument.this.pageGroups.isEmpty()) {
                        AFPDocument.this.logger.warning("Unexpected ending of group" + object);
                        return object;
                    }
                    try {
                        String string = (String)AFPDocument.this.pageGroups.pop();
                        if (!string.equals(object) && object != null && !object.equals("")) {
                            AFPDocument.this.logger.warning("Wrong name of ending group: expected " + string + " found " + object);
                        }
                        AFPDocument.this.afp.startAccumulation();
                        AFPDocument.this.afp.writeModcaSFNamed("ENG", Util.nameN(string, 8, false));
                        AFPDocument.this.afp.writeAccumulatedLength(1);
                    }
                    catch (Exception exception) {
                        AFPDocument.this.logger.exception("Can't end page group", exception);
                    }
                    return object;
                }
            });
            this.pendingEndPageGroups = this.pendingEndPageGroups.clear();
        }
    }

    public void endAllPageGroups() throws IOException {
        if (!this.pageGroups.isEmpty()) {
            this.pageGroups.foreach(new Applicator(){

                public Object f(Object object) {
                    try {
                        String string = (String)object;
                        AFPDocument.this.afp.startAccumulation();
                        AFPDocument.this.afp.writeModcaSFNamed("ENG", Util.nameN(string, 8, false));
                        AFPDocument.this.afp.writeAccumulatedLength(1);
                    }
                    catch (Exception exception) {
                        AFPDocument.this.logger.exception("Can't end page group", exception);
                    }
                    return object;
                }
            });
            this.pageGroups.clear();
        }
    }

    public void beginPage(XPage xPage) throws AFPInternalException {
        try {
            this.beginPageGroup();
            this.processPageGroupTags();
            this.afp.writeHighlightColors();
            xPage.render();
            this.endPageGroup();
        }
        catch (IOException iOException) {
            this.logger.exception("Can't begin a page", iOException);
        }
    }

    public void addPagegroupTLE(Tag tag) {
        this.pagegroupTLE.add(tag);
    }

    public void processPageGroupTags() throws IOException, AFPInternalException {
        this.afp.processTags(this.pagegroupTLE);
        this.pagegroupTLE.clear();
    }

    public final void embedObjectToResources(XGraphic xGraphic) throws IOException, ImageFormatException, AFPInternalException {
        if (!this.isUsingResource()) {
            return;
        }
        if (this.resourceSet.contains(xGraphic.afpObjectToken)) {
            return;
        }
        this.logger.info("resource " + xGraphic.afpObjectToken + " " + xGraphic.src);
        AFP.EmbeddableObjectType embeddableObjectType = AFP.getMoDcaEmbeddableObjectType(xGraphic.mimeType);
        this.resourceSet.add(xGraphic.afpObjectToken);
        if (embeddableObjectType.isMoDcaResource) {
            this.res.writeModcaObject(xGraphic);
        } else {
            this.res.writeContainerObject(xGraphic);
        }
    }

    public final void placeReferenceToResourceToAFPDS(XGraphic xGraphic) throws IOException, ImageFormatException, AFPInternalException {
        AFP.EmbeddableObjectType embeddableObjectType = AFP.getMoDcaEmbeddableObjectType(xGraphic.mimeType);
        if (xGraphic.mimeType.equals("modca/oly")) {
            xGraphic.writeIPO(this.afp);
        } else if (embeddableObjectType.isMoDcaResource) {
            this.afp.iobModca(xGraphic);
        } else {
            this.afp.iobOther(xGraphic);
        }
    }

    public void processFormDefinition(String string) {
        String[] stringArray = string.split("\\s+");
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].trim().split("=", 2);
            stringArray2[1] = stringArray2[1].split("\"")[1];
            if ("sheet-height".equals(stringArray2[0])) {
                n2 = Util.parseLengthSpecifier(stringArray2[1]);
                continue;
            }
            if (!"sheet-width".equals(stringArray2[0])) continue;
            n = Util.parseLengthSpecifier(stringArray2[1]);
        }
        if (n == -1 || n2 == -1) {
            this.logger.error("Wrong <?xep-afp-form-definition?> processing instruction. Must have attributes sheet-height and sheet-width.");
        } else {
            this.formDef = new FormDef(n, n2);
        }
    }

    public void processPageDefinition(String string) {
        try {
            String[] stringArray = string.split("\\s+");
            int n = -1;
            short s = 0;
            short s2 = 0;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].trim().split("=", 2);
                stringArray2[1] = stringArray2[1].split("\"")[1];
                for (int j = 0; j < stringArray.length; ++j) {
                    if (stringArray2[0].equals("id")) {
                        n = Integer.parseInt(stringArray2[1]);
                        continue;
                    }
                    if (stringArray2[0].equals("type")) {
                        s = FormDef.PageDef.PageType.decode(stringArray2[1]);
                        continue;
                    }
                    if (stringArray2[0].equals("orientation")) {
                        s2 = FormDef.PageDef.Orientation.decode(stringArray2[1]);
                        continue;
                    }
                    if (stringArray2[0].equals("x0")) {
                        n2 = Util.parseLengthSpecifier(stringArray2[1]);
                        continue;
                    }
                    if (!stringArray2[0].equals("y0")) continue;
                    n3 = Util.parseLengthSpecifier(stringArray2[1]);
                }
            }
            if (this.formDef != null) {
                this.formDef.addPageDef(n, new FormDef.PageDef(s, s2, n2, n3));
            }
        }
        catch (Exception exception) {
            this.logger.exception("Can't process <?xep-afp-page-definition?>.", exception);
        }
    }

    public void processCopyGroup(String string) {
        try {
            String[] stringArray = string.split("\\s+");
            int n = -1;
            short s = -1;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].trim().split("=", 2);
                stringArray2[1] = stringArray2[1].split("\"")[1];
                if (stringArray2[0].equals("id")) {
                    n = Integer.parseInt(stringArray2[1]);
                    continue;
                }
                if (stringArray2[0].equals("copy-count")) {
                    s = Short.parseShort(stringArray2[1]);
                    continue;
                }
                if (stringArray2[0].equals("mode") && stringArray2[0].equals("duplex")) {
                    bl = true;
                    continue;
                }
                if (!stringArray2[0].equals("mode") || !stringArray2[0].equals("tumble-duplex")) continue;
                bl2 = true;
            }
            FormDef.CopyCountGroup copyCountGroup = null;
            if (n != -1 && s != -1) {
                copyCountGroup = new FormDef.CopyCountGroup(s, bl, bl2);
            }
            if (this.formDef != null && copyCountGroup != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray3 = stringArray[i].trim().split("=", 2);
                    stringArray3[1] = stringArray3[1].split("\"")[1];
                    if (stringArray3[0].equals("id") || stringArray3[0].equals("copy-count") || stringArray3[0].equals("mode")) continue;
                    short s2 = Short.parseShort(stringArray3[0].substring(1), 16);
                    short s3 = Short.parseShort(stringArray3[1], 16);
                    copyCountGroup.addOptionValue(new FormDef.CopyCountGroup.KeywordValueTuple(s2, s3));
                }
                this.formDef.addCopyGroup(n, copyCountGroup);
            }
        }
        catch (Exception exception) {
            this.logger.exception("Can't process <?xep-afp-page-definition?>.", exception);
        }
    }

    public ImageFactory getImageProcessor() {
        return this.session.config.imageFactory;
    }
}

