/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre.att;

import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.AttributeParser;
import com.renderx.xep.pre.ParserContext;
import com.renderx.xep.pre.ParserException;

public class VerticalAlign
extends Attn {
    private final Attn alignAdjust = Attn.$alignment_adjust;
    private final Attn alignBase = Attn.$alignment_baseline;
    private final Attn baseShift = Attn.$baseline_shift;
    private final Attn domBase = Attn.$dominant_baseline;

    public VerticalAlign(String string) throws ParserException {
        super(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(String string, ParserContext parserContext) throws ParserException {
        Attr attr = AttributeParser.parse(string).evaluate(parserContext, this);
        if (attr instanceof Attr.Word) {
            String string2 = attr.word();
            if (string2.equals("baseline")) {
                this.alignBase.process("baseline", parserContext);
                this.alignAdjust.process("auto", parserContext);
                this.baseShift.process("baseline", parserContext);
                this.domBase.process("auto", parserContext);
                return;
            } else if (string2.equals("top")) {
                this.alignBase.process("before-edge", parserContext);
                this.alignAdjust.process("auto", parserContext);
                this.baseShift.process("baseline", parserContext);
                this.domBase.process("auto", parserContext);
                return;
            } else if (string2.equals("text-top")) {
                this.alignBase.process("text-before-edge", parserContext);
                this.alignAdjust.process("auto", parserContext);
                this.baseShift.process("baseline", parserContext);
                this.domBase.process("auto", parserContext);
                return;
            } else if (string2.equals("middle")) {
                this.alignBase.process("middle", parserContext);
                this.alignAdjust.process("auto", parserContext);
                this.baseShift.process("baseline", parserContext);
                this.domBase.process("auto", parserContext);
                return;
            } else if (string2.equals("bottom")) {
                this.alignBase.process("after-edge", parserContext);
                this.alignAdjust.process("auto", parserContext);
                this.baseShift.process("baseline", parserContext);
                this.domBase.process("auto", parserContext);
                return;
            } else if (string2.equals("text-bottom")) {
                this.alignBase.process("text-after-edge", parserContext);
                this.alignAdjust.process("auto", parserContext);
                this.baseShift.process("baseline", parserContext);
                this.domBase.process("auto", parserContext);
                return;
            } else if (string2.equals("sub")) {
                this.alignBase.process("baseline", parserContext);
                this.alignAdjust.process("auto", parserContext);
                this.baseShift.process("sub", parserContext);
                this.domBase.process("auto", parserContext);
                return;
            } else {
                if (!string2.equals("super")) throw new ParserException("Invalid keyword in property value: " + this.name + "=\"" + string + "\"");
                this.alignBase.process("baseline", parserContext);
                this.alignAdjust.process("auto", parserContext);
                this.baseShift.process("super", parserContext);
                this.domBase.process("auto", parserContext);
            }
            return;
        } else {
            if (!(attr instanceof Attr.Length) && !(attr instanceof Attr.Percentage)) throw new ParserException("Invalid property value: " + this.name + "=\"" + string + "\"");
            this.alignBase.process("baseline", parserContext);
            this.alignAdjust.process(attr.toString(), parserContext);
            this.baseShift.process("baseline", parserContext);
            this.domBase.process("auto", parserContext);
        }
    }
}

