/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.cmp;

import com.renderx.util.Hashtable;
import com.renderx.xep.cmp.Area;
import com.renderx.xep.cmp.PM;
import com.renderx.xep.cmp.Region;
import com.renderx.xep.cmp.SM;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.AttList;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.CompilerException;
import com.renderx.xep.pre.ElementHandler;
import com.renderx.xep.pre.PI;
import com.renderx.xep.pre.PIHandler;

class LMSHandler
implements ElementHandler,
PIHandler {
    private final Session session;
    private final Hashtable masters;
    private Hashtable pmtab = new Hashtable();
    private PM pm = null;
    private AttList body = null;
    private AttList before = null;
    private AttList after = null;
    private AttList start = null;
    private AttList end = null;
    private int w;
    private int h;
    private SM sm = null;
    private SM.PMSet set = null;

    LMSHandler(Hashtable hashtable, Session session) {
        this.masters = hashtable;
        this.session = session;
    }

    public void startElement(short s, AttList attList) throws CompilerException {
        switch (s) {
            case 10: {
                Attr attr = attList.get(Attn.$master_name);
                this.pm = this.getpm(attr);
                this.session.openState("sequence-master");
                this.session.event("master-name", attr.word());
                this.sm = new SM(attList);
                this.masters.put(attr, this.sm);
                this.set = new SM.PMSet();
                this.set.refs.append(new SM.PMRef(this.pm, -1));
                this.pm.bind(attList);
                Area.fixBorderWidth(this.pm.a);
                Attr attr2 = this.pm.get(Attn.$page_width);
                Attr attr3 = this.pm.get(Attn.$page_height);
                if (attr2 instanceof Attr.Word) {
                    if (attr2 == Attr.newWord("indefinite")) {
                        attr2 = Attr.newLength(this.session.config.MAX_PAGE_WIDTH);
                    } else if (attr2 == Attr.auto) {
                        attr2 = Attr.newLength(this.session.config.PAGE_WIDTH);
                    } else {
                        this.session.warning("page-width=" + attr2.word() + " must be converted to length in the parser");
                    }
                    this.pm.put(Attn.$page_width, attr2);
                }
                if (attr3 instanceof Attr.Word) {
                    if (attr3 == Attr.newWord("indefinite")) {
                        attr3 = Attr.newLength(this.session.config.MAX_PAGE_HEIGHT);
                    } else if (attr3 == Attr.auto) {
                        attr3 = Attr.newLength(this.session.config.PAGE_HEIGHT);
                    } else {
                        this.session.warning("page-height=" + attr3.word() + " must be converted to length in the parser");
                    }
                    this.pm.put(Attn.$page_height, attr3);
                }
                this.w = attr2.length();
                this.h = attr3.length();
                if (this.w < this.session.config.MIN_PAGE_WIDTH) {
                    this.w = this.session.config.MIN_PAGE_WIDTH;
                    this.pm.put(Attn.$page_width, Attr.newLength(this.w));
                }
                if (this.h < this.session.config.MIN_PAGE_HEIGHT) {
                    this.h = this.session.config.MIN_PAGE_HEIGHT;
                    this.pm.put(Attn.$page_height, Attr.newLength(this.h));
                }
                if (this.w > this.session.config.MAX_PAGE_WIDTH) {
                    this.w = this.session.config.MAX_PAGE_WIDTH;
                    this.pm.put(Attn.$page_width, Attr.newLength(this.w));
                }
                if (this.h > this.session.config.MAX_PAGE_HEIGHT) {
                    this.h = this.session.config.MAX_PAGE_HEIGHT;
                    this.pm.put(Attn.$page_height, Attr.newLength(this.h));
                }
                String[] stringArray = new String[]{"before", "after", "start", "end"};
                int n = 0;
                while (n != stringArray.length) {
                    Attn attn = Attn.oldName("margin-" + stringArray[n]);
                    if (this.pm.get(attn) == Attr.auto) {
                        this.pm.put(attn, Attr.zerolength);
                    }
                    ++n;
                }
                this.pm.dimensions(this.w, this.h);
                if (attList.containsKey(Attn.$watermark)) {
                    this.pm.put(Attn.$watermark, attList.get(Attn.$watermark));
                    if (attList.containsKey(Attn.$image_base_url)) {
                        this.pm.put(Attn.$image_base_url, attList.get(Attn.$image_base_url));
                    }
                }
                if (attList.containsKey(Attn.$js_open)) {
                    this.pm.put(Attn.$js_open, attList.get(Attn.$js_open));
                }
                if (!attList.containsKey(Attn.$js_close)) break;
                this.pm.put(Attn.$js_close, attList.get(Attn.$js_close));
                break;
            }
            case 5: {
                Attr attr = attList.get(Attn.$master_name);
                this.session.openState("sequence-master");
                this.session.event("master-name", attr.word());
                this.sm = new SM(attList);
                this.masters.put(attr, this.sm);
                break;
            }
            case 6: {
                this.set = new SM.PMSet(1);
                this.set.refs.append(new SM.PMRef(this.getpm(attList.get(Attn.$master_reference)), -1));
                break;
            }
            case 7: {
                this.set = new SM.PMSet(attList.get(Attn.$maximum_repeats).count());
                this.set.refs.append(new SM.PMRef(this.getpm(attList.get(Attn.$master_reference)), -1));
                break;
            }
            case 8: {
                this.set = new SM.PMSet(attList.get(Attn.$maximum_repeats).count());
                break;
            }
            case 9: {
                PM pM = this.getpm(attList.get(Attn.$master_reference));
                int n = 0;
                Attr attr = attList.get(Attn.$page_position);
                if (attr == Attr.newWord("any")) {
                    n |= 7;
                } else if (attr == Attr.newWord("only")) {
                    n |= 0x80;
                } else if (attr == Attr.newWord("first")) {
                    n |= 1;
                } else if (attr == Attr.newWord("last")) {
                    n |= 2;
                } else if (attr == Attr.newWord("rest")) {
                    n |= 4;
                } else {
                    throw new InternalException("illegal value for page-position:" + attr);
                }
                Attr attr4 = attList.get(Attn.$blank_or_not_blank);
                if (attr4 == Attr.newWord("any")) {
                    n |= 0x18;
                } else if (attr4 == Attr.newWord("blank")) {
                    n |= 8;
                } else if (attr4 == Attr.newWord("not-blank")) {
                    n |= 0x10;
                } else {
                    throw new InternalException("illegal value for blank-or-not-blank:" + attr4);
                }
                Attr attr5 = attList.get(Attn.$odd_or_even);
                if (attr5 == Attr.newWord("any")) {
                    n |= 0x60;
                } else if (attr5 == Attr.newWord("odd")) {
                    n |= 0x20;
                } else if (attr5 == Attr.newWord("even")) {
                    n |= 0x40;
                } else {
                    throw new InternalException("illegal value for odd-or-even:" + attr5);
                }
                this.set.refs.append(new SM.PMRef(pM, n));
                if ((n & 3) == 0) break;
                n = n & 0xFFFFFFFC | 0x80;
                this.set.refs.append(new SM.PMRef(pM, n));
                break;
            }
            case 11: {
                this.body = attList;
                break;
            }
            case 12: {
                this.before = attList;
                break;
            }
            case 13: {
                this.after = attList;
                break;
            }
            case 14: {
                this.start = attList;
                break;
            }
            case 15: {
                this.end = attList;
                break;
            }
            default: {
                throw new CompilerException("invalid element id: " + s);
            }
        }
    }

    public void endElement(short s) throws CompilerException {
        switch (s) {
            case 10: {
                this.sm.sets.append(this.set);
                this.set = null;
                this.sm = null;
                this.session.closeState("sequence-master");
                if (this.pm.get(Attn.$writing_mode) == Attr.rl_tb) {
                    if (this.body != null) {
                        Area.fixBorderWidth(this.body);
                        this.pm.regtab.put(this.body.containsKey(Attn.$region_name) ? this.body.get(Attn.$region_name) : Attr.newWord("xsl-region-body"), new Region(this.pm.pagerect, this.body));
                    }
                    if (this.before != null) {
                        int[] nArray;
                        Area.fixBorderWidth(this.before);
                        Hashtable hashtable = this.pm.regtab;
                        Attr attr = this.before.containsKey(Attn.$region_name) ? this.before.get(Attn.$region_name) : Attr.newWord("xsl-region-before");
                        if (this.before.get(Attn.$precedence).bool()) {
                            int[] nArray2 = new int[4];
                            nArray2[0] = this.pm.pagerect[0];
                            nArray2[1] = this.pm.pagerect[3] - this.before.get(Attn.$extent).length_or_ratio(this.h);
                            nArray2[2] = this.pm.pagerect[2];
                            nArray = nArray2;
                            nArray2[3] = this.pm.pagerect[3];
                        } else {
                            int[] nArray3 = new int[4];
                            nArray3[0] = this.end != null ? this.pm.pagerect[0] + this.end.get(Attn.$extent).length_or_ratio(this.h) : this.pm.pagerect[0];
                            nArray3[1] = this.pm.pagerect[3] - this.before.get(Attn.$extent).length_or_ratio(this.h);
                            nArray3[2] = this.start != null ? this.pm.pagerect[2] - this.start.get(Attn.$extent).length_or_ratio(this.w) : this.pm.pagerect[2];
                            nArray = nArray3;
                            nArray3[3] = this.pm.pagerect[3];
                        }
                        hashtable.put(attr, new Region(nArray, this.before));
                    }
                    if (this.after != null) {
                        int[] nArray;
                        Area.fixBorderWidth(this.after);
                        Hashtable hashtable = this.pm.regtab;
                        Attr attr = this.after.containsKey(Attn.$region_name) ? this.after.get(Attn.$region_name) : Attr.newWord("xsl-region-after");
                        if (this.after.get(Attn.$precedence).bool()) {
                            int[] nArray4 = new int[4];
                            nArray4[0] = this.pm.pagerect[0];
                            nArray4[1] = this.pm.pagerect[1];
                            nArray4[2] = this.pm.pagerect[2];
                            nArray = nArray4;
                            nArray4[3] = this.pm.pagerect[1] + this.after.get(Attn.$extent).length_or_ratio(this.h);
                        } else {
                            int[] nArray5 = new int[4];
                            nArray5[0] = this.end != null ? this.pm.pagerect[0] + this.end.get(Attn.$extent).length_or_ratio(this.h) : this.pm.pagerect[0];
                            nArray5[1] = this.pm.pagerect[1];
                            nArray5[2] = this.start != null ? this.pm.pagerect[2] - this.start.get(Attn.$extent).length_or_ratio(this.h) : this.pm.pagerect[2];
                            nArray = nArray5;
                            nArray5[3] = this.pm.pagerect[1] + this.after.get(Attn.$extent).length_or_ratio(this.w);
                        }
                        hashtable.put(attr, new Region(nArray, this.after));
                    }
                    if (this.start != null) {
                        Area.fixBorderWidth(this.start);
                        this.pm.regtab.put(this.start.containsKey(Attn.$region_name) ? this.start.get(Attn.$region_name) : Attr.newWord("xsl-region-start"), new Region(new int[]{this.pm.pagerect[2] - this.start.get(Attn.$extent).length_or_ratio(this.w), this.after != null && this.after.get(Attn.$precedence).bool() ? this.pm.pagerect[1] + this.after.get(Attn.$extent).length_or_ratio(this.w) : this.pm.pagerect[1], this.pm.pagerect[2], this.before != null && this.before.get(Attn.$precedence).bool() ? this.pm.pagerect[3] - this.before.get(Attn.$extent).length_or_ratio(this.w) : this.pm.pagerect[3]}, this.start));
                    }
                    if (this.end != null) {
                        Area.fixBorderWidth(this.end);
                        this.pm.regtab.put(this.end.containsKey(Attn.$region_name) ? this.end.get(Attn.$region_name) : Attr.newWord("xsl-region-end"), new Region(new int[]{this.pm.pagerect[0], this.after != null && this.after.get(Attn.$precedence).bool() ? this.pm.pagerect[1] + this.after.get(Attn.$extent).length_or_ratio(this.w) : this.pm.pagerect[1], this.pm.pagerect[0] + this.end.get(Attn.$extent).length_or_ratio(this.w), this.before != null && this.before.get(Attn.$precedence).bool() ? this.pm.pagerect[3] - this.before.get(Attn.$extent).length_or_ratio(this.w) : this.pm.pagerect[3]}, this.end));
                    }
                } else {
                    if (this.body != null) {
                        Area.fixBorderWidth(this.body);
                        this.pm.regtab.put(this.body.containsKey(Attn.$region_name) ? this.body.get(Attn.$region_name) : Attr.newWord("xsl-region-body"), new Region(this.pm.pagerect, this.body));
                    }
                    if (this.before != null) {
                        int[] nArray;
                        Area.fixBorderWidth(this.before);
                        Hashtable hashtable = this.pm.regtab;
                        Attr attr = this.before.containsKey(Attn.$region_name) ? this.before.get(Attn.$region_name) : Attr.newWord("xsl-region-before");
                        if (this.before.get(Attn.$precedence).bool()) {
                            int[] nArray6 = new int[4];
                            nArray6[0] = this.pm.pagerect[0];
                            nArray6[1] = this.pm.pagerect[3] - this.before.get(Attn.$extent).length_or_ratio(this.h);
                            nArray6[2] = this.pm.pagerect[2];
                            nArray = nArray6;
                            nArray6[3] = this.pm.pagerect[3];
                        } else {
                            int[] nArray7 = new int[4];
                            nArray7[0] = this.start != null ? this.pm.pagerect[0] + this.start.get(Attn.$extent).length_or_ratio(this.h) : this.pm.pagerect[0];
                            nArray7[1] = this.pm.pagerect[3] - this.before.get(Attn.$extent).length_or_ratio(this.h);
                            nArray7[2] = this.end != null ? this.pm.pagerect[2] - this.end.get(Attn.$extent).length_or_ratio(this.w) : this.pm.pagerect[2];
                            nArray = nArray7;
                            nArray7[3] = this.pm.pagerect[3];
                        }
                        hashtable.put(attr, new Region(nArray, this.before));
                    }
                    if (this.after != null) {
                        int[] nArray;
                        Area.fixBorderWidth(this.after);
                        Hashtable hashtable = this.pm.regtab;
                        Attr attr = this.after.containsKey(Attn.$region_name) ? this.after.get(Attn.$region_name) : Attr.newWord("xsl-region-after");
                        if (this.after.get(Attn.$precedence).bool()) {
                            int[] nArray8 = new int[4];
                            nArray8[0] = this.pm.pagerect[0];
                            nArray8[1] = this.pm.pagerect[1];
                            nArray8[2] = this.pm.pagerect[2];
                            nArray = nArray8;
                            nArray8[3] = this.pm.pagerect[1] + this.after.get(Attn.$extent).length_or_ratio(this.h);
                        } else {
                            int[] nArray9 = new int[4];
                            nArray9[0] = this.start != null ? this.pm.pagerect[0] + this.start.get(Attn.$extent).length_or_ratio(this.h) : this.pm.pagerect[0];
                            nArray9[1] = this.pm.pagerect[1];
                            nArray9[2] = this.end != null ? this.pm.pagerect[2] - this.end.get(Attn.$extent).length_or_ratio(this.h) : this.pm.pagerect[2];
                            nArray = nArray9;
                            nArray9[3] = this.pm.pagerect[1] + this.after.get(Attn.$extent).length_or_ratio(this.w);
                        }
                        hashtable.put(attr, new Region(nArray, this.after));
                    }
                    if (this.start != null) {
                        Area.fixBorderWidth(this.start);
                        this.pm.regtab.put(this.start.containsKey(Attn.$region_name) ? this.start.get(Attn.$region_name) : Attr.newWord("xsl-region-start"), new Region(new int[]{this.pm.pagerect[0], this.after != null && this.after.get(Attn.$precedence).bool() ? this.pm.pagerect[1] + this.after.get(Attn.$extent).length_or_ratio(this.w) : this.pm.pagerect[1], this.pm.pagerect[0] + this.start.get(Attn.$extent).length_or_ratio(this.w), this.before != null && this.before.get(Attn.$precedence).bool() ? this.pm.pagerect[3] - this.before.get(Attn.$extent).length_or_ratio(this.w) : this.pm.pagerect[3]}, this.start));
                    }
                    if (this.end != null) {
                        Area.fixBorderWidth(this.end);
                        this.pm.regtab.put(this.end.containsKey(Attn.$region_name) ? this.end.get(Attn.$region_name) : Attr.newWord("xsl-region-end"), new Region(new int[]{this.pm.pagerect[2] - this.end.get(Attn.$extent).length_or_ratio(this.w), this.after != null && this.after.get(Attn.$precedence).bool() ? this.pm.pagerect[1] + this.after.get(Attn.$extent).length_or_ratio(this.w) : this.pm.pagerect[1], this.pm.pagerect[2], this.before != null && this.before.get(Attn.$precedence).bool() ? this.pm.pagerect[3] - this.before.get(Attn.$extent).length_or_ratio(this.w) : this.pm.pagerect[3]}, this.end));
                    }
                }
                this.pm = null;
                this.end = null;
                this.start = null;
                this.after = null;
                this.before = null;
                this.body = null;
                break;
            }
            case 5: {
                this.sm = null;
                this.session.closeState("sequence-master");
                break;
            }
            case 6: {
                this.sm.sets.append(this.set);
                this.set = null;
                break;
            }
            case 7: {
                this.sm.sets.append(this.set);
                this.set = null;
                break;
            }
            case 8: {
                this.sm.sets.append(this.set);
                this.set = null;
                break;
            }
            case 9: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            default: {
                throw new CompilerException("invalid element id: " + s);
            }
        }
    }

    public void processingInstruction(String string, String string2) throws CompilerException {
        if (this.pm != null) {
            this.pm.pilist.append(new PI(string, string2));
        }
    }

    private PM getpm(Attr attr) {
        PM pM = (PM)this.pmtab.get(attr);
        if (pM == null) {
            pM = new PM();
            this.pmtab.put(attr, pM);
        }
        return pM;
    }
}

