/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.FontDescriptor;
import com.renderx.fonts.FontRecord;
import com.renderx.fonts.Metric;
import com.renderx.fonts.TTMetric;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFFont;
import com.renderx.pdflib.PDFFontDescriptor;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.util.Array;
import com.renderx.util.UnicodeTable;

public class T0DescendantFont
extends PDFFont {
    PDFFontDescriptor pdfFontDescriptor;

    T0DescendantFont(IndirectObject indirectObject, FontDescriptor fontDescriptor, boolean bl) {
        super(indirectObject, fontDescriptor);
        this.enableSubset = bl;
        if (this.enableSubset && fontDescriptor.record.subset && fontDescriptor.record.embed) {
            this.subsetName();
        }
    }

    String getSubType() {
        if (this.descriptor.record.getMetric().isCFF) {
            return "CIDFontType0";
        }
        return "CIDFontType2";
    }

    void writeAddInfo(PDFOutputStream pDFOutputStream) {
        FontRecord fontRecord = this.descriptor.record;
        String string = "Adobe";
        String string2 = "";
        String string3 = "0";
        Metric metric = fontRecord.getMetric();
        if (metric.isCFF) {
            try {
                string = ((TTMetric)metric).getCFFMetric().registry;
                string2 = ((TTMetric)metric).getCFFMetric().ordering;
                string3 = String.valueOf(((TTMetric)metric).getCFFMetric().supplement);
            }
            catch (Exception exception) {
                pDFOutputStream.exception("Cannot extract CFF data; ", exception);
            }
        }
        pDFOutputStream.println("/CIDSystemInfo <<");
        pDFOutputStream.println("/Registry (" + string + ")");
        pDFOutputStream.println("/Ordering (" + string2 + ")");
        pDFOutputStream.println("/Supplement " + string3 + " >>");
        this.pdfFontDescriptor = new PDFFontDescriptor(pDFOutputStream.getNextID(), this.descriptor, this.subsetName + fontRecord.getMetric().fontName, this.make_fontflags(), this.enableSubset);
        pDFOutputStream.println("/FontDescriptor " + this.pdfFontDescriptor.getID().toStringR());
        this.writeTTFWidths(pDFOutputStream);
        if (!metric.isCFF && fontRecord.embed && pDFOutputStream.doc.hasPDFA()) {
            pDFOutputStream.println("/CIDToGIDMap /Identity");
        }
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        this.pdfFontDescriptor.write(pDFOutputStream);
    }

    void writeTTFWidths(PDFOutputStream pDFOutputStream) {
        Object object;
        int n;
        Metric metric = this.descriptor.record.getMetric();
        UnicodeTable unicodeTable = new UnicodeTable();
        if (metric.missingGlyph != null) {
            unicodeTable.put((char)metric.missingGlyph.c, new Double(metric.missingGlyph.wx));
        }
        int n2 = 0;
        while (n2 < 256) {
            Array array = (Array)metric.uniTable.ranges.get(n2);
            if (array != null) {
                n = 0;
                while (n < 256) {
                    object = (CharMetrics)array.get(n);
                    if (object != null && this.descriptor.used.checkGlyph((char)(n2 << 8 | n))) {
                        unicodeTable.put((char)((CharMetrics)object).c, new Double(((CharMetrics)object).wx));
                    }
                    ++n;
                }
            }
            ++n2;
        }
        pDFOutputStream.println("/W [");
        boolean bl = false;
        n2 = 0;
        while (n2 < 256) {
            object = (Array)unicodeTable.ranges.get(n2);
            if (object == null) {
                if (bl) {
                    pDFOutputStream.print("]");
                    bl = false;
                }
            } else {
                n = 0;
                while (n < 256) {
                    Double d = (Double)((Array)object).get(n);
                    if (d == null) {
                        if (bl) {
                            pDFOutputStream.print("]");
                            bl = false;
                        }
                    } else if (bl) {
                        pDFOutputStream.print(" " + PDFOutputStream.pdf_float(d));
                    } else {
                        pDFOutputStream.print("" + (n2 << 8 | n) + "[" + d);
                        bl = true;
                    }
                    ++n;
                }
            }
            ++n2;
        }
        if (bl) {
            pDFOutputStream.print("]");
        }
        pDFOutputStream.println("\n]");
    }
}

