/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFIOException;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.StructAttrs;
import com.renderx.util.Array;
import com.renderx.util.Hashtable;
import java.util.Enumeration;

public class StructElem
extends PDFObject {
    StructElem parentElem;
    String structType;
    boolean rolledUp = false;
    Hashtable accessibilityProperties = new Hashtable();
    Array childElems = new Array();
    StructAttrs attrs = null;

    StructElem(IndirectObject indirectObject, String string, StructElem structElem) {
        super(indirectObject);
        this.structType = string;
        this.parentElem = structElem;
    }

    String getType() {
        return "StructElem";
    }

    void addStructElemChild(StructElem structElem, int n) {
        if (n != -1) {
            this.childElems.put(n - 1, structElem);
        } else {
            this.childElems.put(this.childElems.length(), structElem);
        }
    }

    void addPDFObjectChild(IndirectObject indirectObject, IndirectObject indirectObject2) {
        PDFObjectElem pDFObjectElem = new PDFObjectElem(indirectObject, indirectObject2);
        this.childElems.put(this.childElems.length(), pDFObjectElem);
    }

    void addMarkedContentChild(int n, IndirectObject indirectObject) {
        MarkedContentElem markedContentElem = new MarkedContentElem(n, indirectObject);
        this.childElems.put(this.childElems.length(), markedContentElem);
    }

    StructElem closeStructElem() {
        return this.parentElem;
    }

    static StructElem getStructElem(StructElem structElem) {
        if (!structElem.rolledUp) {
            return structElem;
        }
        return StructElem.getStructElem(structElem.parentElem);
    }

    void setOptionalKey(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string2 == null) {
            return;
        }
        this.accessibilityProperties.put(string, string2);
    }

    private boolean isEmpty() {
        int n = 0;
        while (n < this.childElems.length()) {
            block4: {
                block3: {
                    Object object = this.childElems.get(n);
                    if (!(object instanceof StructElem)) break block3;
                    StructElem structElem = (StructElem)object;
                    if ("Artifact".equals(structElem.structType) || structElem.rolledUp) break block4;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    private void rollUpChildren(int n, StructElem structElem) {
        Array array = new Array(this.childElems.length() + structElem.childElems.length());
        int n2 = 0;
        while (n2 <= n) {
            array.put(n2, this.childElems.get(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < structElem.childElems.length()) {
            Object object = structElem.childElems.get(n3);
            if (object instanceof StructElem) {
                ((StructElem)object).parentElem = this;
            }
            array.put(n3 + n + 1, object);
            ++n3;
        }
        int n4 = n + 1;
        while (n4 < this.childElems.length()) {
            array.put(n4 + structElem.childElems.length(), this.childElems.get(n4));
            ++n4;
        }
        this.childElems = array;
        structElem.childElems = new Array();
    }

    private void removeChildren(int n) {
        Array array = new Array(this.childElems.length() - 1);
        int n2 = 0;
        while (n2 < n) {
            array.put(n2, this.childElems.get(n2));
            ++n2;
        }
        int n3 = n + 1;
        while (n3 < this.childElems.length()) {
            array.put(n3 - 1, this.childElems.get(n3));
            ++n3;
        }
        this.childElems = array;
    }

    private void rearrangeChildren() {
        int n = 0;
        while (n < this.childElems.length()) {
            Object object = this.childElems.get(n);
            if (object == null) {
                this.removeChildren(n--);
            } else if (object instanceof StructElem) {
                StructElem structElem = (StructElem)object;
                if (structElem.rolledUp) {
                    this.rollUpChildren(n, structElem);
                }
            }
            ++n;
        }
    }

    void writeChildren(PDFOutputStream pDFOutputStream) {
        block6: {
            this.rearrangeChildren();
            if (this.isEmpty()) break block6;
            pDFOutputStream.print("/K [");
            int n = 0;
            while (n < this.childElems.length()) {
                block8: {
                    block9: {
                        Object object;
                        Object object2;
                        block7: {
                            object2 = this.childElems.get(n);
                            if (!(object2 instanceof StructElem)) break block7;
                            object = (StructElem)object2;
                            if ("Artifact".equals(((StructElem)object).structType) || ((StructElem)object).rolledUp) break block8;
                            pDFOutputStream.print(((PDFObject)object).getID().toStringR());
                            break block9;
                        }
                        if (object2 instanceof PDFObjectElem) {
                            object = (PDFObjectElem)object2;
                            ((PDFObjectElem)object).writePDFObject(pDFOutputStream);
                        } else if (object2 instanceof MarkedContentElem) {
                            object = (MarkedContentElem)object2;
                            ((MarkedContentElem)object).writeMarkedContent(pDFOutputStream);
                        } else {
                            throw new PDFIOException("Structure element contains content item of unknown type");
                        }
                    }
                    if (n < this.childElems.length() - 1) {
                        pDFOutputStream.print(" ");
                    }
                }
                ++n;
            }
            pDFOutputStream.println("]");
        }
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println("/S /" + (this.attrs == null ? this.structType : "TH"));
        pDFOutputStream.println("/P " + this.parentElem.getID().toStringR());
        this.writeChildren(pDFOutputStream);
        if (this.attrs != null) {
            pDFOutputStream.println("/A " + this.attrs.getID().toStringR());
        }
        Enumeration enumeration = this.accessibilityProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            pDFOutputStream.print("/");
            pDFOutputStream.print(string);
            pDFOutputStream.print(" ");
            pDFOutputStream.print_annotation((String)this.accessibilityProperties.get(string));
            pDFOutputStream.println();
        }
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        if (this.attrs != null) {
            this.attrs.write(pDFOutputStream);
        }
        int n = 0;
        while (n < this.childElems.length()) {
            Object object = this.childElems.get(n);
            if (object instanceof StructElem) {
                StructElem structElem = (StructElem)object;
                structElem.write(pDFOutputStream);
            }
            ++n;
        }
    }

    protected class PDFObjectElem {
        IndirectObject page;
        IndirectObject obj;

        PDFObjectElem(IndirectObject indirectObject, IndirectObject indirectObject2) {
            this.page = indirectObject2;
            this.obj = indirectObject;
        }

        void writePDFObject(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.print("<<");
            pDFOutputStream.print("/Type /OBJR ");
            pDFOutputStream.print("/Pg " + this.page.toStringR() + " ");
            pDFOutputStream.print("/Obj " + this.obj.toStringR());
            pDFOutputStream.print(">>");
        }
    }

    protected class MarkedContentElem {
        int mcid;
        IndirectObject page;

        MarkedContentElem(int n, IndirectObject indirectObject) {
            this.mcid = n;
            this.page = indirectObject;
        }

        void writeMarkedContent(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.print("<<");
            pDFOutputStream.print("/Type /MCR ");
            pDFOutputStream.print("/Pg " + this.page.toStringR() + " ");
            pDFOutputStream.print("/MCID " + this.mcid);
            pDFOutputStream.print(">>");
        }
    }
}

