/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.graphics.vector.Gradient;
import com.renderx.graphics.vector.OpaqueColor;
import com.renderx.pdflib.FunctionType2;
import com.renderx.pdflib.FunctionType3;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.util.List;
import java.util.Enumeration;

public abstract class PDFShading
extends PDFObject {
    Gradient gradient;
    int colorComponents = -1;

    PDFShading(IndirectObject indirectObject, Gradient gradient) {
        super(indirectObject);
        this.gradient = gradient;
    }

    abstract String getShadingType();

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println("/ShadingType " + this.getShadingType());
        pDFOutputStream.println("/ColorSpace " + this.getColorSpace(pDFOutputStream));
        this.writeShadingContent(pDFOutputStream);
    }

    abstract void writeShadingContent(PDFOutputStream var1);

    abstract void writeSubObjects(PDFOutputStream var1);

    FunctionType2 createFunctionType2(PDFOutputStream pDFOutputStream, double[] dArray, double[] dArray2) {
        FunctionType2 functionType2 = new FunctionType2(pDFOutputStream.getNextID(), this.colorComponents, 1.0);
        functionType2.setC0(dArray);
        functionType2.setC1(dArray2);
        return functionType2;
    }

    void setFunctionType3Intervals(PDFOutputStream pDFOutputStream, FunctionType3 functionType3) {
        Gradient.Stop stop = (Gradient.Stop)this.gradient.stoplist.car();
        stop.offset = 0.0;
        Enumeration enumeration = this.gradient.stoplist.elements();
        while (enumeration.hasMoreElements()) {
            Gradient.Stop stop2 = (Gradient.Stop)enumeration.nextElement();
            if (stop2.offset > stop.offset) {
                functionType3.addFunction(this.createFunctionType2(pDFOutputStream, stop.color.values(), stop2.color.values()));
                if (stop2.offset < 1.0) {
                    functionType3.addBound(stop2.offset);
                }
            }
            stop = stop2;
        }
        if (stop.offset < 1.0) {
            functionType3.addFunction(this.createFunctionType2(pDFOutputStream, stop.color.values(), stop.color.values()));
        }
    }

    private boolean checkColorSpaceConsistency() {
        OpaqueColor opaqueColor = ((Gradient.Stop)this.gradient.stoplist.car()).color;
        Enumeration enumeration = this.gradient.stoplist.elements();
        while (enumeration.hasMoreElements()) {
            OpaqueColor opaqueColor2 = ((Gradient.Stop)enumeration.nextElement()).color;
            if (!opaqueColor.getClass().getName().equals(opaqueColor2.getClass().getName())) {
                return false;
            }
            opaqueColor = opaqueColor2;
        }
        return true;
    }

    private void setDefaultColors() {
        Gradient.Stop stop = new Gradient.Stop(0.0, new OpaqueColor.RGB(0.0, 0.0, 0.0), 1.0);
        Gradient.Stop stop2 = new Gradient.Stop(1.0, new OpaqueColor.RGB(0.0, 0.0, 0.0), 1.0);
        List list = new List();
        list.append(stop).append(stop2);
        this.gradient.stoplist = list;
        this.colorComponents = 3;
    }

    private String getDefaultColorSpace() {
        return "/DeviceRGB";
    }

    private String getColorSpace(PDFOutputStream pDFOutputStream) {
        if (!this.checkColorSpaceConsistency()) {
            Enumeration enumeration = this.gradient.stoplist.elements();
            while (enumeration.hasMoreElements()) {
                Gradient.Stop stop = (Gradient.Stop)enumeration.nextElement();
                stop.color = stop.color.toRGB();
            }
            return this.getDefaultColorSpace();
        }
        return this.getColorSpace(((Gradient.Stop)this.gradient.stoplist.car()).color, pDFOutputStream);
    }

    private String getColorSpace(OpaqueColor opaqueColor, PDFOutputStream pDFOutputStream) {
        if (opaqueColor instanceof OpaqueColor.RGB) {
            this.colorComponents = 3;
            return "/DeviceRGB";
        }
        if (opaqueColor instanceof OpaqueColor.CMYK) {
            this.colorComponents = 4;
            return "/DeviceCMYK";
        }
        if (opaqueColor instanceof OpaqueColor.Grayscale) {
            this.colorComponents = 1;
            return "/DeviceGray";
        }
        if (opaqueColor instanceof OpaqueColor.SpotColor) {
            return this.getColorSpace(((OpaqueColor.SpotColor)opaqueColor).altcolor, pDFOutputStream);
        }
        if (opaqueColor instanceof OpaqueColor.Registration) {
            if (pDFOutputStream.doc.errorHandler != null) {
                pDFOutputStream.doc.errorHandler.warning("Unsuported color space in a gradient; gradient reverted to solid black color.");
            }
            this.setDefaultColors();
            return this.getDefaultColorSpace();
        }
        if (pDFOutputStream.doc.errorHandler != null) {
            pDFOutputStream.doc.errorHandler.error("Unexpected color space in a gradient; gradient reverted to solid black color.");
        }
        this.setDefaultColors();
        return this.getDefaultColorSpace();
    }
}

