/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts.afp;

import com.renderx.fonts.afp.FontOrientationData;
import com.renderx.fonts.afp.FontPatternData;
import com.renderx.fonts.afp.FontResourceObject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class FontCharacterSet
extends FontResourceObject {
    public static final byte[] BFN = new byte[]{-45, -88, -119};
    public static final byte[] FND = new byte[]{-45, -90, -119};
    public static final byte[] FNC = new byte[]{-45, -89, -119};
    public static final byte[] FNM = new byte[]{-45, -94, -119};
    public static final byte[] FNO = new byte[]{-45, -82, -119};
    public static final byte[] FNP = new byte[]{-45, -84, -119};
    public static final byte[] FNI = new byte[]{-45, -116, -119};
    private String name;
    private String typefaceDescription;
    private byte weightClass;
    private byte widthClass;
    private byte[] maximumVerticalFontSize;
    private byte[] nominalVerticalFontSize;
    private byte[] minimumVerticalFontSize;
    private byte[] maximumHorizontalFontSize;
    private byte[] nominalHorizontalFontSize;
    private byte[] minimumHorizontalFontSize;
    private byte[] isoTypefaceClassification;
    private byte designFlags;
    private byte[] gcsGID;
    private byte[] ftGID;
    private byte patternTechnologyIdentifier;
    private byte fontUseFlags;
    private byte metricsXUnitBase;
    private byte metricsYUnitBase;
    private byte[] metricsXUnitsPerUnitBase;
    private byte[] metricsYUnitsPerUnitBase;
    private byte[] maxCharacterBoxWidth;
    private byte[] maxCharacterBoxHeight;
    private byte fnoGroupLength;
    private byte fniGroupLength;
    private byte rasterPatternDataAlignment;
    private byte[] rasterPatternDataCount;
    private byte fnpGroupLength;
    private byte fnmGroupLength;
    private byte shapeXUnitBase;
    private byte shapeYUnitBase;
    private byte[] shapeXUnitsPerUnitBase;
    private byte[] shapeYUnitsPerUnitBase;
    private byte[] outlinePatternDataCount;
    private byte fnnGroupLength;
    private byte[] fnnDataCount;
    private byte[] fnnNameCount;
    private ArrayList fontPatterns;
    private HashMap fontOrientations;

    public String getName() {
        return this.name;
    }

    public String getTypefaceDescription() {
        return this.typefaceDescription;
    }

    public byte getWeightClass() {
        return this.weightClass;
    }

    public String getWeightClassName() {
        switch (this.weightClass) {
            case 1: {
                return "Ultralight";
            }
            case 2: {
                return "Extralight";
            }
            case 3: {
                return "Light";
            }
            case 4: {
                return "Semilight";
            }
            case 5: {
                return "Medium";
            }
            case 6: {
                return "Semibold";
            }
            case 7: {
                return "Bold";
            }
            case 8: {
                return "Extrabold";
            }
            case 9: {
                return "Ultrabold";
            }
        }
        return "Medium";
    }

    public byte getWidthClass() {
        return this.widthClass;
    }

    public byte[] getMaximumVerticalFontSize() {
        return this.maximumVerticalFontSize;
    }

    public byte[] getNominalVerticalFontSize() {
        return this.nominalVerticalFontSize;
    }

    public byte[] getMinimumVerticalFontSize() {
        return this.minimumVerticalFontSize;
    }

    public byte[] getMaximumHorizontalFontSize() {
        return this.maximumHorizontalFontSize;
    }

    public byte[] getNominalHorizontalFontSize() {
        return this.nominalHorizontalFontSize;
    }

    public byte[] getMinimumHorizontalFontSize() {
        return this.minimumHorizontalFontSize;
    }

    public byte[] getIsoTypefaceClassification() {
        return this.isoTypefaceClassification;
    }

    public byte getDesignFlags() {
        return this.designFlags;
    }

    public byte[] getGcsGID() {
        return this.gcsGID;
    }

    public byte[] getFtGID() {
        return this.ftGID;
    }

    public byte getPatternTechnologyIdentifier() {
        return this.patternTechnologyIdentifier;
    }

    public byte getFontUseFlags() {
        return this.fontUseFlags;
    }

    public byte getMetricsXUnitBase() {
        return this.metricsXUnitBase;
    }

    public byte getMetricsYUnitBase() {
        return this.metricsYUnitBase;
    }

    public byte[] getMetricsXUnitsPerUnitBase() {
        return this.metricsXUnitsPerUnitBase;
    }

    public byte[] getMetricsYUnitsPerUnitBase() {
        return this.metricsYUnitsPerUnitBase;
    }

    public byte[] getMaxCharacterBoxWidth() {
        return this.maxCharacterBoxWidth;
    }

    public byte[] getMaxCharacterBoxHeight() {
        return this.maxCharacterBoxHeight;
    }

    public byte getFnoGroupLength() {
        return this.fnoGroupLength;
    }

    public byte getFniGroupLength() {
        return this.fniGroupLength;
    }

    public byte getRasterPatternDataAlignment() {
        return this.rasterPatternDataAlignment;
    }

    public byte[] getRasterPatternDataCount() {
        return this.rasterPatternDataCount;
    }

    public byte getFnpGroupLength() {
        return this.fnpGroupLength;
    }

    public byte getFnmGroupLength() {
        return this.fnmGroupLength;
    }

    public byte getShapeXUnitBase() {
        return this.shapeXUnitBase;
    }

    public byte getShapeYUnitBase() {
        return this.shapeYUnitBase;
    }

    public byte[] getShapeXUnitsPerUnitBase() {
        return this.shapeXUnitsPerUnitBase;
    }

    public byte[] getShapeYUnitsPerUnitBase() {
        return this.shapeYUnitsPerUnitBase;
    }

    public byte[] getOutlinePatternDataCount() {
        return this.outlinePatternDataCount;
    }

    public byte getFnnGroupLength() {
        return this.fnnGroupLength;
    }

    public byte[] getFnnDataCount() {
        return this.fnnDataCount;
    }

    public byte[] getFnnNameCount() {
        return this.fnnNameCount;
    }

    public ArrayList getFontPatterns() {
        return this.fontPatterns;
    }

    public HashMap getFontOrientations() {
        return this.fontOrientations;
    }

    public void load(String string) throws IOException {
        this.load(new FileInputStream(string));
    }

    public void load(InputStream inputStream) throws IOException {
        FontOrientationData fontOrientationData;
        Object object;
        byte[] byArray = FontResourceObject.readStructuredField(inputStream, BFN);
        byte[] byArray2 = new byte[8];
        int n = 0;
        while (n < byArray.length) {
            if (n < 8) {
                byArray2[n] = byArray[n];
            }
            ++n;
        }
        this.name = new String(byArray2, this.getEncoding()).trim();
        byArray2 = null;
        byArray = FontResourceObject.readStructuredField(inputStream, FND);
        byte[] byArray3 = new byte[32];
        this.maximumVerticalFontSize = new byte[2];
        this.nominalVerticalFontSize = new byte[2];
        this.minimumVerticalFontSize = new byte[2];
        this.maximumHorizontalFontSize = new byte[2];
        this.nominalHorizontalFontSize = new byte[2];
        this.minimumHorizontalFontSize = new byte[2];
        this.isoTypefaceClassification = new byte[3];
        this.gcsGID = new byte[2];
        this.ftGID = new byte[2];
        int n2 = 0;
        while (n2 < byArray.length) {
            if (!(n2 >= 49 && n2 <= 63 || n2 >= 65 && n2 <= 75)) {
                if (n2 <= 31) {
                    byArray3[n2] = byArray[n2];
                } else if (n2 == 32) {
                    this.weightClass = byArray[n2];
                } else if (n2 == 33) {
                    this.widthClass = byArray[n2];
                } else if (n2 <= 35) {
                    this.maximumVerticalFontSize[n2 - 34] = byArray[n2];
                } else if (n2 <= 37) {
                    this.nominalVerticalFontSize[n2 - 36] = byArray[n2];
                } else if (n2 <= 39) {
                    this.minimumVerticalFontSize[n2 - 38] = byArray[n2];
                } else if (n2 <= 41) {
                    this.maximumHorizontalFontSize[n2 - 40] = byArray[n2];
                } else if (n2 <= 43) {
                    this.nominalHorizontalFontSize[n2 - 42] = byArray[n2];
                } else if (n2 <= 45) {
                    this.minimumHorizontalFontSize[n2 - 44] = byArray[n2];
                } else if (n2 <= 48) {
                    this.isoTypefaceClassification[n2 - 46] = byArray[n2];
                } else if (n2 == 64) {
                    this.designFlags = byArray[n2];
                } else if (n2 <= 77) {
                    this.gcsGID[n2 - 76] = byArray[n2];
                } else if (n2 <= 79) {
                    this.ftGID[n2 - 78] = byArray[n2];
                }
            }
            ++n2;
        }
        this.typefaceDescription = new String(byArray3, FontResourceObject.EBCDIC).trim();
        byArray3 = null;
        byArray = FontResourceObject.readStructuredField(inputStream, FNC);
        this.metricsXUnitsPerUnitBase = new byte[2];
        this.metricsYUnitsPerUnitBase = new byte[2];
        this.maxCharacterBoxWidth = new byte[2];
        this.maxCharacterBoxHeight = new byte[2];
        this.rasterPatternDataCount = new byte[3];
        this.shapeXUnitsPerUnitBase = new byte[2];
        this.shapeYUnitsPerUnitBase = new byte[2];
        this.outlinePatternDataCount = new byte[4];
        this.fnnDataCount = new byte[4];
        this.fnnNameCount = new byte[2];
        int n3 = 0;
        while (n3 < byArray.length) {
            if (n3 != 0 && n3 != 2 && (n3 < 32 || n3 > 34)) {
                if (n3 == 1) {
                    this.patternTechnologyIdentifier = byArray[n3];
                } else if (n3 == 3) {
                    this.fontUseFlags = byArray[n3];
                } else if (n3 == 4) {
                    this.metricsXUnitBase = byArray[n3];
                } else if (n3 == 5) {
                    this.metricsYUnitBase = byArray[n3];
                } else if (n3 <= 7) {
                    this.metricsXUnitsPerUnitBase[n3 - 6] = byArray[n3];
                } else if (n3 <= 9) {
                    this.metricsYUnitsPerUnitBase[n3 - 8] = byArray[n3];
                } else if (n3 <= 11) {
                    this.maxCharacterBoxWidth[n3 - 10] = byArray[n3];
                } else if (n3 <= 13) {
                    this.maxCharacterBoxHeight[n3 - 12] = byArray[n3];
                } else if (n3 == 14) {
                    this.fnoGroupLength = byArray[n3];
                } else if (n3 == 15) {
                    this.fniGroupLength = byArray[n3];
                } else if (n3 == 16) {
                    this.rasterPatternDataAlignment = byArray[n3];
                } else if (n3 <= 19) {
                    this.rasterPatternDataCount[n3 - 17] = byArray[n3];
                } else if (n3 == 20) {
                    this.fnpGroupLength = byArray[n3];
                } else if (n3 == 21) {
                    this.fnmGroupLength = byArray[n3];
                } else if (n3 == 22) {
                    this.shapeXUnitBase = byArray[n3];
                } else if (n3 == 23) {
                    this.shapeYUnitBase = byArray[n3];
                } else if (n3 <= 25) {
                    this.shapeXUnitsPerUnitBase[n3 - 24] = byArray[n3];
                } else if (n3 <= 27) {
                    this.shapeYUnitsPerUnitBase[n3 - 26] = byArray[n3];
                } else if (n3 <= 31) {
                    this.outlinePatternDataCount[n3 - 28] = byArray[n3];
                } else if (n3 == 35) {
                    this.fnnGroupLength = byArray[n3];
                } else if (n3 <= 39) {
                    this.fnnDataCount[n3 - 36] = byArray[n3];
                } else if (n3 <= 41) {
                    this.fnnNameCount[n3 - 40] = byArray[n3];
                }
            }
            ++n3;
        }
        byArray = FontResourceObject.readStructuredField(inputStream, FNM);
        this.fontPatterns = new ArrayList();
        byte[] byArray4 = new byte[this.fnmGroupLength];
        int n4 = 0;
        int n5 = 0;
        while (n5 < byArray.length) {
            int n6 = n5 - this.fnmGroupLength * n4;
            byArray4[n6] = byArray[n5];
            if (n6 == this.fnmGroupLength - 1) {
                object = new FontPatternData();
                object.parse(byArray4);
                this.fontPatterns.add(object);
                byArray4 = new byte[this.fnmGroupLength];
                ++n4;
            }
            ++n5;
        }
        byArray4 = null;
        byArray = FontResourceObject.readStructuredField(inputStream, FNO);
        this.fontOrientations = new HashMap();
        ArrayList<FontOrientationData> arrayList = new ArrayList<FontOrientationData>();
        object = new byte[this.fnoGroupLength];
        n4 = 0;
        int n7 = 0;
        while (n7 < byArray.length) {
            int n8 = n7 - this.fnoGroupLength * n4;
            object[n8] = byArray[n7];
            if (n8 == this.fnoGroupLength - 1) {
                FontOrientationData fontOrientationData2 = new FontOrientationData();
                Short s = fontOrientationData2.parse((byte[])object);
                this.fontOrientations.put(s, fontOrientationData2);
                arrayList.add(fontOrientationData2);
                object = new byte[this.fnoGroupLength];
                ++n4;
            }
            ++n7;
        }
        object = null;
        byArray = FontResourceObject.readStructuredField(inputStream, FNP);
        byte[] byArray5 = new byte[this.fnpGroupLength];
        n4 = 0;
        int n9 = 0;
        while (n9 < byArray.length) {
            int n10 = n9 - this.fnpGroupLength * n4;
            byArray5[n10] = byArray[n9];
            if (n10 == this.fnpGroupLength - 1) {
                fontOrientationData = (FontOrientationData)arrayList.get(n4);
                fontOrientationData.parseFontPosition(byArray5);
                byArray5 = new byte[this.fnpGroupLength];
                ++n4;
            }
            ++n9;
        }
        object = null;
        int n11 = 0;
        while (n11 < arrayList.size()) {
            byArray = FontResourceObject.readStructuredField(inputStream, FNI);
            fontOrientationData = (FontOrientationData)arrayList.get(n11);
            fontOrientationData.parseFontIndex(byArray, this.fniGroupLength, this.getEncoding());
            ++n11;
        }
        arrayList = null;
        byArray = null;
    }
}

