/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

class TIFFFaxEncoder {
    public static final int WHITE = 0;
    public static final int BLACK = 1;
    public static byte[] byteTable = new byte[]{8, 7, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static int[] termCodesBlack = new int[]{230686730, 0x40000003, -1073741822, -2147483646, 0x60000003, 0x30000004, 0x20000004, 402653189, 335544326, 0x10000006, 0x8000007, 0xA000007, 0xE000007, 0x4000008, 0x7000008, 0xC000009, 96469002, 0x600000A, 0x200000A, 216006667, 0xD00000B, 226492427, 115343371, 0x500000B, 48234507, 0x300000B, 0xCA0000C, 0xCB0000C, 0xCC0000C, 0xCD0000C, 109051916, 110100492, 111149068, 112197644, 220200972, 221249548, 222298124, 223346700, 224395276, 225443852, 0x6C0000C, 114294796, 228589580, 229638156, 88080396, 0x550000C, 90177548, 91226124, 104857612, 105906188, 85983244, 87031820, 37748748, 57671692, 58720268, 40894476, 41943052, 92274700, 93323276, 45088780, 0x2C0000C, 94371852, 0x660000C, 108003340};
    public static int[] termCodesWhite = new int[]{889192456, 469762054, 0x70000004, -2147483644, -1342177276, -1073741820, -536870908, -268435452, -1744830459, -1610612731, 939524101, 0x40000005, 0x20000006, 0xC000006, -805306362, -738197498, -1476395002, -1409286138, 1308622855, 402653191, 0x10000007, 771751943, 0x6000007, 0x8000007, 0x50000007, 1442840583, 637534215, 1207959559, 0x30000007, 0x2000008, 0x3000008, 436207624, 452984840, 301989896, 318767112, 335544328, 352321544, 369098760, 385875976, 0x28000008, 687865864, 704643080, 721420296, 738197512, 754974728, 0x4000008, 0x5000008, 0xA000008, 0xB000008, 1375731720, 1392508936, 1409286152, 0x55000008, 603979784, 620757000, 0x58000008, 1493172232, 1509949448, 1526726664, 1241513992, 1258291208, 838860808, 0x33000008, 872415240};
    public static int[] makeupCodesBlack = new int[]{0, 62914570, 0xC80000C, 0xC90000C, 95420428, 0x330000C, 54525964, 55574540, 56623117, 57147405, 38797325, 39321613, 39845901, 40370189, 59768845, 60293133, 60817421, 61341709, 61865997, 62390285, 42991629, 43515917, 44040205, 44564493, 0x2D0000D, 47710221, 52428813, 52953101, 0x100000B, 25165835, 27262987, 18874380, 19922956, 20971532, 22020108, 23068684, 24117260, 0x1C0000C, 30408716, 31457292, 32505868, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static int[] makeupCodesWhite = new int[]{0, -671088635, -1879048187, 1543503878, 1845493767, 905969672, 922746888, 1677721608, 1694498824, 0x68000008, 1728053256, 0x66000009, 1719664649, 0x69000009, 1769996297, 1778384905, 1786773513, 1795162121, 1803550729, 1811939337, 1820327945, 1828716553, 1837105161, 1275068425, 1283457033, 1291845641, 0x60000006, 1300234249, 0x100000B, 25165835, 27262987, 18874380, 19922956, 20971532, 22020108, 23068684, 24117260, 0x1C0000C, 30408716, 31457292, 32505868, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static int[] passMode = new int[]{0x10000004};
    public static int[] vertMode = new int[]{0x6000007, 0xC000006, 0x60000003, -2147483647, 0x40000003, 0x8000006, 0x4000007};
    public static int[] horzMode = new int[]{0x20000003};
    public static int[][] termCodes = new int[][]{termCodesWhite, termCodesBlack};
    public static int[][] makeupCodes = new int[][]{makeupCodesWhite, makeupCodesBlack};
    public static int[][] pass = new int[][]{passMode, passMode};
    public static int[][] vert = new int[][]{vertMode, vertMode};
    public static int[][] horz = new int[][]{horzMode, horzMode};
    public boolean inverseFill;
    public int bits;
    public int ndex;

    TIFFFaxEncoder(boolean bl) {
        this.inverseFill = bl;
    }

    public int nextState(byte[] byArray, int n, int n2, int n3) {
        int n4;
        if (byArray == null) {
            return n3;
        }
        int n5 = n + (n2 >>> 3);
        int n6 = n + (n3 >>> 3) - 1;
        int n7 = n2 & 7;
        if ((byArray[n5] & 128 >>> n7) != 0) {
            n4 = ~byArray[n5] & 255 >>> n7;
            while (n5 < n6 && n4 == 0) {
                n4 = ~byArray[++n5] & 0xFF;
            }
        } else {
            n4 = byArray[n5] & 255 >>> n7;
            if (n4 != 0) {
                n2 = (n5 - n) * 8 + byteTable[n4];
                return n2 < n3 ? n2 : n3;
            }
            while (n5 < n6) {
                if ((n4 = byArray[++n5] & 0xFF) == 0) continue;
                n2 = (n5 - n) * 8 + byteTable[n4];
                return n2 < n3 ? n2 : n3;
            }
        }
        return (n2 = (n5 - n) * 8 + byteTable[n4]) < n3 ? n2 : n3;
    }

    public void initBitBuf() {
        this.ndex = 0;
        this.bits = 0;
    }

    public int add1DBits(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5 = n;
        int n6 = n2 >>> 6;
        n2 &= 0x3F;
        if (n6 != 0) {
            while (n6 > 40) {
                n4 = makeupCodes[n3][40];
                this.bits |= (n4 & 0xFFF80000) >>> this.ndex;
                this.ndex += n4 & 0xFFFF;
                while (this.ndex > 7) {
                    byArray[n5++] = (byte)(this.bits >>> 24);
                    this.bits <<= 8;
                    this.ndex -= 8;
                }
                n6 -= 40;
            }
            n4 = makeupCodes[n3][n6];
            this.bits |= (n4 & 0xFFF80000) >>> this.ndex;
            this.ndex += n4 & 0xFFFF;
            while (this.ndex > 7) {
                byArray[n5++] = (byte)(this.bits >>> 24);
                this.bits <<= 8;
                this.ndex -= 8;
            }
        }
        n4 = termCodes[n3][n2];
        this.bits |= (n4 & 0xFFF80000) >>> this.ndex;
        this.ndex += n4 & 0xFFFF;
        while (this.ndex > 7) {
            byArray[n5++] = (byte)(this.bits >>> 24);
            this.bits <<= 8;
            this.ndex -= 8;
        }
        return n5 - n;
    }

    public int add2DBits(byte[] byArray, int n, int[][] nArray, int n2) {
        int n3 = n;
        int n4 = 0;
        int n5 = nArray[n4][n2];
        this.bits |= (n5 & 0xFFF80000) >>> this.ndex;
        this.ndex += n5 & 0xFFFF;
        while (this.ndex > 7) {
            byArray[n3++] = (byte)(this.bits >>> 24);
            this.bits <<= 8;
            this.ndex -= 8;
        }
        return n3 - n;
    }

    public int addEOL(boolean bl, boolean bl2, boolean bl3, byte[] byArray, int n) {
        int n2 = n;
        if (bl2) {
            this.ndex += this.ndex <= 4 ? 4 - this.ndex : 12 - this.ndex;
        }
        if (bl) {
            this.bits |= 0x100000 >>> this.ndex;
            this.ndex += 12;
        } else {
            this.bits |= (bl3 ? 0x180000 : 0x100000) >>> this.ndex;
            this.ndex += 13;
        }
        while (this.ndex > 7) {
            byArray[n2++] = (byte)(this.bits >>> 24);
            this.bits <<= 8;
            this.ndex -= 8;
        }
        return n2 - n;
    }

    public int addEOFB(byte[] byArray, int n) {
        int n2 = n;
        this.bits |= 0x100100 >>> this.ndex;
        this.ndex += 24;
        while (this.ndex > 0) {
            byArray[n2++] = (byte)(this.bits >>> 24);
            this.bits <<= 8;
            this.ndex -= 8;
        }
        return n2 - n;
    }

    public int encode1D(byte[] byArray, int n, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = n6 + n3;
        int n8 = n4;
        int n9 = (byArray[n5 + (n6 >>> 3)] & 0xFF) >>> 7 - (n6 & 7) & 1;
        int n10 = 1;
        if (n9 != 0) {
            n8 += this.add1DBits(byArray2, n8, 0, 0);
        } else {
            n10 = 0;
        }
        while (n6 < n7) {
            int n11 = this.nextState(byArray, n5, n6, n7) - n6;
            n8 += this.add1DBits(byArray2, n8, n11, n10);
            n6 += n11;
            n10 ^= 1;
        }
        return n8 - n4;
    }

    synchronized int encodeRLE(byte[] byArray, int n, int n2, int n3, byte[] byArray2) {
        this.initBitBuf();
        int n4 = this.encode1D(byArray, n, n2, n3, byArray2, 0);
        while (this.ndex > 0) {
            byArray2[n4++] = (byte)(this.bits >>> 24);
            this.bits <<= 8;
            this.ndex -= 8;
        }
        return n4;
    }

    synchronized int encodeT4(boolean bl, boolean bl2, byte[] byArray, int n, int n2, int n3, int n4, byte[] byArray2) {
        int n5;
        byte[] byArray3 = byArray;
        int n6 = 0;
        int n7 = 0;
        this.initBitBuf();
        int n8 = 2;
        for (n5 = 0; n5 < n4; ++n5) {
            if (bl || n5 % n8 == 0) {
                n7 += this.addEOL(bl, bl2, true, byArray2, n7);
                n7 += this.encode1D(byArray, n6, n2, n3, byArray2, n7);
            } else {
                n7 += this.addEOL(bl, bl2, false, byArray2, n7);
                int n9 = n6 - n;
                int n10 = n2;
                int n11 = n10 + n3;
                int n12 = (byArray[n6 + (n10 >>> 3)] & 0xFF) >>> 7 - (n10 & 7) & 1;
                int n13 = n12 != 0 ? n10 : this.nextState(byArray, n6, n10, n11);
                n12 = (byArray3[n9 + (n10 >>> 3)] & 0xFF) >>> 7 - (n10 & 7) & 1;
                int n14 = n12 != 0 ? n10 : this.nextState(byArray3, n9, n10, n11);
                int n15 = 0;
                while (true) {
                    int n16;
                    if ((n16 = this.nextState(byArray3, n9, n14, n11)) < n13) {
                        n7 += this.add2DBits(byArray2, n7, pass, 0);
                        n10 = n16;
                    } else {
                        int n17 = n14 - n13 + 3;
                        if (n17 <= 6 && n17 >= 0) {
                            n7 += this.add2DBits(byArray2, n7, vert, n17);
                            n10 = n13;
                        } else {
                            int n18 = this.nextState(byArray, n6, n13, n11);
                            n7 += this.add2DBits(byArray2, n7, horz, 0);
                            n7 += this.add1DBits(byArray2, n7, n13 - n10, n15);
                            n7 += this.add1DBits(byArray2, n7, n18 - n13, n15 ^ 1);
                            n10 = n18;
                        }
                    }
                    if (n10 >= n11) break;
                    n15 = (byArray[n6 + (n10 >>> 3)] & 0xFF) >>> 7 - (n10 & 7) & 1;
                    n13 = this.nextState(byArray, n6, n10, n11);
                    n14 = this.nextState(byArray3, n9, n10, n11);
                    n12 = (byArray3[n9 + (n14 >>> 3)] & 0xFF) >>> 7 - (n14 & 7) & 1;
                    if (n12 != n15) continue;
                    n14 = this.nextState(byArray3, n9, n14, n11);
                }
            }
            n6 += n;
        }
        for (n5 = 0; n5 < 6; ++n5) {
            n7 += this.addEOL(bl, bl2, true, byArray2, n7);
        }
        while (this.ndex > 0) {
            byArray2[n7++] = (byte)(this.bits >>> 24);
            this.bits <<= 8;
            this.ndex -= 8;
        }
        return n7;
    }

    public synchronized int encodeT6(byte[] byArray, int n, int n2, int n3, int n4, byte[] byArray2) {
        byte[] byArray3 = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        this.initBitBuf();
        while (n4-- != 0) {
            int n8 = n2;
            int n9 = n8 + n3;
            int n10 = (byArray[n6 + (n8 >>> 3)] & 0xFF) >>> 7 - (n8 & 7) & 1;
            int n11 = n10 != 0 ? n8 : this.nextState(byArray, n6, n8, n9);
            n10 = byArray3 == null ? 0 : (byArray3[n5 + (n8 >>> 3)] & 0xFF) >>> 7 - (n8 & 7) & 1;
            int n12 = n10 != 0 ? n8 : this.nextState(byArray3, n5, n8, n9);
            int n13 = 0;
            while (true) {
                int n14;
                if ((n14 = this.nextState(byArray3, n5, n12, n9)) < n11) {
                    n7 += this.add2DBits(byArray2, n7, pass, 0);
                    n8 = n14;
                } else {
                    int n15 = n12 - n11 + 3;
                    if (n15 <= 6 && n15 >= 0) {
                        n7 += this.add2DBits(byArray2, n7, vert, n15);
                        n8 = n11;
                    } else {
                        int n16 = this.nextState(byArray, n6, n11, n9);
                        n7 += this.add2DBits(byArray2, n7, horz, 0);
                        n7 += this.add1DBits(byArray2, n7, n11 - n8, n13);
                        n7 += this.add1DBits(byArray2, n7, n16 - n11, n13 ^ 1);
                        n8 = n16;
                    }
                }
                if (n8 >= n9) break;
                n13 = (byArray[n6 + (n8 >>> 3)] & 0xFF) >>> 7 - (n8 & 7) & 1;
                n11 = this.nextState(byArray, n6, n8, n9);
                n12 = this.nextState(byArray3, n5, n8, n9);
                n10 = byArray3 == null ? 0 : (byArray3[n5 + (n12 >>> 3)] & 0xFF) >>> 7 - (n12 & 7) & 1;
                if (n10 != n13) continue;
                n12 = this.nextState(byArray3, n5, n12, n9);
            }
            byArray3 = byArray;
            n5 = n6;
            n6 += n;
        }
        n7 += this.addEOFB(byArray2, n7);
        return n7;
    }
}

