package com.renderx.xepx.x4u.ct.charsetspanel;

import java.awt.Dimension;
import java.awt.event.FocusEvent;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import com.renderx.xepx.x4u.ct.DomToJTreeAdapter;

/**
 * @author AlexanderR
 */

public class CodepageNamePanel extends JPanel

{
    private static final long serialVersionUID = 3839950733117926797L;

    private CharsetsPanel parentPanel;
    
    private JLabel codepageNameLabel = new JLabel();
    private JTextField codepageNameTextField = new JTextField();
    private JTextField source = new JTextField();
    
    public CodepageNamePanel(CharsetsPanel _charsetsPanel)
    {
	this.parentPanel = _charsetsPanel;
	
        add(codepageNameLabel, null);
        add(codepageNameTextField, null);
        
        codepageNameTextField.setName("codepage-name");
        codepageNameTextField.setText("1");      
        codepageNameTextField.setPreferredSize(new Dimension(70, 15));
        codepageNameTextField.setEnabled(true);
        source.setName("");
        
	codepageNameLabel.setText("codepage-name");
	
	codepageNameTextField.getDocument().addDocumentListener
	(
		new DocumentListener()
		{
		  public void insertUpdate(DocumentEvent e) {
		      //System.out.println("insertUpdate");
		      parentPanel.textField_focusLost(source, (Element) parentPanel.getCharsetNode());
		  };
		  public void removeUpdate(DocumentEvent e) { 
		      //System.out.println("removeUpdate");
		      parentPanel.textField_focusLost(source, (Element) parentPanel.getCharsetNode());
		  };
		  public void changedUpdate(DocumentEvent e) { 
		      //System.out.println("changedUpdate");
		  };
		}
	);
	
	codepageNameTextField.addFocusListener
        (
        	new java.awt.event.FocusAdapter()
        	{
        	    public void focusLost(FocusEvent e)
        	    {
        		//parentPanel.textField_focusLost((JTextField)e.getSource(), (Element) parentPanel.getCharsetNode());
        	    }
        
        	    public void focusGained(FocusEvent e)
        	    {
        		parentPanel.textField_focusGained(e, (Element) parentPanel.getCharsetNode());
        	    }
        });	
    }
    
    
    public String getText()
    {
	return codepageNameTextField.getText();
    }
    
    public void setText(String text)
    {
	codepageNameTextField.setText(text);
    }
    
    public void setEnabled(boolean value)
    {
	codepageNameTextField.setEnabled(value);
    }
    
    public void setTextFromNode(DomToJTreeAdapter.FontTreeNode node)
    {
	NamedNodeMap attribs = node.getBody().getAttributes();
	if (attribs.getNamedItem("name") != null)
	{
	    //setSelected(true);
	    setText(attribs.getNamedItem("name").getNodeValue());
	    setEnabled(true);
	} else
	{
	    //setSelected(false);
	    setText("11");
	    setEnabled(false);
	}	
	this.updateUI();
	
	Node sizeNode = node.getBody().getAttributes().getNamedItem("name");
	String sizeValue = "";
	
	if(sizeNode != null)
	    sizeValue = node.getBody().getAttributes().getNamedItem("name").getNodeValue();
	
	setText(sizeValue);
    }

    public JTextField getSource()
    {
        return source;
    }

    public void setSource(JTextField source)
    {
        this.source = source;
    }    
}
