package com.renderx.xepx.x4u.ct;

import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.event.*;
import javax.swing.event.*;
import java.util.*;
import org.w3c.dom.Document;
import org.w3c.dom.*;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 * @todo add Actions for commands button
 */

public class LanguagePanel extends JPanel implements ActionListener{//,TableModelListener{
  Controller cntr = new Controller();
  Document doc;
  DOMWalker model;
  DomToTableModel lngTM;
  DomToTableModel fntTM;
  Element currentNode;
  String currTextValue = "";
//  Map lngMap = new TreeMap();
  int currLngIndex = -1;
  BorderLayout borderLayout1 = new BorderLayout();
  Border border1;
  JPanel parametersPanel = new JPanel();
  Border border2;
  TitledBorder titledBorder1;
  BorderLayout borderLayout2 = new BorderLayout();
  JPanel customParamPanel = new JPanel();
  JPanel lngDetailPanel = new JPanel();
  JLabel hyppLabel = new JLabel();
  JLabel encodindLabel = new JLabel();
  JTextField encodingTextField = new JTextField();
  JTextField pattTextField = new JTextField();
  JLabel codesLabel = new JLabel();
  JTextField codesTextField = new JTextField();
  JTable lngList;
  JScrollPane lngScrollPane; // = new JScrollPane(lngList);
  JSplitPane jSplitPane1 = new JSplitPane();
  JButton browseButton = new JButton();
  JLabel pattLabel = new JLabel();
  GridLayout gridLayout1 = new GridLayout();
  JPanel lngParamPanel = new JPanel();
  GridBagLayout gridBagLayout2 = new GridBagLayout();
  BorderLayout borderLayout3 = new BorderLayout();
  JPanel lngAliasesPanel = new JPanel();
  JPanel lngCommandPanel = new JPanel();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JScrollPane aliasesScrollPane = new JScrollPane();
  GridLayout gridLayout2 = new GridLayout();
  JTable aliaseTable; // = new JTable();
  JButton deleteButton = new JButton();
///////////  JButton editButton = new JButton();
  JButton addButton = new JButton();
  Border border3;
  Border border4;
  TitledBorder titledBorder2;

  public LanguagePanel(Document doc) {
    this.doc = doc;
    model = DOMWalker.getDOMWalker(doc);/////////////new DOMWalker(doc);
    this.currentNode = (Element)model.lngRoot.getElementsByTagName("language").item(0);
    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    border1 = new EtchedBorder(EtchedBorder.RAISED, Color.white, new Color(148, 145, 140));
    border2 = new EtchedBorder(EtchedBorder.RAISED, Color.white, new Color(148, 145, 140));
    border4 = new EtchedBorder(EtchedBorder.RAISED, Color.white, new Color(142, 142, 142));
    titledBorder2 = new TitledBorder(border4, "Font Aliases");
    lngTM = new DomToTableModel(model.lngRoot,false);
    lngList = new JTable (lngTM);
    lngList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    ///// for language table row changes action ////
    ListSelectionModel rowSM = lngList.getSelectionModel();
    currLngIndex = 0;
    rowSM.addListSelectionListener(new ListSelectionListener() {
        public void valueChanged(ListSelectionEvent e) {
            //Ignore extra messages.
            if (e.getValueIsAdjusting()) return;
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (lsm.isSelectionEmpty()) return;
            else cntr.action(new ActionEvent(e.getSource(),0,"changeRow"));
        }
    });
    lngScrollPane = new JScrollPane(lngList);
    titledBorder1 = new TitledBorder(new EtchedBorder(EtchedBorder.RAISED, Color.white,
                                                      new Color(148, 145, 140)),"Supported Languages");
    this.setLayout(borderLayout1);
    parametersPanel.setBorder(titledBorder1);
    parametersPanel.setLayout(borderLayout2);
    hyppLabel.setText("Hyphenation");
    encodindLabel.setText("Encoding");
    lngDetailPanel.setLayout(borderLayout3);
    customParamPanel.setPreferredSize(new Dimension(160, 300));
    customParamPanel.setLayout(gridLayout1);
    encodingTextField.setPreferredSize(new Dimension(80, 21));
    encodingTextField.setText("");
    encodingTextField.setActionCommand("encodingTextField");
    encodingTextField.setName("encodingTextField");
    encodingTextField.addActionListener(this);
    encodingTextField.addFocusListener(new java.awt.event.FocusAdapter() {
               public void focusLost(FocusEvent e) {
                 cntr.textField_focusLost(e);
               }
               public void focusGained(FocusEvent e) {
                 cntr.textField_focusGained(e);
               }
             });

    pattTextField.setText("");
    pattTextField.setHorizontalAlignment(SwingConstants.LEFT);
    pattTextField.setPreferredSize(new Dimension(80, 21));
    pattTextField.setActionCommand("pattTextField");
    pattTextField.setName("pattTextField");
    pattTextField.addActionListener(this);
    pattTextField.addFocusListener(new java.awt.event.FocusAdapter() {
               public void focusLost(FocusEvent e) {
                 cntr.textField_focusLost(e);
               }
               public void focusGained(FocusEvent e) {
                 cntr.textField_focusGained(e);
               }
             });

    codesLabel.setText("Codes");
    codesTextField.setPreferredSize(new Dimension(80, 21));
    codesTextField.setText("");
    codesTextField.setActionCommand("codesTextField");
    codesTextField.setName("codesTextField");
    codesTextField.addActionListener(this);
    codesTextField.addFocusListener(new java.awt.event.FocusAdapter() {
               public void focusLost(FocusEvent e) {
                 cntr.textField_focusLost(e);
               }
               public void focusGained(FocusEvent e) {
                 cntr.textField_focusGained(e);
               }
             });
    jSplitPane1.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
    jSplitPane1.setPreferredSize(new Dimension(350, 300));
    jSplitPane1.setDividerLocation(0.35);
    browseButton.setMaximumSize(new Dimension(80, 22));
    browseButton.setMinimumSize(new Dimension(80, 22));
    browseButton.setMargin(new Insets(0, 10, 0, 10));
    browseButton.setText("Browse");
    browseButton.setActionCommand("browseButton");
    browseButton.addActionListener(this);
    pattLabel.setText("Pattern file:");
    gridLayout1.setColumns(1);
    gridLayout1.setRows(0);
    lngParamPanel.setLayout(gridBagLayout1);
    deleteButton.setText("Delete language");
    deleteButton.setActionCommand("Delete");
    deleteButton.addActionListener(this);
/////////    editButton.setText("Edit Language");
/////////    editButton.addActionListener(this);
    addButton.setActionCommand("Add");
    addButton.setText("New language");
    addButton.addActionListener(this);
    aliasesScrollPane.setBorder(null);
    lngList.setShowHorizontalLines(false);
    lngList.setShowVerticalLines(false);
    this.add(parametersPanel, BorderLayout.CENTER);
    lngDetailPanel.add(lngParamPanel, BorderLayout.NORTH);
    lngParamPanel.add(encodindLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0 , GridBagConstraints.EAST,
                                                            GridBagConstraints.NONE, new Insets(5, 0, 0, 5), 0, 0));
    lngParamPanel.add(encodingTextField, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0,
         GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 0, 0, 0), 0, 0));
    lngParamPanel.add(pattTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0
                                                            , GridBagConstraints.WEST,
                                                            GridBagConstraints.HORIZONTAL,
                                                            new Insets(5, 0, 0, 0), 0, 0));
    lngParamPanel.add(codesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
                                                         , GridBagConstraints.EAST,
                                                         GridBagConstraints.NONE,
                                                         new Insets(5, 0, 0, 5), 0, 0));
    lngParamPanel.add(hyppLabel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0
                                                        , GridBagConstraints.CENTER,
                                                        GridBagConstraints.NONE,
                                                        new Insets(15, 0, 0, 0), 0, 0));
    lngParamPanel.add(pattLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
                                                        , GridBagConstraints.EAST,
                                                        GridBagConstraints.NONE,
                                                        new Insets(5, 0, 0, 5), 0, 0));
    lngParamPanel.add(codesTextField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0
        , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 0, 0, 10), 0, 0));
    lngParamPanel.add(browseButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
                                                           , GridBagConstraints.CENTER,
                                                           GridBagConstraints.NONE,
                                                           new Insets(5, 2, 2, 10), 0, 0));
    parametersPanel.add(jSplitPane1, BorderLayout.CENTER);
    jSplitPane1.add(customParamPanel, JSplitPane.TOP);
    customParamPanel.add(lngScrollPane, null);
    jSplitPane1.add(lngDetailPanel, JSplitPane.BOTTOM);
    lngAliasesPanel.add(aliasesScrollPane, null);
    parametersPanel.add(lngCommandPanel, BorderLayout.SOUTH);
    aliasesScrollPane.getViewport().add(aliaseTable, null);
    lngCommandPanel.add(addButton, null);
////////////    lngCommandPanel.add(editButton, null);
    lngCommandPanel.add(deleteButton, null);
    fillLngDetail();
  }

  void fillLngDetail(){
    Map mp = DOMWalker.getLngDetail(lngList.getValueAt(currLngIndex,0).toString());//currentNode.getAttributes().getNamedItem("name").getNodeValue());//lngName);
    this.codesTextField.setText((mp.get("codes") == null) ? "" : (String) mp.get("codes"));
    this.pattTextField.setText((mp.get("pattern") == null) ? "" : (String) mp.get("pattern"));
    this.encodingTextField.setText((mp.get("encoding") == null) ? "" : (String) mp.get("encoding"));
    boolean depends = (pattTextField.getText().length() > 0);
    encodingTextField.setEditable(depends);
    encodingTextField.setEnabled(depends);
    lngDetailPanel.remove(lngAliasesPanel);
    lngAliasesPanel = new FontAliasesPanel(this.currentNode);
    lngAliasesPanel.setVisible(true);
    lngDetailPanel.add(lngAliasesPanel, BorderLayout.CENTER);
    lngDetailPanel.updateUI();
  }

  public void actionPerformed(ActionEvent e) {
    cntr.action(e);
  }

  ////////////////////// Action implementation //////////////////////
  class Controller {
    void action(ActionEvent e) {
      String action = e.getActionCommand();
      String value = null;
      if(action.equals("changeRow")){
        currLngIndex = lngList.getSelectedRow();
        currentNode = (Element)lngTM.getNodeAt(currLngIndex);
        fillLngDetail();
      }
      else if (action.equals("codesTextField")) {
        value = codesTextField.getText().trim();
        Element curr = (Element) currentNode;
        if (value.length() == 0) {
          value = "none";
        }
        curr.setAttribute("codes", value);
      }
      else if (action.equals("browseButton") || action.equals("pattTextField")) {
        if (action.equals("browseButton")) {
          JFileChooser fc = new JFileChooser();
          fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
          int returnVal = fc.showOpenDialog(encodingTextField);
          if (returnVal == JFileChooser.CANCEL_OPTION) {
            return;/////////////pattTextField.setText("");
          }
          else {
            pattTextField.setText(fc.getSelectedFile().getAbsolutePath());
          }
        }
        value = pattTextField.getText().trim();
        NodeList lst = currentNode.getChildNodes();
        Element curr = null;
        encodingTextField.setEnabled(true);
        encodingTextField.setEditable(true);
        for (int i = 0; i < lst.getLength(); i++) {
          if (lst.item(i).getNodeName().equalsIgnoreCase("hyphenation")) {
            curr = (Element) lst.item(i);
            break;
          }
        }
        if (value.length() > 0){
          if (curr == null) {
            curr = doc.createElement("hyphenation");
            currentNode.appendChild(curr);
          }
          curr.setAttribute("pattern", value);
        }
        else if (curr != null) {
          currentNode.removeChild(curr);
        }
      }
      if (action.equals("encodingTextField")) {
        value = encodingTextField.getText().trim();
        NodeList lst = currentNode.getChildNodes();
        Element curr = null;
        for (int i = 0; i < lst.getLength(); i++) {
          if (lst.item(i).getNodeName().equalsIgnoreCase("hyphenation")) {
            curr = (Element) lst.item(i);
            break;
          }
        }
        if (value.length() > 0){
          if (curr == null) {
            curr = doc.createElement("hyphenation");
            currentNode.appendChild(curr);
          }
          curr.setAttribute("encoding", value);
        }
        else if (curr != null) {
          currentNode.removeChild(curr);
        }
      }
      if(action.equalsIgnoreCase("Add")){
        Element tmp = doc.createElement("language");
        tmp.setAttribute("codes","none");
        tmp.setAttribute("name","New Language");
        model.lngRoot.appendChild(tmp);
        currentNode = tmp;
        lngTM.addRow(tmp);//"New Lang");
        currLngIndex = lngTM.getRowCount() -1;
        fillLngDetail();//"New Lang");
      }
      if(action.equalsIgnoreCase("Delete")){
        int curr = lngList.getSelectedRow();
        Node tmp = (Element)lngTM.getNodeAt(curr);
        DOMWalker.lngRoot.removeChild(tmp);
        lngTM.deleteRow(curr);
        currLngIndex = (curr == 0)?0:curr -1;
      }
      if(value != null) currTextValue = value;
    }

    void textField_focusGained(FocusEvent e) {
      currTextValue = ( (JTextField) e.getSource()).getText().trim();
    }

    void textField_focusLost(FocusEvent e) {
      JTextField s = (JTextField) e.getSource();
/////////////System.out.println("??????? "+currentNode.toString());
      String cmd = s.getName();
      String attValue = s.getText().trim();
      String attName = null;
      if (currTextValue == attValue) return;
      if(cmd.equalsIgnoreCase("encodingTextField") || cmd.equalsIgnoreCase("pattTextField")){
        Element el = (Element)currentNode.getElementsByTagName("hyphenation").item(0);
        attName = (cmd.equalsIgnoreCase("pattTextField"))?"pattern":"encoding";
        if (attValue.length() == 0 && el != null) {
          el.removeAttribute(attName);
          if(cmd.equalsIgnoreCase("pattTextField")){
             encodingTextField.setEnabled(false);
             encodingTextField.setEditable(false);
          }
        }
        else {
          if (el == null) {
            el = currentNode.getOwnerDocument().createElement("hyphenation");
            currentNode.appendChild(el);
          }
          el.setAttribute(attName, attValue);
          encodingTextField.setEnabled(true);
          encodingTextField.setEditable(true);
        }
      } else if (cmd.equalsIgnoreCase("codesTextField"))
          currentNode.setAttribute("codes",attValue);
    }
  }
}
