package com.renderx.xepx.x4u.ct;

import javax.swing.*;
import javax.swing.border.*;

import java.awt.*;
import java.awt.event.*;

import javax.swing.filechooser.*;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.*;

/**
 * <p>Description: Retrive formatting options from selected xml-file, make changees and save back.
 * <p>Usage:
 * <ol><li> ConfigTools() - activate file-brouse screen for xep.xml selection (with hidden parent);
 *   <li> ConfigTools(xmlFilePath) - open formatting options from given xmlFilePath;
 *   <li> ConfigTools(parentFrame) - same as 1 with parentFrame as owner of this dialog;
 *   <li> ConfigTools(parentFrame) - same as 3 for given xmlFilePath.
 * </ol>
 * @see DOMWalker - read, change, edit DOM from xml source.
 * @see KernelPanel - for common options
 * @see BackendPanel - for PDF and PostScript options
 * @see LanguagePanel - for Supported Language options
 * @see FontPanel - for Fonts grouping, aliases and options
 * Copyright: Copyright (c) 2004</p>
 * <p>Company: Zenteq.am</p>
 * @author: B. Karapetyan (boris@zenteq.am)
 * @version 0.01
 */

public class ConfigTools extends JDialog
{
    boolean colapse = false; // close parent frame or not
    Frame parent = null;
    String xepFileName = null;
    DOMWalker domWalker;
    Document doc;
    public ConfigTools()
    {
	this(new Frame("Configure"), "", true);
    }

    public ConfigTools(Frame parent)
    {
	this(parent, "", false);
    }

    public ConfigTools(String xepFileName)
    {
	this(new Frame("Configure"), xepFileName, true);
    }

    public ConfigTools(Frame parent, String xepFileName, boolean colapse)
    {
	super(parent, true);
	this.parent = parent;
	this.colapse = colapse;
	if (xepFileName == null || xepFileName.length() == 0)
	    xepFileName = setXmlFileName();
	if (xepFileName == null)
	    finish(); // not continued with null xep.xml
	this.domWalker = DOMWalker.getDOMWalker(xepFileName); // new
                                                                // DOMWalker(xepFileName);
	this.doc = domWalker.getDoc();
	this.setModal(true);
	try
	{
	    init();
	} catch (Exception e)
	{
	    e.printStackTrace();
	}
	this.validate();
	this.setVisible(true);
    }

    private void init() throws Exception
    {
	Border tabBorder = BorderFactory.createCompoundBorder(new EtchedBorder(
		EtchedBorder.RAISED, Color.white, new Color(148, 145, 140)),
		BorderFactory.createEmptyBorder(5, 5, 5, 5));
	Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	Dimension frameSize = new Dimension(800, 600);
	this.setSize(frameSize);
	this.setTitle("XEP Configuration");
	if (frameSize.height > screenSize.height)
	    frameSize.height = screenSize.height;
	if (frameSize.width > screenSize.width)
	    frameSize.width = screenSize.width;
	this.setLocation((screenSize.width - frameSize.width) / 2,
		(screenSize.height - frameSize.height) / 2);

	JTabbedPane tabbedPane1 = new JTabbedPane();
	tabbedPane1.addTab("Main", new KernelPanel(doc));
	tabbedPane1.addTab("Backends", new BackendPanel(doc));
	tabbedPane1.addTab("Languages", new LanguagePanel(doc));
	tabbedPane1.addTab("Fonts", new FontsPanel(doc));

	// /// commandPanel components /////
	JPanel commandPanel = new JPanel();
	JButton exitButton = new JButton();
	JButton saveButton = new JButton();
	exitButton.setText("Exit");
	exitButton.addActionListener(new java.awt.event.ActionListener()
	{
	    public void actionPerformed(ActionEvent e)
	    {
		finish();
	    }
	});
	saveButton.setText("Save");
	saveButton.addActionListener(new java.awt.event.ActionListener()
	{
	    public void actionPerformed(ActionEvent e)
	    {
		NodeList nl = domWalker.optRoot.getElementsByTagName("option");
		boolean chk = true;
		String name = "";

		for (int i = 0; i < nl.getLength(); i++)
		{
		    Node node = nl.item(i);
		    if (node.getAttributes().getNamedItem("name").getNodeValue().startsWith("AFPFont"))
		    {
			String s = node.getAttributes().getNamedItem("value").getNodeValue();
			java.util.StringTokenizer t = new java.util.StringTokenizer(
				s, ", ");
			if (t.countTokens() != 9)
			{
			    chk = false;
			    name = node.getAttributes().getNamedItem("name").getNodeValue();
			    break;
			}
		    }
		}
		if (!chk)
		{
		    JOptionPane.showMessageDialog(new JFrame(), "The value of "
			    + name + " cannot be empty.", "Error",
			    JOptionPane.OK_OPTION);
		} else
		{
		    domWalker.writeDoc();
		    finish();
		}
	    }
	});

	commandPanel.add(saveButton, null);
	commandPanel.add(exitButton, null);

	JPanel mainPanel = new JPanel();
	this.getContentPane().add(mainPanel, BorderLayout.CENTER);
	mainPanel.setLayout(new BorderLayout());
	mainPanel.add(tabbedPane1, BorderLayout.CENTER);
	mainPanel.add(commandPanel, BorderLayout.SOUTH);
    }

  String setXmlFileName()
    {
	JFileChooser fc = new JFileChooser();
	fc.setDialogTitle("Select configuration file");
	fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
	fc.setApproveButtonText("Select configuration file");
	fc.setFileFilter(new FileFilter()
	{
	    public boolean accept(File f)
	    {
		if (f.isDirectory())
		    return true;
		String ext = f.getName();
		int ind = ext.lastIndexOf(".");
		return (ind > 0 && ind < ext.length() - 1 && ext.substring(
			ind + 1).equalsIgnoreCase("xml"));
	    }

	    public String getDescription()
	    {
		return "XML";
	    }
	});
	int returnVal = fc.showOpenDialog(null);
	if (returnVal == JFileChooser.CANCEL_OPTION)
	    return null;
	else
	    return fc.getSelectedFile().getAbsolutePath();
    }

    protected void processWindowEvent(WindowEvent e)
    {
	super.processWindowEvent(e);
	if (e.getID() == WindowEvent.WINDOW_CLOSING)
	{
	    finish();
	}
    }

    void finish()
    {// current frame closed allwais, parent - only if collapse is true
	DOMWalker.cleanUp();
	this.dispose();
	if (this.colapse)
	    System.exit(0);
    }

    ///////// for Stayalone starting ///////////////////
    public static void main(String[] args)
    {
	Frame test = new Frame("TESTING");
	test.setSize(100, 100);
	test.validate();
	test.setVisible(true);
	ConfigTools configTools1 = new ConfigTools();//test);
    }
}
