/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre.exp;

import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.Expr;
import com.renderx.xep.pre.ParserContext;
import com.renderx.xep.pre.ParserException;

public class RGB_Color
extends Expr {
    protected Attr R = null;
    protected Attr G = null;
    protected Attr B = null;

    public String toString() {
        return "rgb(" + this.R + ", " + this.G + ", " + this.B + ")";
    }

    public RGB_Color() {
    }

    public RGB_Color(Attr attr, Attr attr2, Attr attr3) {
        this.R = attr;
        this.G = attr2;
        this.B = attr3;
    }

    public Attr initialize(Attr[] attrArray) throws ParserException {
        if (attrArray == null) {
            throw new ParserException("rgb() function requires 3 arguments");
        }
        if (attrArray.length != 3) {
            throw new ParserException("rgb() function requires 3 arguments");
        }
        this.R = attrArray[0];
        this.G = attrArray[1];
        this.B = attrArray[2];
        return this.preevaluate();
    }

    public final Attr preevaluate() throws ParserException {
        return this.calculate(this.R.preevaluate(), this.G.preevaluate(), this.B.preevaluate());
    }

    public final Attr evaluate(ParserContext parserContext, Attn attn) throws ParserException {
        return this.calculate(this.R.evaluate(parserContext, attn), this.G.evaluate(parserContext, attn), this.B.evaluate(parserContext, attn));
    }

    protected final Attr calculate(Attr attr, Attr attr2, Attr attr3) throws ParserException {
        if (attr instanceof Expr || attr2 instanceof Expr || attr3 instanceof Expr) {
            return attr == this.R && attr2 == this.G && attr3 == this.B ? this : new RGB_Color(attr, attr2, attr3);
        }
        double d = this.extractColorComponent(attr);
        double d2 = this.extractColorComponent(attr2);
        double d3 = this.extractColorComponent(attr3);
        return Attr.Color.RGB.create(d, d2, d3);
    }

    private double extractColorComponent(Attr attr) throws ParserException {
        double d = 0.0;
        if (attr instanceof Attr.Percentage) {
            d = attr.percentage() / 100.0;
        } else if (attr instanceof Attr.Ratio) {
            d = attr.ratio() / 255.0;
        } else if (attr instanceof Attr.Count) {
            d = (double)attr.count() / 255.0;
        } else {
            throw new ParserException("Argument of rgb() function cannot be of type " + attr.getTypeName());
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }
}

