/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.gen;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.FontRecord;
import com.renderx.fonts.Metric;
import com.renderx.graphics.Image;
import com.renderx.graphics.Media;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.Sort;
import com.renderx.util.URLSpec;
import com.renderx.xep.cmp.Area;
import com.renderx.xep.cmp.FO;
import com.renderx.xep.cmp.Item;
import com.renderx.xep.cmp.Rectangle;
import com.renderx.xep.cmp.Xattr;
import com.renderx.xep.fmt.BPB;
import com.renderx.xep.fmt.BkMaker;
import com.renderx.xep.fmt.BodyRegion;
import com.renderx.xep.fmt.Cntl;
import com.renderx.xep.fmt.Instruction;
import com.renderx.xep.fmt.InstructionDispatcher;
import com.renderx.xep.fmt.Line;
import com.renderx.xep.gen.SAX;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.lib.Util;
import com.renderx.xep.pre.AttList;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.Attributed;
import com.renderx.xep.pre.BorderComparator;
import com.renderx.xep.pre.PI;
import com.renderx.xepout.XEPOUTImage;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAX
implements InstructionDispatcher {
    private static final String uri = "http://www.renderx.com/XEP/xep";
    public static final String pfx = "xep";
    private ContentHandler handler = null;
    private final List book;
    private final FO fo;
    private final Session session;
    private final String DEFAULT_POSTER = "data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBzdGFuZGFsb25lPSJubyI/Pg0KPHN2ZyB3aWR0aD0iOTBwdCIgaGVpZ2h0PSI5MHB0IiB2aWV3Qm94PSIwIDAgOTAgOTAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIj4NCiAgPGNpcmNsZSBjeD0iNDUiIGN5PSI0NSIgcj0iMTUiIGZpbGw9ImxpZ2h0Z3JleSIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLXdpZHRoPSIwLjUiICAvPg0KCTxwYXRoIGQ9Ik0gNTQuMjcwNTA5ODMxMjQ4NDIyNzIzMDY4ODAyNTE1NDg0IDQ1IEwgNDAuMzY0NzQ1MDg0Mzc1Nzg4NjM4NDY1NTk4NzQyMjU4IDUzLjAyODQ5NzAxOTg5NDUyMzQ2ODY5NDMyMTQ2ODUzNiBMIDQwLjM2NDc0NTA4NDM3NTc4ODYzODQ2NTU5ODc0MjI1OCAzNi45NzE1MDI5ODAxMDU0NzY1MzEzMDU2Nzg1MzE0NjQgeiIgZmlsbD0iZGFya2dyZXkiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS13aWR0aD0iMC43IiAvPg0KPC9zdmc+DQoNCg==";
    private AttributesImpl attrs = new AttributesImpl();
    private BkMaker.Page page;
    private int lwsp;
    private int lcsp;
    private int wsp;
    private int csp;
    private double stretch;
    private int x;
    private int y;
    private Item.TextTraits tt;
    private FontRecord te;
    private int font_size;
    private Attr.Color color;
    private Hashtable breg;
    private List anchors;
    private List deferredPIs = new List();
    private boolean idlePass = false;
    private boolean forceEmitFont = false;
    private boolean forceEmitColor = false;
    private boolean overprintFlag = false;
    private Hashtable tableFrames;
    private Hashtable tableIdCounters;
    private int numInsertedPages = 0;
    private Hashtable pageNumbers = new Hashtable();
    private static final short[][][] EDGES = new short[][][]{new short[][]{{1, 0}, {1, 3}, {1, 2}, {1, 3}, {0, 2}, {0, 3}, {0, 0}, {0, 3}}, new short[][]{{0, 0}, {0, 1}, {0, 2}, {0, 1}, {1, 2}, {1, 1}, {1, 0}, {1, 1}}, new short[][]{{1, 0}, {1, 1}, {1, 0}, {1, 3}, {0, 0}, {0, 3}, {0, 0}, {0, 1}}, new short[][]{{0, 2}, {0, 1}, {0, 2}, {0, 3}, {1, 2}, {1, 3}, {1, 2}, {1, 1}}};
    private static final String[] EDGEIDSLR = new String[]{"before", "after", "start", "end"};
    private static final String[] EDGEIDSRL = new String[]{"before", "after", "end", "start"};
    private static final short NONE = -2;
    private static final short HIDDEN = -1;
    private static final short SOLID = 0;
    private static final short DOTTED = 1;
    private static final short DASHED = 2;
    private static final short DOUBLE = 3;
    private static final short RIDGE = 4;
    private static final short GROOVE = 5;
    private static final short OUTSET = 6;
    private static final short INSET = 7;
    private static final short MAIN = 0;
    private static final short LIGHTER = 1;
    private static final short DARKER = 2;
    private static final short TRANSPARENT = 3;
    private static final int[][] SOLIDEDGECOLORS = new int[][]{{0, 0, 0, 0}, null, null, null, null, null, {1, 2, 1, 2}, {2, 1, 2, 1}};
    private static final int[][][] STRIPEDEDGECOLORS = new int[][][]{null, null, null, null, new int[][]{{2, 0, 1}, {2, 0, 1}, {2, 0, 1}, {2, 0, 1}}, new int[][]{{1, 0, 2}, {1, 0, 2}, {1, 0, 2}, {1, 0, 2}}, null, null};
    private static final Hashtable styles = new Hashtable();
    private static final short START = 0;
    private static final short END = 1;
    private static final short LEFT = 2;
    private static final short RIGHT = 3;
    private static final short INSIDE = 4;
    private static final short OUTSIDE = 5;
    private static final short ALTERNATE = 6;
    private static Hashtable cbPlacement;
    private static final int[][][] affinm;
    private static final int[] unitvec_x;

    public SAX(List list, FO fO, Session session) {
        this.book = list;
        this.fo = fO;
        this.session = session;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
    }

    private void addAttribute(String string, String string2, String string3) {
        this.attrs.addAttribute("", string, string, string2, string3);
    }

    private void addMandatoryAttribute(Attn attn, String string, Attributed attributed) {
        this.addAttribute(attn.toString(), string, attributed.get(attn).toString());
    }

    private void addOptionalAttribute(Attn attn, String string, Attributed attributed) {
        try {
            this.addMandatoryAttribute(attn, string, attributed);
        }
        catch (InternalException internalException) {
            // empty catch block
        }
    }

    private void startElement(String string, Attributes attributes) throws SAXException {
        this.handler.startElement(uri, string, "xep:" + string, attributes);
    }

    private void endElement(String string) throws SAXException {
        this.handler.endElement(uri, string, "xep:" + string);
    }

    public void traverse() {
        Object object;
        Object object2;
        Enumeration enumeration;
        try {
            Object object3;
            this.handler.startDocument();
            enumeration = this.book.elements();
            while (enumeration.hasMoreElements()) {
                this.page = (BkMaker.Page)enumeration.nextElement();
                if (this.page.sequence.containsKey(Attn.$insert_document)) {
                    object3 = this.page.sequence.get(Attn.$image_base_url);
                    object2 = this.page.sequence.get(Attn.$insert_document);
                    object = this.session.config.imageFactory.makeImage((Attr)object2, (Attr)object3, this.page.sequence.get(Attn.$document_content_type), this.session);
                    this.numInsertedPages += ((Image)object).getCountPages();
                }
                this.pageNumbers.put(this.page, new Integer(this.numInsertedPages));
            }
            object3 = this.fo.pilist.elements();
            while (object3.hasMoreElements()) {
                object2 = (PI)object3.nextElement();
                this.handler.processingInstruction(((PI)object2).target, ((PI)object2).data);
            }
            this.handler.startPrefixMapping(pfx, uri);
            this.attrs.clear();
            this.addAttribute("producer", "CDATA", this.session.config.APPLICATION_ID);
            object2 = this.fo.metainfo.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                this.addAttribute((String)object, "CDATA", (String)this.fo.metainfo.get(object));
            }
            if (this.fo.initial_destination != null) {
                this.addAttribute("initial-destination", "CDATA", this.fo.initial_destination.word());
            }
            if (this.session.config.ENABLE_ACCESSIBILITY && this.fo.language != null) {
                object = this.fo.language.word();
                if (this.fo.country != null) {
                    ((String)object).concat("-").concat(this.fo.country.word());
                }
                this.addAttribute("language", "CDATA", (String)object);
            }
            if (this.fo.js_didprint != null) {
                this.addAttribute("js-didprint", "CDATA", this.fo.js_didprint.word());
            }
            if (this.fo.js_didsave != null) {
                this.addAttribute("js-didsave", "CDATA", this.fo.js_didsave.word());
            }
            if (this.fo.js_open != null) {
                this.addAttribute("js-open", "CDATA", this.fo.js_open.word());
            }
            if (this.fo.js_willclose != null) {
                this.addAttribute("js-willclose", "CDATA", this.fo.js_willclose.word());
            }
            if (this.fo.js_willprint != null) {
                this.addAttribute("js-willprint", "CDATA", this.fo.js_willprint.word());
            }
            if (this.fo.js_willsave != null) {
                this.addAttribute("js-willsave", "CDATA", this.fo.js_willsave.word());
            }
            this.startElement("document", this.attrs);
        }
        catch (SAXException sAXException) {
            throw new InternalException(sAXException.getMessage());
        }
        enumeration = this.fo.outline.elements();
        while (enumeration.hasMoreElements()) {
            ((Instruction)enumeration.nextElement()).pass(this);
        }
        if (this.fo.javascript != null) {
            try {
                this.attrs.clear();
                this.addAttribute("name", "CDATA", this.fo.javascript.name);
                this.addAttribute("value", "CDATA", this.fo.javascript.script);
                this.startElement("pdf-javascript", this.attrs);
                this.endElement("pdf-javascript");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        }
        int n = 0;
        object2 = this.book.elements();
        while (object2.hasMoreElements()) {
            Object object4;
            this.page = (BkMaker.Page)object2.nextElement();
            this.session.event("page-number", this.page.id);
            this.csp = Integer.MIN_VALUE;
            this.wsp = Integer.MIN_VALUE;
            this.stretch = Double.MIN_VALUE;
            this.tt = null;
            this.te = null;
            this.font_size = -1;
            this.color = null;
            this.overprintFlag = false;
            try {
                Object object5;
                if (this.page.sequence.containsKey(Attn.$insert_document)) {
                    object = null;
                    try {
                        object = new URLSpec(new URLSpec(this.page.sequence.get(Attn.$image_base_url).word()), this.page.sequence.get(Attn.$insert_document).word());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    this.attrs.clear();
                    this.addAttribute("src", "CDATA", ((URLSpec)object).toString());
                    this.startElement("insert-document", this.attrs);
                    this.endElement("insert-document");
                }
                this.attrs.clear();
                this.addAttribute("width", "CDATA", Integer.toString(this.page.master.width));
                this.addAttribute("height", "CDATA", Integer.toString(this.page.master.height));
                this.addAttribute("page-number", "CDATA", Integer.toString(this.getRenumberedPageNumber(this.page.no)));
                object = this.session.config.ENABLE_PAGE_NUMBERS ? Integer.toString(this.getRenumberedPageNumber(Integer.parseInt(this.page.id))) : this.page.id;
                this.addAttribute("page-id", "CDATA", (String)object);
                if (this.page.master.containsKey(Attn.$js_open)) {
                    this.addAttribute("js-open", "CDATA", this.page.master.get(Attn.$js_open).word());
                }
                if (this.page.master.containsKey(Attn.$js_close)) {
                    this.addAttribute("js-close", "CDATA", this.page.master.get(Attn.$js_close).word());
                }
                this.startElement("page", this.attrs);
                object4 = this.page.sequence.pilist.elements();
                while (object4.hasMoreElements()) {
                    object5 = (PI)object4.nextElement();
                    this.handler.processingInstruction(((PI)object5).target, ((PI)object5).data);
                }
                object5 = this.page.master.pilist.elements();
                while (object5.hasMoreElements()) {
                    PI pI = (PI)object5.nextElement();
                    this.handler.processingInstruction(pI.target, pI.data);
                }
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
            ++n;
            if (this.page.master.containsKey(Attn.$watermark)) {
                object = null;
                object = this.session.config.imageFactory.makeImage(this.page.master.get(Attn.$watermark), this.page.master.get(Attn.$image_base_url), Attr.Word.create("application/xepout"), this.session);
                if (object instanceof XEPOUTImage) {
                    ((XEPOUTImage)object).setContentHandler(this.handler);
                    try {
                        ((XEPOUTImage)object).play();
                    }
                    catch (SAXException sAXException) {
                        this.session.exception("Internal error: cannot output watermark image", sAXException);
                    }
                }
            }
            this.anchors = new List();
            if (this.page.master.phi != 0) {
                this.attrs.clear();
                this.addAttribute("phi", "CDATA", Integer.toString(this.page.master.phi));
                try {
                    this.startElement("rotate", this.attrs);
                    this.endElement("rotate");
                }
                catch (SAXException sAXException) {
                    throw new InternalException(sAXException.getMessage());
                }
            }
            this.tableFrames = new Hashtable();
            this.idlePass = true;
            object = this.page.strmtab.elements();
            while (object.hasMoreElements()) {
                this.breg = new Hashtable();
                this.tableIdCounters = new Hashtable();
                object4 = ((List)object.nextElement()).elements();
                while (object4.hasMoreElements()) {
                    ((Instruction)object4.nextElement()).pass(this);
                }
                this.breg = null;
                this.tableIdCounters = null;
            }
            this.idlePass = false;
            this.drawChangeBars(this.page, -1);
            object = this.page.strmtab.elements();
            while (object.hasMoreElements()) {
                this.breg = new Hashtable();
                this.tableIdCounters = new Hashtable();
                object4 = ((List)object.nextElement()).elements();
                while (object4.hasMoreElements()) {
                    ((Instruction)object4.nextElement()).pass(this);
                }
                this.breg = null;
                this.tableIdCounters = null;
            }
            this.tableFrames = null;
            this.drawChangeBars(this.page, 0);
            if (this.page.master.phi != 0) {
                this.attrs.clear();
                this.addAttribute("phi", "CDATA", Integer.toString(360 - this.page.master.phi));
                try {
                    this.startElement("rotate", this.attrs);
                    this.endElement("rotate");
                }
                catch (SAXException sAXException) {
                    throw new InternalException(sAXException.getMessage());
                }
            }
            object4 = this.anchors.elements();
            while (object4.hasMoreElements()) {
                this.process((BPB.Anchor)object4.nextElement());
            }
            try {
                this.attrs.clear();
                this.endElement("page");
                object = this.deferredPIs.elements();
                while (object.hasMoreElements()) {
                    object4 = (Item.PI)object.nextElement();
                    this.handler.processingInstruction(((Item.PI)object4).target, ((Item.PI)object4).data);
                    this.deferredPIs.shift();
                }
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
            this.page.strmtab = null;
        }
        try {
            this.endElement("document");
            this.handler.endPrefixMapping(pfx);
            this.handler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new InternalException(sAXException.getMessage());
        }
    }

    private int getRenumberedPageNumber(int n) {
        return this.getRenumberedPageNumber(this.page, n);
    }

    private int getRenumberedPageNumber(BkMaker.Page page, int n) {
        return this.session.config.ENABLE_PAGE_NUMBERS ? n + (Integer)this.pageNumbers.get(page) : n;
    }

    public void process(BPB bPB) {
        BPB bPB2;
        if (!bPB.draw || this.breg.containsKey(bPB)) {
            return;
        }
        this.breg.put(bPB, bPB);
        if (this.idlePass) {
            if (bPB.containsKey(Attn.$table_identifier)) {
                this.addTablePart(bPB);
            }
            return;
        }
        if (bPB.containsKey(Attn.$table_identifier)) {
            this.processTablePart(bPB);
        } else {
            this.processBackground(bPB);
            this.processBorder(bPB);
        }
        if (bPB instanceof BPB.Block) {
            this.processRuler((BPB.Block)bPB);
        }
        if (bPB instanceof BPB.Anchor) {
            this.anchors.snoc(bPB);
        }
        if (bPB instanceof BPB.Frame) {
            bPB2 = (BPB.Frame)bPB;
            if (bPB2.pdfformfield != null) {
                if (!bPB2.pdfformfield.a.containsKey(Attn.$name)) {
                    this.session.error("Mandatory attribute \"name\" missing on rx:pdf-form-field.");
                }
                if (!this.session.PDFFormFields.containsKey(bPB2.pdfformfield.a.get(Attn.$name).word())) {
                    this.session.PDFFormFields.put(bPB2.pdfformfield.a.get(Attn.$name).word(), bPB2.pdfformfield);
                    bPB2.pdfformfield.parentbpb = bPB2;
                    this.processPDFFormField(bPB2.pdfformfield);
                }
            }
        }
        if (bPB instanceof BPB.Inline) {
            bPB2 = (BPB.Inline)bPB;
            if (((BPB.Inline)bPB2).pdfformfield != null) {
                if (!((BPB.Inline)bPB2).pdfformfield.a.containsKey(Attn.$name)) {
                    this.session.error("Mandatory attribute \"name\" missing on rx:pdf-form-field.");
                }
                if (!this.session.PDFFormFields.containsKey(((BPB.Inline)bPB2).pdfformfield.a.get(Attn.$name).word())) {
                    this.session.PDFFormFields.put(((BPB.Inline)bPB2).pdfformfield.a.get(Attn.$name).word(), ((BPB.Inline)bPB2).pdfformfield);
                    ((BPB.Inline)bPB2).pdfformfield.parentbpb = bPB2;
                    this.processPDFFormField(((BPB.Inline)bPB2).pdfformfield);
                }
            }
        }
    }

    public void addTablePart(BPB bPB) {
        Attr attr = bPB.get(Attn.$table_identifier);
        TableData tableData = null;
        if (bPB.get(Attn.$table_element_class) == Attr.Word.create("table") || bPB.get(Attn.$table_element_class) == Attr.Word.create("header") && this.tableIdCounters.get(attr) == null) {
            Integer n = (Integer)this.tableIdCounters.get(attr);
            Integer n2 = n == null ? new Integer(1) : new Integer(1 + n);
            this.tableIdCounters.put(attr, n2);
            tableData = new TableData(bPB.get(Attn.$border_collapse) == Attr.Word.create("separate"));
            String string = "" + n2 + ":" + attr;
            this.tableFrames.put(string, tableData);
        } else {
            Integer n = (Integer)this.tableIdCounters.get(attr);
            String string = "" + n + ":" + attr;
            tableData = (TableData)this.tableFrames.get(string);
        }
        tableData.add(bPB);
    }

    public void processTablePart(BPB bPB) {
        Attr attr = bPB.get(Attn.$table_identifier);
        if (bPB.get(Attn.$table_element_class) == Attr.Word.create("table") || bPB.get(Attn.$table_element_class) == Attr.Word.create("header") && this.tableIdCounters.get(attr) == null) {
            Integer n = (Integer)this.tableIdCounters.get(attr);
            Integer n2 = n == null ? new Integer(1) : new Integer(1 + n);
            this.tableIdCounters.put(attr, n2);
            String string = "" + n2 + ":" + attr;
            TableData tableData = (TableData)this.tableFrames.get(string);
            tableData.draw();
        }
    }

    public void processBackground(BPB bPB) {
        Area area = this.makeArea(bPB);
        Attr.Color color = (Attr.Color)bPB.get(Attn.$background_color);
        if (color != Attr.Color.transparent) {
            color.overprint = bPB.get(Attn.$overprint_flag).bool();
            this.processColor((Attr.Color.Opaque)color);
            try {
                this.attrs.clear();
                this.addAttribute("x-from", "CDATA", Integer.toString(area.r[1][0]));
                this.addAttribute("y-from", "CDATA", Integer.toString(area.r[1][1]));
                this.addAttribute("x-till", "CDATA", Integer.toString(area.r[1][2]));
                this.addAttribute("y-till", "CDATA", Integer.toString(area.r[1][3]));
                this.startElement("rectangle", this.attrs);
                this.endElement("rectangle");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        }
        if (bPB.im != null) {
            int[] nArray = area.r[1];
            int n = bPB.get(Attn.$reference_orientation).count();
            if (n != 0) {
                this.process(new Cntl.Rotate(n));
                nArray = Rectangle.rotate(nArray, n);
            }
            this.attrs.clear();
            this.addAttribute("x-from", "CDATA", Integer.toString(nArray[0]));
            this.addAttribute("y-from", "CDATA", Integer.toString(nArray[1]));
            this.addAttribute("x-till", "CDATA", Integer.toString(nArray[2]));
            this.addAttribute("y-till", "CDATA", Integer.toString(nArray[3]));
            double[] dArray = new double[]{1.0, 1.0};
            Attr attr = bPB.get(Attn.$background_content_width);
            Attr attr2 = bPB.get(Attn.$background_content_height);
            if (attr instanceof Attr.Length) {
                dArray[0] = (double)attr.length() / (bPB.im.width * 1000.0);
            } else if (attr instanceof Attr.Ratio) {
                dArray[0] = attr.ratio();
            } else if (attr == Attr.newWord("scale-to-fit")) {
                dArray[0] = (double)(nArray[2] - nArray[0]) / (bPB.im.width * 1000.0);
            }
            if (attr2 instanceof Attr.Length) {
                dArray[1] = (double)attr2.length() / (bPB.im.height * 1000.0);
            } else if (attr2 instanceof Attr.Ratio) {
                dArray[1] = attr2.ratio();
            } else if (attr2 == Attr.newWord("scale-to-fit")) {
                dArray[1] = (double)(nArray[3] - nArray[1]) / (bPB.im.height * 1000.0);
            }
            if (bPB.get(Attn.$background_scaling) == Attr.newWord("uniform")) {
                if (dArray[0] != 1.0) {
                    dArray[1] = dArray[0];
                } else if (dArray[1] != 1.0) {
                    dArray[0] = dArray[1];
                }
            }
            Attr attr3 = bPB.get(Attn.$background_repeat);
            int n2 = 0;
            int n3 = 1;
            int n4 = 1;
            int n5 = nArray[2] - nArray[0];
            int n6 = nArray[3] - nArray[1];
            int n7 = (int)Math.round(bPB.im.width * 1000.0 * dArray[0]);
            int n8 = (int)Math.round(bPB.im.height * 1000.0 * dArray[1]);
            int n9 = nArray[0];
            int n10 = nArray[3] - n8;
            if (n5 < 0) {
                n5 = -n5;
                n9 = nArray[2];
            }
            if (n6 < 0) {
                n6 = -n6;
                n10 = nArray[3];
            }
            if (attr3 == Attr.newWord("repeat")) {
                n2 = 3;
            } else if (attr3 == Attr.newWord("repeat-x")) {
                n2 = 1;
            } else if (attr3 == Attr.newWord("repeat-y")) {
                n2 = 2;
            } else if (attr3 == Attr.newWord("no-repeat")) {
                n2 = 0;
            } else {
                throw new InternalException("illegal background-repeat: " + attr3);
            }
            Attr[] attrArray = new Attr[]{bPB.get(Attn.$background_position_horizontal), bPB.get(Attn.$background_position_vertical)};
            if ((n2 & 1) != 0) {
                n3 = (int)Math.round((double)n5 / (double)n7 + 0.5);
            } else {
                n9 += attrArray[0].length_or_ratio(n5 - n7);
            }
            if ((n2 & 2) != 0) {
                n4 = (int)Math.round((double)n6 / (double)n8 + 0.5);
            } else {
                n10 -= attrArray[1].length_or_ratio(n6 - n8);
            }
            try {
                this.startElement("clip", this.attrs);
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
            int n11 = n10;
            int n12 = 0;
            while (n12 != n3) {
                int n13 = 0;
                while (n13 != n4) {
                    this.attrs.clear();
                    URLSpec uRLSpec = bPB.im.source != null ? bPB.im.source : bPB.im.getFactory().getSource(bPB.im);
                    this.addAttribute("src", "CDATA", uRLSpec.toString());
                    if (uRLSpec.scheme != 3) {
                        this.addAttribute("base", "CDATA", uRLSpec.getBase().toString());
                    }
                    this.addAttribute("type", "CDATA", bPB.im.mimetype);
                    this.addAttribute("x-from", "CDATA", Integer.toString(n9));
                    this.addAttribute("y-from", "CDATA", Integer.toString(n10));
                    this.addAttribute("scale-x", "CDATA", Double.toString(dArray[0]));
                    this.addAttribute("scale-y", "CDATA", Double.toString(dArray[1]));
                    this.addAttribute("width", "CDATA", Integer.toString((int)Math.round(bPB.im.width * 1000.0 * dArray[0])));
                    this.addAttribute("height", "CDATA", Integer.toString((int)Math.round(bPB.im.height * 1000.0 * dArray[1])));
                    this.addAttribute("is-background", "CDATA", "true");
                    if (this.session.config.ENABLE_ACCESSIBILITY) {
                        this.addAttribute("xpath", "CDATA", bPB.get(Attn.$xpath).word());
                        this.addAttribute("alt-description", "CDATA", "a background image");
                        this.addAttribute("pdf-structure-tag", "CDATA", "Artifact");
                        this.addAttribute("pdf-artifact-type", "CDATA", "Background");
                    }
                    try {
                        this.startElement("image", this.attrs);
                        this.endElement("image");
                    }
                    catch (SAXException sAXException) {
                        throw new InternalException(sAXException.getMessage());
                    }
                    n10 -= n8;
                    ++n13;
                }
                n9 += n7;
                n10 = n11;
                ++n12;
            }
            try {
                this.endElement("clip");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
            if (n != 0) {
                this.process(new Cntl.Rotate(360 - n));
            }
        }
    }

    public void processBorder(BPB bPB) {
        Area area = this.makeArea(bPB);
        int n = 0;
        while (n != EDGES.length) {
            Attr attr;
            String string = bPB.writing_mode == Attr.rl_tb ? EDGEIDSRL[n] : EDGEIDSLR[n];
            int n2 = bPB.get(Attn.oldName("border-" + string + "-width.length")).length();
            if (!Util.eq0(n2) && (attr = bPB.get(Attn.oldName("border-" + string + "-color"))) != Attr.Color.transparent) {
                if (!(attr instanceof Attr.Color.Opaque)) {
                    this.session.error("invalid border-" + string + "-color: " + attr);
                } else {
                    Attr.Color.Opaque opaque = (Attr.Color.Opaque)attr;
                    opaque.overprint = bPB.get(Attn.$overprint_flag).bool();
                    Attr attr2 = bPB.get(Attn.oldName("border-" + string + "-style"));
                    Short s = (Short)styles.get(attr2);
                    short s2 = 0;
                    if (s == null) {
                        this.session.error("invalid border-" + string + "-style: " + attr2);
                        attr2 = Attr.newWord("solid");
                    } else {
                        s2 = s;
                    }
                    short[][] sArray = EDGES[n];
                    int n3 = area.r[sArray[0][0]][sArray[0][1]];
                    int n4 = area.r[sArray[1][0]][sArray[1][1]];
                    int n5 = area.r[sArray[2][0]][sArray[2][1]];
                    int n6 = area.r[sArray[3][0]][sArray[3][1]];
                    int n7 = area.r[sArray[4][0]][sArray[4][1]];
                    int n8 = area.r[sArray[5][0]][sArray[5][1]];
                    int n9 = area.r[sArray[6][0]][sArray[6][1]];
                    int n10 = area.r[sArray[7][0]][sArray[7][1]];
                    switch (s2) {
                        case -2: 
                        case -1: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.drawLine(opaque, attr2.word(), n2, (n3 + n9) / 2, (n4 + n10) / 2, (n5 + n7) / 2, (n6 + n8) / 2);
                            break;
                        }
                        case 0: {
                            this.drawTetragon(opaque, n3, n4, n5, n6, n7, n8, n9, n10);
                            break;
                        }
                        case 6: 
                        case 7: {
                            this.drawStripe(opaque, SOLIDEDGECOLORS[s2][n], n3, n4, n5, n6, n7, n8, n9, n10);
                            break;
                        }
                        case 3: {
                            int n11 = (n9 - n3) / 3;
                            int n12 = (n10 - n4) / 3;
                            int n13 = (n7 - n5) / 3;
                            int n14 = (n8 - n6) / 3;
                            this.drawTetragon(opaque, n3, n4, n5, n6, n5 + n13, n6 + n14, n3 + n11, n4 + n12);
                            this.drawTetragon(opaque, n9 - n11, n10 - n12, n7 - n13, n8 - n14, n7, n8, n9, n10);
                            break;
                        }
                        case 4: 
                        case 5: {
                            int n11 = (n9 - n3) / 4;
                            int n12 = (n10 - n4) / 4;
                            int n13 = (n7 - n5) / 4;
                            int n14 = (n8 - n6) / 4;
                            this.drawStripe(opaque, STRIPEDEDGECOLORS[s2][n][0], n3, n4, n5, n6, n5 + n13, n6 + n14, n3 + n11, n4 + n12);
                            this.drawStripe(opaque, STRIPEDEDGECOLORS[s2][n][1], n3 + n11, n4 + n12, n5 + n13, n6 + n14, n7 - n13, n8 - n14, n9 - n11, n10 - n12);
                            this.drawStripe(opaque, STRIPEDEDGECOLORS[s2][n][2], n9 - n11, n10 - n12, n7 - n13, n8 - n14, n7, n8, n9, n10);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Internal error: bad value for style switch: " + s2);
                        }
                    }
                }
            }
            ++n;
        }
    }

    private void drawLine(Attr.Color.Opaque opaque, String string, int n, int n2, int n3, int n4, int n5) {
        this.processColor(opaque);
        this.attrs.clear();
        this.addAttribute("style", "CDATA", string);
        this.addAttribute("thickness", "CDATA", Integer.toString(n));
        this.addAttribute("x-from", "CDATA", Integer.toString(n2));
        this.addAttribute("y-from", "CDATA", Integer.toString(n3));
        this.addAttribute("x-till", "CDATA", Integer.toString(n4));
        this.addAttribute("y-till", "CDATA", Integer.toString(n5));
        try {
            this.startElement("line", this.attrs);
            this.endElement("line");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private void drawStripe(Attr.Color.Opaque opaque, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        switch (n) {
            case 3: {
                return;
            }
            case 2: {
                opaque = opaque.darkerColor();
                break;
            }
            case 1: {
                opaque = opaque.lighterColor();
            }
        }
        this.drawTetragon(opaque, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    private void drawTetragon(Attr.Color.Opaque opaque, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.processColor(opaque);
        try {
            this.attrs.clear();
            this.addAttribute("x-from", "CDATA", Integer.toString(n));
            this.addAttribute("y-from", "CDATA", Integer.toString(n2));
            this.startElement("polygon", this.attrs);
            this.attrs.clear();
            this.addAttribute("x-till", "CDATA", Integer.toString(n3));
            this.addAttribute("y-till", "CDATA", Integer.toString(n4));
            this.startElement("point", this.attrs);
            this.endElement("point");
            this.attrs.clear();
            this.addAttribute("x-till", "CDATA", Integer.toString(n5));
            this.addAttribute("y-till", "CDATA", Integer.toString(n6));
            this.startElement("point", this.attrs);
            this.endElement("point");
            this.attrs.clear();
            this.addAttribute("x-till", "CDATA", Integer.toString(n7));
            this.addAttribute("y-till", "CDATA", Integer.toString(n8));
            this.startElement("point", this.attrs);
            this.endElement("point");
            this.endElement("polygon");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private void drawHexagon(Attr.Color.Opaque opaque, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        this.processColor(opaque);
        try {
            this.attrs.clear();
            this.addAttribute("x-from", "CDATA", Integer.toString(n));
            this.addAttribute("y-from", "CDATA", Integer.toString(n2));
            this.startElement("polygon", this.attrs);
            this.attrs.clear();
            this.addAttribute("x-till", "CDATA", Integer.toString(n3));
            this.addAttribute("y-till", "CDATA", Integer.toString(n4));
            this.startElement("point", this.attrs);
            this.endElement("point");
            this.attrs.clear();
            this.addAttribute("x-till", "CDATA", Integer.toString(n5));
            this.addAttribute("y-till", "CDATA", Integer.toString(n6));
            this.startElement("point", this.attrs);
            this.endElement("point");
            this.attrs.clear();
            this.addAttribute("x-till", "CDATA", Integer.toString(n7));
            this.addAttribute("y-till", "CDATA", Integer.toString(n8));
            this.startElement("point", this.attrs);
            this.endElement("point");
            this.attrs.clear();
            this.addAttribute("x-till", "CDATA", Integer.toString(n9));
            this.addAttribute("y-till", "CDATA", Integer.toString(n10));
            this.startElement("point", this.attrs);
            this.endElement("point");
            this.attrs.clear();
            this.addAttribute("x-till", "CDATA", Integer.toString(n11));
            this.addAttribute("y-till", "CDATA", Integer.toString(n12));
            this.startElement("point", this.attrs);
            this.endElement("point");
            this.endElement("polygon");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void processRuler(BPB.Block block) {
        int n;
        int n2;
        AttList attList = block.ruler;
        if (attList == null) {
            return;
        }
        Area area = this.makeArea(block);
        String string = attList.get(Attn.$format).word();
        Attr attr = attList.get(Attn.$text_align);
        if (attr == Attr.newWord("inside")) {
            attr = this.page.number % 2 == 1 ? Attr.newWord("start") : Attr.newWord("end");
        } else if (attr == Attr.newWord("outside")) {
            Attr attr2 = attr = this.page.number % 2 == 0 ? Attr.newWord("start") : Attr.newWord("end");
        }
        if (block.writing_mode == Attr.rl_tb) {
            attr = attr == Attr.newWord("end") ? Attr.newWord("start") : Attr.newWord("end");
        }
        int n3 = 1;
        Item.Text text = new Item.Text(Util.i2s(n3, string), attList, this.session);
        int n4 = text.tt.max_ascender + text.tt.lea;
        int n5 = n4 - text.tt.min_descender + text.tt.lea;
        this.y = area.r[2][3] - n4;
        int n6 = Attr.dim_range(attList, Attn.$inline_progression_dimension_minimum, Attn.$inline_progression_dimension_optimum, Attn.$inline_progression_dimension_maximum, area.r[2][2] - area.r[2][0]);
        if (block.writing_mode == Attr.rl_tb) {
            n2 = area.r[2][2];
            n = n6 == Integer.MIN_VALUE ? area.r[2][0] : area.r[2][2] - n6;
        } else {
            n = area.r[2][0];
            n2 = n6 == Integer.MIN_VALUE ? area.r[2][2] : area.r[2][0] + n6;
        }
        while (this.y >= area.r[2][1]) {
            this.x = attr == Attr.newWord("end") ? n2 - text.width : (attr == Attr.newWord("center") ? n + (n2 - text.width) / 2 : n);
            this.process(text);
            this.y -= n5;
            text = new Item.Text(Util.i2s(++n3, string), attList, this.session);
        }
    }

    private void process(BPB.Anchor anchor) {
        String string;
        if (this.idlePass) {
            return;
        }
        this.attrs.clear();
        this.addAttribute("x-from", "CDATA", Integer.toString(anchor.rabs[0]));
        this.addAttribute("y-from", "CDATA", Integer.toString(anchor.rabs[1]));
        this.addAttribute("x-till", "CDATA", Integer.toString(anchor.rabs[2]));
        this.addAttribute("y-till", "CDATA", Integer.toString(anchor.rabs[3]));
        this.addAccessibilityProperties(anchor);
        if (anchor.containsKey(Attn.$internal_destination)) {
            this.addAttribute("destination-id", "CDATA", anchor.get(Attn.$internal_destination).word());
            this.addAttribute("destination", "CDATA", Integer.toString(this.getRenumberedPageNumber(anchor.id.page, anchor.id.page.no)));
            this.addAttribute("destination-x", "CDATA", Integer.toString(anchor.id.x));
            this.addAttribute("destination-y", "CDATA", Integer.toString(anchor.id.y));
            try {
                this.startElement("internal-link", this.attrs);
                this.endElement("internal-link");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        }
        if (anchor.containsKey(Attn.$external_destination) && (string = anchor.get(Attn.$external_destination).word()) != "") {
            this.addAttribute("destination", "CDATA", string);
            this.addAttribute("show-destination", "CDATA", anchor.get(Attn.$show_destination).word());
            try {
                this.startElement("external-link", this.attrs);
                this.endElement("external-link");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        }
    }

    public void process(Cntl.Rotate rotate) {
        if (this.idlePass) {
            return;
        }
        if (rotate.phi != 0) {
            this.attrs.clear();
            this.addAttribute("phi", "CDATA", Integer.toString(rotate.phi));
            try {
                this.startElement("rotate", this.attrs);
                this.endElement("rotate");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        }
    }

    public void process(Cntl.Translate translate) {
        if (this.idlePass) {
            return;
        }
        if (translate.x != 0 || translate.y != 0) {
            this.attrs.clear();
            this.addAttribute("x", "CDATA", Integer.toString(translate.x));
            this.addAttribute("y", "CDATA", Integer.toString(translate.y));
            try {
                this.startElement("translate", this.attrs);
                this.endElement("translate");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        }
    }

    public void process(Line line) {
        if (this.idlePass) {
            return;
        }
        this.attrs.clear();
        this.x = line.x;
        this.y = line.y;
        this.lwsp = line.wsp;
        this.lcsp = line.csp;
        Enumeration enumeration = line.words.elements();
        while (enumeration.hasMoreElements()) {
            ((Instruction)enumeration.nextElement()).pass(this);
        }
    }

    public void process(Item.PageId pageId) {
        this.processText(pageId);
    }

    public void process(Item.Text text) {
        this.processText(text);
    }

    private void processText(Item.Text text) {
        int n;
        int n2;
        block59: {
            double d;
            int n3;
            int n4;
            if (this.idlePass) {
                return;
            }
            Hashtable hashtable = new Hashtable();
            if (this.session.config.ENABLE_ACCESSIBILITY) {
                if (text.containsKey(Attn.$xpath)) {
                    hashtable.put("xpath", text.get(Attn.$xpath));
                }
                if (text.containsKey(Attn.$language)) {
                    hashtable.put("language", text.get(Attn.$language));
                }
                if (text.containsKey(Attn.$country)) {
                    hashtable.put("country", text.get(Attn.$country));
                }
                if (text.containsKey(Attn.$pdf_structure_tag)) {
                    hashtable.put("pdf-structure-tag", text.get(Attn.$pdf_structure_tag));
                }
                if (text.containsKey(Attn.$role_mapping)) {
                    hashtable.put("role-mapping", text.get(Attn.$role_mapping));
                }
                if (text.containsKey(Attn.$pdf_artifact_type)) {
                    hashtable.put("pdf-artifact-type", text.get(Attn.$pdf_artifact_type));
                }
                if (text.containsKey(Attn.$pdf_artifact_subtype)) {
                    hashtable.put("pdf-artifact-subtype", text.get(Attn.$pdf_artifact_subtype));
                }
                if (text.containsKey(Attn.$alt_description)) {
                    hashtable.put("alt-description", text.get(Attn.$alt_description));
                }
                if (text.containsKey(Attn.$actual_text)) {
                    hashtable.put("actual-text", text.get(Attn.$actual_text));
                }
                if (text.containsKey(Attn.$abbreviation)) {
                    hashtable.put("abbreviation", text.get(Attn.$abbreviation));
                }
            }
            n2 = this.x;
            this.tt = text.tt;
            Attr attr = text.get(Attn.$color);
            Attr attr2 = text.get(Attn.$text_shadow);
            if (attr == Attr.Color.transparent && attr2 == Attr.none) {
                return;
            }
            ((Attr.Color)attr).overprint = text.get(Attn.$overprint_flag).bool();
            int n5 = this.tt.merge_white_space ? (this.tt.varwsp ? this.tt.wsp + this.lwsp : this.tt.wsp) : (n4 = 0);
            if (n4 != this.wsp) {
                this.attrs.clear();
                this.addAttribute("value", "CDATA", Integer.toString(n4));
                try {
                    this.startElement("word-spacing", this.attrs);
                    this.endElement("word-spacing");
                }
                catch (SAXException sAXException) {
                    throw new InternalException(sAXException.getMessage());
                }
            }
            this.wsp = n4;
            int n6 = n3 = this.tt.varcsp ? this.tt.csp + this.lcsp : this.tt.csp;
            if (n3 != this.csp) {
                this.attrs.clear();
                this.addAttribute("value", "CDATA", Integer.toString(n3));
                try {
                    this.startElement("letter-spacing", this.attrs);
                    this.endElement("letter-spacing");
                }
                catch (SAXException sAXException) {
                    throw new InternalException(sAXException.getMessage());
                }
                this.csp = n3;
            }
            if ((d = this.tt.font_stretch) != this.stretch) {
                this.stretch = d;
                this.attrs.clear();
                this.addAttribute("value", "CDATA", Double.toString(this.stretch));
                try {
                    this.startElement("font-stretch", this.attrs);
                    this.endElement("font-stretch");
                }
                catch (SAXException sAXException) {
                    throw new InternalException(sAXException.getMessage());
                }
            }
            if (this.tt.multifont) {
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                n = 0;
                Metric metric = this.tt.te.getMetric();
                FontRecord fontRecord = this.tt.te;
                FontRecord fontRecord2 = this.tt.te;
                Metric metric2 = null;
                block12: while (true) {
                    char c;
                    CharMetrics charMetrics;
                    block60: {
                        if (n7 == text.chars.length) {
                            n = 1;
                        }
                        if (n != 0) {
                            if (n8 != n7) {
                                if (fontRecord != this.te || this.tt.font_size != this.font_size || this.forceEmitFont) {
                                    this.te = fontRecord;
                                    this.font_size = this.tt.font_size;
                                    this.attrs.clear();
                                    this.addAttribute("family", "CDATA", this.te.familyName);
                                    this.addAttribute("weight", "CDATA", Integer.toString(this.tt.font_weight.count()));
                                    this.addAttribute("style", "CDATA", this.tt.font_style.word());
                                    this.addAttribute("variant", "CDATA", this.tt.font_variant.word());
                                    this.addAttribute("size", "CDATA", Integer.toString(this.font_size));
                                    try {
                                        this.startElement("font", this.attrs);
                                        this.endElement("font");
                                    }
                                    catch (SAXException sAXException) {
                                        throw new InternalException(sAXException.getMessage());
                                    }
                                }
                                n9 = (int)Math.round((double)n9 * this.tt.font_stretch * (double)this.tt.font_size / 1000.0);
                                this.emitText(new String(text.chars, n8, n7 - n8), this.x, this.y + text.offset, n9 += (n7 - n8) * this.csp + n10 * this.wsp, attr, attr2, hashtable, text instanceof Item.PageId);
                                this.x += n9;
                                n8 = n7;
                                n9 = 0;
                                n10 = 0;
                            }
                            if (n7 == text.chars.length) break block59;
                            fontRecord = fontRecord2;
                            n = 0;
                        }
                        if ((charMetrics = metric.ucm(c = text.chars[n7++])) == null) {
                            Enumeration enumeration = this.tt.tes.elements();
                            do {
                                if (enumeration.hasMoreElements()) continue;
                                fontRecord2 = this.tt.te;
                                n = fontRecord2 != fontRecord ? 1 : 0;
                                if (n != 0) {
                                    --n7;
                                    continue block12;
                                }
                                charMetrics = metric.missingGlyph;
                                break block60;
                            } while ((charMetrics = (metric2 = (fontRecord2 = (FontRecord)enumeration.nextElement()).getMetric()).ucm(c)) == null);
                            n = fontRecord2 != fontRecord ? 1 : 0;
                            if (n != 0) {
                                --n7;
                                continue;
                            }
                        } else {
                            fontRecord2 = (FontRecord)this.tt.tes.car();
                            n = fontRecord2 != fontRecord ? 1 : 0;
                            if (n != 0) {
                                --n7;
                                continue;
                            }
                        }
                    }
                    if (charMetrics == null) continue;
                    n9 = (int)((float)n9 + charMetrics.wx);
                    if (c != ' ') continue;
                    ++n10;
                }
            }
            if (this.tt.te != this.te || this.tt.font_size != this.font_size || this.forceEmitFont) {
                this.te = this.tt.te;
                this.font_size = this.tt.font_size;
                this.attrs.clear();
                this.addAttribute("family", "CDATA", this.te.familyName);
                this.addAttribute("weight", "CDATA", Integer.toString(this.tt.font_weight.count()));
                this.addAttribute("style", "CDATA", this.tt.font_style.word());
                this.addAttribute("variant", "CDATA", this.tt.font_variant.word());
                this.addAttribute("size", "CDATA", Integer.toString(this.font_size));
                try {
                    this.startElement("font", this.attrs);
                    this.endElement("font");
                }
                catch (SAXException sAXException) {
                    throw new InternalException(sAXException.getMessage());
                }
            }
            if (this.session.config.ENABLE_ACCESSIBILITY || text.nwsp != text.chars.length || this.forceEmitFont) {
                this.emitText(new String(text.chars), this.x, this.y + text.offset, text.width, attr, attr2, hashtable, text instanceof Item.PageId);
            }
        }
        this.x = n2 + text.width;
        this.forceEmitFont = false;
        try {
            Attr attr = text.get(Attn.$text_decoration);
            Metric metric = this.tt.te.getMetric();
            List list = new List();
            if (attr instanceof Attr.Word) {
                String string = attr.word();
                n = 0;
                while (true) {
                    int n11;
                    if ((n11 = string.indexOf(32, n + 1)) == -1) {
                        n11 = string.length();
                    }
                    if (n11 - n > 1) {
                        list.snoc(string.substring(n, n11));
                    }
                    if (n11 != string.length()) {
                        n = n11 + 1;
                        continue;
                    }
                    break;
                }
            } else if (attr instanceof Attr.Composite) {
                Attr[] attrArray = attr.vector();
                n = 0;
                while (n != attrArray.length) {
                    list.snoc(attrArray[n].word());
                    ++n;
                }
            }
            Enumeration enumeration = list.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = false;
                int n12 = this.y + text.offset;
                if (!string.equals("none")) {
                    if (string.equals("underline")) {
                        n12 = (int)((float)n12 + metric.underlinePosition * (float)this.font_size / 1000.0f);
                        bl = true;
                    } else if (string.equals("overline")) {
                        n12 = (int)((float)n12 + ((float)(this.tt.x_height * 4 / 3) - metric.underlinePosition * (float)this.font_size / 1000.0f));
                        bl = true;
                    } else if (string.equals("line-through")) {
                        n12 += this.tt.x_height * 2 / 3;
                        bl = true;
                    } else if (!string.equals("blink")) {
                        this.session.error("text-decoration='" + string + "'" + " is not supported");
                    }
                }
                if (!bl) continue;
                this.attrs.clear();
                this.addAttribute("x-from", "CDATA", Integer.toString(this.x - text.width));
                this.addAttribute("x-till", "CDATA", Integer.toString(this.x));
                this.addAttribute("y-from", "CDATA", Integer.toString(n12));
                this.addAttribute("y-till", "CDATA", Integer.toString(n12));
                this.addAttribute("thickness", "CDATA", Integer.toString(Math.round(metric.underlineThickness / 1000.0f * (float)this.font_size)));
                this.addAttribute("style", "CDATA", "solid");
                this.startElement("line", this.attrs);
                this.endElement("line");
            }
        }
        catch (SAXException sAXException) {
            throw new InternalException(sAXException.getMessage());
        }
    }

    private void emitText(String string, int n, int n2, int n3, Attr attr, Attr attr2, Hashtable hashtable, boolean bl) {
        if (attr2 instanceof Attr.Composite) {
            Attr[] attrArray = ((Attr.Composite)attr2).vector;
            int n4 = attrArray.length;
            while (n4-- > 0) {
                if (!(attrArray[n4] instanceof Attr.Composite)) {
                    this.session.error("Internal misconfiguration: text-shadow incorrectly parsed");
                    continue;
                }
                Attr[] attrArray2 = ((Attr.Composite)attrArray[n4]).vector;
                Attr attr3 = attrArray2[0];
                Attr attr4 = attrArray2[1];
                Attr attr5 = attrArray2[2];
                if (attr3 == null) {
                    attr3 = attr;
                }
                if (attr3 instanceof Attr.Color && attr4 instanceof Attr.Length && attr5 instanceof Attr.Length) {
                    this.emitBareText(string, n + attr4.length(), n2 - attr5.length(), n3, attr3, hashtable, bl);
                    continue;
                }
                this.session.error("Internal misconfiguration: text-shadow incorrectly parsed");
            }
        }
        this.emitBareText(string, n, n2, n3, attr, hashtable, bl);
    }

    private void emitBareText(String string, int n, int n2, int n3, Attr attr, Hashtable hashtable, boolean bl) {
        if (attr == Attr.Color.transparent) {
            return;
        }
        this.processColor((Attr.Color.Opaque)attr);
        this.attrs.clear();
        this.addAttribute("value", "CDATA", string);
        this.addAttribute("x", "CDATA", Integer.toString(n));
        this.addAttribute("y", "CDATA", Integer.toString(n2));
        this.addAttribute("width", "CDATA", Integer.toString(n3));
        if (hashtable == null) {
            throw new InternalException("Optional attributes can't be 'null'");
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Attr attr2 = (Attr)hashtable.get(string2);
            if (attr2 == null) {
                throw new InternalException("Attribute " + string2 + " is 'null'");
            }
            this.addAttribute(string2, "CDATA", attr2.word());
        }
        try {
            if (bl) {
                this.attrs.setValue(0, Integer.toString(this.getRenumberedPageNumber(Integer.parseInt(string))));
                this.startElement("page-number", this.attrs);
                this.endElement("page-number");
            } else {
                this.startElement("text", this.attrs);
                this.endElement("text");
            }
        }
        catch (SAXException sAXException) {
            throw new InternalException(sAXException.getMessage());
        }
    }

    public void process(Item.Leader leader) {
        if (this.idlePass) {
            return;
        }
        switch (leader.leader_pattern) {
            case 0: {
                break;
            }
            case 1: {
                this.processRuleLeader(leader);
                break;
            }
            case 2: 
            case 3: {
                int n = leader.width / leader.patwidth;
                if (n <= 0) break;
                int n2 = this.x;
                leader.dot.offset = leader.offset;
                if (leader.patwidth > leader.dot.width) {
                    leader.dot.width = leader.patwidth;
                    int n3 = 0;
                    while (n3 != n) {
                        this.process(leader.dot);
                        ++n3;
                    }
                } else {
                    Item.Text text = (Item.Text)leader.dot.clone();
                    char[] cArray = new char[n * text.chars.length];
                    int n4 = 0;
                    while (n4 != cArray.length) {
                        System.arraycopy(text.chars, 0, cArray, n4, text.chars.length);
                        n4 += text.chars.length;
                    }
                    text.chars = cArray;
                    text.width = leader.patwidth * n;
                    this.process(text);
                }
                this.x = n2;
                break;
            }
            default: {
                throw new InternalException("leader_pattern=" + leader.leader_pattern);
            }
        }
        this.x += leader.width;
    }

    private void processRuleLeader(Item.Leader leader) {
        Attr attr = leader.get(Attn.$color);
        if (attr == Attr.Color.transparent) {
            return;
        }
        if (!(attr instanceof Attr.Color.Opaque)) {
            this.session.error("invalid rule color: " + attr);
            return;
        }
        Attr.Color.Opaque opaque = (Attr.Color.Opaque)attr;
        opaque.overprint = leader.get(Attn.$overprint_flag).bool();
        int n = leader.get(Attn.$rule_thickness).length();
        if (Util.eq0(n)) {
            return;
        }
        Attr attr2 = leader.get(Attn.$rule_style);
        Short s = (Short)styles.get(attr2);
        short s2 = 0;
        if (s == null) {
            this.session.error("invalid rule-style: " + attr2);
            attr2 = Attr.newWord("solid");
        } else {
            s2 = s;
        }
        switch (s2) {
            case -2: 
            case -1: {
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.drawLine(opaque, attr2.word(), n, this.x, this.y + leader.offset, this.x + leader.width, this.y + leader.offset);
                break;
            }
            case 3: {
                this.drawLine(opaque, "solid", n / 3, this.x, this.y + leader.offset + n / 3, this.x + leader.width, this.y + leader.offset + n / 3);
                this.drawLine(opaque, "solid", n / 3, this.x, this.y + leader.offset - n / 3, this.x + leader.width, this.y + leader.offset - n / 3);
                break;
            }
            case 4: 
            case 5: {
                int n2 = this.x;
                int n3 = this.x + leader.width;
                int n4 = this.y + leader.offset - n / 2;
                int n5 = this.y + leader.offset + n / 2;
                int n6 = n / 4;
                int n7 = n / 4;
                if (n6 > leader.width / 4) {
                    n6 = leader.width / 4;
                }
                this.drawStripe(opaque, STRIPEDEDGECOLORS[s2][0][0], n2, n4, n3, n4, n3 - n6, n4 + n7, n2 + n6, n4 + n7);
                this.drawStripe(opaque, STRIPEDEDGECOLORS[s2][0][0], n3, n5, n3, n4, n3 - n6, n4 + n7, n3 - n6, n5 - n7);
                this.drawStripe(opaque, STRIPEDEDGECOLORS[s2][0][1], n2 + n6, n4 + n7, n3 - n6, n4 + n7, n3 - n6, n5 - n7, n2 + n6, n5 - n7);
                this.drawStripe(opaque, STRIPEDEDGECOLORS[s2][0][2], n2, n4, n2 + n6, n4 + n7, n2 + n6, n5 - n7, n2, n5);
                this.drawStripe(opaque, STRIPEDEDGECOLORS[s2][0][2], n2, n5, n3, n5, n3 - n6, n5 - n7, n2 + n6, n5 - n7);
                break;
            }
            case 6: 
            case 7: {
                this.session.error("invalid rule-style: " + attr2 + " (not applicable to leaders)");
                break;
            }
            default: {
                throw new RuntimeException("Internal error: invalid rule style index " + s2);
            }
        }
    }

    public void process(Item.PDFComment pDFComment) {
        if (this.idlePass) {
            return;
        }
        int n = 0;
        int n2 = 0;
        n = Math.round(pDFComment.cwidth * 1000.0f);
        n2 = Math.round(pDFComment.cheight * 1000.0f);
        try {
            this.attrs.clear();
            this.addAttribute("x-from", "CDATA", Integer.toString(this.x));
            this.addAttribute("y-from", "CDATA", Integer.toString(this.y));
            this.addAttribute("x-till", "CDATA", Integer.toString(this.x + n));
            this.addAttribute("y-till", "CDATA", Integer.toString(this.y + n2));
            this.addAttribute("content", "CDATA", pDFComment.get(Attn.$content).word());
            this.addAttribute("title", "CDATA", pDFComment.get(Attn.$title).word());
            this.addAttribute("opacity", "CDATA", "" + pDFComment.get(Attn.$opacity).ratio());
            this.startElement("pdf-comment", this.attrs);
            if (pDFComment.containsKey(Attn.$color)) {
                Attr.Color.Opaque opaque = (Attr.Color.Opaque)pDFComment.get(Attn.$color);
                if (!(opaque instanceof Attr.Color.SpotColor) && !(opaque instanceof Attr.Color.Registration)) {
                    this.processColor(opaque);
                } else {
                    this.session.warning("color type: '" + opaque.getTypeName() + "' is not supported in PDF comments");
                }
            }
            this.attrs.clear();
            if (pDFComment.getStickyNote() != null) {
                this.addAttribute("icon-type", "CDATA", pDFComment.getStickyIconType());
                this.addAttribute("open", "CDATA", pDFComment.isOpen() ? "true" : "false");
                this.startElement("pdf-sticky-note", this.attrs);
                this.endElement("pdf-sticky-note");
            } else if (pDFComment.getFileAttachment() != null) {
                this.addAttribute("src", "CDATA", pDFComment.getFile());
                this.addAttribute("filename", "CDATA", pDFComment.getFileName());
                this.addAttribute("icon-type", "CDATA", pDFComment.getFileIconType());
                this.startElement("pdf-file-attachment", this.attrs);
                this.endElement("pdf-file-attachment");
            }
            this.attrs.clear();
            this.endElement("pdf-comment");
        }
        catch (SAXException sAXException) {
            throw new InternalException(sAXException.getMessage());
        }
        this.x += pDFComment.width;
    }

    public void process(Item.Image image) {
        if (this.idlePass) {
            return;
        }
        int n = 0;
        int n2 = 0;
        n = (int)Math.round(image.im.width * 1000.0 * image.scale[0]);
        n2 = (int)Math.round(image.im.height * 1000.0 * image.scale[1]);
        Attr attr = image.get(Attn.$overflow);
        if (image.im != null) {
            try {
                Attr.Color.Grayscale grayscale = Attr.Color.Grayscale.create(0);
                grayscale.overprint = this.overprintFlag;
                this.processColor(grayscale);
                if (attr != Attr.newWord("visible")) {
                    this.attrs.clear();
                    this.addAttribute("x-from", "CDATA", Integer.toString(this.x));
                    this.addAttribute("y-from", "CDATA", Integer.toString(this.y + image.offset));
                    this.addAttribute("x-till", "CDATA", Integer.toString(this.x + image.width));
                    this.addAttribute("y-till", "CDATA", Integer.toString(this.y + image.offset + image.ascender));
                    this.startElement("clip", this.attrs);
                }
                int n3 = 0;
                int n4 = 0;
                Attr attr2 = image.get(Attn.$display_align);
                if (attr2 == Attr.newWord("before")) {
                    n4 = image.ascender - n2;
                } else if (attr2 == Attr.newWord("center")) {
                    n4 = (image.ascender - n2) / 2;
                }
                Attr attr3 = image.get(Attn.$text_align);
                if (attr3 == Attr.newWord("inside")) {
                    attr3 = this.page.number % 2 == 1 ? Attr.newWord("start") : Attr.newWord("end");
                } else if (attr3 == Attr.newWord("outside")) {
                    Attr attr4 = attr3 = this.page.number % 2 == 0 ? Attr.newWord("start") : Attr.newWord("end");
                }
                if (image.get(Attn.$writing_mode) == Attr.rl_tb) {
                    Attr attr5 = attr3 = attr3 == Attr.newWord("end") ? Attr.newWord("start") : Attr.newWord("end");
                }
                if (attr3 == Attr.newWord("end")) {
                    n3 = image.width - n;
                } else if (attr3 == Attr.newWord("center")) {
                    n3 = (image.width - n) / 2;
                }
                this.attrs.clear();
                URLSpec uRLSpec = image.im.source != null ? image.im.source : image.im.getFactory().getSource(image.im);
                this.addAttribute("src", "CDATA", uRLSpec.toString());
                if (uRLSpec.scheme != 3) {
                    this.addAttribute("base", "CDATA", uRLSpec.getBase().toString());
                }
                this.addAttribute("type", "CDATA", image.im.mimetype);
                this.addAttribute("x-from", "CDATA", Integer.toString(this.x + n3));
                this.addAttribute("y-from", "CDATA", Integer.toString(this.y + image.offset + n4));
                this.addAttribute("scale-x", "CDATA", Double.toString(image.scale[0]));
                this.addAttribute("scale-y", "CDATA", Double.toString(image.scale[1]));
                this.addAttribute("width", "CDATA", Integer.toString(n));
                this.addAttribute("height", "CDATA", Integer.toString(n2));
                if ("application/pdf".equals(image.im.mimetype)) {
                    this.addAttribute("page-number", "CDATA", Integer.toString(image.get(Attn.$pdf_page).count()));
                }
                this.addAccessibilityProperties(image);
                if (image.im instanceof Media) {
                    Object object;
                    this.addAttribute("alt", "CDATA", image.get(Attn.$alt).word());
                    if (!image.isRMO) {
                        if (uRLSpec.scheme == 1 && !image.get(Attn.$embed).bool()) {
                            this.session.warning("Media object is not stand-alone: embedding forced");
                            this.addAttribute("embed", "CDATA", "true");
                        } else {
                            this.addAttribute("embed", "CDATA", image.get(Attn.$embed).bool() ? "true" : "false");
                        }
                        this.addAttribute("extraction-policy", "CDATA", image.get(Attn.$extraction_policy).word());
                        this.addAttribute("show-controls", "CDATA", image.get(Attn.$show_controls).bool() ? "true" : "false");
                        if (image.get(Attn.$duration) instanceof Attr.Ratio) {
                            this.addAttribute("duration", "CDATA", image.get(Attn.$duration).ratio() + "");
                        } else {
                            this.addAttribute("duration", "CDATA", image.get(Attn.$duration).word());
                        }
                        this.addAttribute("play-mode", "CDATA", image.get(Attn.$play_mode).ratio() + "");
                        if (image.get(Attn.$volume) instanceof Attr.Ratio) {
                            this.addAttribute("volume", "CDATA", image.get(Attn.$volume).ratio() + "");
                        } else {
                            this.addAttribute("volume", "CDATA", image.get(Attn.$volume).toString());
                        }
                    } else {
                        this.addAttribute("embed", "CDATA", "true");
                        this.addAttribute("transparency", "CDATA", image.get(Attn.$transparency).bool() ? "true" : "false");
                        this.addAttribute("activate-condition", "CDATA", image.get(Attn.$activate_condition).word());
                        this.addAttribute("deactivate-condition", "CDATA", image.get(Attn.$deactivate_condition).word());
                        this.addAttribute("play-count", "CDATA", image.get(Attn.$play_count).count() + "");
                        this.addAttribute("name", "CDATA", image.get(Attn.$name).word());
                    }
                    this.startElement(image.isRMO ? "rich-media-object" : "media-object", this.attrs);
                    this.attrs.clear();
                    this.addAttribute("x-from", "CDATA", Integer.toString(this.x + n3));
                    this.addAttribute("y-from", "CDATA", Integer.toString(this.y + image.offset + n4));
                    int n5 = 0;
                    int n6 = 0;
                    if (image.containsKey(Attn.$poster)) {
                        object = image.poster.source != null ? image.poster.source : image.poster.getFactory().getSource(image.poster);
                        this.addAttribute("src", "CDATA", ((URLSpec)object).toString());
                        if (uRLSpec.scheme != 3) {
                            this.addAttribute("base", "CDATA", ((URLSpec)object).getBase().toString());
                        }
                        this.addAttribute("type", "CDATA", image.poster.mimetype);
                        n5 = (int)Math.round(image.poster.width * 1000.0);
                        n6 = (int)Math.round(image.poster.height * 1000.0);
                    } else {
                        this.addAttribute("src", "CDATA", "data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBzdGFuZGFsb25lPSJubyI/Pg0KPHN2ZyB3aWR0aD0iOTBwdCIgaGVpZ2h0PSI5MHB0IiB2aWV3Qm94PSIwIDAgOTAgOTAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIj4NCiAgPGNpcmNsZSBjeD0iNDUiIGN5PSI0NSIgcj0iMTUiIGZpbGw9ImxpZ2h0Z3JleSIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLXdpZHRoPSIwLjUiICAvPg0KCTxwYXRoIGQ9Ik0gNTQuMjcwNTA5ODMxMjQ4NDIyNzIzMDY4ODAyNTE1NDg0IDQ1IEwgNDAuMzY0NzQ1MDg0Mzc1Nzg4NjM4NDY1NTk4NzQyMjU4IDUzLjAyODQ5NzAxOTg5NDUyMzQ2ODY5NDMyMTQ2ODUzNiBMIDQwLjM2NDc0NTA4NDM3NTc4ODYzODQ2NTU5ODc0MjI1OCAzNi45NzE1MDI5ODAxMDU0NzY1MzEzMDU2Nzg1MzE0NjQgeiIgZmlsbD0iZGFya2dyZXkiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS13aWR0aD0iMC43IiAvPg0KPC9zdmc+DQoNCg==");
                        this.addAttribute("type", "CDATA", "image/svg+xml");
                        try {
                            object = this.session.config.imageFactory.makeImage(new URLSpec("data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBzdGFuZGFsb25lPSJubyI/Pg0KPHN2ZyB3aWR0aD0iOTBwdCIgaGVpZ2h0PSI5MHB0IiB2aWV3Qm94PSIwIDAgOTAgOTAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmVyc2lvbj0iMS4xIj4NCiAgPGNpcmNsZSBjeD0iNDUiIGN5PSI0NSIgcj0iMTUiIGZpbGw9ImxpZ2h0Z3JleSIgc3Ryb2tlPSJibGFjayIgc3Ryb2tlLXdpZHRoPSIwLjUiICAvPg0KCTxwYXRoIGQ9Ik0gNTQuMjcwNTA5ODMxMjQ4NDIyNzIzMDY4ODAyNTE1NDg0IDQ1IEwgNDAuMzY0NzQ1MDg0Mzc1Nzg4NjM4NDY1NTk4NzQyMjU4IDUzLjAyODQ5NzAxOTg5NDUyMzQ2ODY5NDMyMTQ2ODUzNiBMIDQwLjM2NDc0NTA4NDM3NTc4ODYzODQ2NTU5ODc0MjI1OCAzNi45NzE1MDI5ODAxMDU0NzY1MzEzMDU2Nzg1MzE0NjQgeiIgZmlsbD0iZGFya2dyZXkiIHN0cm9rZT0iYmxhY2siIHN0cm9rZS13aWR0aD0iMC43IiAvPg0KPC9zdmc+DQoNCg=="));
                            n5 = (int)Math.round(((Image)object).width * 1000.0);
                            n6 = (int)Math.round(((Image)object).height * 1000.0);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.addAttribute("scale-x", "CDATA", Double.toString((double)n / (double)n5));
                    this.addAttribute("scale-y", "CDATA", Double.toString((double)n2 / (double)n6));
                    this.addAccessibilityProperties(image);
                    this.addAttribute("width", "CDATA", "" + n5);
                    this.addAttribute("height", "CDATA", "" + n6);
                    this.startElement("poster", this.attrs);
                    this.endElement("poster");
                    if (image.isRMO) {
                        Object object2;
                        Object object3;
                        object = image.getFlashVars();
                        if (object != null && !((Hashtable)(object3 = ((Item.Image.FlashVars)object).getVars())).isEmpty()) {
                            object2 = ((Hashtable)object3).elements();
                            while (object2.hasMoreElements()) {
                                Item.Image.FlashVars.FlashVar flashVar = (Item.Image.FlashVars.FlashVar)object2.nextElement();
                                this.startElement("flash-var", flashVar.getAttrs());
                                this.endElement("flash-var");
                            }
                        }
                        if (image.rmoResources != null) {
                            object3 = image.rmoResources.keys();
                            while (object3.hasMoreElements()) {
                                this.attrs.clear();
                                object2 = (String)object3.nextElement();
                                this.addAttribute("name", "CDATA", (String)object2);
                                this.addAttribute("src", "CDATA", (String)image.rmoResources.get(object2));
                                this.startElement("rich-media-resource", this.attrs);
                                this.endElement("rich-media-resource");
                            }
                        }
                    }
                } else {
                    this.startElement("image", this.attrs);
                }
                if (image.im instanceof Media) {
                    this.endElement(image.isRMO ? "rich-media-object" : "media-object");
                } else {
                    this.endElement("image");
                }
                if (attr != Attr.newWord("visible")) {
                    this.endElement("clip");
                }
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        }
        this.x += image.width;
    }

    public void process(Item.Washer.Inline inline) {
        if (this.idlePass) {
            return;
        }
        this.x += inline.thickness;
    }

    public void process(Item.Filled filled) {
        if (this.idlePass) {
            return;
        }
    }

    public void process(Item.Id id) {
        if (this.idlePass) {
            return;
        }
        this.attrs.clear();
        this.addAccessibilityProperties(id);
        this.addAttribute("x", "CDATA", Integer.toString(id.x));
        this.addAttribute("y", "CDATA", Integer.toString(id.y));
        this.addAttribute("id", "CDATA", id.id.word());
        this.addAttribute("name", "CDATA", id.id.word());
        try {
            this.startElement("target", this.attrs);
            this.endElement("target");
        }
        catch (SAXException sAXException) {
            throw new InternalException(sAXException.getMessage());
        }
    }

    public void process(Item.Pinpoint pinpoint) {
        if (this.idlePass) {
            return;
        }
        this.attrs.clear();
        this.addAttribute("x", "CDATA", Integer.toString(pinpoint.x));
        this.addAttribute("y", "CDATA", Integer.toString(pinpoint.y));
        this.addAttribute("value", "CDATA", pinpoint.get(Attn.$value).word());
        try {
            this.startElement("pinpoint", this.attrs);
            this.endElement("pinpoint");
        }
        catch (SAXException sAXException) {
            throw new InternalException(sAXException.getMessage());
        }
    }

    public void process(Item.ChangeBarPoint changeBarPoint) {
    }

    public void process(Item.PI pI) {
        if (this.idlePass) {
            return;
        }
        try {
            if ("xepx-df-split".equals(pI.target)) {
                this.deferredPIs.snoc(pI);
            } else {
                this.handler.processingInstruction(pI.target, pI.data);
            }
        }
        catch (SAXException sAXException) {
            throw new InternalException(sAXException.getMessage());
        }
    }

    public void process(Item.Bookmark bookmark) {
        String string;
        if (this.idlePass) {
            return;
        }
        this.attrs.clear();
        this.addAccessibilityProperties(bookmark);
        this.addAttribute("label", "CDATA", bookmark.label);
        if (bookmark.font_style != null) {
            this.addAttribute("font-style", "CDATA", bookmark.font_style.word());
        }
        if (bookmark.font_weight != null) {
            this.addAttribute("font-weight", "CDATA", Integer.toString(bookmark.font_weight.count()));
        }
        this.addAttribute("id", "CDATA", bookmark.bno.toString());
        this.addAttribute("parent-id", "CDATA", bookmark.parent != null ? bookmark.parent.bno.toString() : "0");
        boolean bl = bookmark.containsKey(Attn.$collapse_subtree) && bookmark.get(Attn.$collapse_subtree).bool() || bookmark.containsKey(Attn.$starting_state) && bookmark.get(Attn.$starting_state).word().equals("hide");
        this.addAttribute("collapse-subtree", "CDATA", bl ? "true" : "false");
        if (bookmark.containsKey(Attn.$internal_destination)) {
            this.addAttribute("destination-id", "CDATA", bookmark.get(Attn.$internal_destination).word());
            this.addAttribute("destination", "CDATA", Integer.toString(this.getRenumberedPageNumber(bookmark.id.page, bookmark.id.page.no)));
            this.addAttribute("destination-x", "CDATA", Integer.toString(bookmark.id.x));
            this.addAttribute("destination-y", "CDATA", Integer.toString(bookmark.id.y));
            try {
                this.startElement("internal-bookmark", this.attrs);
                this.processBookmarkColor(bookmark.color);
                this.endElement("internal-bookmark");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        }
        if (bookmark.containsKey(Attn.$external_destination) && (string = bookmark.get(Attn.$external_destination).word()) != "") {
            this.addAttribute("destination", "CDATA", string);
            this.addAttribute("show-destination", "CDATA", bookmark.get(Attn.$show_destination).word());
            try {
                this.startElement("external-bookmark", this.attrs);
                this.processBookmarkColor(bookmark.color);
                this.endElement("external-bookmark");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        }
    }

    private final void processBookmarkColor(Object object) {
        if (object != null) {
            Attr.Color.Opaque opaque = (Attr.Color.Opaque)object;
            if (!(opaque instanceof Attr.Color.SpotColor) && !(opaque instanceof Attr.Color.Registration)) {
                this.forceEmitColor = true;
                this.processColor(opaque);
            } else {
                this.session.warning("color type: '" + opaque.getTypeName() + "' is not supported in bookmarks");
            }
        }
    }

    private final void processColor(Attr.Color.Opaque opaque) {
        if (opaque.equals(this.color) && !this.forceEmitColor && opaque.overprint == this.overprintFlag) {
            return;
        }
        this.forceEmitColor = false;
        this.color = opaque;
        try {
            if (opaque instanceof Attr.Color.Grayscale) {
                double d = ((Attr.Color.Grayscale)opaque).gray();
                this.attrs.clear();
                this.addAttribute("gray", "CDATA", Float.toString((float)d));
                if (opaque.overprint != this.overprintFlag) {
                    this.addAttribute("overprint", "CDATA", opaque.overprint ? "true" : "false");
                }
                this.startElement("gray-color", this.attrs);
                this.endElement("gray-color");
            } else if (opaque instanceof Attr.Color.RGB) {
                double[] dArray = ((Attr.Color.RGB)opaque).r_g_b();
                this.attrs.clear();
                this.addAttribute("red", "CDATA", Float.toString((float)dArray[0]));
                this.addAttribute("green", "CDATA", Float.toString((float)dArray[1]));
                this.addAttribute("blue", "CDATA", Float.toString((float)dArray[2]));
                if (opaque.overprint != this.overprintFlag) {
                    this.addAttribute("overprint", "CDATA", opaque.overprint ? "true" : "false");
                }
                this.startElement("rgb-color", this.attrs);
                this.endElement("rgb-color");
            } else if (opaque instanceof Attr.Color.CMYK) {
                double[] dArray = ((Attr.Color.CMYK)opaque).c_m_y_k();
                this.attrs.clear();
                this.addAttribute("cyan", "CDATA", Float.toString((float)dArray[0]));
                this.addAttribute("magenta", "CDATA", Float.toString((float)dArray[1]));
                this.addAttribute("yellow", "CDATA", Float.toString((float)dArray[2]));
                this.addAttribute("black", "CDATA", Float.toString((float)dArray[3]));
                if (opaque.overprint != this.overprintFlag) {
                    this.addAttribute("overprint", "CDATA", opaque.overprint ? "true" : "false");
                }
                this.startElement("cmyk-color", this.attrs);
                this.endElement("cmyk-color");
            } else if (opaque instanceof Attr.Color.SpotColor) {
                Attr.Color.SpotColor spotColor = (Attr.Color.SpotColor)opaque;
                this.attrs.clear();
                this.addAttribute("colorant", "CDATA", spotColor.colorant);
                this.addAttribute("tint", "CDATA", Float.toString((float)spotColor.tint()));
                if (spotColor.altColor == null) {
                    this.addAttribute("alt-gray", "CDATA", "0");
                } else if (spotColor.altColor instanceof Attr.Color.Grayscale) {
                    double d = ((Attr.Color.Grayscale)spotColor.altColor).gray();
                    this.addAttribute("alt-gray", "CDATA", Float.toString((float)d));
                } else if (spotColor.altColor instanceof Attr.Color.RGB) {
                    double[] dArray = ((Attr.Color.RGB)spotColor.altColor).r_g_b();
                    this.addAttribute("alt-red", "CDATA", Float.toString((float)dArray[0]));
                    this.addAttribute("alt-green", "CDATA", Float.toString((float)dArray[1]));
                    this.addAttribute("alt-blue", "CDATA", Float.toString((float)dArray[2]));
                } else if (spotColor.altColor instanceof Attr.Color.CMYK) {
                    double[] dArray = ((Attr.Color.CMYK)spotColor.altColor).c_m_y_k();
                    this.addAttribute("alt-cyan", "CDATA", Float.toString((float)dArray[0]));
                    this.addAttribute("alt-magenta", "CDATA", Float.toString((float)dArray[1]));
                    this.addAttribute("alt-yellow", "CDATA", Float.toString((float)dArray[2]));
                    this.addAttribute("alt-black", "CDATA", Float.toString((float)dArray[3]));
                } else {
                    throw new RuntimeException("Unknown color type: " + spotColor.altColor.getClass().getName());
                }
                if (opaque.overprint != this.overprintFlag) {
                    this.addAttribute("overprint", "CDATA", opaque.overprint ? "true" : "false");
                }
                this.startElement("spot-color", this.attrs);
                this.endElement("spot-color");
            } else if (opaque instanceof Attr.Color.Registration) {
                double d = ((Attr.Color.Registration)opaque).tint();
                this.attrs.clear();
                this.addAttribute("tint", "CDATA", Float.toString((float)d));
                if (opaque.overprint != this.overprintFlag) {
                    this.addAttribute("overprint", "CDATA", opaque.overprint ? "true" : "false");
                }
                this.startElement("registration-color", this.attrs);
                this.endElement("registration-color");
            }
        }
        catch (SAXException sAXException) {
            throw new InternalException(sAXException.getMessage());
        }
        this.overprintFlag = opaque.overprint;
    }

    private final Area makeArea(BPB bPB) {
        Area area = new Area(bPB.r, bPB);
        if (bPB.writing_mode == Attr.rl_tb) {
            int n = 0;
            while (n != 3) {
                int n2 = area.r[n][0];
                area.r[n][0] = -area.r[n][2];
                area.r[n][2] = -n2;
                ++n;
            }
        }
        return area;
    }

    private List zfilter(List list, int n) {
        List list2 = new List();
        Enumeration enumeration = list.elements();
        while (enumeration.hasMoreElements()) {
            Item.ChangeBar changeBar = (Item.ChangeBar)enumeration.nextElement();
            if (changeBar.zindex < 0 != n < 0) continue;
            list2.snoc(changeBar);
        }
        return list2;
    }

    private void drawChangeBars(BkMaker.Page page, int n) {
        List list = new List();
        List list2 = new List();
        Enumeration enumeration = page.bodyregtab.elements();
        while (enumeration.hasMoreElements()) {
            BodyRegion bodyRegion = (BodyRegion)enumeration.nextElement();
            if (bodyRegion.type == BodyRegion.STATIC) {
                list2.snoc(bodyRegion);
                continue;
            }
            list.snoc(bodyRegion);
        }
        list = Sort.sort(list, (Sort.Cmp)new SSorter());
        list.prepend(list2);
        Enumeration enumeration2 = list.elements();
        while (enumeration2.hasMoreElements()) {
            BodyRegion bodyRegion = (BodyRegion)enumeration2.nextElement();
            CBProcessor cBProcessor = new CBProcessor(bodyRegion, n);
            List list3 = cBProcessor.processBars();
            class ZSorter
            implements Sort.Cmp {
                private final /* synthetic */ SAX this$0;

                ZSorter(SAX sAX) {
                    this.this$0 = sAX;
                }

                public int cmp(Object object, Object object2) {
                    int n;
                    int n2 = ((CB)object).icb.a.get(Attn.$z_index).count();
                    return n2 > (n = ((CB)object2).icb.a.get(Attn.$z_index).count()) ? 1 : (n2 < n ? -1 : 0);
                }
            }
            list3 = Sort.sort(list3, (Sort.Cmp)new ZSorter(this));
            Enumeration enumeration3 = list3.elements();
            while (enumeration3.hasMoreElements()) {
                this.drawCB((CB)enumeration3.nextElement(), bodyRegion);
            }
        }
    }

    private void drawCB(CB cB, BodyRegion bodyRegion) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        Attributed attributed = cB.icb.a;
        int n11 = attributed.get(Attn.$change_bar_width).length();
        if (Util.eq0(n11)) {
            return;
        }
        Attr attr = attributed.get(Attn.$change_bar_color);
        if (attr == Attr.Color.transparent) {
            return;
        }
        if (!(attr instanceof Attr.Color.Opaque)) {
            this.session.error("Invalid change-bar-color: " + attr);
            return;
        }
        Attr.Color.Opaque opaque = (Attr.Color.Opaque)attr;
        short s = 0;
        Attr attr2 = attributed.get(Attn.$change_bar_style);
        Short s2 = (Short)styles.get(attr2);
        if (s2 == null) {
            this.session.warning("invalid change-bar-style: " + attr2 + ", using 'solid'");
            attr2 = Attr.newWord("solid");
        } else {
            s = s2;
        }
        int n12 = 0;
        Attr attr3 = attributed.get(Attn.$change_bar_placement);
        Short s3 = (Short)cbPlacement.get(attr3);
        if (s3 == null) {
            this.session.warning("Invalid change-bar-placement: " + attr3 + ", using 'start'");
            attr3 = Attr.newWord("start");
        } else {
            n12 = s3.shortValue();
        }
        Attr attr4 = bodyRegion.reg.get(Attn.$writing_mode);
        if (n12 == 6) {
            int n13 = n12 = bodyRegion.pos == BodyRegion.LAST ? 1 : 0;
        }
        if (n12 == 4 || n12 == 5) {
            int n14 = n12 = (bodyRegion.pgid % 2 == 1 ^ attr4 == Attr.rl_tb) == (n12 == 5) ? 1 : 0;
        }
        if (n12 == 0 || n12 == 1) {
            int n15 = n12 = attr4 == Attr.lr_tb == (n12 == 0) ? 2 : 3;
        }
        if ((n10 = (n9 = bodyRegion.reg.phi) / 90) < 0 || n10 > 3) {
            throw new InternalError("illegal region-body@reference-orientation: " + n9);
        }
        int[] nArray = new int[4];
        int n16 = 0;
        while (n16 < 2) {
            nArray[2 * n16] = bodyRegion.rc[2 * n16] * affinm[n10][0][0] + bodyRegion.rc[2 * n16 + 1] * affinm[n10][0][1];
            nArray[2 * n16 + 1] = bodyRegion.rc[2 * n16] * affinm[n10][1][0] + bodyRegion.rc[2 * n16 + 1] * affinm[n10][1][1];
            ++n16;
        }
        int n17 = cB.start_x;
        int n18 = cB.start_y;
        int n19 = cB.end_x;
        int n20 = cB.end_y;
        int n21 = attributed.get(Attn.$change_bar_offset).length();
        if (n10 % 2 == 0) {
            int n22;
            if (n18 == Integer.MIN_VALUE) {
                n18 = nArray[3];
            }
            if (n20 == Integer.MIN_VALUE) {
                n20 = nArray[1];
            }
            n17 = n19 = (n22 = n12 == 2 ? nArray[0] - unitvec_x[n10] * n21 : nArray[2] + unitvec_x[n10] * n21);
            if (Util.eq0(n18 - n20)) {
                return;
            }
            n7 = n8 = n17 - n11 / 2;
            n5 = n6 = n17 + n11 / 2;
            n3 = n4 = n18;
            n = n2 = n20;
        } else {
            int n23;
            if (n17 == Integer.MIN_VALUE) {
                n17 = nArray[2];
            }
            if (n19 == Integer.MIN_VALUE) {
                n19 = nArray[0];
            }
            n18 = n20 = (n23 = n12 == 2 ? nArray[1] - unitvec_x[n10] * n21 : nArray[3] + unitvec_x[n10] * n21);
            if (Util.eq0(n17 - n19)) {
                return;
            }
            n3 = n = n18 - n11 / 2;
            n2 = n4 = n18 + n11 / 2;
            n7 = n6 = n17;
            n8 = n5 = n19;
        }
        switch (s) {
            case -2: 
            case -1: {
                break;
            }
            case 1: 
            case 2: {
                this.drawLine(opaque, attr2.word(), n11, (n5 + n7) / 2, n3, (n5 + n7) / 2, n);
                break;
            }
            case 6: 
            case 7: {
                this.drawStripe(opaque, SOLIDEDGECOLORS[s][n12 == 2 ? 0 : 1], n7, n3, n8, n, n5, n2, n6, n4);
                break;
            }
            case 4: 
            case 5: {
                int n24 = (n6 - n7) / 4;
                int n25 = (n4 - n3) / 4;
                int n26 = (n5 - n8) / 4;
                int n27 = (n2 - n) / 4;
                this.drawStripe(opaque, STRIPEDEDGECOLORS[s][0][2], n7, n3, n8, n, n8 + n26, n + n27, n7 + n24, n3 + n25);
                this.drawStripe(opaque, STRIPEDEDGECOLORS[s][0][1], n7 + n24, n3 + n25, n8 + n26, n + n27, n5 - n26, n2 - n27, n6 - n24, n4 - n25);
                this.drawStripe(opaque, STRIPEDEDGECOLORS[s][0][0], n6 - n24, n4 - n25, n5 - n26, n2 - n27, n5, n2, n6, n4);
                break;
            }
            case 0: {
                this.drawTetragon(opaque, n7, n3, n8, n, n5, n2, n6, n4);
                break;
            }
            case 3: {
                int n28 = (n6 - n7) / 3;
                int n29 = (n4 - n3) / 3;
                int n30 = (n5 - n8) / 3;
                int n31 = (n2 - n) / 3;
                this.drawTetragon(opaque, n7, n3, n8, n, n8 + n30, n + n31, n7 + n28, n3 + n29);
                this.drawTetragon(opaque, n6 - n28, n4 - n29, n5 - n30, n2 - n31, n5, n2, n6, n4);
                break;
            }
            default: {
                throw new InternalError("bad value for style switch: " + s);
            }
        }
    }

    private void processPDFFormField(Item.PDFFormField pDFFormField) {
        if (pDFFormField == null) {
            return;
        }
        try {
            if (pDFFormField.content.isEmpty()) {
                return;
            }
            Item.PDFFormField pDFFormField2 = (Item.PDFFormField)pDFFormField.content.car();
            if (pDFFormField2.parentbpb == null) {
                pDFFormField2.parentbpb = pDFFormField.parentbpb;
            }
            Area area = this.makeArea(pDFFormField.parentbpb);
            int n = pDFFormField2.a.get(Attn.oldName("border-start-width.length")).length();
            this.attrs.clear();
            this.addAttribute("x-from", "CDATA", Integer.toString(area.r[0][0] - n));
            this.addAttribute("y-from", "CDATA", Integer.toString(area.r[0][1] - n));
            this.addAttribute("x-till", "CDATA", Integer.toString(area.r[0][2] + n));
            this.addAttribute("y-till", "CDATA", Integer.toString(area.r[0][3] + n));
            this.addMandatoryAttribute(Attn.$name, "CDATA", pDFFormField.a);
            if (pDFFormField.fieldno > 0) {
                this.addAttribute("fieldno", "CDATA", Integer.toString(pDFFormField.fieldno));
            }
            this.addOptionalAttribute(Attn.$readonly, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$required, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$noexport, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$hidden, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$printable, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$js_keystroke, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$js_format, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$js_validate, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$js_calculate, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$js_blur, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$js_focus, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$js_mousedown, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$js_mouseup, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$js_mouseenter, "CDATA", pDFFormField.a);
            this.addOptionalAttribute(Attn.$js_mouseexit, "CDATA", pDFFormField.a);
            this.startElement("pdf-form-field", this.attrs);
            this.processPDFFormFieldContent(pDFFormField2);
            this.endElement("pdf-form-field");
        }
        catch (SAXException sAXException) {
            throw new InternalException(sAXException.getMessage());
        }
        this.forceEmitFont = true;
        this.forceEmitColor = true;
    }

    private void processPDFFormFieldContent(Item.PDFFormField pDFFormField) {
        if (pDFFormField instanceof Item.PDFFormFieldText) {
            try {
                this.attrs.clear();
                this.addMandatoryAttribute(Attn.$text, "CDATA", pDFFormField.a);
                this.addOptionalAttribute(Attn.$multiline, "CDATA", pDFFormField.a);
                this.addOptionalAttribute(Attn.$password, "CDATA", pDFFormField.a);
                this.addOptionalAttribute(Attn.$maxlen, "CDATA", pDFFormField.a);
                this.startElement("pdf-form-field-text", this.attrs);
                this.processPDFFormFieldAppearance(pDFFormField);
                if (pDFFormField.a.containsKey(Attn.$multiline) && pDFFormField.a.get(Attn.$multiline).bool()) {
                    this.addPDFFormFieldOption(pDFFormField, "start", true);
                } else {
                    this.addPDFFormFieldOption(pDFFormField, "start", false);
                }
                this.endElement("pdf-form-field-text");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        } else if (pDFFormField instanceof Item.PDFFormFieldRadio) {
            try {
                this.attrs.clear();
                this.addMandatoryAttribute(Attn.$group_name, "CDATA", pDFFormField.a);
                this.startElement("pdf-form-field-radio-button", this.attrs);
                this.processPDFFormFieldAppearance(pDFFormField);
                this.processPDFFormFieldOptions(pDFFormField, "center", false, true);
                this.endElement("pdf-form-field-radio-button");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        } else if (pDFFormField instanceof Item.PDFFormFieldCheckbox) {
            try {
                this.attrs.clear();
                this.startElement("pdf-form-field-checkbox", this.attrs);
                this.processPDFFormFieldAppearance(pDFFormField);
                this.processPDFFormFieldOptions(pDFFormField, "center", false, true);
                this.endElement("pdf-form-field-checkbox");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        } else if (pDFFormField instanceof Item.PDFFormFieldListbox) {
            try {
                this.attrs.clear();
                this.addOptionalAttribute(Attn.$multiselect, "CDATA", pDFFormField.a);
                this.startElement("pdf-form-field-listbox", this.attrs);
                this.processPDFFormFieldAppearance(pDFFormField);
                this.processPDFFormFieldOptions(pDFFormField, "start", false, false);
                this.endElement("pdf-form-field-listbox");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        } else if (pDFFormField instanceof Item.PDFFormFieldCombobox) {
            try {
                this.attrs.clear();
                this.addOptionalAttribute(Attn.$editable, "CDATA", pDFFormField.a);
                this.addOptionalAttribute(Attn.$multiselect, "CDATA", pDFFormField.a);
                this.startElement("pdf-form-field-combobox", this.attrs);
                this.processPDFFormFieldAppearance(pDFFormField);
                this.processPDFFormFieldOptions(pDFFormField, "start", false, false);
                this.endElement("pdf-form-field-combobox");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        } else if (pDFFormField instanceof Item.PDFFormFieldReset) {
            try {
                this.attrs.clear();
                this.addMandatoryAttribute(Attn.$text, "CDATA", pDFFormField.a);
                this.addOptionalAttribute(Attn.$fields, "CDATA", pDFFormField.a);
                this.startElement("pdf-form-field-reset", this.attrs);
                this.processPDFFormFieldAppearance(pDFFormField);
                this.addPDFFormFieldOption(pDFFormField, "center", false);
                this.endElement("pdf-form-field-reset");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        } else if (pDFFormField instanceof Item.PDFFormFieldSubmit) {
            try {
                this.attrs.clear();
                this.addMandatoryAttribute(Attn.$text, "CDATA", pDFFormField.a);
                this.addMandatoryAttribute(Attn.$url, "CDATA", pDFFormField.a);
                this.addOptionalAttribute(Attn.$fields, "CDATA", pDFFormField.a);
                this.addOptionalAttribute(Attn.$submit_format, "CDATA", pDFFormField.a);
                this.addOptionalAttribute(Attn.$method, "CDATA", pDFFormField.a);
                this.addOptionalAttribute(Attn.$novalue_fields, "CDATA", pDFFormField.a);
                this.startElement("pdf-form-field-submit", this.attrs);
                this.processPDFFormFieldAppearance(pDFFormField);
                this.addPDFFormFieldOption(pDFFormField, "center", false);
                this.endElement("pdf-form-field-submit");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        } else {
            throw new RuntimeException("Content of a PDFFormField is neither Radio nor Checkboxnor Listbox nor Combobox nor Reset nor Submit: it is a " + pDFFormField.getClass().getName() + " instance.");
        }
    }

    private void processPDFFormFieldOptions(Item.PDFFormField pDFFormField, String string, boolean bl, boolean bl2) {
        boolean bl3 = true;
        this.y = 0;
        Enumeration enumeration = pDFFormField.content.elements();
        while (enumeration.hasMoreElements()) {
            Item.PDFFormFieldOption pDFFormFieldOption = (Item.PDFFormFieldOption)enumeration.nextElement();
            AttList attList = (AttList)pDFFormField.a.clone();
            attList.put(Attn.$text, pDFFormFieldOption.a.get(Attn.$text));
            attList.put(Attn.$initially_selected, pDFFormFieldOption.a.get(Attn.$initially_selected));
            Item.PDFFormFieldOption pDFFormFieldOption2 = new Item.PDFFormFieldOption(attList, this.session);
            if (pDFFormFieldOption.parentbpb == null) {
                pDFFormFieldOption2.parentbpb = pDFFormField.parentbpb;
            }
            this.processPDFFormFieldOption(pDFFormFieldOption2, string, bl2 ? "center" : "start", bl, bl3, !bl2);
            if (bl2) continue;
            bl3 = false;
        }
    }

    private void processPDFFormFieldOption(Item.PDFFormFieldOption pDFFormFieldOption, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            this.y = 0;
        }
        try {
            this.attrs.clear();
            this.addMandatoryAttribute(Attn.$text, "CDATA", pDFFormFieldOption.a);
            this.addOptionalAttribute(Attn.$initially_selected, "CDATA", pDFFormFieldOption.a);
            this.startElement("pdf-form-field-option", this.attrs);
            this.processPDFFormFieldText(pDFFormFieldOption, string, string2, bl, bl2, bl3);
            this.endElement("pdf-form-field-option");
        }
        catch (SAXException sAXException) {
            throw new InternalException(sAXException.getMessage());
        }
    }

    private void addPDFFormFieldOption(Item.PDFFormField pDFFormField, String string, boolean bl) {
        AttList attList = (AttList)pDFFormField.a.clone();
        attList.put(Attn.$text, pDFFormField.a.get(Attn.$text));
        attList.put(Attn.$initially_selected, Attr.trueval);
        Item.PDFFormFieldOption pDFFormFieldOption = new Item.PDFFormFieldOption(attList, this.session);
        pDFFormFieldOption.parentbpb = pDFFormField.parentbpb;
        this.processPDFFormFieldOption(pDFFormFieldOption, string, "center", bl, true, false);
    }

    private void processPDFFormFieldAppearance(Item.PDFFormField pDFFormField) {
        this.forceEmitColor = true;
        this.processPDFFormFieldBackground(pDFFormField);
        this.processPDFFormFieldBorder(pDFFormField);
    }

    private void processPDFFormFieldBackground(Item.PDFFormField pDFFormField) {
        Area area = this.makeArea(pDFFormField.parentbpb);
        Attr.Color color = (Attr.Color)pDFFormField.a.get(Attn.$background_color);
        if (color != Attr.Color.transparent) {
            this.processColor((Attr.Color.Opaque)color);
            try {
                this.attrs.clear();
                this.addAttribute("x-from", "CDATA", "0");
                this.addAttribute("y-from", "CDATA", "0");
                this.addAttribute("x-till", "CDATA", Integer.toString(area.r[0][2] - area.r[0][0]));
                this.addAttribute("y-till", "CDATA", Integer.toString(area.r[0][3] - area.r[0][1]));
                this.startElement("rectangle", this.attrs);
                this.endElement("rectangle");
            }
            catch (SAXException sAXException) {
                throw new InternalException(sAXException.getMessage());
            }
        }
    }

    private void processPDFFormFieldBorder(Item.PDFFormField pDFFormField) {
        Area area = this.makeArea(pDFFormField.parentbpb);
        int n = pDFFormField.a.get(Attn.oldName("border-start-width.length")).length();
        if (Util.eq0(n)) {
            return;
        }
        Attr attr = pDFFormField.a.get(Attn.oldName("border-start-color"));
        if (attr == Attr.Color.transparent) {
            return;
        }
        if (!(attr instanceof Attr.Color.Opaque)) {
            this.session.error("invalid border-start-color: " + attr);
            return;
        }
        Attr.Color.Opaque opaque = (Attr.Color.Opaque)attr;
        Attr attr2 = pDFFormField.a.get(Attn.oldName("border-start-style"));
        Short s = (Short)styles.get(attr2);
        short s2 = 0;
        if (s == null) {
            this.session.error("invalid border-start-style: " + attr2);
            attr2 = Attr.newWord("solid");
        } else {
            s2 = s;
        }
        int n2 = area.r[0][2] - area.r[0][0] + 2 * n;
        int n3 = area.r[0][3] - area.r[0][1] + 2 * n;
        switch (s2) {
            case -2: 
            case -1: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                this.drawLine(opaque, attr2.word(), n, n / 2, n3 - n / 2, n2 - n / 2, n3 - n / 2);
                this.drawLine(opaque, attr2.word(), n, n / 2, n / 2, n2 - n / 2, n / 2);
                this.drawLine(opaque, attr2.word(), n, n / 2, n / 2, n / 2, n3 - n / 2);
                this.drawLine(opaque, attr2.word(), n, n2 - n / 2, n / 2, n2 - n / 2, n3 - n / 2);
                break;
            }
            default: {
                throw new RuntimeException("Internal error: bad value for style switch: " + s2);
            }
        }
    }

    private void processPDFFormFieldText(Item.PDFFormFieldOption pDFFormFieldOption, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        Item.Text text;
        this.forceEmitColor = true;
        this.forceEmitFont = true;
        Area area = null;
        int n = 0;
        int n2 = 0;
        if (bl2) {
            area = this.makeArea(pDFFormFieldOption.parentbpb);
            n = area.r[2][3] - area.r[2][1];
            n2 = n - pDFFormFieldOption.tt.line_height - pDFFormFieldOption.tt.min_descender;
        } else {
            n2 = -pDFFormFieldOption.tt.line_height;
        }
        if ("center".equals(string2)) {
            n2 += n2 / 2;
        }
        if (bl) {
            n2 = n - pDFFormFieldOption.tt.line_height;
        }
        this.y += n2;
        this.x = 0;
        if (bl3 && pDFFormFieldOption.a.get(Attn.$initially_selected).bool() && area == null) {
            area = this.makeArea(pDFFormFieldOption.parentbpb);
        }
        Item.Text text2 = text = pDFFormFieldOption.a.containsKey(Attn.$text) ? new Item.Text(pDFFormFieldOption.a.get(Attn.$text).word(), pDFFormFieldOption.a, this.session) : new Item.Text("", pDFFormFieldOption.a, this.session);
        if ("center".equals(string)) {
            this.x += (area.r[2][2] - area.r[2][0] - text.width) / 2;
        }
        if (bl) {
            StringTokenizer stringTokenizer = new StringTokenizer(text.a.get(Attn.$text).word(), "\n\r", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if ("\n".equals(string3) || "\r".equals(string3)) {
                    this.x = 0;
                    this.y -= pDFFormFieldOption.tt.line_height;
                    continue;
                }
                this.process(new Item.Text(string3, pDFFormFieldOption.a, this.session));
            }
        } else {
            this.process(text);
        }
    }

    private void addAccessibilityProperties(Xattr xattr) {
        if (this.session.config.ENABLE_ACCESSIBILITY) {
            if (xattr.containsKey(Attn.$xpath)) {
                this.addAttribute("xpath", "CDATA", xattr.get(Attn.$xpath).word());
            }
            if (xattr.containsKey(Attn.$pdf_structure_tag)) {
                this.addAttribute("pdf-structure-tag", "CDATA", xattr.get(Attn.$pdf_structure_tag).word());
            }
            if (xattr.containsKey(Attn.$role_mapping)) {
                this.addAttribute("role-mapping", "CDATA", xattr.get(Attn.$role_mapping).word());
            }
            if (xattr.containsKey(Attn.$pdf_artifact_type)) {
                this.addAttribute("pdf-artifact-type", "CDATA", xattr.get(Attn.$pdf_artifact_type).word());
            }
            if (xattr.containsKey(Attn.$pdf_artifact_subtype)) {
                this.addAttribute("pdf-artifact-subtype", "CDATA", xattr.get(Attn.$pdf_artifact_subtype).word());
            }
            if (xattr.containsKey(Attn.$alt_description)) {
                this.addAttribute("alt-description", "CDATA", xattr.get(Attn.$alt_description).word());
            }
            if (xattr.containsKey(Attn.$actual_text)) {
                this.addAttribute("actual-text", "CDATA", xattr.get(Attn.$actual_text).word());
            }
            if (xattr.containsKey(Attn.$abbreviation)) {
                this.addAttribute("abbreviation", "CDATA", xattr.get(Attn.$abbreviation).word());
            }
            this.addAttribute("role", "CDATA", xattr.get(Attn.$role).word());
        }
    }

    static {
        styles.put(Attr.none, new Short(-2));
        styles.put(Attr.newWord("hidden"), new Short(-1));
        styles.put(Attr.newWord("solid"), new Short(0));
        styles.put(Attr.newWord("dotted"), new Short(1));
        styles.put(Attr.newWord("dashed"), new Short(2));
        styles.put(Attr.newWord("double"), new Short(3));
        styles.put(Attr.newWord("ridge"), new Short(4));
        styles.put(Attr.newWord("groove"), new Short(5));
        styles.put(Attr.newWord("outset"), new Short(6));
        styles.put(Attr.newWord("inset"), new Short(7));
        cbPlacement = new Hashtable();
        cbPlacement.put(Attr.newWord("start"), new Short(0));
        cbPlacement.put(Attr.newWord("end"), new Short(1));
        cbPlacement.put(Attr.newWord("left"), new Short(2));
        cbPlacement.put(Attr.newWord("right"), new Short(3));
        cbPlacement.put(Attr.newWord("inside"), new Short(4));
        cbPlacement.put(Attr.newWord("outside"), new Short(5));
        cbPlacement.put(Attr.newWord("alternate"), new Short(6));
        affinm = new int[][][]{new int[][]{{1, 0}, {0, 1}}, new int[][]{{0, -1}, {1, 0}}, new int[][]{{-1, 0}, {0, -1}}, new int[][]{{0, 1}, {-1, 0}}};
        unitvec_x = new int[]{1, 1, -1, -1};
    }

    private class CBProcessor {
        BodyRegion region;
        int zindex;
        SSorter ssorter = new SSorter();
        private List starts;
        private List transits;
        private List ends;
        private List drawings = new List();

        CBProcessor(BodyRegion bodyRegion, int n) {
            this.region = bodyRegion;
            this.zindex = n;
            this.starts = bodyRegion.starts;
            this.transits = bodyRegion.transits;
            this.ends = bodyRegion.ends;
        }

        List processBars() {
            this.starts = Sort.sort(SAX.this.zfilter(this.starts, this.zindex), (Sort.Cmp)this.ssorter);
            this.transits = Sort.sort(SAX.this.zfilter(this.transits, this.zindex), (Sort.Cmp)this.ssorter);
            this.ends = SAX.this.zfilter(this.ends, this.zindex);
            this.makeCBs(false);
            this.makeCBs(true);
            if (this.ends.isPair()) {
                throw new InternalException("ending changebar that's not started, icb:" + (Item.ChangeBar)this.ends.car() + ";br=" + this.region);
            }
            return this.drawings;
        }

        void makeCBs(boolean bl) {
            List list = bl ? this.starts : this.transits;
            Enumeration enumeration = list.elements();
            while (enumeration.hasMoreElements()) {
                Item.ChangeBarPoint changeBarPoint;
                Item.ChangeBar changeBar = (Item.ChangeBar)enumeration.nextElement();
                CB cB = new CB(changeBar);
                if (bl) {
                    try {
                        changeBarPoint = changeBar.getMatchingPoint(this.region);
                        cB.start_y = changeBarPoint.y;
                        cB.start_x = changeBarPoint.x;
                    }
                    catch (InternalException internalException) {
                        SAX.this.session.error(internalException.getMessage());
                    }
                }
                if (this.ends.isPair() && this.ends.contains(changeBar.pair)) {
                    this.ends = this.ends.remove(changeBar.pair);
                    try {
                        changeBarPoint = changeBar.pair.getMatchingPoint(this.region);
                        cB.end_y = changeBarPoint.y;
                        cB.end_x = changeBarPoint.x;
                    }
                    catch (InternalException internalException) {
                        SAX.this.session.error(internalException.getMessage());
                    }
                }
                this.drawings.snoc(cB);
            }
        }
    }

    private static class SSorter
    implements Sort.Cmp {
        private SSorter() {
        }

        public int cmp(Object object, Object object2) {
            int n;
            int n2 = object instanceof BodyRegion ? ((BodyRegion)object).serial : ((Item.ChangeBar)object).serial;
            int n3 = n = object2 instanceof BodyRegion ? ((BodyRegion)object2).serial : ((Item.ChangeBar)object2).serial;
            return n2 < n ? -1 : (n2 > n ? 1 : 0);
        }
    }

    private static class CB {
        final Item.ChangeBar icb;
        int start_x = Integer.MIN_VALUE;
        int start_y = Integer.MIN_VALUE;
        int end_x = Integer.MIN_VALUE;
        int end_y = Integer.MIN_VALUE;

        CB(Item.ChangeBar changeBar) {
            this.icb = changeBar;
        }

        public String toString() {
            return "class=" + this.icb.cbclass + ",start_x=" + this.start_x + ",start_y=" + this.start_y + ",end_x=" + this.end_x + ",end_y=" + this.end_y + ",z-index=" + this.icb.a.get(Attn.$z_index).count();
        }
    }

    private class TableGrid {
        private static final int HORIZONTAL = 0;
        private static final int VERTICAL = 1;
        Vertex start = null;

        private TableGrid() {
        }

        public void add(BPB bPB) {
            Attr attr = bPB.get(Attn.$table_element_class);
            Area area = SAX.this.makeArea(bPB);
            int n = 0;
            while (n != EDGES.length) {
                String string = bPB.writing_mode == Attr.rl_tb ? EDGEIDSRL[n] : EDGEIDSLR[n];
                Chunk chunk = new Chunk();
                chunk.element_class = attr;
                chunk.thickness = bPB.get(Attn.oldName("border-" + string + "-width.collapsed")).length();
                chunk.color = (Attr.Color)bPB.get(Attn.oldName("border-" + string + "-color"));
                if (!(chunk.color instanceof Attr.Color)) {
                    SAX.this.session.error("invalid border-" + string + "-color: " + chunk.color);
                    chunk.color = Attr.Color.transparent;
                }
                ((Attr.Color)chunk.color).overprint = bPB.get(Attn.$overprint_flag).bool();
                chunk.style = bPB.get(Attn.oldName("border-" + string + "-style"));
                Short s = (Short)styles.get(chunk.style);
                if (s == null) {
                    SAX.this.session.error("invalid border-" + string + "-style: " + chunk.style);
                    chunk.style = Attr.Word.create("solid");
                } else if (s == -2 || s == -1) {
                    chunk.thickness = 0;
                }
                chunk.precedence = bPB.get(Attn.oldName("border-" + string + "-precedence"));
                short[][] sArray = EDGES[n];
                Vertex vertex = null;
                Vertex vertex2 = null;
                if (attr == Attr.Word.create("table")) {
                    vertex = this.getVertex(area.r[1][sArray[0][1]], area.r[1][sArray[1][1]]);
                    vertex2 = this.getVertex(area.r[1][sArray[2][1]], area.r[1][sArray[3][1]]);
                } else {
                    vertex = this.getVertex(area.r[0][sArray[0][1]], area.r[0][sArray[1][1]]);
                    vertex2 = this.getVertex(area.r[0][sArray[2][1]], area.r[0][sArray[3][1]]);
                }
                if (chunk.color != Attr.Color.transparent && (chunk.style == Attr.Word.create("inset") || chunk.style == Attr.Word.create("outset"))) {
                    switch (SOLIDEDGECOLORS[s][n]) {
                        case 3: {
                            chunk.color = Attr.Color.transparent;
                        }
                        case 2: {
                            chunk.color = ((Attr.Color.Opaque)chunk.color).darkerColor();
                            break;
                        }
                        case 1: {
                            chunk.color = ((Attr.Color.Opaque)chunk.color).lighterColor();
                        }
                    }
                }
                if (vertex.x == vertex2.x) {
                    this.tracePath(vertex, vertex2, chunk, 1);
                } else if (vertex.y == vertex2.y) {
                    this.tracePath(vertex, vertex2, chunk, 0);
                } else {
                    throw new RuntimeException("Table border is neither horizontal nor vertical");
                }
                ++n;
            }
        }

        Vertex getVertex(int n, int n2) {
            Vertex vertex;
            Vertex vertex2;
            if (this.start == null) {
                this.start = new Vertex(n, n2);
                return this.start;
            }
            Vertex vertex3 = null;
            vertex3 = this.start;
            while (vertex3 != null) {
                if (Util.eq0(n - vertex3.x)) break;
                if (vertex3.x > n) {
                    vertex2 = null;
                    vertex = vertex3;
                    while (vertex != null) {
                        vertex2 = new Vertex(n, vertex.y, vertex.prev[0], vertex, vertex2, null);
                        vertex = vertex.next[1];
                    }
                    if (this.start.prev[0] == null) break;
                    this.start = this.start.prev[0];
                    break;
                }
                if (vertex3.next[0] == null) {
                    vertex2 = null;
                    vertex = vertex3;
                    while (vertex != null) {
                        vertex2 = new Vertex(n, vertex.y, vertex, null, vertex2, null);
                        vertex = vertex.next[1];
                    }
                    break;
                }
                vertex3 = vertex3.next[0];
            }
            vertex3 = this.start;
            while (vertex3 != null) {
                if (Util.eq0(n2 - vertex3.y)) break;
                if (vertex3.y > n2) {
                    vertex2 = null;
                    vertex = vertex3;
                    while (vertex != null) {
                        vertex2 = new Vertex(vertex.x, n2, vertex2, null, vertex.prev[1], vertex);
                        vertex = vertex.next[0];
                    }
                    if (this.start.prev[1] == null) break;
                    this.start = this.start.prev[1];
                    break;
                }
                if (vertex3.next[1] == null) {
                    vertex2 = null;
                    vertex = vertex3;
                    while (vertex != null) {
                        vertex2 = new Vertex(vertex.x, n2, vertex2, null, vertex, null);
                        vertex = vertex.next[0];
                    }
                    break;
                }
                vertex3 = vertex3.next[1];
            }
            vertex3 = this.start;
            while (Util.ne0(n - vertex3.x)) {
                vertex3 = vertex3.next[0];
            }
            while (Util.ne0(n2 - vertex3.y)) {
                vertex3 = vertex3.next[1];
            }
            return vertex3;
        }

        void tracePath(Vertex vertex, Vertex vertex2, Chunk chunk, int n) {
            if (vertex.x > vertex2.x || vertex.y > vertex2.y) {
                this.tracePath(vertex2, vertex, chunk, n);
                return;
            }
            Vertex vertex3 = vertex;
            while (vertex3.x != vertex2.x || vertex3.y != vertex2.y) {
                Vertex vertex4 = vertex3.next[n];
                if (vertex4 == null) {
                    throw new RuntimeException("Bad grid structure: cannot trace from [" + vertex.x + "," + vertex.y + "] to [" + vertex2.x + "," + vertex2.y + "] along axis #" + n);
                }
                if (chunk.compare(vertex3.nextLine[n]) >= 0) {
                    vertex3.nextLine[n] = vertex4.prevLine[n] = chunk;
                }
                vertex3 = vertex3.next[n];
            }
        }

        public void draw() {
            this.draw(1, 0);
            this.draw(0, 1);
        }

        private void draw(int n, int n2) {
            Vertex vertex = this.start;
            while (vertex != null) {
                Vertex vertex2 = vertex;
                while (vertex2 != null) {
                    Chunk chunk = vertex2.nextLine[n2];
                    if (chunk == null) {
                        vertex2 = vertex2.next[n2];
                        continue;
                    }
                    Vertex vertex3 = vertex2.next[n2];
                    while (chunk.sameLine(vertex3.nextLine[n2]) && (vertex3.nextLine[n] == null || vertex3.nextLine[n].isInvisible()) && (vertex3.prevLine[n] == null || vertex3.prevLine[n].isInvisible())) {
                        vertex3 = vertex3.next[n2];
                    }
                    chunk.draw(vertex2, vertex3);
                    vertex2 = vertex3;
                }
                vertex = vertex.next[n];
            }
        }

        private class Chunk {
            Attr color;
            Attr style;
            int thickness;
            Attr precedence;
            Attr element_class;

            private Chunk() {
            }

            public boolean sameLine(Chunk chunk) {
                if (chunk == null) {
                    return false;
                }
                return this.color == chunk.color && this.style == chunk.style && this.thickness == chunk.thickness;
            }

            public boolean isInvisible() {
                return this.thickness == 0 || this.color == Attr.Color.transparent || this.style == Attr.hidden || this.style == Attr.none;
            }

            public int compare(Chunk chunk) {
                if (chunk == null) {
                    return 1;
                }
                int n = 0;
                n = BorderComparator.comparePrecedence(this.precedence, chunk.precedence);
                if (n != 0) {
                    return n;
                }
                if (this.style == Attr.hidden && chunk.style != Attr.hidden) {
                    return 1;
                }
                if (this.style != Attr.hidden && chunk.style == Attr.hidden) {
                    return -1;
                }
                if (this.style == Attr.none && chunk.style != Attr.none) {
                    return -1;
                }
                if (this.style != Attr.none && chunk.style == Attr.none) {
                    return 1;
                }
                if (this.thickness != chunk.thickness) {
                    return this.thickness - chunk.thickness;
                }
                n = BorderComparator.compareStyle(this.style, chunk.style);
                if (n != 0) {
                    return n;
                }
                n = BorderComparator.compareElementClass(this.element_class, chunk.element_class);
                return n;
            }

            public void draw(Vertex vertex, Vertex vertex2) {
                if (this.isInvisible()) {
                    return;
                }
                Attr.Color.Opaque opaque = (Attr.Color.Opaque)this.color;
                short s = (Short)styles.get(this.style);
                switch (s) {
                    case -2: 
                    case -1: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        SAX.this.drawLine(opaque, this.style.word(), this.thickness, vertex.x, vertex.y, vertex2.x, vertex2.y);
                        break;
                    }
                    case 0: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (vertex.y == vertex2.y) {
                            this.drawHorizontal(s, vertex, vertex2);
                            break;
                        }
                        if (vertex.x == vertex2.x) {
                            this.drawVertical(s, vertex, vertex2);
                            break;
                        }
                        throw new RuntimeException("Line in the table grid neither vertical nor horizontal");
                    }
                    default: {
                        throw new RuntimeException("Internal error: invalid rule style index " + s);
                    }
                }
            }

            private void drawHorizontal(int n, Vertex vertex, Vertex vertex2) {
                Attr.Color.Opaque opaque = (Attr.Color.Opaque)this.color;
                int n2 = vertex.y;
                int n3 = vertex.y + this.thickness / 2;
                int n4 = vertex.y - this.thickness / 2;
                int n5 = vertex.x;
                int n6 = vertex2.x;
                int n7 = vertex.x;
                int n8 = vertex2.x;
                int n9 = vertex.x;
                int n10 = vertex2.x;
                Chunk chunk = vertex.nextLine[1];
                Chunk chunk2 = vertex.prevLine[1];
                Chunk chunk3 = vertex.prevLine[0];
                Chunk chunk4 = vertex2.nextLine[1];
                Chunk chunk5 = vertex2.prevLine[1];
                Chunk chunk6 = vertex2.nextLine[0];
                if (chunk != null && chunk.isInvisible()) {
                    chunk = null;
                }
                if (chunk2 != null && chunk2.isInvisible()) {
                    chunk2 = null;
                }
                if (chunk3 != null && chunk3.isInvisible()) {
                    chunk3 = null;
                }
                if (chunk4 != null && chunk4.isInvisible()) {
                    chunk4 = null;
                }
                if (chunk5 != null && chunk5.isInvisible()) {
                    chunk5 = null;
                }
                if (chunk6 != null && chunk6.isInvisible()) {
                    chunk6 = null;
                }
                if (chunk != null) {
                    n7 += chunk.thickness / 2;
                    if (chunk2 == null && chunk3 == null) {
                        n9 -= chunk.thickness / 2;
                    }
                }
                if (chunk2 != null) {
                    n9 += chunk2.thickness / 2;
                    if (chunk == null && chunk3 == null) {
                        n7 -= chunk2.thickness / 2;
                    }
                }
                if (chunk4 != null) {
                    n8 -= chunk4.thickness / 2;
                    if (chunk5 == null && chunk6 == null) {
                        n10 += chunk4.thickness / 2;
                    }
                }
                if (chunk5 != null) {
                    n10 -= chunk5.thickness / 2;
                    if (chunk4 == null && chunk6 == null) {
                        n8 += chunk5.thickness / 2;
                    }
                }
                switch (n) {
                    case 0: 
                    case 6: 
                    case 7: {
                        SAX.this.drawHexagon(opaque, n5, n2, n7, n3, n8, n3, n6, n2, n10, n4, n9, n4);
                        break;
                    }
                    case 3: {
                        SAX.this.drawTetragon(opaque, n7, n3, n8, n3, (2 * n6 + n8) / 3, (2 * n2 + n3) / 3, (2 * n5 + n7) / 3, (2 * n2 + n3) / 3);
                        SAX.this.drawTetragon(opaque, n9, n4, n10, n4, (2 * n6 + n10) / 3, (2 * n2 + n4) / 3, (2 * n5 + n9) / 3, (2 * n2 + n4) / 3);
                        break;
                    }
                    case 5: {
                        SAX.this.drawTetragon(opaque.darkerColor(), n7, n3, n8, n3, (n6 + n8) / 2, (n2 + n3) / 2, (n5 + n7) / 2, (n2 + n3) / 2);
                        SAX.this.drawHexagon(opaque, n5, n2, (n5 + n7) / 2, (n2 + n3) / 2, (n6 + n8) / 2, (n2 + n3) / 2, n6, n2, (n6 + n10) / 2, (n2 + n4) / 2, (n5 + n9) / 2, (n2 + n4) / 2);
                        SAX.this.drawTetragon(opaque.lighterColor(), n9, n4, n10, n4, (n6 + n10) / 2, (n2 + n4) / 2, (n5 + n9) / 2, (n2 + n4) / 2);
                        break;
                    }
                    case 4: {
                        SAX.this.drawTetragon(opaque.lighterColor(), n7, n3, n8, n3, (n6 + n8) / 2, (n2 + n3) / 2, (n5 + n7) / 2, (n2 + n3) / 2);
                        SAX.this.drawHexagon(opaque, n5, n2, (n5 + n7) / 2, (n2 + n3) / 2, (n6 + n8) / 2, (n2 + n3) / 2, n6, n2, (n6 + n10) / 2, (n2 + n4) / 2, (n5 + n9) / 2, (n2 + n4) / 2);
                        SAX.this.drawTetragon(opaque.darkerColor(), n9, n4, n10, n4, (n6 + n10) / 2, (n2 + n4) / 2, (n5 + n9) / 2, (n2 + n4) / 2);
                    }
                }
            }

            private void drawVertical(int n, Vertex vertex, Vertex vertex2) {
                Attr.Color.Opaque opaque = (Attr.Color.Opaque)this.color;
                int n2 = vertex.x;
                int n3 = vertex.x + this.thickness / 2;
                int n4 = vertex.x - this.thickness / 2;
                int n5 = vertex.y;
                int n6 = vertex2.y;
                int n7 = vertex.y;
                int n8 = vertex2.y;
                int n9 = vertex.y;
                int n10 = vertex2.y;
                Chunk chunk = vertex.nextLine[0];
                Chunk chunk2 = vertex.prevLine[0];
                Chunk chunk3 = vertex.prevLine[1];
                Chunk chunk4 = vertex2.nextLine[0];
                Chunk chunk5 = vertex2.prevLine[0];
                Chunk chunk6 = vertex2.nextLine[1];
                if (chunk != null && chunk.isInvisible()) {
                    chunk = null;
                }
                if (chunk2 != null && chunk2.isInvisible()) {
                    chunk2 = null;
                }
                if (chunk3 != null && chunk3.isInvisible()) {
                    chunk3 = null;
                }
                if (chunk4 != null && chunk4.isInvisible()) {
                    chunk4 = null;
                }
                if (chunk5 != null && chunk5.isInvisible()) {
                    chunk5 = null;
                }
                if (chunk6 != null && chunk6.isInvisible()) {
                    chunk6 = null;
                }
                if (chunk != null) {
                    n7 += chunk.thickness / 2;
                    if (chunk2 == null && chunk3 == null) {
                        n9 -= chunk.thickness / 2;
                    }
                }
                if (chunk2 != null) {
                    n9 += chunk2.thickness / 2;
                    if (chunk == null && chunk3 == null) {
                        n7 -= chunk2.thickness / 2;
                    }
                }
                if (chunk4 != null) {
                    n8 -= chunk4.thickness / 2;
                    if (chunk5 == null && chunk6 == null) {
                        n10 += chunk4.thickness / 2;
                    }
                }
                if (chunk5 != null) {
                    n10 -= chunk5.thickness / 2;
                    if (chunk4 == null && chunk6 == null) {
                        n8 += chunk5.thickness / 2;
                    }
                }
                switch (n) {
                    case 0: 
                    case 6: 
                    case 7: {
                        SAX.this.drawHexagon(opaque, n2, n5, n3, n7, n3, n8, n2, n6, n4, n10, n4, n9);
                        break;
                    }
                    case 3: {
                        SAX.this.drawTetragon(opaque, n3, n7, n3, n8, (2 * n2 + n3) / 3, (2 * n6 + n8) / 3, (2 * n2 + n3) / 3, (2 * n5 + n7) / 3);
                        SAX.this.drawTetragon(opaque, n4, n9, n4, n10, (2 * n2 + n4) / 3, (2 * n6 + n10) / 3, (2 * n2 + n4) / 3, (2 * n5 + n9) / 3);
                        break;
                    }
                    case 5: {
                        SAX.this.drawTetragon(opaque.lighterColor(), n3, n7, n3, n8, (n2 + n3) / 2, (n6 + n8) / 2, (n2 + n3) / 2, (n5 + n7) / 2);
                        SAX.this.drawHexagon(opaque, n2, n5, (n2 + n3) / 2, (n5 + n7) / 2, (n2 + n3) / 2, (n6 + n8) / 2, n2, n6, (n2 + n4) / 2, (n6 + n10) / 2, (n2 + n4) / 2, (n5 + n9) / 2);
                        SAX.this.drawTetragon(opaque.darkerColor(), n4, n9, n4, n10, (n2 + n4) / 2, (n6 + n10) / 2, (n2 + n4) / 2, (n5 + n9) / 2);
                        break;
                    }
                    case 4: {
                        SAX.this.drawTetragon(opaque.darkerColor(), n3, n7, n3, n8, (n2 + n3) / 2, (n6 + n8) / 2, (n2 + n3) / 2, (n5 + n7) / 2);
                        SAX.this.drawHexagon(opaque, n2, n5, (n2 + n3) / 2, (n5 + n7) / 2, (n2 + n3) / 2, (n6 + n8) / 2, n2, n6, (n2 + n4) / 2, (n6 + n10) / 2, (n2 + n4) / 2, (n5 + n9) / 2);
                        SAX.this.drawTetragon(opaque.lighterColor(), n4, n9, n4, n10, (n2 + n4) / 2, (n6 + n10) / 2, (n2 + n4) / 2, (n5 + n9) / 2);
                    }
                }
            }
        }

        private class Vertex {
            public final int x;
            public final int y;
            public final Chunk[] prevLine = new Chunk[]{null, null};
            public final Chunk[] nextLine = new Chunk[]{null, null};
            public final Vertex[] prev = new Vertex[]{null, null};
            public final Vertex[] next = new Vertex[]{null, null};

            public Vertex(int n, int n2) {
                this.x = n;
                this.y = n2;
            }

            public Vertex(int n, int n2, Vertex vertex, Vertex vertex2, Vertex vertex3, Vertex vertex4) {
                this(n, n2);
                this.linkThrough(vertex, vertex2, 0);
                this.linkThrough(vertex3, vertex4, 1);
            }

            private void linkThrough(Vertex vertex, Vertex vertex2, int n) {
                this.next[n] = vertex2;
                if (vertex2 != null) {
                    vertex2.prev[n] = this;
                    this.nextLine[n] = vertex2.prevLine[n];
                }
                this.prev[n] = vertex;
                if (vertex != null) {
                    vertex.next[n] = this;
                    this.prevLine[n] = vertex.nextLine[n];
                }
            }
        }
    }

    private class TableData {
        private final boolean separateBorders;
        private final List areas = new List();

        TableData(boolean bl) {
            this.separateBorders = bl;
        }

        void add(BPB bPB) {
            this.areas.snoc(bPB);
        }

        void draw() {
            Enumeration enumeration = this.areas.elements();
            while (enumeration.hasMoreElements()) {
                SAX.this.processBackground((BPB)enumeration.nextElement());
            }
            if (this.separateBorders) {
                enumeration = this.areas.elements();
                while (enumeration.hasMoreElements()) {
                    SAX.this.processBorder((BPB)enumeration.nextElement());
                }
            } else {
                TableGrid tableGrid = new TableGrid();
                enumeration = this.areas.elements();
                while (enumeration.hasMoreElements()) {
                    tableGrid.add((BPB)enumeration.nextElement());
                }
                tableGrid.draw();
            }
        }
    }
}

