/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.ICCProfileFormatException;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.SeekableInput;
import java.io.IOException;
import java.util.Enumeration;

public class ICCProfile {
    private static final List profileClasses = new List().append("scnr").append("mntr").append("prtr").append("link").append("spac").append("abst").append("nmcl");
    private static final short CS_XYZ = 1;
    private static final short CS_LAB = 2;
    private static final short CS_LUV = 3;
    private static final short CS_YCBCR = 4;
    private static final short CS_YXY = 5;
    private static final short CS_RGB = 6;
    private static final short CS_GRAY = 7;
    private static final short CS_HSV = 8;
    private static final short CS_HLS = 9;
    private static final short CS_CMYK = 10;
    private static final short CS_CMY = 11;
    private static final short CS_2CLR = 12;
    private static final short CS_3CLR = 13;
    private static final short CS_4CLR = 14;
    private static final short CS_5CLR = 15;
    private static final short CS_6CLR = 16;
    private static final short CS_7CLR = 17;
    private static final short CS_8CLR = 18;
    private static final short CS_9CLR = 19;
    private static final short CS_10CLR = 20;
    private static final short CS_11CLR = 21;
    private static final short CS_12CLR = 22;
    private static final short CS_13CLR = 23;
    private static final short CS_14CLR = 24;
    private static final short CS_15CLR = 25;
    private static final Hashtable cstab = new Hashtable();
    public short colorSpace = 0;

    public ICCProfile(SeekableInput seekableInput) throws IOException, ICCProfileFormatException {
        seekableInput.skipBytes(12);
        byte[] byArray = new byte[4];
        seekableInput.readFully(byArray);
        String string = new String(byArray);
        boolean bl = false;
        Enumeration enumeration = profileClasses.elements();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().equals(string)) continue;
            bl = true;
        }
        if (!bl) {
            throw new ICCProfileFormatException("Not a ICC Profile file, or unsupported profile class: " + string);
        }
        seekableInput.readFully(byArray);
        String string2 = new String(byArray);
        short s = (Short)cstab.get(string2);
        switch (s) {
            case 7: {
                this.colorSpace = 1;
                break;
            }
            case 12: {
                this.colorSpace = (short)2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                this.colorSpace = (short)3;
                break;
            }
            case 10: 
            case 14: {
                this.colorSpace = (short)4;
                break;
            }
            case 15: {
                this.colorSpace = (short)5;
                break;
            }
            case 16: {
                this.colorSpace = (short)6;
                break;
            }
            case 17: {
                this.colorSpace = (short)7;
                break;
            }
            case 18: {
                this.colorSpace = (short)8;
                break;
            }
            case 19: {
                this.colorSpace = (short)9;
                break;
            }
            case 20: {
                this.colorSpace = (short)10;
                break;
            }
            case 21: {
                this.colorSpace = (short)11;
                break;
            }
            case 22: {
                this.colorSpace = (short)12;
                break;
            }
            case 23: {
                this.colorSpace = (short)13;
                break;
            }
            case 24: {
                this.colorSpace = (short)14;
                break;
            }
            case 25: {
                this.colorSpace = (short)15;
                break;
            }
            default: {
                throw new ICCProfileFormatException("Unsupported profile color space: " + string2);
            }
        }
    }

    static {
        cstab.put("XYZ ", new Short(1));
        cstab.put("Lab ", new Short(2));
        cstab.put("Luv ", new Short(3));
        cstab.put("YCbr", new Short(4));
        cstab.put("Yxy ", new Short(5));
        cstab.put("RGB ", new Short(6));
        cstab.put("GRAY", new Short(7));
        cstab.put("HSV ", new Short(8));
        cstab.put("HLS ", new Short(9));
        cstab.put("CMYK", new Short(10));
        cstab.put("CMY ", new Short(11));
        cstab.put("2CLR", new Short(12));
        cstab.put("3CLR", new Short(13));
        cstab.put("4CLR", new Short(14));
        cstab.put("5CLR", new Short(15));
        cstab.put("6CLR", new Short(16));
        cstab.put("7CLR", new Short(17));
        cstab.put("8CLR", new Short(18));
        cstab.put("9CLR", new Short(19));
        cstab.put("ACLR", new Short(20));
        cstab.put("BCLR", new Short(21));
        cstab.put("CCLR", new Short(22));
        cstab.put("DCLR", new Short(23));
        cstab.put("ECLR", new Short(24));
        cstab.put("FCLR", new Short(25));
    }
}

