/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

import com.renderx.fonts.AFMMetric;
import com.renderx.fonts.Encoding;
import com.renderx.fonts.FontRecord;
import com.renderx.fonts.Metric;
import com.renderx.fonts.UsedGlyphs;
import com.renderx.util.Array;
import com.renderx.util.Hashtable;

public class FontDescriptor {
    public final FontRecord record;
    public final UsedGlyphs used;
    public final Array encodingTable;
    public boolean canExtend = true;
    public boolean hasUnmappedChars = false;
    public boolean forceEmbedSuccess = true;
    private static final Hashtable enctab = new Hashtable();

    public FontDescriptor(FontRecord fontRecord, Array array, UsedGlyphs usedGlyphs) {
        this(fontRecord, array, usedGlyphs, false);
    }

    public FontDescriptor(FontRecord fontRecord, Array array, UsedGlyphs usedGlyphs, boolean bl) {
        this.record = fontRecord;
        fontRecord.getMetric();
        if (array != null) {
            this.encodingTable = array;
        } else {
            this.encodingTable = new Array();
            if (bl && !fontRecord.embed) {
                this.forceEmbed();
            }
            if (!fontRecord.embed && fontRecord.datatype == 2) {
                this.canExtend = false;
                short s = this.selectEncoding(fontRecord.initialencoding, (short)2);
                this.putEncoding(0, s);
            } else {
                short s = this.selectEncoding(fontRecord.initialencoding, (short)0);
                this.putEncoding(0, s);
            }
        }
        this.used = usedGlyphs != null ? usedGlyphs : new UsedGlyphs();
    }

    private void forceEmbed() {
        Metric metric = this.record.getMetric();
        if (!metric.embeddable()) {
            this.forceEmbedSuccess = false;
            this.record.error("Font '" + metric.fontName + "' cannot be embedded because of license restrictions.");
        } else if (this.record.fontfile == null) {
            this.forceEmbedSuccess = false;
            this.record.error("No outline file for font metric '" + this.record.metricfile + "'; font " + metric.fontName + " cannot be embedded.");
        } else {
            this.record.embed = true;
            this.record.warning("Fonts must be embedded with PDF/X and PDF/A; font '" + metric.fontName + "' will be embedded");
        }
    }

    private void fillEncoding(Encoding encoding, char[] cArray) {
        int n = 0;
        while (n < 256) {
            char c = cArray[n];
            encoding.assignCode(c, this.record.getMetric().ucm(c));
            ++n;
        }
    }

    private void putEncoding(int n, short s) {
        Encoding encoding = new Encoding();
        switch (s) {
            case 0: {
                this.fillEncoding(encoding, Encoding.LATIN1);
                break;
            }
            case 2: {
                this.fillEncoding(encoding, Encoding.WINANSI);
                break;
            }
            case 3: {
                this.fillEncoding(encoding, Encoding.MACROMAN);
                break;
            }
            case 4: {
                this.fillEncoding(encoding, Encoding.MACEXPERT);
                break;
            }
            case 1: {
                AFMMetric aFMMetric = (AFMMetric)this.record.getMetric();
                encoding = aFMMetric.builtinEncoding;
            }
        }
        encoding.encoding_type = s;
        this.encodingTable.put(n, encoding);
    }

    private short selectEncoding(String string, short s) {
        if (string == null) {
            return s;
        }
        Object object = enctab.get(string.trim().toUpperCase());
        if (object == null) {
            this.record.warning("Unrecognized 'intial-encoding' value '" + string + "' for '" + this.record.getMetric().fontName + "' font; setting ignored");
            return s;
        }
        return (Short)object;
    }

    static {
        enctab.put("CUSTOM", new Short(0));
        enctab.put("STANDARD", new Short(1));
        enctab.put("ANSI", new Short(2));
        enctab.put("ROMAN", new Short(3));
        enctab.put("EXPERT", new Short(4));
    }
}

