/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.FontFileFormatError;
import com.renderx.fonts.KernVector;
import com.renderx.fonts.Metric;
import com.renderx.fonts.afp.CodePage;
import com.renderx.fonts.afp.FontCharacterSet;
import com.renderx.fonts.afp.FontIndexData;
import com.renderx.fonts.afp.FontOrientationData;
import com.renderx.fonts.afp.FontPositionData;
import com.renderx.fonts.afp.FontResourceObject;
import com.renderx.util.UnicodeTable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;

public class AFPMetric
extends Metric {
    public float ITALIC_ANGLE = 17.5f;
    public String codepageName;
    public String charsetName;
    public int wordSpacing;
    public String encoding;

    public AFPMetric(InputStream inputStream, InputStream inputStream2, String string, String string2, String string3) throws IOException, FontFileFormatError {
        this.codepageName = string3;
        this.charsetName = string2;
        this.encoding = string;
        this.isAFP = true;
        FontCharacterSet fontCharacterSet = new FontCharacterSet();
        if (string != null) {
            fontCharacterSet.setEncoding(string);
        }
        fontCharacterSet.load(inputStream);
        CodePage codePage = new CodePage();
        if (string != null) {
            codePage.setEncoding(string);
        }
        codePage.load(inputStream2);
        this.fontName = fontCharacterSet.getName();
        this.fullName = fontCharacterSet.getTypefaceDescription();
        this.family = fontCharacterSet.getTypefaceDescription();
        this.weight = fontCharacterSet.getWeightClassName();
        boolean bl = FontResourceObject.byteToBits(fontCharacterSet.getDesignFlags())[0];
        this.italicAngle = bl ? -this.ITALIC_ANGLE : 0.0f;
        this.fontBBox = new float[]{0.0f, 0.0f, FontResourceObject.bytesToScaledSize(fontCharacterSet.getMaxCharacterBoxWidth()), FontResourceObject.bytesToScaledSize(fontCharacterSet.getMaxCharacterBoxHeight())};
        HashMap hashMap = fontCharacterSet.getFontOrientations();
        if (hashMap != null) {
            Object object;
            FontOrientationData fontOrientationData = (FontOrientationData)hashMap.get(new Short(0));
            this.wordSpacing = FontResourceObject.bytesToScaledSize(fontOrientationData.getSpaceCharacterIncrement());
            if (fontOrientationData != null) {
                int n;
                object = fontOrientationData.getFontIndex();
                this.numGlyphs = n = ((ArrayList)object).size();
                this.isFixedPitch = FontResourceObject.byteToBits(fontOrientationData.getControlFlags())[7];
                boolean bl2 = true;
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    FontIndexData fontIndexData = (FontIndexData)((ArrayList)object).get(n3);
                    if (bl2) {
                        if (n3 == 0) {
                            n2 = FontResourceObject.bytesToScaledSize(fontIndexData.getCharacterIncrement());
                        } else if (n2 != FontResourceObject.bytesToScaledSize(fontIndexData.getCharacterIncrement())) {
                            bl2 = false;
                        }
                    }
                    this.putGlyphMetrics(fontIndexData, codePage);
                    ++n3;
                }
                boolean bl3 = this.isFixedPitch = this.isFixedPitch || bl2;
            }
            if ((object = fontOrientationData.getFontPositionData()) != null) {
                this.underlineThickness = FontResourceObject.bytesToScaledSize(((FontPositionData)object).getUnderscoreWidth());
                this.underlinePosition = FontResourceObject.bytesToScaledSize(((FontPositionData)object).getUnderscorePosition());
                if (this.underlinePosition >= 0.0f) {
                    this.underlinePosition += this.underlineThickness / 2.0f;
                }
                this.capHeight = FontResourceObject.bytesToInt(((FontPositionData)object).getCapMHeight());
                this.xHeight = FontResourceObject.bytesToScaledSize(((FontPositionData)object).getLowercaseHeight());
                this.ascender = FontResourceObject.bytesToScaledSize(((FontPositionData)object).getMaximumAscender());
                this.descender = FontResourceObject.bytesToScaledSize(((FontPositionData)object).getMaximumDescender());
                this.wx = FontResourceObject.bytesToScaledSize(fontOrientationData.getMaxCharacterIncrement());
                this.wy = FontResourceObject.bytesToScaledSize(fontOrientationData.getMaxBaselineExtent());
                this.stdHW = this.wx;
                this.stdVW = this.wy;
            }
        }
        this.missingGlyph = this.ucm(' ');
        fontCharacterSet = null;
        codePage = null;
    }

    private void putGlyphMetrics(FontIndexData fontIndexData, CodePage codePage) {
        char[] cArray = codePage.getCharactersByGcgid(fontIndexData.getCharacterGlobalID());
        if (cArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < cArray.length) {
            CharMetrics charMetrics = new CharMetrics();
            charMetrics.wx = FontResourceObject.bytesToScaledSize(fontIndexData.getCharacterIncrement());
            charMetrics.wy = FontResourceObject.bytesToScaledSize(fontIndexData.getCharacterAscender()) + FontResourceObject.bytesToScaledSize(fontIndexData.getCharacterDescender());
            charMetrics.b = new float[]{0.0f, -FontResourceObject.bytesToScaledSize(fontIndexData.getCharacterDescender()), charMetrics.wx, FontResourceObject.bytesToScaledSize(fontIndexData.getCharacterAscender())};
            int n2 = FontResourceObject.bytesToScaledSize(fontIndexData.getASpace()) + FontResourceObject.bytesToScaledSize(fontIndexData.getCSpace());
            charMetrics.uc = cArray[n];
            if (n2 < 0) {
                charMetrics.kernTable = new UnicodeTable();
                KernVector kernVector = new KernVector();
                kernVector.X = n2;
                charMetrics.kernTable.put(cArray[n], kernVector);
            }
            this.uniTable.put(cArray[n], charMetrics);
            ++n;
        }
    }

    public void dump(PrintStream printStream) {
        super.dump(printStream);
    }
}

