/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFPDocument;
import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.Util;
import com.renderx.afplib.XPage;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.util.ErrorHandler;
import com.renderx.xep.gen.ErasedPage;
import com.renderx.xep.gen.backends.Stamp;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.Attr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XTrialPage
extends XPage {
    private boolean isUnLocked = false;
    private ContentHandler contentHandler;
    private int originalWidth;
    private int originalHeight;

    public XTrialPage(AFPDocument aFPDocument, Attributes attributes, String string, Session session, ContentHandler contentHandler, ErrorHandler errorHandler, Map map, Map map2, ConfigManager configManager, ArrayList arrayList) {
        super(aFPDocument, attributes, string, session, errorHandler, map, map2, configManager, arrayList);
        this.originalWidth = Util.parseLength(attributes.getValue("width"));
        this.originalHeight = Util.parseLength(attributes.getValue("height"));
        this.contentHandler = contentHandler;
    }

    public void render() {
        this.isUnLocked = true;
        this.resetTranslations();
        try {
            ErasedPage.put(this.contentHandler, this.originalWidth, this.originalHeight);
            Stamp.put(this.contentHandler, this.session);
        }
        catch (SAXException sAXException) {
            throw new InternalException(sAXException.getMessage());
        }
        super.render();
    }

    public void addGraphic(Attributes attributes, ImageFactory imageFactory, String string, boolean bl) throws IOException, ImageFormatException, UnregisteredMIMETypeException {
        if (this.isUnLocked) {
            super.addGraphic(attributes, imageFactory, string, bl);
        }
    }

    public void addLine(Attributes attributes, Attr.Color color) {
        if (this.isUnLocked) {
            super.addLine(attributes, color);
        }
    }

    public void addShadedRectangle(Attributes attributes, Attr.Color color) {
        if (this.isUnLocked) {
            super.addShadedRectangle(attributes, color);
        }
    }

    public void addText(Attributes attributes, Attr.Color color, int n, int n2) {
        if (this.isUnLocked) {
            super.addText(attributes, color, n, n2);
        }
    }
}

