/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.AffineTransform;
import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.FontFactory;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.XBarcode;
import com.renderx.afplib.XFont;
import com.renderx.afplib.XPage;
import com.renderx.afplib.XYObject;
import com.renderx.afplib.barcodes.BarcodeFactory;
import com.renderx.afplib.barcodes.BarcodeParams;
import com.renderx.afplib.orders.GocaOrders;
import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.SvgLevelParams;
import com.renderx.graphics.VectorImage;
import com.renderx.graphics.vector.Barcode;
import com.renderx.graphics.vector.ExternalImage;
import com.renderx.graphics.vector.GraphicGroup;
import com.renderx.graphics.vector.GraphicObject;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.graphics.vector.OpaqueColor;
import com.renderx.graphics.vector.PaintSpec;
import com.renderx.graphics.vector.Path;
import com.renderx.graphics.vector.StrokeSpec;
import com.renderx.graphics.vector.Subpath;
import com.renderx.graphics.vector.Text;
import com.renderx.util.ErrorHandler;
import com.renderx.xep.pre.Attr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;

public class XSvg
extends XYObject {
    private static double LINE_THICKNESS_COEFFICIENT = 1.38333333;
    private String src;
    private String xmlbase;
    private String mimeType;
    private float scale_x = 1.0f;
    private float scale_y = 1.0f;
    private Point2D size;
    private Point2D clipFrom = null;
    private Point2D clipTill = null;
    private Image image;
    private XPage page;
    private SvgLevelParams usingSvgLevelParams;
    AFP afp;
    GocaOrders orders = null;
    private ErrorHandler logger;
    private ImageTree imageTree;
    private FontFactory fontFactory;
    private AffineTransform currentTransformation;
    ConfigManager optionsManager;

    public XSvg(XPage xPage, Image image, String string, String string2, String string3, Point2D point2D, float f, float f2, Point2D point2D2, int n, Point2D point2D3, Point2D point2D4, ErrorHandler errorHandler, FontFactory fontFactory, ConfigManager configManager) {
        super(point2D, n);
        if (n == 90 || n == 270) {
            int n2 = point2D2.x;
            point2D2.x = point2D2.y;
            point2D2.y = n2;
        }
        this.logger = errorHandler;
        this.page = xPage;
        this.image = image;
        this.src = AFP.convertBase64ToString(string);
        this.xmlbase = string2;
        this.mimeType = string3;
        this.scale_x = f;
        this.scale_y = f2;
        this.size = point2D2;
        this.clipFrom = point2D3;
        this.clipTill = point2D4;
        this.fontFactory = fontFactory;
        this.optionsManager = configManager;
        this.afp = this.page.getAFP();
        this.currentTransformation = new AffineTransform();
        this.currentTransformation.scale(f, f2);
        this.usingSvgLevelParams = new SvgLevelParams(configManager.getBcocaLevels(), configManager.getGocaLevels());
        this.orders = new GocaOrders(this.afp, errorHandler);
        this.originRotation();
        if (fontFactory == null) {
            return;
        }
        try {
            this.imageTree = this.createImageTree();
        }
        catch (IOException iOException) {
            errorHandler.exception("Error create imageTree", iOException);
        }
        this.currentTransformation = new AffineTransform();
        this.currentTransformation.scale(f, f2);
    }

    private void originRotation() {
        switch (this.rotation) {
            case 0: {
                break;
            }
            case 90: {
                this.origin.y -= this.size.y;
                break;
            }
            case 180: {
                this.origin.y -= this.size.y;
                this.origin.x -= this.size.x;
                break;
            }
            case 270: {
                this.origin.x -= this.size.x;
            }
        }
    }

    public void writeToAFP(AFP aFP) throws IOException, AFPInternalException {
        if (this.isBarcodePresent(this.imageTree.root) && this.usingSvgLevelParams.isUseBarcodes()) {
            this.paintGraphicObject(this.imageTree.root);
        } else if (this.usingSvgLevelParams.isUseSvg()) {
            try {
                this.orders.writeGOCABegin(this.image, this.size, this.origin);
                this.paintGraphicObject(this.imageTree.root);
                this.orders.writeGOCAEnd();
            }
            catch (IOException iOException) {
                this.logger.error(iOException.toString());
                aFP.rollback();
            }
        }
    }

    private ImageTree createImageTree() throws IOException {
        VectorImage vectorImage = (VectorImage)this.image;
        ImageTree imageTree = null;
        try {
            imageTree = vectorImage.getImageTreeByType(VectorImage.IMAGE_TYPE_SVG_AFP, this.usingSvgLevelParams);
        }
        catch (ImageFormatException imageFormatException) {
            this.logger.error(imageFormatException.toString());
        }
        this.processFont(imageTree.root);
        return imageTree;
    }

    private void processFont(GraphicObject graphicObject) {
        GraphicObject graphicObject2;
        if (graphicObject instanceof GraphicGroup) {
            graphicObject2 = (GraphicGroup)graphicObject;
            this.applyTransformationParameters(graphicObject2.matrix, false);
            Enumeration enumeration = graphicObject2.children.elements();
            while (enumeration.hasMoreElements()) {
                this.processFont((GraphicObject)enumeration.nextElement());
            }
            this.applyTransformationParameters(graphicObject2.matrix, true);
        }
        if (graphicObject instanceof Text) {
            graphicObject2 = (Text)graphicObject;
            double d = this.currentTransformation.getScaleX();
            double d2 = this.currentTransformation.getScaleY();
            double d3 = Math.sqrt((d * d + d2 * d2) / 2.0);
            ((Text)graphicObject2).font.size *= d3 * 1000.0;
            XFont xFont = this.fontFactory.getXFont(((Text)graphicObject2).font);
            ((Text)graphicObject2).font.fontAFPLocalId = xFont.fontAFPLocalId;
        }
    }

    private boolean isBarcodePresent(GraphicObject graphicObject) throws AFPInternalException, IOException {
        boolean bl = false;
        if (graphicObject instanceof GraphicGroup) {
            GraphicGroup graphicGroup = (GraphicGroup)graphicObject;
            Enumeration enumeration = graphicGroup.children.elements();
            while (enumeration.hasMoreElements()) {
                if (!this.isBarcodePresent((GraphicObject)enumeration.nextElement())) continue;
                bl = true;
            }
        }
        if (graphicObject instanceof Barcode) {
            bl = true;
        }
        return bl;
    }

    private int getScaledThickness(double d) {
        int n = (int)Math.round(d * LINE_THICKNESS_COEFFICIENT * (Math.abs(this.currentTransformation.m00) + Math.abs(this.currentTransformation.m11)) / 2.0);
        return n;
    }

    private void applyTransformationParameters(double[] dArray, boolean bl) {
        AffineTransform affineTransform = new AffineTransform(dArray);
        this.applyTransformationParameters(affineTransform, bl);
    }

    private void applyTransformationParameters(AffineTransform affineTransform, boolean bl) {
        if (bl) {
            affineTransform = affineTransform.createInverse();
        }
        this.currentTransformation.concatenate(affineTransform);
    }

    private void paintGraphicObject(GraphicObject graphicObject) throws AFPInternalException, IOException {
        GraphicObject graphicObject2;
        if (graphicObject instanceof GraphicGroup) {
            graphicObject2 = (GraphicGroup)graphicObject;
            graphicObject2.matrix[4] = graphicObject2.matrix[4] * 1000.0;
            graphicObject2.matrix[5] = graphicObject2.matrix[5] * 1000.0;
            this.applyTransformationParameters(graphicObject2.matrix, false);
            Enumeration enumeration = graphicObject2.children.elements();
            while (enumeration.hasMoreElements()) {
                this.paintGraphicObject((GraphicObject)enumeration.nextElement());
            }
            this.applyTransformationParameters(graphicObject2.matrix, true);
        }
        if (graphicObject instanceof Barcode) {
            graphicObject2 = (Barcode)graphicObject;
            this.processBarcode((Barcode)graphicObject2);
        }
        if (graphicObject instanceof Path) {
            graphicObject2 = (Path)graphicObject;
            this.processSVGPath((Path)graphicObject2);
        }
        if (graphicObject instanceof Text) {
            graphicObject2 = (Text)graphicObject;
            try {
                this.processSVGText((Text)graphicObject2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (graphicObject instanceof ExternalImage) {
            // empty if block
        }
    }

    private void processBarcode(Barcode barcode) throws IOException, AFPInternalException {
        BarcodeParams barcodeParams = new BarcodeParams(barcode, this.image, this.src, this.xmlbase, this.mimeType, this.origin, this.scale_x, this.scale_y, this.size, this.rotation, this.clipFrom, this.clipTill);
        XBarcode xBarcode = BarcodeFactory.getBarcode(barcodeParams, this.optionsManager);
        if (xBarcode != null) {
            xBarcode.writeToAFP(this.afp);
        }
    }

    private void processSVGPath(Path path) throws AFPInternalException {
        if (path.fill != null) {
            this.processSVGPathContourOrFilling(path, true);
        }
        this.processSVGPathContourOrFilling(path, false);
    }

    private void processSVGPathContourOrFilling(Path path, boolean bl) throws AFPInternalException {
        Attr.Color color;
        if (bl && path.fill == null) {
            return;
        }
        Attr.Color color2 = color = bl ? this.paintStrokeToAFPColor(path.fill) : this.strokeSpecToAFPColor(path.stroke);
        if (color == null) {
            return;
        }
        Enumeration enumeration = path.subs.elements();
        while (enumeration.hasMoreElements()) {
            try {
                this.processSVGSubpath((Subpath)enumeration.nextElement(), bl, color, path.stroke.thickness);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void processSVGSubpath(Subpath subpath, boolean bl, Attr.Color color, double d) throws AFPInternalException {
        this.checkSubpathClosing(subpath);
        Enumeration enumeration = subpath.segs.elements();
        Point2D point2D = null;
        XSvgPolylines xSvgPolylines = new XSvgPolylines();
        XSvgCurves xSvgCurves = new XSvgCurves();
        XSvgEllipses xSvgEllipses = new XSvgEllipses();
        this.orders.setColor(color);
        this.orders.writeGSLW_SetLineWidth(this.getScaledThickness(d));
        while (enumeration.hasMoreElements()) {
            Object object;
            Subpath.Segment segment = (Subpath.Segment)enumeration.nextElement();
            Point2D point2D2 = null;
            Point2D point2D3 = null;
            Point2D point2D4 = null;
            Point2D point2D5 = null;
            if (segment instanceof Subpath.Line) {
                object = (Subpath.Line)segment;
                point2D2 = this.fromXEPOutToAFPCoordinates(((Subpath.Line)object).xbeg, ((Subpath.Line)object).ybeg);
                point2D3 = this.fromXEPOutToAFPCoordinates(((Subpath.Line)object).xend, ((Subpath.Line)object).yend);
                xSvgPolylines.addLine(point2D2, point2D3);
            } else if (segment instanceof Subpath.Curve) {
                if (segment instanceof Subpath.Ellipse) {
                    point2D2 = this.fromXEPOutToAFPCoordinates(segment.xbeg, segment.ybeg);
                    point2D3 = this.fromXEPOutToAFPCoordinates(segment.xend, segment.yend);
                    object = this.fromXEPOutToAFPCoordinates(segment.xbeg - Math.abs(segment.xbeg - segment.xend), segment.ybeg);
                    xSvgEllipses.addEllipse(point2D2, point2D3, (Point2D)object);
                    break;
                }
                object = (Subpath.Curve)segment;
                point2D2 = this.fromXEPOutToAFPCoordinates(((Subpath.Curve)object).xbeg, ((Subpath.Curve)object).ybeg);
                point2D3 = this.fromXEPOutToAFPCoordinates(((Subpath.Curve)object).xend, ((Subpath.Curve)object).yend);
                point2D4 = this.fromXEPOutToAFPCoordinates(((Subpath.Curve)object).cpx1, ((Subpath.Curve)object).cpy1);
                point2D5 = this.fromXEPOutToAFPCoordinates(((Subpath.Curve)object).cpx2, ((Subpath.Curve)object).cpy2);
                xSvgCurves.addCurve(point2D2, point2D4, point2D5, point2D3, subpath.closed && bl);
            }
            if (!subpath.closed) continue;
            if (point2D == null) {
                point2D = point2D2;
            }
            if (enumeration.hasMoreElements() || point2D3 == null || point2D == null || point2D3.distance(point2D) == 0) continue;
            xSvgPolylines.addLine(point2D3, point2D);
        }
        if (bl) {
            this.orders.writeGBAR_BeginArea();
        }
        xSvgPolylines.closeCurrentPolyline();
        xSvgPolylines.drawPolylines();
        xSvgPolylines.clear();
        xSvgPolylines = null;
        xSvgCurves.closeCurrentCurve();
        xSvgCurves.drawCurves();
        xSvgCurves.clear();
        xSvgCurves = null;
        xSvgEllipses.drawEllipses();
        xSvgEllipses.clear();
        xSvgEllipses = null;
        if (bl) {
            this.orders.writeGEAR_EndArea();
        }
    }

    private void checkSubpathClosing(Subpath subpath) {
        boolean bl;
        if (subpath.closed) {
            return;
        }
        Enumeration enumeration = subpath.segs.elements();
        Subpath.Segment segment = null;
        Subpath.Segment segment2 = null;
        boolean bl2 = bl = subpath.segs.length() > 1;
        while (enumeration.hasMoreElements()) {
            Subpath.Segment segment3 = (Subpath.Segment)enumeration.nextElement();
            if (segment == null) {
                segment = segment3;
            }
            if (segment2 != null && (segment2.xend != segment3.xbeg || segment2.yend != segment3.ybeg)) {
                bl = false;
                break;
            }
            if (enumeration.hasMoreElements()) {
                segment2 = segment3;
                continue;
            }
            if (segment.xbeg == segment3.xend && segment.ybeg == segment3.yend) continue;
            bl = false;
        }
        subpath.closed = bl;
    }

    private Attr.Color strokeSpecToAFPColor(StrokeSpec strokeSpec) {
        Attr.Color.Opaque opaque = null;
        if (strokeSpec.paint instanceof OpaqueColor.Grayscale) {
            OpaqueColor.Grayscale grayscale = (OpaqueColor.Grayscale)strokeSpec.paint;
            opaque = Attr.Color.Grayscale.create(grayscale.g);
        } else if (strokeSpec.paint instanceof OpaqueColor.RGB) {
            OpaqueColor.RGB rGB = (OpaqueColor.RGB)strokeSpec.paint;
            opaque = Attr.Color.RGB.create(rGB.r, rGB.g, rGB.b);
        } else if (strokeSpec.paint instanceof OpaqueColor.CMYK) {
            OpaqueColor.CMYK cMYK = (OpaqueColor.CMYK)strokeSpec.paint;
            opaque = Attr.Color.CMYK.create(cMYK.c, cMYK.m, cMYK.y, cMYK.k);
        }
        return opaque;
    }

    private Attr.Color paintStrokeToAFPColor(PaintSpec paintSpec) {
        Attr.Color.Opaque opaque = null;
        if (paintSpec instanceof OpaqueColor.Grayscale) {
            OpaqueColor.Grayscale grayscale = (OpaqueColor.Grayscale)paintSpec;
            opaque = Attr.Color.Grayscale.create(grayscale.g);
        } else if (paintSpec instanceof OpaqueColor.RGB) {
            OpaqueColor.RGB rGB = (OpaqueColor.RGB)paintSpec;
            opaque = Attr.Color.RGB.create(rGB.r, rGB.g, rGB.b);
        } else if (paintSpec instanceof OpaqueColor.CMYK) {
            OpaqueColor.CMYK cMYK = (OpaqueColor.CMYK)paintSpec;
            opaque = Attr.Color.CMYK.create(cMYK.c, cMYK.m, cMYK.y, cMYK.k);
        }
        return opaque;
    }

    private Point2D fromXEPOutToAFPCoordinates(double d, double d2) {
        return this.toImageCoordinates(this.toAFPCoordinates(d, d2));
    }

    private Point2D toAFPCoordinates(double d, double d2) {
        Point2D point2D = new Point2D(d * 1000.0, d2 * 1000.0);
        this.currentTransformation.transform(point2D, point2D);
        return point2D.toAFPCoordinates();
    }

    public Point2D toImageCoordinates(Point2D point2D) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.toRadians(this.rotation), 0.0, 0.0);
        point2D = affineTransform.transform(point2D, null);
        switch (this.rotation) {
            case 0: {
                break;
            }
            case 90: {
                point2D.x += this.size.x;
                break;
            }
            case 180: {
                point2D.x += this.size.x;
                point2D.y += this.size.y;
                break;
            }
            case 270: {
                point2D.y += this.size.y;
            }
        }
        return point2D;
    }

    private void processSVGText(Text text) throws IOException, AFPInternalException {
        Attr.Color color = this.paintStrokeToAFPColor(text.fill);
        this.orders.setColor(color);
        this.orders.writeGSCA_SetCharacterAngle(this.rotation);
        Point2D point2D = this.fromXEPOutToAFPCoordinates(text.x, text.y);
        this.orders.writeGSCS_SetCharacterSet(text.font.fontAFPLocalId);
        this.orders.writeTextGivenPosition(point2D, text.value);
    }

    private class XSvgEllipses {
        private ArrayList ellipses;

        private XSvgEllipses() {
        }

        public ArrayList getEllipses() {
            return this.ellipses;
        }

        public void addEllipse(Point2D point2D, Point2D point2D2, Point2D point2D3) {
            if (point2D == null || point2D2 == null || point2D3 == null) {
                return;
            }
            if (this.ellipses == null) {
                this.ellipses = new ArrayList();
            }
            this.ellipses.add(new Point2D[]{point2D, point2D2, point2D3});
        }

        public void drawEllipses() throws AFPInternalException {
            if (this.ellipses == null) {
                return;
            }
            int n = this.ellipses.size();
            for (int i = 0; i < n; ++i) {
                Point2D[] point2DArray = (Point2D[])this.ellipses.get(i);
                XSvg.this.orders.writeGSAP_SetArcParameters(point2DArray[0], point2DArray[1], point2DArray[2]);
                XSvg.this.orders.writeGFARC_FullArc(point2DArray[2]);
            }
        }

        public void clear() {
            this.ellipses = null;
        }
    }

    private class XSvgCurves {
        private ArrayList curves;
        private ArrayList curvePoints;
        Point2D prevEndPoint;

        private XSvgCurves() {
        }

        public ArrayList getCurves() {
            return this.curves;
        }

        public void addCurve(Point2D point2D, Point2D point2D2) {
            this.addCurve(point2D, null, null, point2D2, false);
        }

        public void addCurve(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4, boolean bl) {
            if (point2D == null || point2D4 == null || point2D2 == null || point2D3 == null) {
                return;
            }
            if (this.curves == null) {
                this.curves = new ArrayList();
            }
            if (this.curvePoints == null) {
                this.curvePoints = new ArrayList();
            }
            if (this.curvePoints.size() == 0) {
                this.curvePoints.add(point2D);
                this.curvePoints.add(point2D2);
                this.curvePoints.add(point2D3);
                this.curvePoints.add(point2D4);
            } else if (point2D.distance(this.prevEndPoint) == 0) {
                if (!bl) {
                    this.closeCurrentCurve();
                    this.curvePoints = new ArrayList();
                    this.curvePoints.add(point2D);
                    this.curvePoints.add(point2D2);
                } else {
                    this.curvePoints.set(this.curvePoints.size() - 1, point2D2);
                }
                this.curvePoints.add(point2D3);
                this.curvePoints.add(point2D4);
            } else {
                if (bl) {
                    this.curvePoints.add(this.prevEndPoint);
                    this.curvePoints.add(point2D);
                } else {
                    this.closeCurrentCurve();
                    this.curvePoints = new ArrayList();
                }
                this.curvePoints.add(point2D);
                this.curvePoints.add(point2D2);
                this.curvePoints.add(point2D3);
                this.curvePoints.add(point2D4);
            }
            this.prevEndPoint = point2D4;
        }

        public void closeCurrentCurve() {
            if (this.curvePoints == null) {
                return;
            }
            Point2D[] point2DArray = new Point2D[this.curvePoints.size()];
            this.curvePoints.toArray(point2DArray);
            this.curves.add(point2DArray);
        }

        public void drawCurves() throws AFPInternalException {
            if (this.curves == null) {
                return;
            }
            int n = this.curves.size();
            for (int i = 0; i < n; ++i) {
                Point2D[] point2DArray = (Point2D[])this.curves.get(i);
                if (point2DArray.length == 0) continue;
                ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
                Point2D[] point2DArray2 = null;
                for (int j = 0; j < point2DArray.length; ++j) {
                    if (arrayList.size() < 62) {
                        arrayList.add(point2DArray[j]);
                        continue;
                    }
                    point2DArray2 = new Point2D[arrayList.size()];
                    arrayList.toArray(point2DArray2);
                    this.drawCurve(point2DArray2);
                    arrayList = new ArrayList();
                    arrayList.add(point2DArray[j - 1]);
                    arrayList.add(point2DArray[j]);
                }
                if (arrayList.size() <= 0) continue;
                point2DArray2 = new Point2D[arrayList.size()];
                arrayList.toArray(point2DArray2);
                this.drawCurve(point2DArray2);
            }
        }

        private void drawCurve(Point2D[] point2DArray) throws AFPInternalException {
            Point2D[] point2DArray2 = new Point2D[point2DArray.length - 2];
            for (int i = 1; i < point2DArray.length - 1; ++i) {
                point2DArray2[i - 1] = point2DArray[i];
            }
            XSvg.this.orders.writeCurveLine(point2DArray[0], point2DArray[point2DArray.length - 1], point2DArray2);
        }

        public void clear() {
            this.curves = null;
            this.curvePoints = null;
            this.prevEndPoint = null;
        }
    }

    private class XSvgPolylines {
        private ArrayList polylines;
        private ArrayList polylinePoints;
        private Point2D prevBeginPoint;
        private Point2D prevEndPoint;

        private XSvgPolylines() {
        }

        public ArrayList getPolylines() {
            return this.polylines;
        }

        public void addLine(Point2D point2D, Point2D point2D2) {
            if (point2D == null || point2D2 == null) {
                return;
            }
            if (this.polylines == null) {
                this.polylines = new ArrayList();
            }
            if (this.polylinePoints == null) {
                this.polylinePoints = new ArrayList();
            }
            if (this.polylinePoints.size() == 0) {
                this.polylinePoints.add(point2D);
                this.polylinePoints.add(point2D2);
            } else if (point2D.distance(this.prevEndPoint) == 0) {
                this.polylinePoints.add(point2D2);
            } else if (point2D2.distance(this.prevBeginPoint) == 0) {
                ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
                arrayList.add(point2D);
                arrayList.addAll(this.polylinePoints);
                this.polylinePoints = arrayList;
            } else {
                this.closeCurrentPolyline();
                this.polylinePoints = new ArrayList();
                this.polylinePoints.add(point2D);
                this.polylinePoints.add(point2D2);
            }
            this.prevBeginPoint = point2D;
            this.prevEndPoint = point2D2;
        }

        public void closeCurrentPolyline() {
            if (this.polylinePoints == null) {
                return;
            }
            Point2D[] point2DArray = new Point2D[this.polylinePoints.size()];
            this.polylinePoints.toArray(point2DArray);
            this.polylines.add(point2DArray);
            this.polylinePoints = null;
        }

        public void drawPolylines() throws AFPInternalException {
            if (this.polylines == null) {
                return;
            }
            int n = this.polylines.size();
            for (int i = 0; i < n; ++i) {
                Point2D[] point2DArray = (Point2D[])this.polylines.get(i);
                ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
                Point2D[] point2DArray2 = null;
                for (int j = 0; j < point2DArray.length; ++j) {
                    if (arrayList.size() < 62) {
                        arrayList.add(point2DArray[j]);
                        continue;
                    }
                    point2DArray2 = new Point2D[arrayList.size()];
                    arrayList.toArray(point2DArray2);
                    XSvg.this.orders.writeGLINE_LineGivenPosition(point2DArray2);
                    arrayList = new ArrayList();
                    arrayList.add(point2DArray[j - 1]);
                    arrayList.add(point2DArray[j]);
                }
                if (arrayList.size() <= 0) continue;
                point2DArray2 = new Point2D[arrayList.size()];
                arrayList.toArray(point2DArray2);
                XSvg.this.orders.writeGLINE_LineGivenPosition(point2DArray2);
            }
        }

        public void clear() {
            this.polylines = null;
            this.polylinePoints = null;
            this.prevEndPoint = null;
        }
    }
}

