/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.ScatterDataManager;
import jas.hist.StatisticsBlock;
import jas.plot.DataArea;
import jas.plot.DateAxis;
import jas.plot.DoubleAxis;
import jas.plot.Legend;
import java.util.TimeZone;

final class DateScatterDataManager
extends ScatterDataManager {
    private DateAxis xAxisType;

    DateScatterDataManager(JASHist plot, DataArea da, Legend l, StatisticsBlock stats) {
        super(plot, da, l, stats);
        DoubleAxis yAxisType;
        if (this.xm.getType() instanceof DateAxis) {
            this.xAxisType = (DateAxis)this.xm.getType();
        } else {
            this.xAxisType = new DateAxis();
            this.xm.setType(this.xAxisType);
        }
        if (this.ym[0].getType() instanceof DoubleAxis) {
            yAxisType = (DoubleAxis)this.ym[0].getType();
        } else {
            yAxisType = new DoubleAxis();
            this.ym[0].setType(yAxisType);
        }
        this.xm.setDataManager(this, false, this.xAxisType);
        this.ym[0].setDataManager(this, false, yAxisType);
    }

    protected final void calcMinMaxXBins(double x1, double x2) {
        long iLow = (long)(x1 * 1000.0);
        long iHigh = (long)(x2 * 1000.0);
        long oldXMin = this.xAxisType.getAxisMin();
        long oldXMax = this.xAxisType.getAxisMax();
        if (iLow < oldXMin || iHigh > oldXMax || (double)((iHigh - iLow) / (oldXMax - oldXMin)) < 0.75) {
            this.xAxisType.setMin(iLow);
            this.xAxisType.setMax(iHigh);
            this.xm.invalidate();
        }
    }

    JASHistData add(DataSource ds) {
        JASHistData jhd = super.add(ds);
        TimeZone tz = jhd.getStyle().getTimeZone();
        if (tz != null) {
            this.xAxisType.setTimeZone(tz);
        }
        return jhd;
    }

    void styleUpdate(JASHistData data) {
        TimeZone tz = data.getStyle().getTimeZone();
        if (tz != null) {
            this.xAxisType.setTimeZone(tz);
        }
        super.styleUpdate(data);
    }
}

