/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public class ModifyWorldTransform
extends EMFTag
implements EMFConstants {
    private AffineTransform transform;
    private int mode;

    public ModifyWorldTransform() {
        super(36, 1);
    }

    public ModifyWorldTransform(AffineTransform transform, int mode) {
        this();
        this.transform = transform;
        this.mode = mode;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        return new ModifyWorldTransform(emf.readXFORM(), emf.readDWORD());
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeXFORM(this.transform);
        emf.writeDWORD(this.mode);
    }

    public String toString() {
        return super.toString() + "\n  transform: " + this.transform + "\n  mode: " + this.mode;
    }

    public void render(EMFRenderer renderer) {
        if (this.mode == 1) {
            if (renderer.getPath() != null) {
                renderer.setPathTransform(new AffineTransform());
            } else {
                renderer.resetTransformation();
            }
        } else if (this.mode == 2) {
            if (renderer.getPath() != null) {
                renderer.getPathTransform().concatenate(this.transform);
                renderer.transform(this.transform);
            } else {
                renderer.transform(this.transform);
            }
        } else if (this.mode == 3) {
            logger.warning("unsupport transform mode " + this.toString());
        }
    }
}

