/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xepout;

import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.FontRecord;
import com.renderx.graphics.vector.GraphicGroup;
import com.renderx.graphics.vector.GraphicObject;
import com.renderx.graphics.vector.OpaqueColor;
import com.renderx.graphics.vector.Path;
import com.renderx.graphics.vector.StrokeSpec;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import java.util.ArrayList;
import java.util.Enumeration;
import org.xml.sax.Attributes;

public class XEPOUTParserContext {
    public GraphicGroup prevGroup = null;
    public GraphicGroup curGroup = null;
    public OpaqueColor currentColor = null;
    public String fontFamily = null;
    public int fontWeight = Integer.MIN_VALUE;
    public String fontStyle = null;
    public String fontVariant = null;
    public double fontSize = 0.0;
    public double letterSpacing = 0.0;
    public double wordSpacing = 0.0;
    public double fontStretch = 0.0;
    public String language = null;
    public static final String DEFAULT_FONT_FAMILY = "Helvetica";
    public static final double DEFAULT_FONT_SIZE = 12.0;
    public FontRecord[] fonts = null;
    public final FontCatalog fontCatalog;
    protected final Hashtable fontCache;

    public XEPOUTParserContext(FontCatalog fontCatalog, Hashtable hashtable, ErrorHandler errorHandler) {
        this.fontCatalog = fontCatalog;
        this.fontCache = hashtable;
        this.initialize(errorHandler);
    }

    public void initialize(ErrorHandler errorHandler) {
        this.currentColor = new OpaqueColor.Grayscale(0.0);
        this.fontFamily = DEFAULT_FONT_FAMILY;
        this.fontWeight = 400;
        this.fontStyle = "normal";
        this.fontVariant = "normal";
        this.fontSize = 12.0;
        this.language = null;
        this.letterSpacing = 0.0;
        this.wordSpacing = 0.0;
        this.fontStretch = 1.0;
        this.selectFont(errorHandler);
    }

    void pushGroup() {
        this.prevGroup = this.curGroup;
        GraphicGroup graphicGroup = new GraphicGroup();
        this.curGroup.append(graphicGroup);
        this.curGroup = graphicGroup;
    }

    void popGroup() {
        this.curGroup = this.prevGroup;
    }

    public void addGraphicObject(GraphicObject graphicObject) {
        this.curGroup.append(graphicObject);
    }

    public void rotate(double d) {
        this.curGroup.rotate((double)((int)d) * Math.PI / 180.0);
    }

    public void translate(double d, double d2) {
        this.curGroup.translate(d, d2);
    }

    public void scale(double d, double d2) {
        this.curGroup.scale(d, d2);
    }

    public void transform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.curGroup.transform(d, d2, d3, d4, d5, d6);
    }

    public GraphicObject drawLine(double d, double d2, double d3, double d4, String string, double d5) {
        double d6;
        StrokeSpec strokeSpec = new StrokeSpec(this.currentColor, d5);
        if (string.equals("dotted")) {
            d6 = XEPOUTParserContext.getLineLength(d, d2, d3, d4) / d5;
            double d7 = d6 - 2.0 * Math.floor(d6 / 2.0);
            double d8 = 2.0 - d7 / 2.0;
            if (d6 > 2.0 && d8 > 1.5) {
                d8 -= 1.0;
            }
            strokeSpec.dashArray = new double[]{0.0, d8 * d5};
            strokeSpec.dashPhase = 2.0 * d5;
            strokeSpec.lineCap = 1;
        } else if (string.equals("dashed")) {
            d6 = XEPOUTParserContext.getLineLength(d, d2, d3, d4) / d5;
            double d9 = d6 + 4.0 - 10.0 * Math.floor((d6 + 4.0) / 10.0);
            double d10 = 10.0 - d9 / 2.0;
            if (d10 < 8.0 || d6 < 6.0) {
                d10 -= 5.0;
            }
            if (d10 == 10.0) {
                d10 = 0.0;
            }
            strokeSpec.dashArray = new double[]{6.0 * d5, d10 * d5};
            strokeSpec.dashPhase = 4.0 * d5;
            strokeSpec.lineCap = 0;
        } else {
            strokeSpec.lineCap = 0;
        }
        Path path = new Path(this.currentColor, strokeSpec, 0, 0, 1.0, 1.0);
        path.moveto(d, d2);
        path.lineto(d3, d4);
        return path;
    }

    public GraphicObject drawRectangle(double d, double d2, double d3, double d4) {
        Path path = new Path(this.currentColor, new StrokeSpec(this.currentColor, 0.0), 0, 0, 1.0, 1.0);
        path.rectangle(d, d2, d3 - d, d4 - d2);
        return path;
    }

    public GraphicObject drawPolygon(ArrayList arrayList) {
        Path path = new Path(this.currentColor, new StrokeSpec(this.currentColor, 0.0), 0, 0, 1.0, 1.0);
        path.moveto(((double[])arrayList.get(0))[0], ((double[])arrayList.get(0))[1]);
        int n = 1;
        while (n < arrayList.size()) {
            path.lineto(((double[])arrayList.get(n))[0], ((double[])arrayList.get(n))[1]);
            ++n;
        }
        path.closepath();
        return path;
    }

    private static final double getLineLength(double d, double d2, double d3, double d4) {
        if (d == d3) {
            return d2 > d4 ? d2 - d4 : d4 - d2;
        }
        if (d2 == d4) {
            return d > d3 ? d - d3 : d3 - d;
        }
        double d5 = d - d3;
        double d6 = d2 - d4;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public void setColor(OpaqueColor opaqueColor) {
        this.currentColor = opaqueColor;
    }

    public void selectFont(ErrorHandler errorHandler) {
        String string = this.fontFamily + ":" + this.fontWeight + ":" + this.fontStyle + ":" + this.fontVariant + ":" + this.language;
        this.fonts = (FontRecord[])this.fontCache.get(string);
        if (this.fonts != null) {
            return;
        }
        List list = this.fontCatalog.findAll(this.fontFamily, this.fontWeight, this.fontStyle, this.fontVariant, this.language, errorHandler);
        if (list == null || list.length() == 0) {
            this.fonts = null;
            return;
        }
        this.fonts = new FontRecord[list.length()];
        Enumeration enumeration = list.elements();
        int n = 0;
        while (n < this.fonts.length) {
            this.fonts[n] = (FontRecord)enumeration.nextElement();
            ++n;
        }
        this.fontCache.put(string, this.fonts);
    }

    public static final class Color {
        public static OpaqueColor setRGB(double d, double d2, double d3) {
            return new OpaqueColor.RGB(d, d2, d3);
        }

        public static OpaqueColor setGrayscale(double d) {
            return new OpaqueColor.Grayscale(d);
        }

        public static OpaqueColor setCMYK(double d, double d2, double d3, double d4) {
            return new OpaqueColor.CMYK(d, d2, d3, d4);
        }

        public static OpaqueColor setRegistration(double d) {
            return new OpaqueColor.Registration(d);
        }

        public static OpaqueColor setSpotColor(Attributes attributes) {
            int n = 0;
            while (n < attributes.getLength()) {
                String string = attributes.getLocalName(n);
                if (string.equals("alt-cyan") || string.equals("alt-magenta") || string.equals("alt-yellow") || string.equals("alt-black")) {
                    return new OpaqueColor.SpotColor(Double.parseDouble(attributes.getValue("tint")), attributes.getValue("colorant"), Double.parseDouble(attributes.getValue("alt-cyan")), Double.parseDouble(attributes.getValue("alt-magenta")), Double.parseDouble(attributes.getValue("alt-yellow")), Double.parseDouble(attributes.getValue("alt-black")));
                }
                if (string.equals("alt-gray")) {
                    return new OpaqueColor.SpotColor(Double.parseDouble(attributes.getValue("tint")), attributes.getValue("colorant"), Double.parseDouble(attributes.getValue("alt-gray")));
                }
                ++n;
            }
            return new OpaqueColor.SpotColor(Double.parseDouble(attributes.getValue("tint")), attributes.getValue("colorant"));
        }
    }
}

