/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class Base64OutputStream
extends OutputStream {
    public static final String base64charset = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private int bits = 0;
    private int bitCount = 0;
    private int charCount = 0;
    private boolean endOfFile = false;
    private Writer writer = null;
    private boolean wrap = true;

    public Base64OutputStream(Writer writer) {
        this.writer = writer;
    }

    public Base64OutputStream(Writer writer, boolean bl) {
        this.writer = writer;
        this.wrap = bl;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.EOD();
        this.flush();
    }

    public void write(int n) throws IOException {
        if (this.endOfFile) {
            throw new IOException("Attempt to write to a Base64OutputStream after EOD was sent");
        }
        this.bitCount += 8;
        this.bits |= (n & 0xFF) << 32 - this.bitCount;
        while (this.bitCount >= 6) {
            if (++this.charCount > 64) {
                this.charCount = 1;
                if (this.wrap) {
                    this.writer.write(10);
                }
            }
            int n2 = this.bits >> 26 & 0x3F;
            this.bits <<= 6;
            this.bitCount -= 6;
            this.writer.write(base64charset.charAt(n2));
        }
    }

    public void EOD() throws IOException {
        if (this.endOfFile) {
            return;
        }
        this.endOfFile = true;
        if (this.bitCount == 0) {
            return;
        }
        this.writer.write(base64charset.charAt(this.bits >> 26 & 0x3F));
        switch (this.bitCount) {
            case 2: {
                this.writer.write("==");
                break;
            }
            case 4: {
                this.writer.write("=");
                break;
            }
            default: {
                throw new RuntimeException("Internal error: unexpected bit count [" + this.bitCount + "] in Base64OutputStream");
            }
        }
    }
}

