/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

public class Base32 {
    private static final String base32Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final int[] base32Lookup = new int[]{255, 255, 26, 27, 28, 29, 30, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255};

    public static String encode(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer((byArray.length + 7) * 8 / 5);
        while (n < byArray.length) {
            int n4;
            int n5 = n4 = byArray[n] >= 0 ? byArray[n] : byArray[n] + 256;
            if (n2 > 3) {
                int n6 = n + 1 < byArray.length ? (byArray[n + 1] >= 0 ? byArray[n + 1] : byArray[n + 1] + 256) : 0;
                n3 = n4 & 255 >> n2;
                n2 = (n2 + 5) % 8;
                n3 <<= n2;
                n3 |= n6 >> 8 - n2;
                ++n;
            } else {
                n3 = n4 >> 8 - (n2 + 5) & 0x1F;
                if ((n2 = (n2 + 5) % 8) == 0) {
                    ++n;
                }
            }
            stringBuffer.append(base32Chars.charAt(n3));
        }
        return stringBuffer.toString();
    }

    public static byte[] decode(String string) {
        byte[] byArray = new byte[string.length() * 5 / 8];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < string.length()) {
            int n4;
            int n5 = string.charAt(n) - 48;
            if (n5 >= 0 && n5 < base32Lookup.length && (n4 = base32Lookup[n5]) != 255) {
                if (n2 <= 3) {
                    if ((n2 = (n2 + 5) % 8) == 0) {
                        int n6 = n3++;
                        byArray[n6] = (byte)(byArray[n6] | n4);
                        if (n3 >= byArray.length) {
                            break;
                        }
                    } else {
                        int n7 = n3;
                        byArray[n7] = (byte)(byArray[n7] | n4 << 8 - n2);
                    }
                } else {
                    n2 = (n2 + 5) % 8;
                    int n8 = n3++;
                    byArray[n8] = (byte)(byArray[n8] | n4 >>> n2);
                    if (n3 >= byArray.length) break;
                    int n9 = n3;
                    byArray[n9] = (byte)(byArray[n9] | n4 << 8 - n2);
                }
            }
            ++n;
        }
        return byArray;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Supply a Base32-encoded argument.");
            return;
        }
        System.out.println(" Original: " + stringArray[0]);
        byte[] byArray = Base32.decode(stringArray[0]);
        System.out.print("      Hex: ");
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            if (n2 < 0) {
                n2 += 256;
            }
            System.out.print(Integer.toHexString(n2 + 256).substring(1));
            ++n;
        }
        System.out.println();
        System.out.println("Reencoded: " + Base32.encode(byArray));
    }
}

