/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.sax;

import com.renderx.sax.XMLPlayer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DOMWalker
extends XMLPlayer {
    private Node docroot = null;

    public DOMWalker(Node node) {
        this.docroot = node;
    }

    public DOMWalker(Document document) {
        this.docroot = document.getDocumentElement();
    }

    public void play() throws SAXException {
        this.handler.startDocument();
        if (this.docroot != null) {
            Document document = this.docroot.getOwnerDocument();
            if (document == null) {
                throw new SAXException("DOM element does not have an owner document: cannot determine DOM Level");
            }
            DOMImplementation dOMImplementation = document.getImplementation();
            if (dOMImplementation.hasFeature("XML", "2.0")) {
                this.traverseNS(this.docroot);
            } else {
                throw new SAXException("DOM Level 1 traversal unsupported");
            }
        }
        this.handler.endDocument();
    }

    private void traverseNS(Node node) throws SAXException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                Object object;
                String string = null;
                String string2 = null;
                String string3 = null;
                NamedNodeMap namedNodeMap = node.getAttributes();
                AttributesImpl attributesImpl = new AttributesImpl();
                if (namedNodeMap != null) {
                    int n = 0;
                    while (n < namedNodeMap.getLength()) {
                        object = (Attr)namedNodeMap.item(n);
                        string2 = object.getName();
                        if (!string2.startsWith("xmlns:") && !string2.equals("xmlns")) {
                            string = object.getLocalName();
                            if (string == null) {
                                string = string2;
                            }
                            if ((string3 = object.getNamespaceURI()) == null) {
                                string3 = "";
                            }
                            attributesImpl.addAttribute(string3, string, string2, "CDATA", object.getValue());
                        }
                        ++n;
                    }
                }
                Element element = (Element)node;
                string = element.getLocalName();
                string2 = element.getTagName();
                if (string == null) {
                    string = string2;
                }
                if ((string3 = element.getNamespaceURI()) == null) {
                    string3 = "";
                }
                this.handler.startElement(string3, string, string2, attributesImpl);
                object = node.getChildNodes();
                if (object != null) {
                    int n = 0;
                    while (n < object.getLength()) {
                        this.traverseNS(object.item(n));
                        ++n;
                    }
                }
                this.handler.endElement(string3, string, string2);
                break;
            }
            case 3: 
            case 4: {
                String string = node.getNodeValue();
                if (string == null) break;
                this.handler.characters(string.toCharArray(), 0, string.length());
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                this.handler.processingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
            }
        }
    }
}

