/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.Encoding;
import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.FontConfigurationException;
import com.renderx.fonts.FontDescriptor;
import com.renderx.fonts.FontRecord;
import com.renderx.fonts.U28;
import com.renderx.graphics.EPSImage;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.graphics.vector.ExternalImage;
import com.renderx.graphics.vector.GraphicGroup;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.graphics.vector.PaintServer;
import com.renderx.graphics.vector.Pattern;
import com.renderx.pslib.Bookmarks;
import com.renderx.pslib.EPS;
import com.renderx.pslib.Fonts;
import com.renderx.pslib.Image;
import com.renderx.pslib.Images;
import com.renderx.pslib.Info;
import com.renderx.pslib.InternalException;
import com.renderx.pslib.Names;
import com.renderx.pslib.PSOutputStream;
import com.renderx.pslib.PSText;
import com.renderx.pslib.Pages;
import com.renderx.pslib.Patterns;
import com.renderx.pslib.SpotColors;
import com.renderx.sax.Serializer;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.Base64OutputStream;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class PSDocument {
    static final String BACKUP_PAGE_DEVICE_NAME = "XEPPS_BackupPageDevice";
    static final String DOCUMENT_PAGE_DEVICE_NAME = "XEPPS_DocumentPageDevice";
    public boolean DOCUMENT_MANAGER_COMMENTS = false;
    public int LANGUAGE_LEVEL = 3;
    public boolean UNICODE_ANNOTATIONS = true;
    public boolean CLONE_EPS = true;
    public boolean DROP_UNUSED_DESTINATIONS = true;
    public int IMAGE_INLINE_THRESHOLD = 0;
    final ImageFactory imageFactory;
    final FontCatalog fontCatalog;
    final ErrorHandler errorHandler;
    PSOutputStream out = null;
    PSOutputStream targetStream = null;
    Pages pages = null;
    Image curimage = null;
    Images images = null;
    private Info info = null;
    private Fonts fonts = null;
    private SpotColors spotColors = null;
    private Names names = null;
    private Bookmarks bookmarks = null;
    private Patterns patterns = null;
    private final Hashtable documentLevelComments = new Hashtable();
    private final Hashtable pagedevice = new Hashtable();
    private Hashtable currentDevice = null;
    private final Hashtable pageDeviceEntries = new Hashtable();
    private final Hashtable pageboundaries = new Hashtable();
    private Hashtable currentPageBoundaries = null;
    private final List printermarks = new List();
    private List currentPrinterMarks = null;
    private float letterSpacing = 0.0f;
    private float wordSpacing = 0.0f;
    private float fontSize = 0.0f;
    private float fontStretch = 1.0f;
    int textRenderMode = 0;
    String initialDestination = null;
    String zoom = null;
    String viewMode = null;
    float firstPageHeight = 0.0f;
    boolean unsupportedPatternWarning = false;
    public U28 u28;

    public void setInitialDestination(String string) {
        this.initialDestination = string;
    }

    public void setInitialZoom(String string) {
        this.zoom = string;
    }

    public void setViewMode(String string) {
        this.viewMode = string;
    }

    public PSDocument(String string, File file, ImageFactory imageFactory, FontCatalog fontCatalog, ErrorHandler errorHandler) throws IOException {
        this((OutputStream)new FileOutputStream(string), file, imageFactory, fontCatalog, errorHandler);
    }

    public PSDocument(OutputStream outputStream, File file, ImageFactory imageFactory, FontCatalog fontCatalog, ErrorHandler errorHandler) throws IOException {
        this.errorHandler = errorHandler;
        this.fontCatalog = fontCatalog;
        this.imageFactory = imageFactory;
        this.u28 = new PSU28();
        this.out = this.targetStream = new PSOutputStream(this, outputStream);
        if (file != null) {
            if (!file.exists()) {
                this.errorHandler.error("Directory " + file + " does not exist; disk caching in PostScript generator disabled.");
                file = null;
            } else if (!file.isDirectory()) {
                this.errorHandler.error("File " + file + " is not a directory; disk caching in PostScript generator disabled.");
                file = null;
            } else if (!file.canWrite()) {
                this.errorHandler.error("Directory " + file + " is not writable; disk caching in PostScript generator disabled.");
                file = null;
            }
        }
        this.pages = new Pages(this, file);
        this.info = new Info();
        this.fonts = new Fonts();
        this.images = new Images();
        this.spotColors = new SpotColors();
        this.names = new Names();
        this.bookmarks = new Bookmarks();
        this.patterns = new Patterns();
        this.curimage = null;
        this.currentPageBoundaries = this.pageboundaries;
        this.currentPrinterMarks = this.printermarks;
        this.currentDevice = this.pagedevice;
        this.setPageDeviceEntry("PageOffset", "[0 0]");
        this.setPageDeviceEntry("Margins", "[0 0]");
    }

    protected PSDocument(OutputStream outputStream, File file) throws IOException, FontConfigurationException {
        this(outputStream, file, new URLCache(), new DefaultErrorHandler());
    }

    private PSDocument(OutputStream outputStream, File file, URLCache uRLCache, ErrorHandler errorHandler) throws IOException, FontConfigurationException {
        this(outputStream, file, new FontCatalog(uRLCache, errorHandler), uRLCache, errorHandler);
    }

    private PSDocument(OutputStream outputStream, File file, FontCatalog fontCatalog, URLCache uRLCache, ErrorHandler errorHandler) throws IOException {
        this(outputStream, file, new ImageFactory(fontCatalog, uRLCache, errorHandler), fontCatalog, errorHandler);
    }

    public void setLanguageLevel(int n) {
        this.LANGUAGE_LEVEL = n;
    }

    public void setUnicodeAnnotations(boolean bl) {
        this.UNICODE_ANNOTATIONS = bl;
    }

    public void setCloneEps(boolean bl) {
        this.CLONE_EPS = bl;
    }

    public void setDestinationTreatment(boolean bl) {
        this.DROP_UNUSED_DESTINATIONS = bl;
    }

    public void setImageInlineThreshold(int n) {
        this.IMAGE_INLINE_THRESHOLD = n;
    }

    public void setInfo(String string, String string2) {
        this.info.set(string, string2);
    }

    public void setCustomComment(String string, String string2) {
        if (this.pages.currentPage == null) {
            this.setDocumentLevelComment(string, string2);
        } else {
            this.pages.currentPage.setPageLevelComment(string, string2);
        }
    }

    public void setDocumentLevelComment(String string, String string2) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        string2 = PSDocument.handlePSCommentValue(string2, "%%");
        this.documentLevelComments.put(string, string2);
    }

    public void setPageLabel(String string) {
        this.pages.currentPage.id.setId(string);
    }

    public void setPageDeviceEntry(String string, String string2) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        this.currentDevice.put(string, string2);
        this.pageDeviceEntries.put(string, string);
    }

    public String handleCommentString(String string) {
        String string2 = "";
        return string2;
    }

    public String getPageDeviceEntry(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return (String)this.currentDevice.get(string);
    }

    public void setPageBoundaryEntry(String string, Object object) {
        this.currentPageBoundaries.put(string, object);
    }

    public Hashtable getPageBoundaries() {
        return this.currentPageBoundaries;
    }

    public void setPrinterMarkEntry(String string) {
        this.currentPrinterMarks.append(string);
    }

    public void endDocument() throws IOException {
        if (this.pages.length() == 0) {
            this.pages.insertBlankPage(0);
        }
        this.writeHeader();
        this.writeProlog();
        this.writeDocumentSetup();
        this.pages.write(this.out);
        this.writeTrailer();
        this.out.println("%%EOF");
        this.out.flush();
    }

    public void beginPage(float f, float f2, String string) throws IOException {
        if (this.pages.length() == 0) {
            this.firstPageHeight = f2;
        }
        this.pages.beginPage(string);
        this.out = this.pages.currentPage.contentStream;
        this.currentPageBoundaries = this.pages.currentPage.pageboundaries;
        this.currentPrinterMarks = this.pages.currentPage.printermarks;
        Pages.PageBoundaries pageBoundaries = new Pages.PageBoundaries(this.pageboundaries);
        float[] fArray = pageBoundaries.getMediaBoxOffset();
        float f3 = f + fArray[0] + fArray[2];
        float f4 = f2 + fArray[1] + fArray[3];
        String string2 = "[" + f3 + " " + f4 + "]";
        String string3 = (String)this.pagedevice.get("PageSize");
        if (string3 == null) {
            this.currentDevice = this.pagedevice;
            this.setPageDeviceEntry("PageSize", string2);
            this.currentDevice = this.pages.currentPage.pagedevice;
        } else {
            this.currentDevice = this.pages.currentPage.pagedevice;
            if (!string3.equals(string2)) {
                this.setPageDeviceEntry("PageSize", string2);
            }
        }
    }

    public void endPage() throws IOException {
        this.curimage = null;
        Pages.PageBoundaries pageBoundaries = new Pages.PageBoundaries(this.currentPageBoundaries);
        Pages.PageBoundaries pageBoundaries2 = new Pages.PageBoundaries(this.pageboundaries);
        String string = (String)this.pagedevice.get("PageSize");
        if (this.currentDevice.containsKey("PageSize")) {
            string = (String)this.currentDevice.get("PageSize");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        string2 = string2.substring(1);
        String string3 = stringTokenizer.nextToken();
        string3 = string3.substring(0, string3.length() - 1);
        float[] fArray = pageBoundaries2.getMediaBoxOffset();
        if (pageBoundaries.isMediaBoxOffset()) {
            fArray = pageBoundaries.getMediaBoxOffset();
        }
        float f = new Float(string2).floatValue();
        float f2 = new Float(string3).floatValue();
        boolean bl = pageBoundaries.isPageOffset();
        if (pageBoundaries2.isPageOffset() && this.currentDevice.containsKey("PageSize")) {
            bl = true;
        }
        if (bl) {
            string = "[" + (f += fArray[0] + fArray[2]) + " " + (f2 += fArray[1] + fArray[3]) + "]";
            this.currentDevice.put("PageSize", string);
        }
        if (pageBoundaries2.isPageOffset() || pageBoundaries.isPageOffset()) {
            Object object;
            float f3;
            float[] fArray2 = pageBoundaries2.getBleeds();
            if (pageBoundaries.isBleeds()) {
                fArray2 = pageBoundaries.getBleeds();
            }
            this.out.println("grestore");
            this.out.println("gsave");
            this.out.println("newpath");
            this.out.println("0 0 moveto");
            this.out.println("0 " + string3 + " lineto");
            this.out.println(string2 + " " + string3 + " lineto");
            this.out.println(string2 + " 0 lineto");
            this.out.println("closepath");
            this.out.println("clippath");
            this.out.println("" + (fArray[0] - fArray2[0]) + " " + (fArray[1] - fArray2[1]) + " moveto");
            this.out.println("" + (f - fArray[2] + fArray2[2]) + " " + (fArray[1] - fArray2[1]) + " lineto");
            this.out.println("" + (f - fArray[2] + fArray2[2]) + " " + (f2 - fArray[3] + fArray2[3]) + " lineto");
            this.out.println("" + (fArray[0] - fArray2[0]) + " " + (f2 - fArray[3] + fArray2[3]) + " lineto");
            this.out.println("closepath");
            this.out.println("clip");
            this.out.println("newpath");
            if (pageBoundaries.isBleedMarkWidth() || pageBoundaries2.isBleedMarkWidth()) {
                f3 = pageBoundaries2.getBleedMarkWidth();
                if (pageBoundaries.isBleedMarkWidth()) {
                    f3 = pageBoundaries.getBleedMarkWidth();
                }
                this.drawMarks(fArray, fArray2, f3, f, f2);
            }
            if (pageBoundaries.isCropMarkWidth() || pageBoundaries2.isCropMarkWidth()) {
                f3 = pageBoundaries2.getCropMarkWidth();
                if (pageBoundaries.isCropMarkWidth()) {
                    f3 = pageBoundaries.getCropMarkWidth();
                }
                object = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                this.drawMarks(fArray, (float[])object, f3, f, f2);
            }
            Enumeration enumeration = this.currentPrinterMarks.elements();
            if (!this.printermarks.isEmpty()) {
                enumeration = this.printermarks.elements();
            }
            while (enumeration.hasMoreElements()) {
                String string4;
                object = (String)enumeration.nextElement();
                XMLReader xMLReader = null;
                try {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
                catch (SAXException sAXException) {
                    this.errorHandler.error("Cannot create XML reader: " + sAXException.getMessage());
                    continue;
                }
                StringWriter stringWriter = new StringWriter();
                Base64OutputStream base64OutputStream = new Base64OutputStream(stringWriter);
                try {
                    string4 = String.valueOf(f) + "pt";
                    String string5 = String.valueOf(f2) + "pt";
                    xMLReader.setContentHandler(new ImageSizeSetterHandler(new Serializer(base64OutputStream), string4, string5));
                }
                catch (IOException iOException) {
                    this.errorHandler.error("Cannot constructs serializer from an output stream: " + iOException.getMessage());
                    continue;
                }
                stringWriter.write("data:image/svg+xml;base64,");
                try {
                    xMLReader.parse((String)object);
                    ((OutputStream)base64OutputStream).close();
                    stringWriter.close();
                }
                catch (IOException iOException) {
                    this.errorHandler.warning("Invalid URL or non-existent file: " + (String)object + "; setting ignored");
                    continue;
                }
                catch (SAXException sAXException) {
                    this.errorHandler.error("Cannot parse a document: " + sAXException.getMessage());
                    continue;
                }
                string4 = stringWriter.toString();
                try {
                    this.placeImage(new URLSpec(string4), "image/svg+xml");
                }
                catch (IOException iOException) {
                    this.errorHandler.error("Invalid URL or non-existent file: " + string4);
                }
            }
            this.out.println("grestore");
        }
        this.pages.endPage();
        this.out = this.targetStream;
        this.currentDevice = this.pagedevice;
        this.currentPageBoundaries = this.pageboundaries;
        this.currentPrinterMarks = this.printermarks;
    }

    public void drawMarks(float[] fArray, float[] fArray2, float f, float f2, float f3) {
        try {
            this.out.println("0.0 0.0 0.0 setrgbcolor");
            this.out.println("" + f + " setlinewidth");
            this.out.println("newpath");
            this.out.println("" + (fArray[0] - fArray2[0]) + " " + (fArray[1] - fArray2[1]) + " moveto");
            this.out.println("0 " + (fArray[1] - fArray2[1]) + " lineto");
            this.out.println("stroke");
            this.out.println("newpath");
            this.out.println("" + (fArray[0] - fArray2[0]) + " " + (fArray[1] - fArray2[0]) + " moveto");
            this.out.println("" + (fArray[0] - fArray2[0]) + " 0 lineto");
            this.out.println("stroke");
            this.out.println("0.0 0.0 0.0 setrgbcolor");
            this.out.println("" + f + " setlinewidth");
            this.out.println("newpath");
            this.out.println("" + (fArray[0] - fArray2[0]) + " " + (f3 - fArray[3] + fArray2[3]) + " moveto");
            this.out.println("0 " + (f3 - fArray[3] + fArray2[3]) + " lineto");
            this.out.println("stroke");
            this.out.println("newpath");
            this.out.println("" + (fArray[0] - fArray2[0]) + " " + (f3 - fArray[3] + fArray2[3]) + " moveto");
            this.out.println("" + (fArray[0] - fArray2[0]) + " " + f3 + " lineto");
            this.out.println("stroke");
            this.out.println("0.0 0.0 0.0 setrgbcolor");
            this.out.println("" + f + " setlinewidth");
            this.out.println("newpath");
            this.out.println("" + (f2 - fArray[2] + fArray2[2]) + " " + (f3 - fArray[3] + fArray2[3]) + " moveto");
            this.out.println("" + f2 + " " + (f3 - fArray[3] + fArray2[3]) + " lineto");
            this.out.println("stroke");
            this.out.println("newpath");
            this.out.println("" + (f2 - fArray[2] + fArray2[2]) + " " + (f3 - fArray[3] + fArray2[3]) + " moveto");
            this.out.println("" + (f2 - fArray[2] + fArray2[2]) + " " + f3 + " lineto");
            this.out.println("stroke");
            this.out.println("0.0 0.0 0.0 setrgbcolor");
            this.out.println("" + f + " setlinewidth");
            this.out.println("newpath");
            this.out.println("" + (f2 - fArray[2] + fArray2[2]) + " " + (fArray[1] - fArray2[1]) + " moveto");
            this.out.println("" + f2 + " " + (fArray[1] - fArray2[1]) + " lineto");
            this.out.println("stroke");
            this.out.println("newpath");
            this.out.println("" + (f2 - fArray[2] + fArray2[1]) + " " + (fArray[1] - fArray2[1]) + " moveto");
            this.out.println("" + (f2 - fArray[2] + fArray2[1]) + " 0 lineto");
            this.out.println("stroke");
        }
        catch (IOException iOException) {
            this.errorHandler.warning("Cannot draw printer marks " + iOException.getMessage());
        }
    }

    public void setFont(FontDescriptor fontDescriptor, float f, float f2) throws IOException {
        this.setFont(fontDescriptor, f, f2, 0);
    }

    public void setFont(FontDescriptor fontDescriptor, float f, float f2, int n) throws IOException {
        if (fontDescriptor == null) {
            return;
        }
        this.fontSize = f;
        if (f == 0.0f) {
            return;
        }
        String string = this.fonts.getPSFontName(fontDescriptor, n);
        if (f2 == 1.0f && fontDescriptor.record.extraSlantAngle == 0.0) {
            this.out.println("/" + string + " " + f + " selectfont");
        } else {
            float f3 = (float)Math.tan(fontDescriptor.record.extraSlantAngle * (Math.PI / 180));
            this.out.println("/" + string + " [" + f * f2 + " 0 " + f * f3 + " " + f + " 0 0] selectfont");
        }
    }

    public void placeImage(URLSpec uRLSpec, String string) throws IOException {
        try {
            this.placeImage(this.imageFactory.makeImage(uRLSpec, string), true);
        }
        catch (MalformedURLException malformedURLException) {
            this.errorHandler.exception("Bad image file URL", malformedURLException);
        }
        catch (ImageFormatException imageFormatException) {
            this.errorHandler.exception("Cannot parse image file", imageFormatException);
        }
        catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
            this.errorHandler.error("Unknown MIME type: " + string);
        }
    }

    public void placeImage(com.renderx.graphics.Image image, boolean bl) throws IOException {
        if (this.CLONE_EPS && image instanceof EPSImage) {
            EPS ePS = new EPS((EPSImage)image);
            this.out.println("BeginEPSF");
            this.out.println("" + (float)(-ePS.bbox[0]) + " " + (float)(-ePS.bbox[1]) + " translate");
            ePS.writeEPS(this.out);
            this.out.println("EndEPSF");
        } else {
            try {
                String string = this.images.addImgAndReturnId(image, this, bl);
                this.out.println("ImageForm" + string + " execform");
            }
            catch (ImageFormatException imageFormatException) {
                this.errorHandler.exception("Error parsing image", imageFormatException);
            }
            catch (InternalException internalException) {
                this.errorHandler.warning("" + internalException);
            }
        }
    }

    public void addNamedDestination(String string, float f, float f2) throws IOException {
        string = this.names.makePSName(string);
        this.names.addDestination(string, this.pages.currentPageNumber, f, f2);
    }

    public void addLocalLink(float f, float f2, float f3, float f4, String string) throws IOException {
        string = this.names.makePSName(string);
        this.names.markUsed(string);
        this.out.println("[/Subtype /Link");
        this.out.println("/Rect [" + f + " " + f2 + " " + f3 + " " + f4 + "]");
        this.out.println("/Border [0 0 0 [0]]");
        this.out.println("/Dest /" + string);
        this.out.println("/ANN pdfmark");
    }

    public void addWebLink(float f, float f2, float f3, float f4, String string, boolean bl) throws IOException {
        this.out.println("[/Subtype /Link");
        this.out.println("/Rect [" + f + " " + f2 + " " + f3 + " " + f4 + "]");
        this.out.println("/Border [0 0 0 [0]]");
        this.out.createAction(string, bl);
        this.out.println("/ANN pdfmark");
    }

    public void addTextAnnotation(float f, float f2, float f3, float f4, String string, String string2, float[] fArray) throws IOException {
        this.out.println("[/Subtype /Text");
        this.out.println("/Rect [" + f + " " + f2 + " " + f3 + " " + f4 + "]");
        this.out.println("/Border [0 0 0 [0]]");
        if (fArray != null && fArray.length == 3) {
            this.out.println("/Color [" + fArray[0] + " " + fArray[1] + " " + fArray[2] + "]");
        }
        if (string2 != null) {
            this.out.print("/Title ");
            this.out.print_annotation(string2, 255);
            this.out.println();
        }
        this.out.print("/Contents ");
        this.out.print_annotation(string, 65535);
        this.out.println();
        this.out.println("/ANN pdfmark");
    }

    public void addLocalBookmark(String string, int n, int n2, String string2, boolean bl) throws IOException {
        string2 = this.names.makePSName(string2);
        this.bookmarks.addBookmark(string, n, n2, string2, null, bl, false);
        this.names.markUsed(string2);
    }

    public void addWebBookmark(String string, int n, int n2, String string2, boolean bl, boolean bl2) throws IOException {
        this.bookmarks.addBookmark(string, n, n2, null, string2, bl, bl2);
    }

    public void transform(float f, float f2, float f3, float f4, float f5, float f6) throws IOException {
        this.out.println("[" + f + " " + f2 + " " + f3 + " " + f4 + " " + f5 + " " + f6 + "] concat");
    }

    public void scale(float f, float f2) throws IOException {
        if (f == 1.0f && f2 == 1.0f) {
            return;
        }
        this.out.println("" + f + " " + f2 + " scale");
    }

    public void rotate(float f) throws IOException {
        if (f == 0.0f) {
            return;
        }
        this.out.println("" + f + " rotate");
    }

    public void translate(float f, float f2) throws IOException {
        if (f == 0.0f && f2 == 0.0f) {
            return;
        }
        this.out.println("" + f + " " + f2 + " translate");
    }

    public void moveTo(float f, float f2) throws IOException {
        this.out.println("" + f + " " + f2 + " moveto");
    }

    public void lineTo(float f, float f2) throws IOException {
        this.out.println("" + f + " " + f2 + " lineto");
    }

    public void line(float f, float f2, float f3, float f4, float f5) throws IOException {
        this.setLineWidth(f5);
        this.moveTo(f, f2);
        this.lineTo(f3, f4);
    }

    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) throws IOException {
        this.out.println("" + f + " " + f2 + " " + f3 + " " + f4 + " " + f5 + " " + f6 + " curveto");
    }

    public void rectangleFill(float f, float f2, float f3, float f4) throws IOException {
        this.out.println("" + f + " " + f2 + " " + f3 + " " + f4 + " rectfill");
    }

    public void setCharSpacing(float f) {
        this.letterSpacing = f;
    }

    public void setWordSpacing(float f) {
        this.wordSpacing = f;
    }

    public void setFontSize(float f) {
        this.fontSize = f;
        this.u28.resetFont();
    }

    public void setFontStretch(float f) {
        this.fontStretch = f;
        this.u28.resetFont();
    }

    public void show(String string, FontDescriptor fontDescriptor, int n) throws IOException {
        if (string == null || string.length() == 0 || this.fontSize == 0.0f) {
            return;
        }
        new PSText(string, this.letterSpacing, this.wordSpacing, this.textRenderMode).write(this.out);
    }

    public void gsave() throws IOException {
        this.out.println("gsave");
    }

    public void grestore() throws IOException {
        this.out.println("grestore");
    }

    public void setDash(float f, float f2, float f3) throws IOException {
        String string = "";
        string = f == 0.0f && f2 == 0.0f ? "[] " : "[" + f + " " + f2 + "]";
        this.out.println(string + " " + f3 + " setdash");
    }

    public void setLineCap(int n) throws IOException {
        if (n < 0 || n > 2) {
            this.errorHandler.warning("Wrong line cap style: " + n);
            return;
        }
        this.out.println("" + n + " setlinecap");
    }

    public void setLineWidth(float f) throws IOException {
        if ((double)f < 0.0) {
            this.errorHandler.warning("Wrong line width: " + f);
            return;
        }
        this.out.println("" + f + " setlinewidth");
    }

    public void setCMYKColor(float f, float f2, float f3, float f4) throws IOException {
        if (this.pages.currentPage != null || this.curimage != null) {
            this.out.println("" + f + " " + f2 + " " + f3 + " " + f4 + " setcmykcolor");
        }
    }

    public void setRGBColor(float f, float f2, float f3) throws IOException {
        if (this.pages.currentPage != null || this.curimage != null) {
            this.out.println("" + f + " " + f2 + " " + f3 + " setrgbcolor");
        }
    }

    public void setGrayColor(float f) throws IOException {
        if (this.pages.currentPage != null || this.curimage != null) {
            this.out.println("" + f + " setgray");
        }
    }

    public void setSpotColor(float f, String string, float[] fArray) throws IOException {
        String string2 = this.spotColors.getPSSpotColorName(string, fArray);
        if (string2 == null) {
            this.spotColors.addSpotColor(string, fArray);
            string2 = this.spotColors.getPSSpotColorName(string, fArray);
        }
        if (this.pages.currentPage != null || this.curimage != null) {
            this.out.print("/" + string2 + " /ColorSpace findresource " + "setcolorspace");
            this.out.println(" " + f + " setcolor");
        }
    }

    public void setPattern(PaintServer paintServer) throws IOException, ImageFormatException {
        Object object;
        if (this.LANGUAGE_LEVEL < 3) {
            if (!this.unsupportedPatternWarning && this.errorHandler != null) {
                this.errorHandler.warning("PostScript level " + this.LANGUAGE_LEVEL + " does not support" + " patterns and gradients; feature ignored.");
            }
            this.unsupportedPatternWarning = true;
            return;
        }
        String string = this.patterns.getPSPatternName(paintServer);
        if (string == null) {
            this.patterns.addPattern(paintServer);
            string = this.patterns.getPSPatternName(paintServer);
            if (paintServer instanceof Pattern) {
                object = ((Pattern)paintServer).content;
                ImageTree imageTree = new ImageTree(0.0, 0.0, ((Pattern)paintServer).xstep, ((Pattern)paintServer).ystep);
                imageTree.root = object;
                Image.SubTreeVectorImage subTreeVectorImage = new Image.SubTreeVectorImage(imageTree);
                subTreeVectorImage.supportsVectorRendering = true;
                this.images.addImgAndReturnId(subTreeVectorImage, this, false);
                ((Pattern)paintServer).content = new GraphicGroup();
                ((Pattern)paintServer).content.append(new ExternalImage(subTreeVectorImage));
            }
        }
        object = paintServer.matrix;
        this.out.print("/" + string + " /Pattern findresource ");
        this.out.print("[" + object[0] + " " + object[1] + " " + object[2] + " " + object[3] + " " + object[4] + " " + object[5] + "]");
        this.out.println(" makepattern setpattern");
    }

    public void setOverprintFlag(String string) throws IOException {
        if (null == string) {
            return;
        }
        boolean bl = "true".equals(string);
        this.out.println(bl + " setoverprint");
    }

    public void rectclip(float f, float f2, float f3, float f4) throws IOException {
        this.out.println("" + f + " " + f2 + " " + f3 + " " + f4 + " rectclip");
    }

    public void newpath() throws IOException {
        this.out.println("newpath");
    }

    public void closePath() throws IOException {
        this.out.println("closepath");
    }

    public void fill() throws IOException {
        this.out.println("fill");
    }

    public void stroke() throws IOException {
        this.out.println("stroke");
    }

    public void setTextPos(float f, float f2) throws IOException {
        this.moveTo(f, f2);
    }

    private void writeHeader() throws IOException {
        Object object;
        this.out.println("%!PS-Adobe-" + (this.LANGUAGE_LEVEL == 2 ? "2.1" : "3.0"));
        this.info.writeHeaderComment(this.out, "Title");
        this.info.writeHeaderComment(this.out, "Creator");
        this.out.println("%%Pages: " + this.pages.length());
        if (this.DOCUMENT_MANAGER_COMMENTS) {
            FontDescriptor fontDescriptor;
            object = this.u28.fontStateTable;
            boolean bl = true;
            Enumeration enumeration = ((Hashtable)object).keys();
            while (enumeration.hasMoreElements()) {
                fontDescriptor = (FontDescriptor)((Hashtable)object).get(enumeration.nextElement());
                if (fontDescriptor.record.embed) continue;
                this.out.print(bl ? "%%DocumentNeededResources: " : "%%+ ");
                this.out.println("font " + fontDescriptor.record.getMetric().fontName);
                bl = false;
            }
            bl = true;
            enumeration = ((Hashtable)object).keys();
            while (enumeration.hasMoreElements()) {
                fontDescriptor = (FontDescriptor)((Hashtable)object).get(enumeration.nextElement());
                if (!fontDescriptor.record.embed) continue;
                this.out.print(bl ? "%%DocumentSuppliedResources: " : "%%+ ");
                this.out.println("font " + fontDescriptor.record.getMetric().fontName);
                bl = false;
            }
        }
        object = this.documentLevelComments.keys();
        while (object.hasMoreElements()) {
            String string = (String)this.documentLevelComments.get(object.nextElement());
            if (string == null) continue;
            this.out.println(string);
        }
        this.out.println("%%EndComments");
    }

    private void writeDocumentSetup() throws IOException {
        this.out.println("%%BeginSetup");
        Hashtable hashtable = this.u28.fontStateTable;
        if (this.DOCUMENT_MANAGER_COMMENTS) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                FontDescriptor fontDescriptor = (FontDescriptor)hashtable.get(enumeration.nextElement());
                if (fontDescriptor.record.embed) continue;
                this.out.println("%%IncludeResource: font " + fontDescriptor.record.getMetric().fontName);
            }
        }
        this.images.write(this.out);
        this.patterns.write(this.out);
        this.fonts.write(this.out, hashtable);
        this.spotColors.write(this.out);
        this.info.writePDFMarks(this.out);
        this.writeDocView();
        this.names.write(this.out, this.DROP_UNUSED_DESTINATIONS);
        this.bookmarks.write(this.out);
        this.writePageDevice();
        this.out.println("%%EndSetup");
    }

    void writePageDevice() throws IOException {
        String string;
        int n = this.pageDeviceEntries.size();
        this.out.println("/XEPPS_BackupPageDevice " + n + " dict");
        Enumeration enumeration = this.pageDeviceEntries.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.out.println("dup /" + string + " dup currentpagedevice exch known {dup currentpagedevice exch get put} {pop pop} ifelse ");
        }
        this.out.println("def");
        this.out.println("" + this.pagedevice.size() + " dict");
        enumeration = this.pagedevice.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string2 = (String)this.pagedevice.get(string);
            this.out.println("dup /" + string + " " + string2 + " put");
        }
        this.out.println("SafeSetPageDevice");
        this.out.println("/XEPPS_DocumentPageDevice " + n + " dict");
        enumeration = this.pageDeviceEntries.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.out.println("dup /" + string + " dup currentpagedevice exch known {dup currentpagedevice exch get put} {pop pop} ifelse ");
        }
        this.out.println("def");
    }

    void writeDocView() throws IOException {
        if (this.viewMode == null || "auto".equals(this.viewMode)) {
            String string = this.viewMode = this.bookmarks.isEmpty() ? "show-none" : "show-bookmarks";
        }
        if ("show-bookmarks".equals(this.viewMode)) {
            this.out.println("[/PageMode /UseOutlines");
        } else if ("show-thumbnails".equals(this.viewMode)) {
            this.out.println("[/PageMode /UseThumbs");
        } else if ("show-none".equals(this.viewMode)) {
            this.out.println("[/PageMode /UseNone");
        } else if ("full-screen".equals(this.viewMode)) {
            this.out.println("[/PageMode /FullScreen");
        } else {
            this.out.println("[/PageMode /UseNone");
            this.errorHandler.warning("Wrong value for view mode: " + this.viewMode + "; parameter ignored");
        }
        Names.Destination destination = null;
        if (this.initialDestination != null && (destination = this.names.getDestination(this.initialDestination)) == null) {
            this.errorHandler.warning("Unresolved initial destination: '" + this.initialDestination + "'; parameter ignored");
        }
        if (destination != null || this.zoom != null) {
            if (destination == null) {
                destination = new Names.Destination(1, 0.0f, this.firstPageHeight);
            }
            this.out.println("/Page " + destination.page);
            if (this.zoom == null) {
                this.zoom = "auto";
            }
            this.zoom = this.zoom.trim();
            if ("fit".equals(this.zoom)) {
                this.out.println("/View [/Fit]");
            } else if ("fit-width".equals(this.zoom)) {
                this.out.println("/View [/FitH " + destination.y + "]");
            } else if ("fit-height".equals(this.zoom)) {
                this.out.println("/View [/FitV " + destination.x + "]");
            } else {
                float f = 0.0f;
                try {
                    f = this.zoom.equals("auto") ? 0.0f : (this.zoom.endsWith("%") ? Float.valueOf(this.zoom.substring(0, this.zoom.length() - 1)).floatValue() / 100.0f : Float.valueOf(this.zoom).floatValue());
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorHandler.warning("Wrong value for zoom factor: " + this.zoom + "; parameter ignored");
                    f = 0.0f;
                }
                this.out.println("/View [/XYZ " + destination.x + " " + destination.y + " " + f + "]");
            }
        }
        this.out.println("/DOCVIEW pdfmark ");
    }

    public void writeProlog() throws IOException {
        this.out.println("%%BeginProlog");
        this.out.println("%%BeginResource: procset Common_XEP_procedures");
        this.out.println("/REENCODEFONT {\n  /Enc exch def findfont dup length dict copy\n  dup /Encoding Enc put definefont pop\n} bind def");
        this.out.println("/BeginEPSF {\n  /b4_Inc_state save def\n  /dict_count countdictstack def\n  /op_count count 1 sub def\n  userdict begin\n  /showpage { } def\n  0 setgray 0 setlinecap\n  1 setlinewidth 0 setlinejoin\n  10 setmiterlimit [ ] 0 setdash newpath\n  /languagelevel where\n  { pop languagelevel 1 ne\n    {false setstrokeadjust false setoverprint\n    } if\n  } if\n} bind def");
        this.out.println("/EndEPSF {\n  count op_count sub {pop} repeat\n  countdictstack dict_count sub {end} repeat\n  b4_Inc_state restore\n} bind def");
        this.out.println("/pdfmark where {pop} {userdict /pdfmark /cleartomark load put} ifelse");
        this.out.println("/CreateDataArray {\n  /temp exch def\n  [\n  {\n    temp 16384 string readstring\n    not { exit } if\n  } loop\n  dup length 0 eq { pop } if\n  ]\n} bind def");
        this.out.println("/EqualArray {\n  /array2 exch def\n  /array1 exch def\n  /lenarray array1 length def\n  lenarray array2 length ne {false} {\n    true\n    0 1 lenarray 1 sub {\n      /idxarr exch def\n      array1 idxarr get array2 idxarr get ne {pop false exit} if\n    } for\n  } ifelse\n} bind def");
        this.out.println("/EqualDict {\n  /dict2 exch def\n  /dict1 exch def\n  /lendict dict1 length def\n  lendict dict2 length ne {false} {\n    true\n    dict1 {\n      exch dict2 exch get ne {pop false exit} if\n    } forall \n  } ifelse\n} bind def");
        this.out.println("/DeepEqual {\n  /obj2 exch def\n  /obj1 exch def\n  obj1 obj2 eq {true} {\n    obj1 type obj2 type ne {false} {\n      obj1 type /dicttype eq {\n        obj1 obj2 EqualDict\n      } {\n        obj1 type /arraytype eq {\n          obj1 obj2 EqualArray\n        } {false} ifelse\n      } ifelse\n    } ifelse\n  } ifelse\n} bind def");
        this.out.println("/SafeSetPageDevice {\n  dup length /safedict exch dict def \n  {\n    /devicevalue exch def\n    /devicekey exch def\n    currentpagedevice devicekey known {\n      currentpagedevice devicekey get devicevalue DeepEqual not {\n        safedict devicekey devicevalue put\n      } if\n    } if\n  } forall\n  safedict length 0 ne { safedict setpagedevice} if\n} bind def");
        this.out.println("%%EndResource");
        this.out.println("%%EndProlog");
    }

    public void writeTrailer() throws IOException {
        this.out.println("%%Trailer");
        this.out.println("XEPPS_BackupPageDevice SafeSetPageDevice");
    }

    public static String handlePSCommentValue(String string, String string2) throws IllegalArgumentException {
        String string3 = "";
        String string4 = "%";
        if (string2 == null) {
            throw new IllegalArgumentException("Null symb argument");
        }
        if (string == null) {
            throw new IllegalArgumentException("Null value argument");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Void value argument");
        }
        int n = string.indexOf(string4);
        while (n > -1) {
            string = n != string.length() - 1 ? string.substring(0, n) + string.substring(n + 1) : string.substring(0, n);
            n = string.indexOf(string4);
        }
        if (!string.equals("")) {
            string3 = string.substring(0, 1).toUpperCase() + string.substring(1);
            string3 = string2 + string3;
        }
        return string3;
    }

    class ImageSizeSetterHandler
    implements ContentHandler {
        private final ContentHandler parent;
        private final String height;
        private final String width;

        ImageSizeSetterHandler(ContentHandler contentHandler, String string, String string2) {
            this.parent = contentHandler;
            this.height = string2;
            this.width = string;
        }

        public void startDocument() throws SAXException {
            this.parent.startDocument();
            AttributesImpl attributesImpl = new AttributesImpl();
            this.parent.startPrefixMapping("svg", "http://www.w3.org/2000/svg");
            attributesImpl.addAttribute("", "width", "width", "CDATA", this.width);
            attributesImpl.addAttribute("", "height", "height", "CDATA", this.height);
            this.parent.startElement("http://www.w3.org/2000/svg", "svg", "svg", attributesImpl);
        }

        public void endDocument() throws SAXException {
            this.parent.endElement("http://www.w3.org/2000/svg", "svg", "svg");
            this.parent.endPrefixMapping("svg");
            this.parent.endDocument();
        }

        public void setDocumentLocator(Locator locator) {
            this.parent.setDocumentLocator(locator);
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.parent.startPrefixMapping(string, string2);
        }

        public void endPrefixMapping(String string) throws SAXException {
            this.parent.endPrefixMapping(string);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.parent.startElement(string, string2, string3, attributes);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.parent.endElement(string, string2, string3);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.parent.characters(cArray, n, n2);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.parent.ignorableWhitespace(cArray, n, n2);
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            this.parent.processingInstruction(string, string2);
        }

        public void skippedEntity(String string) throws SAXException {
            this.parent.skippedEntity(string);
        }
    }

    public class PSU28
    extends U28 {
        PSU28() {
            super(PSDocument.this.fontCatalog);
        }

        protected void flushTextBuffer() throws IOException {
            if (this.itxt != 0) {
                if (!this.fontSpecified) {
                    PSDocument.this.setFont(this.curFont, PSDocument.this.fontSize, PSDocument.this.fontStretch, this.fontEncoding);
                    this.fontSpecified = true;
                }
                PSDocument.this.show(new String(this.txt, 0, this.itxt), this.curFont, this.fontEncoding);
                this.itxt = 0;
            }
        }

        protected boolean isOneByteText(FontRecord fontRecord) {
            switch (fontRecord.datatype) {
                case 2: {
                    return !fontRecord.embed;
                }
                case 1: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return false;
                }
            }
            throw new RuntimeException("Invalid data type in font record");
        }

        protected boolean isProcessAsUnicode(FontRecord fontRecord) {
            return false;
        }

        public void processMultiByteTextUnicode(String string) throws IOException {
            this.processMultiByteTextCID(string);
        }

        public void processMultiByteTextCID(String string) throws IOException {
            if (this.txt.length < string.length()) {
                this.txt = new char[string.length()];
            }
            Encoding encoding = null;
            if (!this.curFont.canExtend) {
                if (this.curFont.encodingTable.length() == 0) {
                    throw new RuntimeException("Empty encoding table in font descriptor");
                }
                encoding = (Encoding)this.curFont.encodingTable.get(this.fontEncoding);
            } else if (this.curFont.encodingTable.length() != 0) {
                try {
                    encoding = (Encoding)this.curFont.encodingTable.get(this.fontEncoding);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Wrong encoding is specified");
                }
            } else {
                encoding = new Encoding();
                this.curFont.encodingTable.put(0, encoding);
            }
            int n = 0;
            while (n < string.length()) {
                block16: {
                    int n2;
                    char c;
                    block14: {
                        int n3;
                        Encoding encoding2;
                        block17: {
                            CharMetrics charMetrics;
                            block18: {
                                block15: {
                                    c = string.charAt(n);
                                    n2 = encoding.getCode(c);
                                    if (n2 != -1) break block14;
                                    charMetrics = this.curFont.record.getMetric().ucm(c);
                                    if (charMetrics != null) break block15;
                                    charMetrics = this.curFont.record.getMetric().missingGlyph;
                                    if (charMetrics == null) break block16;
                                    c = charMetrics.uc;
                                    n2 = encoding.getCode(c);
                                }
                                if (n2 != -1) break block14;
                                encoding2 = null;
                                n3 = 0;
                                while (n3 < this.curFont.encodingTable.length()) {
                                    encoding2 = (Encoding)this.curFont.encodingTable.get(n3);
                                    if (encoding2 == null) {
                                        throw new RuntimeException("Null encoding in font descriptor");
                                    }
                                    n2 = encoding2.getCode(c);
                                    if (n2 != -1) break;
                                    ++n3;
                                }
                                if (n2 != -1) break block17;
                                if (this.curFont.canExtend) break block18;
                                this.curFont.hasUnmappedChars = true;
                                n3 = this.fontEncoding;
                                charMetrics = this.curFont.record.getMetric().missingGlyph;
                                if (charMetrics == null) break block16;
                                c = charMetrics.uc;
                                n2 = encoding.getCode(c);
                                break block17;
                            }
                            if (encoding2.hasRoom()) {
                                --n3;
                            } else {
                                encoding2 = new Encoding();
                                this.curFont.encodingTable.put(n3, encoding2);
                            }
                            n2 = encoding2.assignCode(c, charMetrics);
                        }
                        if (n3 != this.fontEncoding) {
                            this.flushTextBuffer();
                            this.fontSpecified = false;
                            this.fontEncoding = n3;
                            encoding = encoding2;
                        }
                    }
                    this.txt[this.itxt++] = (char)n2;
                    this.curFont.used.markGlyph(c);
                }
                ++n;
            }
            this.flushTextBuffer();
        }
    }
}

