/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import java.util.Enumeration;

public class Resources
extends PDFObject {
    final List fonts = new List();
    private final List images = new List();
    private final List spotcolors = new List();
    private final List extgstates = new List();
    private final List patterns = new List();
    private final Hashtable fonttable = new Hashtable();
    private final Hashtable imagetable = new Hashtable();
    private final Hashtable spotcolortable = new Hashtable();
    private final Hashtable extgstatetable = new Hashtable();
    private final Hashtable patterntable = new Hashtable();
    private Hashtable resourceTables = new Hashtable();

    Resources(IndirectObject indirectObject) {
        super(indirectObject);
        this.resourceTables.put("Font", this.fonts);
        this.resourceTables.put("XObject", this.images);
        this.resourceTables.put("ColorSpace", this.spotcolors);
        this.resourceTables.put("ExtGState", this.extgstates);
        this.resourceTables.put("Pattern", this.patterns);
    }

    void setType() {
    }

    void addFont(String string) {
        if (this.fonttable.get(string) != null) {
            return;
        }
        this.fonttable.put(string, string);
        this.fonts.append(string);
    }

    void addImage(String string) {
        if (this.imagetable.get(string) != null) {
            return;
        }
        this.imagetable.put(string, string);
        this.images.append(string);
    }

    void addSpotColor(String string) {
        if (this.spotcolortable.get(string) != null) {
            return;
        }
        this.spotcolortable.put(string, string);
        this.spotcolors.append(string);
    }

    void addExtGState(String string) {
        if (this.extgstatetable.get(string) != null) {
            return;
        }
        this.extgstatetable.put(string, string);
        this.extgstates.append(string);
    }

    void addPattern(String string) {
        if (this.patterntable.get(string) != null) {
            return;
        }
        this.patterntable.put(string, string);
        this.patterns.append(string);
    }

    void writeResource(String string, List list, PDFOutputStream pDFOutputStream) {
        if (!list.isEmpty()) {
            pDFOutputStream.print("/" + string + " <<");
            Enumeration enumeration = list.elements();
            while (enumeration.hasMoreElements()) {
                pDFOutputStream.println((String)enumeration.nextElement());
            }
            pDFOutputStream.println(">>");
        }
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.print("/ProcSet [/PDF");
        if (!this.images.isEmpty()) {
            pDFOutputStream.print(" /ImageC");
        }
        if (!this.fonts.isEmpty()) {
            pDFOutputStream.print(" /Text");
        }
        pDFOutputStream.println("]");
        this.writeResource("Font", this.fonts, pDFOutputStream);
        this.writeResource("XObject", this.images, pDFOutputStream);
        this.writeResource("ColorSpace", this.spotcolors, pDFOutputStream);
        this.writeResource("ExtGState", this.extgstates, pDFOutputStream);
        this.writeResource("Pattern", this.patterns, pDFOutputStream);
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
    }
}

