/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.fonts.CharMetrics;
import com.renderx.fonts.FontDescriptor;
import com.renderx.fonts.Metric;
import com.renderx.pdflib.CFFFontFile;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFFontFile;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.T1FontFile;
import com.renderx.pdflib.TTFontFile;
import java.util.StringTokenizer;

public class PDFFontDescriptor
extends PDFObject {
    PDFFontFile fontFile;
    FontDescriptor descriptor;
    boolean enableSubset;
    int flags;
    String fontName;
    CIDSet cidSet = null;

    PDFFontDescriptor(IndirectObject indirectObject, FontDescriptor fontDescriptor, String string, int n, boolean bl) {
        super(indirectObject);
        this.descriptor = fontDescriptor;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.fontName = "";
        while (stringTokenizer.hasMoreTokens()) {
            this.fontName = this.fontName + stringTokenizer.nextToken();
        }
        this.flags = n;
        this.enableSubset = bl;
    }

    String getType() {
        return "FontDescriptor";
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        Metric metric = this.descriptor.record.getMetric();
        pDFOutputStream.println("/FontName /" + this.fontName);
        pDFOutputStream.println("/Ascent " + PDFOutputStream.pdf_float(metric.ascender));
        pDFOutputStream.println("/Descent " + PDFOutputStream.pdf_float(metric.descender));
        pDFOutputStream.println("/CapHeight " + PDFOutputStream.pdf_float(metric.capHeight));
        pDFOutputStream.println("/Flags " + this.flags);
        pDFOutputStream.println("/FontBBox [" + PDFOutputStream.pdf_float(metric.fontBBox[0]) + " " + PDFOutputStream.pdf_float(metric.fontBBox[1]) + " " + PDFOutputStream.pdf_float(metric.fontBBox[2]) + " " + PDFOutputStream.pdf_float(metric.fontBBox[3]) + "]");
        pDFOutputStream.println("/ItalicAngle " + PDFOutputStream.pdf_float(metric.italicAngle));
        pDFOutputStream.println("/StemV " + PDFOutputStream.pdf_float(metric.stdVW));
        if (metric.stdHW != Float.MIN_VALUE) {
            pDFOutputStream.println("/StemH " + PDFOutputStream.pdf_float(metric.stdHW));
        }
        if (metric.xHeight != Float.MIN_VALUE) {
            pDFOutputStream.println("/XHeight " + PDFOutputStream.pdf_float(metric.xHeight));
        }
        if (this.descriptor.record.embed) {
            if (this.descriptor.record.datatype == 2) {
                if (pDFOutputStream.doc.hasPDFA()) {
                    this.cidSet = new CIDSet(pDFOutputStream.getNextID());
                    pDFOutputStream.println("/CIDSet " + this.cidSet.getID().toStringR());
                }
                this.fontFile = new TTFontFile(pDFOutputStream.getNextID(), this.descriptor, this.enableSubset);
            } else if (this.descriptor.record.datatype == 3 || this.descriptor.record.datatype == 4) {
                this.fontFile = new CFFFontFile(pDFOutputStream.getNextID(), this.descriptor, this.enableSubset);
            } else if (this.descriptor.record.datatype == 1) {
                this.fontFile = new T1FontFile(pDFOutputStream.getNextID(), this.descriptor, this.enableSubset);
            }
            pDFOutputStream.println("/" + this.fontFile.pdfFontType() + " " + this.fontFile.getID().toStringR());
        }
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        if (this.descriptor.record.embed) {
            if (this.cidSet != null) {
                this.cidSet.write(pDFOutputStream);
            }
            this.fontFile.write(pDFOutputStream);
        }
    }

    class CIDSet
    extends PDFObject {
        int length;
        IndirectObject length_id;
        private final byte[] reverseBits = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};

        CIDSet(IndirectObject indirectObject) {
            super(indirectObject);
        }

        void writeBody(PDFOutputStream pDFOutputStream) {
            this.length_id = pDFOutputStream.getNextID();
            pDFOutputStream.println("/Length " + this.length_id.toStringR());
            if (pDFOutputStream.compression) {
                pDFOutputStream.println("/Filter /FlateDecode");
            }
        }

        void writeTail(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.println(">>");
            pDFOutputStream.println("stream");
            int n = pDFOutputStream.size();
            pDFOutputStream.startStream();
            Metric metric = PDFFontDescriptor.this.descriptor.record.getMetric();
            byte[] byArray = new byte[(metric.numGlyphs - 1) / 8 + 1];
            int n2 = 0;
            while (n2 < 65536) {
                if (PDFFontDescriptor.this.descriptor.used.checkGlyph((char)n2)) {
                    CharMetrics charMetrics = (CharMetrics)metric.uniTable.get((char)n2);
                    int n3 = charMetrics.c / 8;
                    byArray[n3] = (byte)(byArray[n3] | this.reverseBits[charMetrics.c % 8]);
                }
                ++n2;
            }
            pDFOutputStream.print(byArray);
            pDFOutputStream.finishStream();
            this.length = pDFOutputStream.size() - n;
            pDFOutputStream.println("\nendstream");
            pDFOutputStream.println("endobj");
        }

        void writeSubObjects(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.printLength(this.length_id, this.length);
        }
    }
}

