/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.Media;
import com.renderx.graphics.ObjectRecordCoordinator;
import com.renderx.util.SeekableInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MP3
extends Media {
    public MP3() {
        this.mimetype = "audio/x-mp3";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse() throws IOException, ImageFormatException {
        this.canCopyData = true;
        SeekableInput seekableInput = this.openSeekableImageStream();
        try {
            try {
                seekableInput.seek(0L);
                byte[] byArray = new byte[3];
                seekableInput.readFully(byArray);
                if (!(byArray[0] == 73 && byArray[1] == 68 && byArray[2] == 51 || byArray[0] == -1 && (byArray[1] >= -30 && byArray[1] <= -25 || byArray[1] >= -14 && byArray[1] <= -9 || byArray[1] >= -6 && byArray[1] <= -1))) {
                    throw new ImageFormatException("Invalid MP3 signature in file '" + this.toDisplayString() + "'");
                }
                Object var4_4 = null;
            }
            catch (EOFException eOFException) {
                throw new ImageFormatException("Premature end of file or corrupt data in MP3 media " + this.toDisplayString(), this.mimetype);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
        this.setDimensions();
    }

    public void copyData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        InputStream inputStream = this.openImageStream();
        try {
            int n;
            byte[] byArray = new byte[objectRecordCoordinator != null ? objectRecordCoordinator.getRecordLength() : 8192];
            while ((n = inputStream.read(byArray)) != -1) {
                if (objectRecordCoordinator != null) {
                    objectRecordCoordinator.beginRecord(outputStream, n);
                }
                outputStream.write(byArray, 0, n);
                if (objectRecordCoordinator == null) continue;
                objectRecordCoordinator.endRecord(outputStream, n);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }
}

