package com.renderx.xepx.x4u.ct.charsetspanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

import com.renderx.xepx.x4u.ct.DOMWalker;
import com.renderx.xepx.x4u.ct.DomToTableModel;

/**
 * @author AlexanderR
 */


public class CharsetsPanel extends JPanel {

    private static final long serialVersionUID = -6622149119140306676L;

//   Font option variable
    public static String DEFAULTCHARSET = null;

    public static final String[] COMBO_VALUE  = {"unspecified", "true", "false"};
    public static final String[] NEW_COMMANDS = {"AddCodeRange","AddCharacterMapping","AddCharset","AddCodepage"};

    JTree fontsTree;

    protected DomToJTreeCharsetsAdapter domModel;
    Document doc;

    BorderLayout borderLayout1 = new BorderLayout();
    Border border1;
    JPanel parametersPanel = new JPanel();
    Border border2;
    TitledBorder titledBorder1;
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel treePanel = new JPanel();
    JPanel detailPanel = new JPanel();
    JScrollPane fontsScrollPane = new JScrollPane();
    JSplitPane jSplitPane1 = new JSplitPane();
    GridLayout gridLayout1 = new GridLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel commonPanel = new JPanel();
    JPanel commandPanel = new JPanel(); // = new JTable();
    CharsetNamePanel charsetNamePanel;
    JButton deleteButton = new JButton();
    
    JButton codepageButton = new JButton();
    JButton characterMappingButton = new JButton();
    JButton codeRangeButton = new JButton();
    JButton charsetButton = new JButton();
    
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    Border border3;
    TitledBorder titledBorder2;
    JPanel charsetPanel;
    CharsetParamsPanel charsetParamsPanel;
    
    JPanel fontsDataPanel = new JPanel();
    JScrollPane fontDetScrollPane = new JScrollPane();
    JTable charsetDetTable;///// = new JTable();
    GridLayout gridLayout2 = new GridLayout();
    
    //TODO check CharsetParamsPanel null
    TitledBorder titledBorder3;
    
    BorderLayout borderLayout4 = new BorderLayout();
    Border border4;
   
    JPanel aliasPanel = new JPanel();
    JScrollPane aliasScrollPane = new JScrollPane();
    JTable aliasTable;
    
    JPanel mappingPanel = new JPanel();
    JScrollPane mappingScrollPane = new JScrollPane();
    JTable mappingTable;

    Border border5;
    TitledBorder titledBorder4;
    GridLayout gridLayout3 = new GridLayout();
    Border border6;
    TitledBorder titledBorder5; // = new JTable();
    Element charsetNode = null;
    JPanel dataCommandsPanel = new JPanel();
    JButton deleteDataButton = new JButton();
    JButton addDataButton = new JButton();
    
    public CharsetsPanel(Document dw) {
      this.doc = dw;
      try {
        jbInit();
      }
      catch (Exception e) {
        e.printStackTrace();
      }
    }
    
    private void jbInit() throws Exception {
      border1 = new EtchedBorder(EtchedBorder.RAISED, Color.white, new Color(148, 145, 140));
      border2 = new EtchedBorder(EtchedBorder.RAISED, Color.white, new Color(148, 145, 140));
      titledBorder1 = new TitledBorder(new EtchedBorder(EtchedBorder.RAISED, Color.white,
                                                        new Color(148, 145, 140)), "Charsets");
      border3 = BorderFactory.createEmptyBorder();
      titledBorder2 = new TitledBorder(border3, "Common Attributes");
      border4 = BorderFactory.createEmptyBorder();
      titledBorder3 = new TitledBorder(border4, "Transformation");
      border5 = BorderFactory.createEmptyBorder();
      titledBorder4 = new TitledBorder(border5, "Font Aliases");
      border6 = BorderFactory.createEmptyBorder();
      titledBorder5 = new TitledBorder(border6, "Font data");

      this.setLayout(borderLayout1);
      parametersPanel.setBorder(titledBorder1);
      parametersPanel.setLayout(borderLayout2);
      detailPanel.setLayout(borderLayout3);
      treePanel.setPreferredSize(new Dimension(160, 250));
      treePanel.setLayout(gridLayout1);
      jSplitPane1.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
      jSplitPane1.setPreferredSize(new Dimension(350, 250));
      jSplitPane1.setDividerLocation(300);
      gridLayout1.setColumns(1);
      gridLayout1.setRows(0);
      commonPanel.setLayout(new BorderLayout());
           
      codeRangeButton.setActionCommand(NEW_COMMANDS[0]);
      codeRangeButton.setText("New Code Ranges");
      codeRangeButton.setEnabled(false);
      codeRangeButton.addActionListener(new java.awt.event.ActionListener()
      {
          public void actionPerformed(ActionEvent e)
          {
      		new_actionPerformed(e);
          }
      });
      characterMappingButton.setText("New Character Mapping");
      characterMappingButton.setActionCommand(NEW_COMMANDS[1]);
      characterMappingButton.setEnabled(false);
      characterMappingButton.addActionListener(new java.awt.event.ActionListener()
      {
          public void actionPerformed(ActionEvent e)
          {
      		new_actionPerformed(e);
          }
      });
      charsetButton.setText("New Charset");
      charsetButton.setActionCommand(NEW_COMMANDS[2]);
      charsetButton.addActionListener(new java.awt.event.ActionListener() 
      {
        public void actionPerformed(ActionEvent e) 
        {
          new_actionPerformed(e);
        }
      });
      codepageButton.setActionCommand(NEW_COMMANDS[3]);
      codepageButton.setText("New Code Page");
      codepageButton.setEnabled(false);
      codepageButton.addActionListener(new java.awt.event.ActionListener()
      {
	  public void actionPerformed(ActionEvent e)
	  {
	      new_actionPerformed(e);
	  }
      });

      deleteButton.setText("Delete Node");
      deleteButton.addActionListener(new java.awt.event.ActionListener() 
      {
        public void actionPerformed(ActionEvent e) 
        {
          deleteButton_actionPerformed(e);
        }
      });

      commonPanel.setBorder(titledBorder2);

      fontsDataPanel.setLayout(gridLayout2);
      gridLayout2.setColumns(1);
      gridLayout2.setRows(0);
      
      charsetPanel = new JPanel();
      charsetParamsPanel = new CharsetParamsPanel(this);
      charsetPanel.setLayout(borderLayout4);
      charsetPanel.setVisible(false);


      aliasPanel.setVisible(false);
      mappingPanel.setVisible(false);
      fontsDataPanel.setBorder(titledBorder5);

      deleteDataButton.setText("Delete");
      deleteDataButton.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(ActionEvent e) {
          deleteDataButton_actionPerformed(e, (Element) charsetNode);
        }
      });
      addDataButton.setText("Add");
      addDataButton.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(ActionEvent e) {
          addDataButton_actionPerformed(e, (Element) charsetNode);
        }
      });
      this.add(parametersPanel, BorderLayout.CENTER);
      parametersPanel.add(jSplitPane1, BorderLayout.CENTER);
      jSplitPane1.add(treePanel, JSplitPane.TOP);
      treePanel.add(fontsScrollPane, null);
      
      if(DOMWalker.chrRoot == null)
      {
	  JOptionPane.showMessageDialog(new JFrame(), "Not found <charsets> element in xep.xml, please add it into <generator-options format=\"AFP\"> element manually", 
		  "Notify", JOptionPane.OK_OPTION);
      }
      domModel = new DomToJTreeCharsetsAdapter(this, this.doc, DOMWalker.chrRoot);
      fontsTree = new JTree(domModel); //new DomToTreeModelAdapter());
      fontsTree.setEditable(true);
      fontsTree.setVisible(true);
      fontsScrollPane.getViewport().add(fontsTree, null);
      fontsTree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
      fontsTree.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
        public void valueChanged(TreeSelectionEvent e) {
          charsets_valueChanged(e);
        }
      });
      fontsTree.setSelectionRow(0);

      jSplitPane1.add(detailPanel, JSplitPane.BOTTOM);
      detailPanel.add(commonPanel, BorderLayout.NORTH);
      commandPanel.add(codepageButton, null);
      commandPanel.add(characterMappingButton, null);
      commandPanel.add(codeRangeButton, null);
      commandPanel.add(charsetButton, null);
      commandPanel.add(deleteButton, null);
      
      //
      charsetDetTable = null;
      fontDetScrollPane.getViewport().add(charsetDetTable, null);

      detailPanel.add(charsetPanel,  BorderLayout.CENTER);
      
      charsetNamePanel = new CharsetNamePanel(this);
      
      commonPanel.add(charsetNamePanel, BorderLayout.NORTH);
    
      charsetPanel.add(charsetParamsPanel, BorderLayout.NORTH);
      
      dataCommandsPanel.setVisible(false);
      detailPanel.add(dataCommandsPanel,  BorderLayout.SOUTH);
      parametersPanel.add(commandPanel, BorderLayout.SOUTH);
      aliasScrollPane.getViewport().add(aliasTable, null);
      dataCommandsPanel.add(addDataButton, null);
      dataCommandsPanel.add(deleteDataButton, null);
    }

      public void setCommonAttribs(org.w3c.dom.Node node)
      {
  	if(node == null)
  	{
  	    return;
  	}
  	
	NamedNodeMap attribs = node.getAttributes();
	
	if(attribs == null)
	{
	    return;
	}

   	if(node.getNodeName().equals("charset"))
   	    charsetNamePanel.setText((attribs.getNamedItem("name") == null) 
  			? COMBO_VALUE[0]
  			: attribs.getNamedItem("name").getNodeValue());
   	if(node.getNodeName().equals("codepage"))
   	    charsetParamsPanel.getCodepageForcelatinPanel()
  		.setText((attribs.getNamedItem("forcelatin") == null) ? COMBO_VALUE[0]
  		: attribs.getNamedItem("forcelatin").getNodeValue());
      }

      void charsets_valueChanged(TreeSelectionEvent treeEvent)
      {
  	TreePath currentTreePath = treeEvent.getNewLeadSelectionPath();
  	charsetNode = null;
  	if (currentTreePath == null)
  	    return;
  	DomToJTreeCharsetsAdapter.OptTreeNode node = (DomToJTreeCharsetsAdapter.OptTreeNode) currentTreePath
  		.getLastPathComponent();
  	if (node == null || node.getBody() == null || charsetNamePanel == null)
  	    return;
  	charsetNode = node.getBody();
  	setCommonAttribs(node.getBody());
  	dataCommandsPanel.setVisible(false); // show only for font nodes
  	if(charsetNamePanel.getNode() == null)
  	  charsetNamePanel.setNode(node.body);
  	if (node.getBody().getNodeName() == "code-ranges"
		|| node.getBody().getNodeName() == "character-mapping"
		|| node.getBody().getNodeName() == "codepage")
  	{
  	    charsetNamePanel.setVisible(false);
  	    this.charsetButton.setEnabled(false);
  	    this.codeRangeButton.setEnabled(false);
  	    this.codepageButton.setEnabled(false);
  	    this.characterMappingButton.setEnabled(false);
  	    charsetPanel.setVisible(false);

  	    if(node.getBody().getNodeName() == "code-ranges")
  	    {
  		mappingPanel.setVisible(false);
  		charsetPanel.setVisible(false);
  		detailPanel.remove(aliasPanel);
  		aliasPanel = new CodeRangePanel(node.getBody());
  		aliasPanel.setVisible(true);
  		detailPanel.add(aliasPanel, BorderLayout.CENTER);  		
  	    }
  	    else if(node.getBody().getNodeName() == "character-mapping")
  	    {
  		aliasPanel.setVisible(false);
  		charsetPanel.setVisible(false);
  		detailPanel.remove(mappingPanel);
  		mappingPanel = new CharacterMappingPanel(node.getBody());
  		mappingPanel.setVisible(true);
  		detailPanel.add(mappingPanel, BorderLayout.CENTER);  		
  	    }
  	    else if(node.getBody().getNodeName() == "codepage")
  	    {
  		aliasPanel.setVisible(false);
  		mappingPanel.setVisible(false);
  		detailPanel.remove(charsetPanel);
  		charsetPanel.setVisible(true);
  		detailPanel.add(charsetPanel, BorderLayout.CENTER);
  		detailPanel.updateUI();
  	    }
  	  
  	    if(charsetParamsPanel.getNode() == null)
  	    {
  		charsetParamsPanel.setNode(node.body);
  	    }
  	    
  	    charsetParamsPanel.fillCharsetParamsPanel(node.body);
  	    detailPanel.updateUI();
  	      	    
  	} else // charset
  	{
  	    this.charsetButton.setEnabled(true);
  	    this.codepageButton.setEnabled(false);
  	    this.codeRangeButton.setEnabled(false);
  	    this.characterMappingButton.setEnabled(false);
  	    aliasPanel.setVisible(false);
  	    mappingPanel.setVisible(false);
  	    this.fontDetScrollPane.getViewport().removeAll();
  	    if (node.getBody().getNodeName() == "charset")
  	    {
  		this.charsetButton.setEnabled(false);
  		charsetNamePanel.setVisible(true);  		
  		
  		charsetButtonsUpdateState(treeEvent);
                
  		charsetPanel.setVisible(false);
  		
  		if(node.getBody().getAttributeNode("name") == null)
  		{
  		  charsetNamePanel.setText("");
  		}
  		else
  		{
  		  charsetNamePanel.setText(node.getBody().getAttributeNode("name").getNodeValue());
  		}

  		NodeList children = node.getBody().getElementsByTagName("code-range");
  		if (children.getLength() == 0)
  		    charsetDetTable = null;
  		else
  		{
  		    charsetDetTable = new JTable(new DomToTableRangeModel(
  			    (Element) node.getBody(), true));
  		    this.fontDetScrollPane.getViewport().add(charsetDetTable, null);
  		}		

  	    } else
  	    { 		
  		charsetNamePanel.setVisible(false);
  		charsetPanel.setVisible(false);
  	    }
  	    charsetNamePanel.setNode(node.body);
  	    this.fontDetScrollPane.updateUI();
  	}
      }


    public void charsetButtonsUpdateState(TreeSelectionEvent treeEvent)
    {
	if(DomToJTreeCharsetsAdapter.isButtonAvalible(treeEvent, "codepage"))
	    this.codepageButton.setEnabled(true);
	if(DomToJTreeCharsetsAdapter.isButtonAvalible(treeEvent, "code-ranges"))                
	    this.codeRangeButton.setEnabled(true);
	if(DomToJTreeCharsetsAdapter.isButtonAvalible(treeEvent, "character-mapping"))
	    this.characterMappingButton.setEnabled(true);
    }

      String currTextValue = "";

      public void textField_focusGained(FocusEvent e, Element node)
      {
  	String cmd = ((JTextField) e.getSource()).getName();
  	if (cmd.equalsIgnoreCase("charset-name"))
  	{
  	    currTextValue = charsetNamePanel.getText().trim();
  	    charsetNamePanel.setNode(node);
  	    charsetNamePanel.setSource((JTextField) e.getSource());
  	}
  	else if (cmd.equalsIgnoreCase("codepage-name"))
  	{
  	    currTextValue = charsetParamsPanel.getCodepageNamePanel().getText().trim();
  	    charsetParamsPanel.setNode(node);
  	    charsetParamsPanel.getCodepageNamePanel().setSource((JTextField) e.getSource());
  	}
  	else if (cmd.equalsIgnoreCase("ibm-name"))
  	{
  	    currTextValue = charsetParamsPanel.getCodepageIbmNamePanel().getText().trim();
  	    charsetParamsPanel.setNode(node);
  	    charsetParamsPanel.getCodepageIbmNamePanel().setSource((JTextField) e.getSource());
  	}
  	else if (cmd.equalsIgnoreCase("forcelatin"))
  	{
  	    currTextValue = charsetParamsPanel.getCodepageForcelatinPanel().getText().trim();
  	    charsetParamsPanel.setNode(node);
  	    charsetParamsPanel.getCodepageForcelatinPanel().setSource((JTextField) e.getSource());
  	}
  	else if (cmd.equalsIgnoreCase("desc"))
  	{
  	    currTextValue = charsetParamsPanel.getCodepageDescPanel().getText().trim();
  	    charsetParamsPanel.setNode(node);
  	    charsetParamsPanel.getCodepageDescPanel().setSource((JTextField) e.getSource());
  	}
      }

      public void textField_focusLost(JTextField textField, Element node)
      {
  	if (node == null)
  	    return;
  	String cmd = textField.getName();
  	
  	if (cmd.equalsIgnoreCase("charset-name")
  		&& currTextValue != charsetNamePanel.getText().trim())
  	{
  	    if(node.getAttribute("name").equalsIgnoreCase(charsetNamePanel.getNode().getAttribute("name"))) // for switching to same node in other charset
  	    {
              	    if (charsetNamePanel.getText().trim().length() == 0
              		    || charsetNamePanel.getText().equalsIgnoreCase(COMBO_VALUE[0]))
              		charsetNamePanel.getNode().removeAttribute("name");
              	    else
              		charsetNamePanel.getNode().setAttribute("name", charsetNamePanel.getText());
  	    }
  	}
  	//------------------------------------------
 
  	else if (cmd.equalsIgnoreCase("ibm-name")
  		&& currTextValue != charsetParamsPanel.getCodepageIbmNamePanel().getText().trim())
  	{
  	  if(node.getAttribute("ibm-name").equalsIgnoreCase(charsetParamsPanel.getNode().getAttribute("ibm-name")))
  	  {
  	      if (charsetParamsPanel.getCodepageIbmNamePanel().getText().trim().length() == 0
  		      || charsetParamsPanel.getCodepageIbmNamePanel().getText().equalsIgnoreCase(COMBO_VALUE[0]))
  		  charsetParamsPanel.getNode().removeAttribute("ibm-name");
  	      else
  		  charsetParamsPanel.getNode().setAttribute("ibm-name", charsetParamsPanel.getCodepageIbmNamePanel().getText());
  	  }
  	}
  	
  	//-----------------------
  	else if (cmd.equalsIgnoreCase("codepage-name")
  		&& currTextValue != charsetParamsPanel.getCodepageNamePanel().getText().trim())
  	{
  	  if(node.getAttribute("codepage-name").equalsIgnoreCase(charsetParamsPanel.getNode().getAttribute("codepage-name")))
  	  {
  	      if (charsetParamsPanel.getCodepageNamePanel().getText().trim().length() == 0
  		      || charsetParamsPanel.getCodepageNamePanel().getText().equalsIgnoreCase(COMBO_VALUE[0]))
  		  charsetParamsPanel.getNode().removeAttribute("codepage-name");
  	      else
  		  charsetParamsPanel.getNode().setAttribute("codepage-name", charsetParamsPanel.getCodepageNamePanel().getText());
  	  }
  	}		
  	// ----------------------
  	
  	else if (cmd.equalsIgnoreCase("desc")
  		&& currTextValue != charsetParamsPanel.getCodepageDescPanel().getText().trim())
  	{
  	  if(node.getAttribute("desc").equalsIgnoreCase(charsetParamsPanel.getNode().getAttribute("desc")))
  	  {
  	      if (charsetParamsPanel.getCodepageDescPanel().getText().trim().length() == 0
  		      || charsetParamsPanel.getCodepageDescPanel().getText().equalsIgnoreCase(COMBO_VALUE[0]))
  		  charsetParamsPanel.getNode().removeAttribute("desc");
  	      else
  		  charsetParamsPanel.getNode().setAttribute("desc", charsetParamsPanel.getCodepageDescPanel().getText());
  	  }
  	}		
  	// ----------------------
  	
  	  else if (cmd.equalsIgnoreCase("forcelatin")
  		&& currTextValue != charsetParamsPanel.getCodepageForcelatinPanel().getText().trim())
  	  {
  	    if(node.getAttribute("forcelatin").equalsIgnoreCase(charsetParamsPanel.getNode().getAttribute("forcelatin")))
  	    {
  		if (charsetParamsPanel.getCodepageForcelatinPanel().getText().trim().length() == 0
  			|| charsetParamsPanel.getCodepageForcelatinPanel().getText().equalsIgnoreCase(COMBO_VALUE[0]))
  		    charsetParamsPanel.getNode().removeAttribute("forcelatin");
  		else
  		    charsetParamsPanel.getNode().setAttribute("forcelatin", charsetParamsPanel.getCodepageForcelatinPanel().getText());
  	    }
  	  }

  	currTextValue = "";
      }

      void new_actionPerformed(ActionEvent e)
      {
  	final TreePath selectionPath = fontsTree.getSelectionPath();
	final TreeModelEvent treeModelEvent = new TreeModelEvent(e.getSource(),	selectionPath);
	domModel.insertInCurrentNode(treeModelEvent, e.getActionCommand());
	
	fontsTree.scrollPathToVisible(selectionPath);
	fontsTree.setSelectionPath(selectionPath);
 	fontsTree.updateUI();
      }

      void deleteButton_actionPerformed(ActionEvent e)
      {
  	TreePath path = fontsTree.getSelectionPath();
  	if (path.getParentPath() == null)
  	    return;
  	domModel.removeCurrentNode(new TreeModelEvent(e.getSource(), path));
  	fontsTree.setSelectionPath(path.getParentPath());
      }

    void addDataButton_actionPerformed(ActionEvent e, Element parent) {
      DomToTableModel tm;
      if(charsetDetTable == null){
        tm = new DomToTableModel(parent, true);
////////////  /System.out.println(" Font="+parent.toString());
        charsetDetTable = new JTable(tm);
        fontDetScrollPane.getViewport().add(charsetDetTable, null);
        fontDetScrollPane.updateUI();
      }
      else tm = (DomToTableModel) charsetDetTable.getModel();
      tm.addRow(parent);
    }

    void deleteDataButton_actionPerformed(ActionEvent e, Element parent) {
      int row = charsetDetTable.getSelectedRow();
      if(row < 0) return;
//////  System.out.println(" Font="+parent.toString()+" sss="+this.fontDetTable.getValueAt(0,0));
      DomToTableModel tm = (DomToTableModel) charsetDetTable.getModel();
      Attr temp = (Attr) tm.getNodeAt(row);
      Element fdata = (Element)parent.getElementsByTagName("code-range").item(0);
      fdata.removeAttributeNode(temp);
      tm.deleteRow(row);
    }

    public Element getCharsetNode()
    {
        return charsetNode;
    }

  }

