package com.renderx.xepx.x4u.as;

import javax.swing.*;
import javax.swing.text.html.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

class Help
{
	private JEditorPane textPanel;
	private JButton back;
	private JButton forward;
	private JButton home;
	
	private String logo_name = "rx.png";
	private String guide_name = "intro.html";
	private java.net.URL logo_url;
	private java.net.URL guide_url;
	
	private java.util.ArrayList history;
	private int count = 0;
	private ButtonListener listener;
	
	Help() {
		logo_url = Help.class.getClassLoader().getResource(logo_name);
		guide_url = Help.class.getClassLoader().getResource(guide_name);
	}
	
	void about(JFrame parent)
	{
		JOptionPane pane = new JOptionPane();
		String version = com.renderx.xep.lib.Conf.VERSION_NUMBER;
		pane.showMessageDialog(parent, "<html>XEP "+version+" Assistant<br>Copyright \u00a9 2004-2009 RenderX Inc.", 
			"About XEP Assistant", JOptionPane.INFORMATION_MESSAGE, new ImageIcon(logo_url));
	}
	
	void contents(JFrame parent) {
		if (guide_url==null) return;
		
		JDialog dialog = new JDialog(parent, "XEP Assistant help",false);
		
		JToolBar toolBar = new JToolBar();
		toolBar.setFloatable(false);
		
		back = new JButton("Back");
		forward = new JButton("Forward");
		home = new JButton("Home");
		home.setEnabled(false);
		back.setEnabled(false);
		forward.setEnabled(false);
		back.setActionCommand("BACK");
		forward.setActionCommand("FORWARD");
		home.setActionCommand("HOME");
		
		toolBar.add(home);
		toolBar.add(back);
		toolBar.add(forward);
				
		try {		
			textPanel = new JEditorPane(guide_url);
		} catch (java.io.IOException e){
			throw new RuntimeException("cannot happen: "+e);
		}
		
		history = new java.util.ArrayList();
		history.add(guide_url);
		
		listener = new ButtonListener();
		
		back.addActionListener(listener);
		forward.addActionListener(listener);
		home.addActionListener(listener);


		textPanel.setEditable(false);
		textPanel.addHyperlinkListener(new LinkListener());
		
		JScrollPane scroller = new JScrollPane(textPanel); 
		
		dialog.getContentPane().add(toolBar, BorderLayout.NORTH);
		dialog.getContentPane().add(scroller, BorderLayout.CENTER);
		
		Dimension parsiz = parent.getSize();
		Point parloc = parent.getLocation();
		dialog.setSize(parsiz);
		dialog.setLocation(parloc.x+parsiz.width/3,parloc.y+parsiz.height/3);
		dialog.validate();
		dialog.setVisible(true);
	}
	
	class LinkListener implements HyperlinkListener {
		public void hyperlinkUpdate(HyperlinkEvent evt) 
		{
			if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
				try {
				//	if (evt.getURL().toString().indexOf("http")==-1) {
						textPanel.setPage(evt.getURL());
						home.setEnabled(true);
						back.setEnabled(true);
						int size = history.size();
//						if(count<size-1) 
						for(int i=count+1; i<size;i++)
							history.remove(count+1);
						history.add(evt.getURL());
						count = history.size()-1;
						forward.setEnabled(false);
				//	}
				} catch (java.io.IOException eio) {
					badURL(eio);
				}
			}
		}
	}

	private void badURL(Exception ex) {
		JOptionPane.showMessageDialog(textPanel,
			"Bad URL:"+ex.getMessage(),
			"Error", JOptionPane.OK_OPTION);
	}

	class ButtonListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			String command = e.getActionCommand();
			forward.setEnabled(true);
			if (command.equals("BACK")) {
				if (count==0)
					throw new RuntimeException("back before first page");
				try {
					count--;
					textPanel.setPage((java.net.URL) history.get(count));
					if (count==0)
						back.setEnabled(false);
				} catch (java.io.IOException eio) {
					badURL(eio);
				}
			} else if (command.equals("FORWARD")) {
				back.setEnabled(true);
				if (count==history.size()-1) 
					throw new RuntimeException("forward after last page");
				try {
					count++;
					textPanel.setPage((java.net.URL) history.get(count));
					if(count==history.size()-1)
						forward.setEnabled(false);
				} catch (java.io.IOException eio) {
					badURL(eio);
				}
			} else if (command.equals("HOME")) {
//					linkListener.hyperlinkUpdate(new HyperlinkEvent(
				try {
					textPanel.setPage(guide_url);
					home.setEnabled(false);
					back.setEnabled(true);
					forward.setEnabled(false);
					int size = history.size();
//						if(count<size-1) 
					for(int i=count+1; i<size;i++)
						history.remove(count+1);
					history.add(guide_url);
					count=history.size()-1;
				} catch (java.io.IOException eio) {
					badURL(eio);
				}
			}
			home.setEnabled(history.get(count)!=guide_url);
		}
	}
}
