/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xpslib;

import com.renderx.xep.gen.backends.H4XPS;
import com.renderx.xpslib.XEPOUTImageParseException;
import com.renderx.xpslib.XPSDocument;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XEPOUTImageHandler
implements ContentHandler {
    private H4XPS ch = null;
    private int page = 0;
    private float xepoutScaleX = 0.0f;
    private float xepoutScaleY = 0.0f;
    private float xepoutX = 0.0f;
    private float xepoutY = 0.0f;
    private float xepoutW = 0.0f;
    private float xepoutH = 0.0f;
    private int openCanvases = 0;
    private XPSDocument XPSGenerator = null;

    public XEPOUTImageHandler(H4XPS h4XPS, XPSDocument xPSDocument) {
        this.ch = h4XPS;
        this.XPSGenerator = xPSDocument;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void skippedEntity(String string) {
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!string.equalsIgnoreCase(this.ch.XEPURI)) {
            throw new SAXException("Element in an XEPOUT image is not in the XEP namespace (" + this.ch.XEPURI + ")");
        }
        if (string2.equalsIgnoreCase("document")) {
            return;
        }
        if (this.page > 0) {
            return;
        }
        if (string2.equalsIgnoreCase("page")) {
            this.openCanvases = this.XPSGenerator.getOpenCanvasesCount();
            if (attributes.getValue("height") == null) {
                throw new XEPOUTImageParseException("Attribute 'height' is null.");
            }
            this.xepoutH = H4XPS.parseLength(attributes.getValue("height"));
            if (attributes.getValue("width") == null) {
                throw new XEPOUTImageParseException("Attribute 'width' is null.");
            }
            this.xepoutW = H4XPS.parseLength(attributes.getValue("width"));
            this.XPSGenerator.startClip(0.0f, 0.0f, this.xepoutW, this.xepoutH);
            return;
        }
        if (string2.equalsIgnoreCase("image")) {
            AttributesImpl attributesImpl = new AttributesImpl(attributes);
            attributesImpl.addAttribute("", "nocache", "nocache", "CDATA", "0");
            if (this.ch != null) {
                this.ch.startElement(this.ch.XEPURI, string2, this.ch.XEPURI + ":" + string2, attributesImpl);
            }
            return;
        }
        if (this.ch != null) {
            this.ch.startElement(this.ch.XEPURI, string2, this.ch.XEPURI + ":" + string2, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!string.equalsIgnoreCase(this.ch.XEPURI)) {
            throw new SAXException("Element in a XEPOUT image is not in the XEP namespace (" + this.ch.XEPURI + ")");
        }
        if (string2.equalsIgnoreCase("document")) {
            return;
        }
        if (this.page > 1) {
            return;
        }
        if (string2.equalsIgnoreCase("page")) {
            this.openCanvases = this.XPSGenerator.getOpenCanvasesCount() - this.openCanvases;
            int n = 0;
            while (n < this.openCanvases) {
                this.XPSGenerator.closeCanvas();
                ++n;
            }
            this.XPSGenerator.endClip();
            ++this.page;
            return;
        }
        if (this.ch != null) {
            this.ch.endElement(this.ch.XEPURI, string2, this.ch.XEPURI + ":" + string2);
        }
    }
}

