/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.graphics.PDFIcons;
import com.renderx.pdflib.Annot;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFCommentAppearance;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.Popup;

class PDFComment
extends Annot {
    String subType;
    String icon;
    String contents = "";
    String title = "";
    float opacity;
    IndirectObject fid;
    IndirectObject parent_page_id;
    IndirectObject pop_id;
    String DEFAULT_COMMENT_TYPE = "Note";
    PDFCommentAppearance ap;
    Popup pop;
    ResObject reso;

    PDFComment(IndirectObject indirectObject, float f, float f2, float f3, float f4) {
        super(indirectObject, f, f2, f3, f4);
    }

    void setSubType(String string) {
        this.subType = string;
    }

    String getSubType() {
        return this.subType;
    }

    void setParentPageID(IndirectObject indirectObject) {
        this.parent_page_id = indirectObject;
    }

    void setPopupID(IndirectObject indirectObject) {
        this.pop_id = indirectObject;
    }

    void setIcon(String string) {
        int n = 0;
        while (n < Annot.icon_names.length) {
            if (Annot.icon_names[n].equalsIgnoreCase(string)) {
                this.icon = Annot.icon_names[n];
            }
            ++n;
        }
    }

    void setOpacity(float f) {
        this.opacity = f;
    }

    void setFID(IndirectObject indirectObject) {
        this.fid = indirectObject;
    }

    void writeAnnotBody(PDFOutputStream pDFOutputStream) {
        if (this.subType == null) {
            this.subType = this.DEFAULT_COMMENT_TYPE;
        }
        if (this.icon == null) {
            this.icon = this.subType.equals("Text") ? Annot.icon_names[6] : Annot.icon_names[2];
        }
        pDFOutputStream.print("/Name /" + this.icon + " ");
        if (this.pop_id != null) {
            pDFOutputStream.print("/Popup " + this.pop_id.toStringR());
        }
        pDFOutputStream.print("/Contents ");
        if (this.contents != null) {
            pDFOutputStream.print_annotation(this.contents);
        } else {
            pDFOutputStream.print("()");
        }
        if (this.title != null) {
            pDFOutputStream.print("/T ");
            pDFOutputStream.print_annotation(this.title);
        }
        pDFOutputStream.print("/AP<<");
        if (this.opacity != 1.0f) {
            IndirectObject indirectObject = pDFOutputStream.getNextID();
            this.reso = new ResObject(indirectObject, (float[])PDFIcons.size.get(this.icon));
            pDFOutputStream.print("/N " + indirectObject.toStringR());
            pDFOutputStream.print(">>");
            pDFOutputStream.print("/CA " + this.opacity);
        } else {
            this.ap = new PDFCommentAppearance(pDFOutputStream.getNextID(), this.icon, this.getColor());
            pDFOutputStream.print("/N " + this.ap.getID().toStringR());
            pDFOutputStream.print(">>");
        }
        if (this.fid != null) {
            pDFOutputStream.print("/FS " + this.fid.toStringR());
        }
        if (this.parent_page_id != null) {
            pDFOutputStream.print("/P " + this.parent_page_id.toStringR());
        }
        pDFOutputStream.print("/Type/Annot");
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        if (this.reso != null) {
            this.reso.write(pDFOutputStream);
        }
        if (this.ap != null && this.opacity == 1.0f) {
            this.ap.write(pDFOutputStream);
        }
    }

    class SubObject
    extends PDFObject {
        float[] box;
        private IndirectObject length_id;
        private int length;

        SubObject(IndirectObject indirectObject, float[] fArray) {
            super(indirectObject);
            this.box = fArray;
        }

        String getType() {
            return "XObject";
        }

        void writeBody(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.println("/Subtype/Form");
            this.length_id = pDFOutputStream.getNextID();
            pDFOutputStream.println("/BBox [0 0 " + this.box[0] + " " + this.box[1] + "]");
            pDFOutputStream.print("/FormType 1/Resources <</ProcSet [/PDF]/");
            PDFComment.this.ap = new PDFCommentAppearance(pDFOutputStream.getNextID(), PDFComment.this.icon, PDFComment.this.getColor());
            if (PDFComment.this.ap != null) {
                pDFOutputStream.print("XObject<</Form " + PDFComment.this.ap.getID().toStringR() + ">>>>");
            }
            pDFOutputStream.println("/Group <</S/Transparency>>");
            if (pDFOutputStream.compression) {
                pDFOutputStream.println("/Filter /FlateDecode");
            }
            pDFOutputStream.println(">>");
            pDFOutputStream.println("stream");
            int n = pDFOutputStream.size();
            pDFOutputStream.startStream();
            pDFOutputStream.println("/Form Do");
            pDFOutputStream.finishStream();
            this.length = pDFOutputStream.size() - n;
            pDFOutputStream.println("\nendstream");
            pDFOutputStream.println("\nendobj");
        }

        void writeSubObjects(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.printLength(this.length_id, this.length);
            if (PDFComment.this.ap != null) {
                PDFComment.this.ap.write(pDFOutputStream);
            }
        }
    }

    class ResObject
    extends PDFObject {
        float[] box;
        private IndirectObject length_id;
        private int length;
        SubObject so;

        ResObject(IndirectObject indirectObject, float[] fArray) {
            super(indirectObject);
            this.box = fArray;
        }

        String getType() {
            return "XObject";
        }

        void writeBody(PDFOutputStream pDFOutputStream) {
            String string = "MWFOForm";
            IndirectObject indirectObject = pDFOutputStream.getNextID();
            this.so = new SubObject(indirectObject, this.box);
            pDFOutputStream.println("/Subtype/Form");
            this.length_id = pDFOutputStream.getNextID();
            pDFOutputStream.println("/BBox [0 0 " + this.box[0] + " " + this.box[1] + "]");
            pDFOutputStream.print("/FormType 1/Resources ");
            pDFOutputStream.print("<</ExtGState<</R0<</AIS false/CA ");
            pDFOutputStream.print(PDFComment.this.opacity + "/Type/ExtGState/ca " + PDFComment.this.opacity + ">>>>");
            pDFOutputStream.print("/ProcSet[/PDF]/XObject<</" + string + " " + indirectObject.toStringR() + ">>>>");
            if (pDFOutputStream.compression) {
                pDFOutputStream.println("/Filter /FlateDecode");
            }
            pDFOutputStream.println(">>");
            pDFOutputStream.println("stream");
            int n = pDFOutputStream.size();
            pDFOutputStream.startStream();
            pDFOutputStream.println("/R0 gs");
            pDFOutputStream.println("/" + string + " Do");
            pDFOutputStream.finishStream();
            this.length = pDFOutputStream.size() - n;
            pDFOutputStream.println("\nendstream");
            pDFOutputStream.println("\nendobj");
        }

        void writeSubObjects(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.printLength(this.length_id, this.length);
            if (this.so != null) {
                this.so.write(pDFOutputStream);
            }
        }
    }
}

