/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts.afp;

import java.io.UnsupportedEncodingException;

public class FontIndexData {
    private String characterGlobalID;
    private byte[] characterIncrement;
    private byte[] characterAscender;
    private byte[] characterDescender;
    private byte[] fnmIndex;
    private byte[] aSpace;
    private byte[] bSpace;
    private byte[] cSpace;
    private byte[] baselineOffset;

    public String getCharacterGlobalID() {
        return this.characterGlobalID;
    }

    public byte[] getCharacterIncrement() {
        return this.characterIncrement;
    }

    public byte[] getCharacterAscender() {
        return this.characterAscender;
    }

    public byte[] getCharacterDescender() {
        return this.characterDescender;
    }

    public byte[] getFnmIndex() {
        return this.fnmIndex;
    }

    public byte[] getASpace() {
        return this.aSpace;
    }

    public byte[] getBSpace() {
        return this.bSpace;
    }

    public byte[] getCSpace() {
        return this.cSpace;
    }

    public byte[] getBaselineOffset() {
        return this.baselineOffset;
    }

    public void parse(byte[] byArray, String string) throws UnsupportedEncodingException {
        byte[] byArray2 = new byte[8];
        this.characterIncrement = new byte[2];
        this.characterAscender = new byte[2];
        this.characterDescender = new byte[2];
        this.fnmIndex = new byte[2];
        this.aSpace = new byte[2];
        this.bSpace = new byte[2];
        this.cSpace = new byte[2];
        this.baselineOffset = new byte[2];
        int n = 0;
        while (n < byArray.length) {
            if (!(n >= 14 && n <= 15 || n >= 24 && n <= 25)) {
                if (n <= 7) {
                    byArray2[n] = byArray[n];
                } else if (n <= 9) {
                    this.characterIncrement[n - 8] = byArray[n];
                } else if (n <= 11) {
                    this.characterAscender[n - 10] = byArray[n];
                } else if (n <= 13) {
                    this.characterDescender[n - 12] = byArray[n];
                } else if (n <= 17) {
                    this.fnmIndex[n - 16] = byArray[n];
                } else if (n <= 19) {
                    this.aSpace[n - 18] = byArray[n];
                } else if (n <= 21) {
                    this.bSpace[n - 20] = byArray[n];
                } else if (n <= 23) {
                    this.cSpace[n - 22] = byArray[n];
                } else if (n <= 27) {
                    this.baselineOffset[n - 26] = byArray[n];
                }
            }
            ++n;
        }
        this.characterGlobalID = new String(byArray2, string).trim();
        byArray2 = null;
    }
}

