/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

import com.renderx.fonts.AFMMetric;
import com.renderx.fonts.AFPMetric;
import com.renderx.fonts.BadFontDataException;
import com.renderx.fonts.FontConfigurationException;
import com.renderx.fonts.FontFileFormatError;
import com.renderx.fonts.GlyphList;
import com.renderx.fonts.Metric;
import com.renderx.fonts.TTMetric;
import com.renderx.util.Array;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.SeekableInput;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import com.renderx.util.UnicodeData;
import com.renderx.util.UnicodeTable;
import java.io.IOException;
import java.io.InputStream;

public class FontRecord
implements Cloneable {
    public final String familyName;
    private Metric metric;
    public boolean embed;
    public boolean subset;
    public boolean makeSmallCaps;
    public double smallCapSizeRatio;
    public double extraSlantAngle;
    public static final int NONE = 0;
    public static final int TYPE1 = 1;
    public static final int TRUETYPE = 2;
    public static final int OPENTYPE_CFF = 3;
    public static final int OPENTYPE_CFF_CID = 4;
    public static final int AFP = 5;
    public int datatype;
    public URLSpec metricfile;
    public URLSpec glyphlistfile;
    public URLSpec fontfile;
    public UnicodeTable ligatures;
    public String initialencoding;
    public int subfont;
    private final ErrorHandler errHandler;
    private final URLCache cache;
    public URLSpec codepagefile;
    public String codepagename;
    public String charsetname;
    public String encoding;
    public int size;

    FontRecord cloneRecord() {
        try {
            return (FontRecord)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    FontRecord(String string, Hashtable hashtable, URLCache uRLCache, ErrorHandler errorHandler) throws FontConfigurationException {
        String string2;
        block32: {
            String string3;
            block31: {
                String string4;
                this.metric = null;
                this.embed = false;
                this.subset = true;
                this.makeSmallCaps = false;
                this.smallCapSizeRatio = 0.8;
                this.extraSlantAngle = 0.0;
                this.datatype = 0;
                this.metricfile = null;
                this.glyphlistfile = null;
                this.fontfile = null;
                this.ligatures = null;
                this.initialencoding = null;
                this.subfont = 1;
                this.codepagefile = null;
                this.familyName = string;
                this.cache = uRLCache;
                this.errHandler = errorHandler;
                this.metricfile = (URLSpec)hashtable.get("ttf");
                if (this.metricfile == null) {
                    this.metricfile = (URLSpec)hashtable.get("otf");
                }
                if (this.metricfile == null) {
                    this.metricfile = (URLSpec)hashtable.get("ttc");
                }
                if (this.metricfile != null) {
                    this.datatype = 2;
                    this.fontfile = this.metricfile;
                    string4 = (String)hashtable.get("subfont");
                    if (string4 != null) {
                        try {
                            this.subfont = Integer.parseInt(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new FontConfigurationException("Invalid subfont attribute '" + string4 + "'; should be a positive integer");
                        }
                    }
                } else {
                    this.metricfile = (URLSpec)hashtable.get("afm");
                    if (this.metricfile != null) {
                        this.datatype = 1;
                        this.glyphlistfile = (URLSpec)hashtable.get("glyph-list");
                        this.fontfile = (URLSpec)hashtable.get("pfa");
                        if (this.fontfile == null) {
                            this.fontfile = (URLSpec)hashtable.get("pfb");
                        }
                        this.initialencoding = (String)hashtable.get("initial-encoding");
                    } else {
                        this.metricfile = (URLSpec)hashtable.get("charset-file");
                        if (this.metricfile != null) {
                            this.datatype = 5;
                            this.charsetname = (String)hashtable.get("charset-name");
                            this.codepagefile = (URLSpec)hashtable.get("codepage-file");
                            this.codepagename = (String)hashtable.get("codepage-name");
                            this.encoding = (String)hashtable.get("encoding");
                            try {
                                this.size = Integer.parseInt((String)hashtable.get("size"));
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new FontConfigurationException("Invalid or missed size information for font " + this.metricfile);
                            }
                            if (this.codepagefile == null) {
                                throw new FontConfigurationException("No code page information present for font " + this.metricfile);
                            }
                            if (this.size <= 0) {
                                throw new FontConfigurationException("Invalid or missed size information for font " + this.metricfile);
                            }
                        } else {
                            throw new FontConfigurationException("No metric information present for font " + this.metricfile);
                        }
                    }
                }
                this.embed = this.getBooleanProperty((String)hashtable.get("embed"), this.fontfile != null);
                this.subset = this.getBooleanProperty((String)hashtable.get("subset"), true);
                if (this.embed && this.fontfile == null) {
                    this.embed = false;
                    this.error("No outline file for font metric '" + this.metricfile + "'; font cannot be embedded");
                }
                if ((string4 = (String)hashtable.get("slant-angle")) != null) {
                    try {
                        this.extraSlantAngle = new Double(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (errorHandler == null) break block31;
                        errorHandler.error("Bad value for slant angle: '" + string4 + "'; property ignored");
                    }
                }
            }
            if ((string3 = (String)hashtable.get("smallcaps-size")) != null) {
                this.makeSmallCaps = true;
                try {
                    this.smallCapSizeRatio = new Double(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    if (errorHandler == null) break block32;
                    errorHandler.error("Bad value for smallcap size ratio: '" + string3 + "'; using default value of " + 0.8);
                }
            }
        }
        if ((string2 = (String)hashtable.get("ligatures")) != null && string2.trim().length() > 0) {
            Object object;
            Object object2;
            int n = 0;
            Array array = new Array();
            n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                object2 = (char[])UnicodeData.LIGATURES.get(c);
                if (object2 != null && ((char[])object2).length > 1) {
                    object = (StringBuffer)array.get(((char[])object2).length);
                    if (object == null) {
                        object = new StringBuffer();
                        array.put(((char[])object2).length, object);
                    }
                    ((StringBuffer)object).append(c);
                }
                ++n;
            }
            StringBuffer stringBuffer = new StringBuffer();
            n = array.length();
            while (n-- > 0) {
                object2 = (StringBuffer)array.get(n);
                if (object2 == null) continue;
                stringBuffer.append(object2);
            }
            this.ligatures = new UnicodeTable();
            n = 0;
            while (n < stringBuffer.length()) {
                char c = stringBuffer.charAt(n);
                object = (char[])UnicodeData.LIGATURES.get(c);
                char[] cArray = new char[((Object)object).length];
                cArray[0] = c;
                int n2 = 1;
                while (n2 < ((Object)object).length) {
                    cArray[n2] = (char)object[n2];
                    ++n2;
                }
                Array array2 = (Array)this.ligatures.get((char)object[0]);
                if (array2 == null) {
                    array2 = new Array();
                }
                array2.put(array2.length(), cArray);
                this.ligatures.put((char)object[0], array2);
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Metric getMetric() {
        if (this.metric != null) {
            return this.metric;
        }
        try {
            InputStream inputStream = null;
            switch (this.datatype) {
                case 2: {
                    SeekableInput seekableInput = this.cache.openSeekableStream(this.metricfile, this.errHandler);
                    if (seekableInput == null) break;
                    try {
                        this.metric = new TTMetric(seekableInput, this.subfont);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        seekableInput.close();
                        throw throwable;
                    }
                    seekableInput.close();
                    break;
                }
                case 1: {
                    inputStream = this.cache.openStream(this.metricfile, this.errHandler);
                    if (inputStream == null) break;
                    try {
                        if (this.glyphlistfile == null) {
                            this.metric = new AFMMetric(inputStream);
                        } else {
                            InputStream inputStream2 = this.cache.openStream(this.glyphlistfile, this.errHandler);
                            if (inputStream2 != null) {
                                try {
                                    this.metric = new AFMMetric(inputStream, new GlyphList(inputStream2));
                                    Object var6_11 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var6_12 = null;
                                    inputStream2.close();
                                    throw throwable;
                                }
                                inputStream2.close();
                            } else {
                                this.metric = null;
                            }
                        }
                        Object var8_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_15 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    break;
                }
                case 5: {
                    inputStream = this.cache.openStream(this.metricfile, this.errHandler);
                    if (inputStream == null) break;
                    InputStream inputStream3 = null;
                    try {
                        inputStream3 = this.cache.openStream(this.codepagefile, this.errHandler);
                    }
                    catch (IOException iOException) {
                        this.exception("Cannot read code page from " + this.codepagefile, iOException);
                    }
                    if (inputStream3 == null) {
                        throw new BadFontDataException("Cannot read code page from '" + this.codepagefile + "'");
                    }
                    try {
                        if (this.charsetname == null) {
                            this.charsetname = this.getNameFromPath(this.metricfile.url.getFile());
                        }
                        if (this.codepagename == null) {
                            this.codepagename = this.getNameFromPath(this.codepagefile.url.getFile());
                        }
                        this.metric = new AFPMetric(inputStream, inputStream3, this.encoding, this.charsetname, this.codepagename);
                        Object var10_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_18 = null;
                        inputStream.close();
                        inputStream3.close();
                        throw throwable;
                    }
                    inputStream.close();
                    inputStream3.close();
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid font type: " + this.datatype);
                }
            }
        }
        catch (FontFileFormatError fontFileFormatError) {
            this.error("Unsupported file format or broken file found reading font metric from " + this.metricfile + ": " + fontFileFormatError.getMessage());
        }
        catch (IOException iOException) {
            this.exception("Cannot read font metric from " + this.metricfile, iOException);
        }
        if (this.metric == null) {
            throw new BadFontDataException("Could not obtain font metric for font family '" + this.familyName + "'");
        }
        if (this.embed) {
            if (!this.metric.embeddable()) {
                this.error("Font '" + this.metric.fontName + "' cannot be embedded because of license restrictions");
                this.embed = false;
            } else if (this.subset && !this.metric.subsettable()) {
                this.error("Font '" + this.metric.fontName + "' cannot be subsetted because of license restrictions");
                this.subset = false;
            }
        }
        if (!this.metric.isCFF) return this.metric;
        if (this.metric.isCIDFont) {
            this.datatype = 4;
            return this.metric;
        }
        this.datatype = 3;
        return this.metric;
    }

    private String getNameFromPath(String string) {
        int n;
        int n2 = string.lastIndexOf("/") + 1;
        if (n2 > string.length() - 1) {
            n2 = string.length() - 1;
        }
        return (n = string.indexOf(".", n2)) > 0 ? string.substring(n2, n) : string.substring(n2);
    }

    public int getThaiShaping() {
        if (this.metric == null) {
            this.metric = this.getMetric();
        }
        return this.metric.ucm('\u0e64') != null ? 0 : (this.metric.ucm('\uf701') != null ? 1 : (this.metric.ucm('\uf885') != null ? 2 : 3));
    }

    public InputStream openFontStream() throws IOException {
        return this.fontfile == null ? null : this.cache.openStream(this.fontfile, this.errHandler);
    }

    public SeekableInput openSeekableFontStream() throws IOException {
        return this.fontfile == null ? null : this.cache.openSeekableStream(this.fontfile, this.errHandler);
    }

    private boolean getBooleanProperty(String string, boolean bl) {
        if (string == null || "auto".equalsIgnoreCase(string)) {
            return bl;
        }
        if ("true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string)) {
            return false;
        }
        this.error("Invalid value '" + string + "' for a boolean property ignored");
        return bl;
    }

    public void warning(String string) {
        if (this.errHandler == null) {
            return;
        }
        ErrorHandler errorHandler = this.errHandler;
        synchronized (errorHandler) {
            this.errHandler.warning(string);
        }
    }

    public void error(String string) {
        if (this.errHandler == null) {
            return;
        }
        ErrorHandler errorHandler = this.errHandler;
        synchronized (errorHandler) {
            this.errHandler.error(string);
        }
    }

    public void exception(String string, Exception exception) {
        if (this.errHandler == null) {
            return;
        }
        ErrorHandler errorHandler = this.errHandler;
        synchronized (errorHandler) {
            this.errHandler.exception(string, exception);
        }
    }
}

