package com.renderx.xepx.x4u.ct.charsetspanel;

import java.awt.Dimension;
import java.awt.event.FocusEvent;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import com.renderx.xepx.x4u.ct.DomToJTreeAdapter;

/**
 * @author AlexanderR
 */

public class CodepageDescPanel extends JPanel
{
    private static final long serialVersionUID = 3349205996810528703L;

    private CharsetsPanel parentPanel;
    
    private JLabel codepageDescLabel = new JLabel();
    private JTextField codepageDescTextField = new JTextField();
    private JTextField source = new JTextField();
    
    public CodepageDescPanel(CharsetsPanel _charsetsPanel)
    {
	this.parentPanel = _charsetsPanel;
	
        add(codepageDescLabel, null);
        add(codepageDescTextField, null);
        
        codepageDescTextField.setName("desc");
        codepageDescTextField.setText("desc");      
        codepageDescTextField.setPreferredSize(new Dimension(100, 19));
        codepageDescTextField.setEnabled(true);
        source.setName("");
        
	codepageDescLabel.setText("Description");
	
	codepageDescTextField.getDocument().addDocumentListener
	(
		new DocumentListener()
		{
		  public void insertUpdate(DocumentEvent e) 
		  {
		      parentPanel.textField_focusLost(source, (Element) parentPanel.getCharsetNode());
		  };
		  public void removeUpdate(DocumentEvent e) 
		  { 
		      parentPanel.textField_focusLost(source, (Element) parentPanel.getCharsetNode());
		  };
		  public void changedUpdate(DocumentEvent e) 
		  { 
		  };
		}
	);
	
	codepageDescTextField.addFocusListener
        (
        	new java.awt.event.FocusAdapter()
        	{
        	    public void focusLost(FocusEvent e)
        	    {
        	    }
        
        	    public void focusGained(FocusEvent e)
        	    {
        		parentPanel.textField_focusGained(e, (Element) parentPanel.getCharsetNode());
        	    }
        });	
    }
       
    public String getText()
    {
	return codepageDescTextField.getText();
    }
    
    public void setText(String text)
    {
	codepageDescTextField.setText(text);
    }
        
    public void setEnabled(boolean value)
    {
	codepageDescTextField.setEnabled(value);
    }
      
    public void setTextFromNode(DomToJTreeAdapter.FontTreeNode node)
    {
	NamedNodeMap attribs = node.getBody().getAttributes();
	if (attribs.getNamedItem("desc") != null)
	{
	    setText(attribs.getNamedItem("desc").getNodeValue());
	    setEnabled(true);
	} else
	{
	    setText("1");
	    setEnabled(false);
	}	
	this.updateUI();
	
	Node sizeNode = node.getBody().getAttributes().getNamedItem("desc");
	String sizeValue = "";
	
	if(sizeNode != null)
	    sizeValue = node.getBody().getAttributes().getNamedItem("desc").getNodeValue();
	
	setText(sizeValue);
    }

    public JTextField getSource()
    {
        return source;
    }

    public void setSource(JTextField source)
    {
        this.source = source;
    }    
}
