package com.renderx.xepx.x4u.ct;
import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.event.*;
import org.w3c.dom.*;

import com.renderx.xepx.x4u.ct.charsetspanel.CharsetsPanel;

import java.util.*;

/**
 * <p>Title: BackendPanel</p>
 * <p>Description: UI for BackEnd parameters </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Zenteq.am</p>
 * @author: Boris Karapetyan, Angelina Andriasyan
 **/

public class BackendPanel extends JPanel implements ActionListener {
	Document doc;
	DOMWalker model;

	Element[] bkNode = new Element[DOMWalker.BACKEND_COUNT];
	// ComboBox values
	static final String[] ZOOM_VALUE = {
		"auto", "fit-screen", "fit-width", "fit-height", "number-or-percentage "};
	static final String[] VIEW_VALUE = {
		"auto","show-none", "show-bookmarks", "show-thumbnails", "full-screen"};
	static final String[] PRIVEL_VALUE = {
		"annotate", "copy", "modify", "print"};
	static final String[] RESOLUTION = {"1440", "720", "360"};
	static final String[] AFP_LOG_LEVEL  = {"0-Nothing", "1-Warnings only", "2-Warnings and Info"};

	java.util.Vector vec = new java.util.Vector();
	java.util.Hashtable h = new java.util.Hashtable();
	JComboBox selectorComboBox; // filled from *.xml (see initValuesFromDOM())
	JLabel selectorLabel = new JLabel("Select backend");
	JPanel selectorPanel = new JPanel();
	Border border = new EtchedBorder(EtchedBorder.RAISED, Color.white, Color.darkGray); //new Color(148, 145, 140));
	JPanel parametersPanel = new JPanel();
	JPanel customParamPanel = new JPanel();
	// Common params panel with UI Elements
	JPanel commonParamPanel = new JPanel();
	JCheckBox dropCheckBox = new JCheckBox("Drop unused destination", true); //new JCheckBox();
	JCheckBox unicodeCheckBox = new JCheckBox("UNICODE annotations", true); //new JCheckBox();
	JComboBox zoomComboBox = new JComboBox(ZOOM_VALUE);
	JComboBox viewComboBox = new JComboBox(VIEW_VALUE);
	JLabel viewLabel = new JLabel("Set Inital view mode");
	JLabel zoomLabel = new JLabel("Set inital zoom value");
	JTextField zoomTextField = new JTextField();

	//  pdf options
	JPanel pdfPanel = new JPanel();
	JCheckBox ownerPSWCheckBox = new JCheckBox("Set owner password", false);
	JTextField ownerPSWTextField = new JTextField();
	JCheckBox userPSWCheckBox = new JCheckBox("Set user password", false);
	JTextField userPSWTextField = new JTextField();
	JLabel privLabel = new JLabel("User Privileges");
	JComboBox privComboBox = new JComboBox(PRIVEL_VALUE);
	JCheckBox compressCheckBox = new JCheckBox("Use PDF compression", true);
	JCheckBox linearizeCheckBox = new JCheckBox("Use PDF linearization", false);

	//  post script options
	JPanel psPanel = new JPanel();
	JCheckBox cloneCheckBox = new JCheckBox("Clone EPS images", true);
	JComboBox levelComboBox = new JComboBox(new String[] {"3", "2"});
	JLabel levelLabel = new JLabel("Select PS Level");


	// svg options
	JPanel svgPanel = new JPanel();
	JCheckBox svgEmbedImagesCheckBox = new JCheckBox("Embed images", false);
	JCheckBox svgBreakPagesCheckBox = new JCheckBox("Generate each page in separate file", false);
	JTextField svgGenerateFirstNPagesTextField = new JTextField("0");
	JLabel svgGenerateFirstNPagesLabel = new JLabel("Generate first N pages");
	
	// html options
	JPanel htmlPanel = new JPanel();
	JCheckBox htmlEmbedImagesCheckBox = new JCheckBox("Embed images", false);
	JCheckBox htmlBreakPagesCheckBox = new JCheckBox("Generate each page in separate file", false);
	JTextField htmlGenerateFirstNPagesTextField = new JTextField("0");
	JLabel htmlGenerateFirstNPagesLabel = new JLabel("Generate first N pages");
	JCheckBox htmlXFormsCheckBox = new JCheckBox("Generate XForms", false);

	// ppml options
	JPanel ppmlPanel = new JPanel();
	JComboBox targetComboBox = new JComboBox(new String[] {"PS", "PDF"});
	JLabel targetLabel = new JLabel("Select target format");
	JComboBox galevelComboBox = new JComboBox(new String[] {"0", "-1", "1", "2"});
	JLabel galevelLabel = new JLabel("Select Graphic Arts Conformance level ");
	
	//  afp options
	JPanel afpPanel = new JPanel();
	//JLabel AFPCodepageTxtLabel = new JLabel("Source Codepage");
	//JTextField AFPCodepageTxt = new JTextField();

	//JLabel AFPCodepageLabel = new JLabel("AFP Codepage");
	//JTextField AFPCodepage = new JTextField();

	JLabel AFPLogLevelLabel = new JLabel("Log Level");
	JComboBox AFPLogLevel = new JComboBox(AFP_LOG_LEVEL);

	JLabel ResolutionLabel = new JLabel("Resolution");
	JComboBox Resolution = new JComboBox(RESOLUTION);

	JLabel AFPGrayImageLabel = new JLabel("Convert image to gray");
	JCheckBox AFPGrayImage = new JCheckBox("", true);

	JLabel UseShadingPatternsLabel = new JLabel("Use shading patterns");//("USE_SHADING_PATTERNS");	
	JCheckBox UseShadingPatterns = new JCheckBox("", false);

	JLabel UseReplicateAndTrimLabel = new JLabel("Use replicate and trim");//("USE_REPLICATE_AND_TRIM");	
	JCheckBox UseReplicateAndTrim = new JCheckBox("", false);

	JLabel ShadingPatternResolutionLabel = new JLabel("Shading pattern resolution");//("SHADING_PATTERN_RESOLUTION");
	JTextField ShadingPatternResolution = new JTextField(5);

	JLabel TryUsingTIFFCompressionLabel = new JLabel("Try using TIFF compression");//("TRY_USING_TIFF_COMPRESSION");
	JCheckBox TryUsingTIFFCompression = new JCheckBox("", true);

	JLabel useBcocaLevelLabel = new JLabel("Use BC:OCA");//("USE_BCOCA_LEVEL");	
	JCheckBox useBcocaLevel = new JCheckBox("", false);

	JLabel useGocaLevelLabel = new JLabel("Use G:OCA");//("USE_GOCA_LEVEL");	
	JCheckBox useGocaLevel = new JCheckBox("", false);

	JLabel AFPFontsLabel = new JLabel("Font selector");
	JComboBox AFPFontsCombo;
	
	JButton addFont = new JButton("Add");
	JButton removeFont = new JButton("Remove");

	JPanel afpFontPanel = new JPanel();
	JTextField Value1 = new JTextField();
	JTextField Value2 = new JTextField();
	JTextField Value3 = new JTextField();
	JTextField Value4 = new JTextField();
	JTextField Value5 = new JTextField();
	JTextField Value6 = new JTextField();
	JTextField Value7 = new JTextField();
	JTextField Value8 = new JTextField();
	JTextField Value9 = new JTextField();

	JLabel ValueLabel1 = new JLabel("Regular:");
	JLabel ValueLabel5 = new JLabel("Symbolic:");
	JLabel ValueLabel2 = new JLabel("Regular:");
	JLabel ValueLabel6 = new JLabel("Symbolic:");
	JLabel ValueLabel3 = new JLabel("Regular:");
	JLabel ValueLabel7 = new JLabel("Symbolic:");
	JLabel ValueLabel4 = new JLabel("Regular:");
	JLabel ValueLabel8 = new JLabel("Symbolic:");
	JLabel ValueLabel9 = new JLabel("Word spacing:");
	
	JPanel normalNormal = new JPanel();
	JPanel normalItalic = new JPanel();
	JPanel boldNormal   = new JPanel();
	JPanel boldItalic   = new JPanel();
	JPanel wordSpacing  = new JPanel();

	String toolTip1 = createToolTip("Regular", "Normal", "Normal");
	String toolTip2 = createToolTip("Regular", "Normal", "Italic");
	String toolTip3 = createToolTip("Regular", "Bold", "Normal");
	String toolTip4 = createToolTip("Regular", "Bold", "Italic");
	String toolTip5 = createToolTip("Symbolic", "Normal", "Normal");
	String toolTip6 = createToolTip("Symbolic", "Normal", "Italic");
	String toolTip7 = createToolTip("Symbolic", "Bold", "Normal");
	String toolTip8 = createToolTip("Symbolic", "Bold", "Italic");
	
	CharsetsPanel charsetsPanel;
	
	int fmt;
/*
	JLabel ValueLabel1 = new JLabel("Font: weight=\"normal\" style=\"normal\"");
	JLabel ValueLabel2 = new JLabel("Font: weight=\"normal\" style=\"italic\"");
	JLabel ValueLabel3 = new JLabel("Font: weight=\"bold\"   style=\"normal\"");
	JLabel ValueLabel4 = new JLabel("Font: weight=\"bold\"   style=\"italic\"");
	JLabel ValueLabel5 = new JLabel("Symbolic font subset: weight=\"normal\" style=\"normal\"");
	JLabel ValueLabel6 = new JLabel("Symbolic font subset: weight=\"normal\" style=\"italic\"");
	JLabel ValueLabel7 = new JLabel("Symbolic font subset: weight=\"bold\"   style=\"normal\"");
	JLabel ValueLabel8 = new JLabel("Symbolic font subset: weight=\"bold\"   style=\"italic\"");
*/
	public BackendPanel(Document doc) { //int selected, Document doc) {
		this.doc = doc;
		model = DOMWalker.getDOMWalker(doc);////////////new DOMWalker(doc);

		try {
			jbInit();
		}
		catch (Exception e) {
			e.printStackTrace();
		}

		fmt = selectorComboBox.getSelectedIndex();
		setValuesFromDOM(bkNode[selectorComboBox.getSelectedIndex()]);
	}


	private void jbInit() throws Exception {
		this.setLayout(new BorderLayout());
		parametersPanel.setBorder(new TitledBorder(border, "Backend Parameters"));
		parametersPanel.setLayout(new BorderLayout());
		selectorComboBox = new JComboBox(DOMWalker.BACKEND_NAMES);
		selectorComboBox.setActionCommand("selectorComboBox");
		selectorComboBox.addActionListener(this);
		selectorComboBox.setSelectedIndex(0);
		selectorPanel.setBorder(border);
		zoomComboBox.setActionCommand("zoomCombo");
		viewLabel.setText("Set inital view mode");
		linearizeCheckBox.addActionListener(this);
		linearizeCheckBox.setActionCommand("linearizeCheckBox");
		linearizeCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);

		zoomTextField.setEnabled(false);
		zoomTextField.setEditable(false);
		zoomTextField.setText(" 100 ");
		zoomTextField.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"zoomTextField"));
			}
		});
		zoomTextField.setActionCommand("zoomTextField");
		selectorPanel.add(selectorLabel, null);
		selectorPanel.add(selectorComboBox, null);
		// UI Elements for Common params
		dropCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
		dropCheckBox.setActionCommand("Dropdest");
		dropCheckBox.addActionListener(this);

		unicodeCheckBox.setActionCommand("UNICODE");
		unicodeCheckBox.addActionListener(this);
		unicodeCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);

		viewComboBox.setActionCommand("viewComboBox");
		viewComboBox.addActionListener(this);
		zoomComboBox.setActionCommand("zoomComboBox");
		zoomComboBox.addActionListener(this);

		commonParamPanel.setLayout(new GridBagLayout());
		commonParamPanel.add(zoomLabel,    new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 0, 5, 0), 0, 0));
		commonParamPanel.add(zoomComboBox,
				new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0
						,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 0, 5, 0), 0, 0));
		commonParamPanel.add(viewLabel,   new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 0, 5, 0), 0, 0));
		commonParamPanel.add(viewComboBox,
				new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
						,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 0, 5, 0), 0, 0));
		commonParamPanel.add(dropCheckBox,
				new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
						,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 5, 0), 0, 0));
		commonParamPanel.add(unicodeCheckBox,
				new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0
						,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		commonParamPanel.add(zoomTextField,       new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0
				,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 0, 5, 0), 0, 0));

		// UI Elements for PDF-specific params
		pdfPanel.setLayout(new GridBagLayout()); //gridBagLayout2);

		ownerPSWCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
		ownerPSWCheckBox.setActionCommand("ownerPSWCheckBox");
		ownerPSWCheckBox.addActionListener(this);

		ownerPSWTextField.setEnabled(false);
		ownerPSWTextField.setPreferredSize(new Dimension(100, 21));
		ownerPSWTextField.setEditable(false);
		ownerPSWTextField.addActionListener(this);
		ownerPSWTextField.setActionCommand("ownerPSWTextField");
		ownerPSWTextField.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"ownerPSWTextField"));
			}
		});

		userPSWCheckBox.setHorizontalAlignment(SwingConstants.RIGHT);
		userPSWCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
		userPSWTextField.setEditable(false);
		userPSWTextField.setActionCommand("userPSWTextField");
		userPSWTextField.addActionListener(this);
		userPSWTextField.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"userPSWTextField"));
			}
		});

		userPSWTextField.setPreferredSize(new Dimension(100, 21));
		userPSWTextField.setEnabled(false);
		userPSWCheckBox.setActionCommand("userPSWCheckBox");
		userPSWCheckBox.addActionListener(this);

		privLabel.setHorizontalAlignment(SwingConstants.RIGHT);
		privComboBox.setActionCommand("privCombo");
		privComboBox.addActionListener(this);
		privComboBox.setEnabled(false);

		compressCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
		compressCheckBox.setActionCommand("compressCheckBox");
		compressCheckBox.addActionListener(this);

		pdfPanel.add(ownerPSWCheckBox,     new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 5), 1, 0));
		pdfPanel.add(ownerPSWTextField,   new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 0), 31, 2));
		pdfPanel.add(userPSWCheckBox,     new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 5), 0, 0));
		pdfPanel.add(userPSWTextField,   new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 0), 31, 2));
		pdfPanel.add(privLabel,     new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 5), 0, 0));
		pdfPanel.add(privComboBox,   new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 0), 0, 0));
		pdfPanel.add(compressCheckBox,    new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
				,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		pdfPanel.add(linearizeCheckBox,    new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
				,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		customParamPanel.add(pdfPanel, null); //////--> selectorComboBox action

		// UI Elements for PS-specific params
		psPanel.setLayout(new GridBagLayout()); 
		cloneCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
		cloneCheckBox.setActionCommand("cloneCheckBox");
		cloneCheckBox.addActionListener(this);

		levelLabel.setHorizontalAlignment(SwingConstants.RIGHT);
		levelComboBox.setActionCommand("levelComboBox");
		levelComboBox.addActionListener(this);
		
		// UI Elements for SVG-specific params
		svgPanel.setLayout(new GridBagLayout()); 
		svgEmbedImagesCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
		svgEmbedImagesCheckBox.setActionCommand("svgEmbedImagesCheckBox");
		svgEmbedImagesCheckBox.addActionListener(this);
		
		svgBreakPagesCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
		svgBreakPagesCheckBox.setActionCommand("svgBreakPagesCheckBox");
		svgBreakPagesCheckBox.addActionListener(this);
		
		svgGenerateFirstNPagesLabel.setHorizontalAlignment(SwingConstants.LEADING);
		svgGenerateFirstNPagesTextField.setPreferredSize(new Dimension(50, 21));
		svgGenerateFirstNPagesTextField.setEditable(true);
		svgGenerateFirstNPagesTextField.addActionListener(this);
		svgGenerateFirstNPagesTextField.setActionCommand("svgGenerateFirstNPagesTextField");
		svgGenerateFirstNPagesTextField.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"svgGenerateFirstNPagesTextField"));
			}
		});

		// UI Elements for HTML-specific params
		htmlPanel.setLayout(new GridBagLayout()); 
		htmlEmbedImagesCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
		htmlEmbedImagesCheckBox.setActionCommand("htmlEmbedImagesCheckBox");
		htmlEmbedImagesCheckBox.addActionListener(this);

		htmlBreakPagesCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
		htmlBreakPagesCheckBox.setActionCommand("htmlBreakPagesCheckBox");
		htmlBreakPagesCheckBox.addActionListener(this);
		
		htmlGenerateFirstNPagesLabel.setHorizontalAlignment(SwingConstants.LEADING);
		htmlGenerateFirstNPagesTextField.setPreferredSize(new Dimension(50, 21));
		htmlGenerateFirstNPagesTextField.setEditable(true);
		htmlGenerateFirstNPagesTextField.addActionListener(this);
		htmlGenerateFirstNPagesTextField.setActionCommand("htmlGenerateFirstNPagesTextField");
		htmlGenerateFirstNPagesTextField.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"htmlGenerateFirstNPagesTextField"));
			}
		});

		htmlXFormsCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
		htmlXFormsCheckBox.setActionCommand("htmlXFormsCheckBox");
		htmlXFormsCheckBox.addActionListener(this);

		// UI Elements for PPML-specific params
		ppmlPanel.setLayout(new GridBagLayout()); 
		targetLabel.setHorizontalAlignment(SwingConstants.RIGHT);
		targetComboBox.setActionCommand("targetComboBox");
		targetComboBox.addActionListener(this);
		galevelLabel.setHorizontalAlignment(SwingConstants.RIGHT);
		galevelComboBox.setActionCommand("galevelComboBox");
		galevelComboBox.addActionListener(this);

		// UI Elements for AFP-specific params


		Value1.setPreferredSize(new Dimension(70, 21));
		Value2.setPreferredSize(new Dimension(70, 21));
		Value3.setPreferredSize(new Dimension(70, 21));
		Value4.setPreferredSize(new Dimension(70, 21));
		Value5.setPreferredSize(new Dimension(70, 21));
		Value6.setPreferredSize(new Dimension(70, 21));
		Value7.setPreferredSize(new Dimension(70, 21));
		Value8.setPreferredSize(new Dimension(70, 21));
		Value9.setPreferredSize(new Dimension(70, 21));

		Value1.addActionListener(this);
		Value1.setActionCommand("Value1");
		Value1.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"Value1"));
			}
		});
		Value2.addActionListener(this);
		Value2.setActionCommand("Value2");
		Value2.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"Value2"));
			}
		});
		Value3.addActionListener(this);
		Value3.setActionCommand("Value3");
		Value3.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"Value3"));
			}
		});
		Value4.addActionListener(this);
		Value4.setActionCommand("Value4");
		Value4.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"Value4"));
			}
		});
		Value5.addActionListener(this);
		Value5.setActionCommand("Value5");
		Value5.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"Value5"));
			}
		});
		Value6.addActionListener(this);
		Value6.setActionCommand("Value6");
		Value6.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"Value6"));
			}
		});
		Value7.addActionListener(this);
		Value7.setActionCommand("Value7");
		Value7.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"Value7"));
			}
		});
		Value8.addActionListener(this);
		Value8.setActionCommand("Value8");
		Value8.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"Value8"));
			}
		});

		Value9.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"Value9"));
			}
		});


		AFPLogLevel.setActionCommand("afpLogLevel");
		AFPLogLevel.addActionListener(this);

		Resolution.setActionCommand("resolution");
		Resolution.addActionListener(this);

		AFPGrayImage.setActionCommand("afpGrayImage");
		AFPGrayImage.addActionListener(this);

		UseShadingPatterns.setActionCommand("useShadingPatterns");
		UseShadingPatterns.addActionListener(this);

		UseReplicateAndTrim.setActionCommand("useReplicateAndTrim");
		UseReplicateAndTrim.addActionListener(this);

		useBcocaLevel.setActionCommand("useBcocaLevel");
		useBcocaLevel.addActionListener(this);
		
		useGocaLevel.setActionCommand("useGocaLevel");
		useGocaLevel.addActionListener(this);
		
		ShadingPatternResolution.setActionCommand("shadingPatternResolution");
		ShadingPatternResolution.addActionListener(this);
		ShadingPatternResolution.addFocusListener(new java.awt.event.FocusAdapter() {
			public void focusLost(FocusEvent e) {
				actionPerformed(new ActionEvent(e.getSource(),e.getID(),"shadingPatternResolution"));
			}
		});

		TryUsingTIFFCompression.setActionCommand("tryUsingTIFFCompression");
		TryUsingTIFFCompression.addActionListener(this);

		NodeList opt = DOMWalker.optRoot.getElementsByTagName("option"); //doc.getElementsByTagName("generator-options");
		if (opt != null){
			for (int i = 0; i < opt.getLength(); i++) {
				Element nd = (Element)opt.item(i);
				if (nd.getAttributes().getNamedItem("name").getNodeValue().startsWith("AFPFont")){
					vec.add(nd.getAttributes().getNamedItem("name").getNodeValue());
				}
			}
		}


		AFPFontsCombo = new JComboBox(vec);
		AFPFontsCombo.setActionCommand("afpFontsCombo");
		AFPFontsCombo.addActionListener(this);

		addFont.addActionListener(this);
		addFont.setActionCommand("ADD_AFP_FONT");
		removeFont.addActionListener(this);
		removeFont.setActionCommand("REMOVE_AFP_FONT");
		if (vec.isEmpty()) removeFont.setEnabled(false);

		ShadingPatternResolution.setText("1.0");
		UseReplicateAndTrimLabel.setEnabled(false);
		UseReplicateAndTrim.setEnabled(false);
		ShadingPatternResolutionLabel.setEnabled(false);
		ShadingPatternResolution.setEnabled(false);
		TryUsingTIFFCompressionLabel.setEnabled(false);
		TryUsingTIFFCompression.setEnabled(false);
		
		afpPanel.setLayout(new BorderLayout());
	
        // Common parameters
		JPanel afpParamsPanel = new JPanel();
		afpParamsPanel.setLayout(new GridBagLayout()); 
		afpParamsPanel.setBorder(border);

		afpPanel.add(afpParamsPanel, BorderLayout.NORTH);
		
		JPanel afpFontParamsCenterPanel = new JPanel();
		
		afpPanel.add(afpFontParamsCenterPanel, BorderLayout.CENTER);

		afpFontParamsCenterPanel.setLayout(new GridBagLayout()); 
		
		afpFontParamsCenterPanel.setBorder(border);

		//CharsetsPanel charsetsPanel = new CharsetsPanel(border);		
		charsetsPanel = new CharsetsPanel(doc);
		charsetsPanel.setPreferredSize(new Dimension(600, 172));
		afpPanel.add(charsetsPanel, BorderLayout.SOUTH);

		
        // Common parameter's content

	// AFPLogLevel
	GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(6, 15, 0, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = GridBagConstraints.EAST;
        AFPLogLevelLabel.setHorizontalAlignment(SwingConstants.RIGHT);
        afpParamsPanel.add(AFPLogLevelLabel, c);
        c.insets = new Insets(6, 2, 0, 2);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = GridBagConstraints.WEST;
        afpParamsPanel.add(AFPLogLevel, c);

	// Resolution
        c.insets = new Insets(6, 15, 0, 2);
		c.gridx = 0;
        c.gridy = 1;
        c.anchor = GridBagConstraints.EAST;
        ResolutionLabel.setHorizontalAlignment(SwingConstants.RIGHT);
        afpParamsPanel.add(ResolutionLabel, c);
        c.insets = new Insets(6, 2, 0, 2);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = GridBagConstraints.WEST;
        afpParamsPanel.add(Resolution, c);
        
	// AFPGrayImage
        c.insets = new Insets(6, 15, 0, 2);
		c.gridx = 0;
        c.gridy = 2;
        c.anchor = GridBagConstraints.EAST;
        AFPGrayImageLabel.setHorizontalAlignment(SwingConstants.RIGHT);
        afpParamsPanel.add(AFPGrayImageLabel, c);
        c.insets = new Insets(6, 2, 0, 2);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = GridBagConstraints.WEST;
        afpParamsPanel.add(AFPGrayImage, c);

        // UseShadingPatterns
        c.insets = new Insets(6, 15, 0, 2);
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = GridBagConstraints.EAST;
        UseShadingPatternsLabel.setHorizontalAlignment(SwingConstants.RIGHT);
        afpParamsPanel.add(UseShadingPatternsLabel, c);
        c.insets = new Insets(6, 2, 0, 2);
        c.gridx = 3;
        c.gridy = 0;
        c.anchor = GridBagConstraints.WEST;
        afpParamsPanel.add(UseShadingPatterns, c);

        // UseReplicateAndTrim
        c.insets = new Insets(6, 15, 0, 2);
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = GridBagConstraints.EAST;
        UseReplicateAndTrimLabel.setHorizontalAlignment(SwingConstants.RIGHT);
        afpParamsPanel.add(UseReplicateAndTrimLabel, c);
        c.insets = new Insets(6, 2, 0, 2);
        c.gridx = 3;
        c.gridy = 1;
        c.anchor = GridBagConstraints.WEST;
        afpParamsPanel.add(UseReplicateAndTrim, c);

        // ShadingPatternResolution
        c.insets = new Insets(6, 15, 0, 2);
        c.gridx = 2;
        c.gridy = 2;
        c.anchor = GridBagConstraints.EAST;
        ShadingPatternResolutionLabel.setHorizontalAlignment(SwingConstants.RIGHT);
        afpParamsPanel.add(ShadingPatternResolutionLabel, c);
        c.insets = new Insets(6, 2, 0, 2);
        c.gridx = 3;
        c.gridy = 2;
        c.anchor = GridBagConstraints.WEST;
        afpParamsPanel.add(ShadingPatternResolution, c);

        // TryUsingTIFFCompression
        c.insets = new Insets(6, 15, 0, 2);
        c.gridx = 2;
        c.gridy = 3;
        c.anchor = GridBagConstraints.EAST;
        TryUsingTIFFCompressionLabel.setHorizontalAlignment(SwingConstants.RIGHT);
        afpParamsPanel.add(TryUsingTIFFCompressionLabel, c);
        c.insets = new Insets(6, 2, 0, 2);
        c.gridx = 3;
        c.gridy = 3;
        c.anchor = GridBagConstraints.WEST;
        afpParamsPanel.add(TryUsingTIFFCompression, c);
		
        // UseBcocaLevel
        c.insets = new Insets(6, 15, 0, 2);
        c.gridx = 4;
        c.gridy = 0;
        c.anchor = GridBagConstraints.EAST;
        useBcocaLevelLabel.setHorizontalAlignment(SwingConstants.RIGHT);
        afpParamsPanel.add(useBcocaLevelLabel, c);
        c.insets = new Insets(6, 2, 0, 15);
        c.gridx = 5;
        c.gridy = 0;
        c.anchor = GridBagConstraints.WEST;
        afpParamsPanel.add(useBcocaLevel, c);

        // UseGocaLevel
        c.insets = new Insets(6, 15, 0, 2);
        c.gridx = 4;
        c.gridy = 1;
        c.anchor = GridBagConstraints.EAST;
        useGocaLevelLabel.setHorizontalAlignment(SwingConstants.RIGHT);
        afpParamsPanel.add(useGocaLevelLabel, c);
        c.insets = new Insets(6, 2, 0, 15);
        c.gridx = 5;
        c.gridy = 1;
        c.anchor = GridBagConstraints.WEST;
        afpParamsPanel.add(useGocaLevel, c);
        
        
        // Font parameter's content
        
		// AFP Fonts
        JPanel afpFontListPanel = new JPanel();
        afpFontListPanel.add(AFPFontsLabel);
        afpFontListPanel.add(AFPFontsCombo);
        // Buttons
        afpFontListPanel.add(addFont);
        afpFontListPanel.add(removeFont);
        
        c.insets = new Insets(8, 10, 0, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.anchor = GridBagConstraints.CENTER;
        afpFontParamsCenterPanel.add(afpFontListPanel, c);
        c.gridwidth = 1;

        // Details font parameter's content
        
        // Group "Normal/Normal"
    	normalNormal.setBorder(new TitledBorder(border, " Normal / Normal "));
    	normalNormal.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = GridBagConstraints.CENTER;
        c.insets = new Insets(3, 10, 0, 0);
        afpFontParamsCenterPanel.add(normalNormal, c);

        // Value1
        c.insets = new Insets(1, 10, 0, 2);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = GridBagConstraints.EAST;
        ValueLabel1.setHorizontalAlignment(SwingConstants.RIGHT);
        ValueLabel1.setToolTipText(toolTip1);
    	normalNormal.add(ValueLabel1, c);
        c.insets = new Insets(1, 2, 0, 10);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = GridBagConstraints.WEST;
        Value1.setToolTipText(toolTip1);
        normalNormal.add(Value1, c);
        
        // Value5
        c.insets = new Insets(1, 10, 0, 2);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = GridBagConstraints.EAST;
        ValueLabel5.setHorizontalAlignment(SwingConstants.RIGHT);
        ValueLabel5.setToolTipText(toolTip5);
        normalNormal.add(ValueLabel5, c);
        c.insets = new Insets(1, 2, 0, 10);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = GridBagConstraints.WEST;
        Value5.setToolTipText(toolTip5);
        normalNormal.add(Value5, c);

        // Group "Normal/Italic"
    	normalItalic.setBorder(new TitledBorder(border, " Normal / Italic "));
    	normalItalic.setLayout(new GridBagLayout());
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = GridBagConstraints.CENTER;
        c.insets = new Insets(3, 6, 0, 0);
        afpFontParamsCenterPanel.add(normalItalic, c);

        // Value2
        c.insets = new Insets(1, 10, 0, 2);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = GridBagConstraints.EAST;
        ValueLabel2.setHorizontalAlignment(SwingConstants.RIGHT);
        ValueLabel2.setToolTipText(toolTip2);
        normalItalic.add(ValueLabel2, c);
        c.insets = new Insets(1, 2, 0, 10);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = GridBagConstraints.WEST;
        Value2.setToolTipText(toolTip2);
        normalItalic.add(Value2, c);
        
        // Value6
        c.insets = new Insets(1, 10, 0, 2);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = GridBagConstraints.EAST;
        ValueLabel6.setHorizontalAlignment(SwingConstants.RIGHT);
        ValueLabel6.setToolTipText(toolTip6);
        normalItalic.add(ValueLabel6, c);
        c.insets = new Insets(1, 2, 0, 10);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = GridBagConstraints.WEST;
        Value6.setToolTipText(toolTip6);
        normalItalic.add(Value6, c);

        // Group "Bold/Normal"
    	boldNormal.setBorder(new TitledBorder(border, " Bold / Normal "));
    	boldNormal.setLayout(new GridBagLayout());
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = GridBagConstraints.CENTER;
        c.insets = new Insets(3, 6, 0, 0);
        afpFontParamsCenterPanel.add(boldNormal, c);

        // Value3
        c.insets = new Insets(1, 10, 0, 2);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = GridBagConstraints.EAST;
        ValueLabel3.setHorizontalAlignment(SwingConstants.RIGHT);
        ValueLabel3.setToolTipText(toolTip3);
        boldNormal.add(ValueLabel3, c);
        c.insets = new Insets(1, 2, 0, 10);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = GridBagConstraints.WEST;
        Value3.setToolTipText(toolTip3);
        boldNormal.add(Value3, c);
        
        // Value7
        c.insets = new Insets(1, 10, 0, 2);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = GridBagConstraints.EAST;
        ValueLabel7.setHorizontalAlignment(SwingConstants.RIGHT);
        ValueLabel7.setToolTipText(toolTip7);
        boldNormal.add(ValueLabel7, c);
        c.insets = new Insets(1, 2, 0, 10);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = GridBagConstraints.WEST;
        Value7.setToolTipText(toolTip7);
        boldNormal.add(Value7, c);

        // Group "Bold/Italic"
    	boldItalic.setBorder(new TitledBorder(border, " Bold / Italic "));
    	boldItalic.setLayout(new GridBagLayout());
        c.gridx = 3;
        c.gridy = 1;
        c.anchor = GridBagConstraints.CENTER;
        c.insets = new Insets(3, 6, 0, 10);
        afpFontParamsCenterPanel.add(boldItalic, c);

        // Value4
        c.insets = new Insets(1, 10, 0, 2);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = GridBagConstraints.EAST;
        ValueLabel4.setHorizontalAlignment(SwingConstants.RIGHT);
        ValueLabel4.setToolTipText(toolTip4);
        boldItalic.add(ValueLabel4, c);
        c.insets = new Insets(1, 2, 0, 10);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = GridBagConstraints.WEST;
        Value4.setToolTipText(toolTip4);
        boldItalic.add(Value4, c);
        
        // Value8
        c.insets = new Insets(1, 10, 0, 2);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = GridBagConstraints.EAST;
        ValueLabel8.setHorizontalAlignment(SwingConstants.RIGHT);
        ValueLabel8.setToolTipText(toolTip8);
        boldItalic.add(ValueLabel8, c);
        c.insets = new Insets(1, 2, 0, 10);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = GridBagConstraints.WEST;
        Value8.setToolTipText(toolTip8);
        boldItalic.add(Value8, c);

        // Group "Word spacing"
        wordSpacing.setBorder(border);
        wordSpacing.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 4;
        c.anchor = GridBagConstraints.CENTER;
        c.insets = new Insets(3, 10, 6, 10);
        afpFontParamsCenterPanel.add(wordSpacing, c);
        c.gridwidth = 1;

        // Value9
        c.insets = new Insets(6, 10, 6, 2);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = GridBagConstraints.EAST;
        ValueLabel9.setHorizontalAlignment(SwingConstants.RIGHT);
        wordSpacing.add(ValueLabel9, c);
        c.insets = new Insets(3, 2, 6, 10);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = GridBagConstraints.CENTER;
        wordSpacing.add(Value9, c);
        
/*		
		AFPCodepageTxtLabel.setHorizontalAlignment(SwingConstants.RIGHT);
		afpPanel.add(AFPCodepageTxtLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 5, 10, 5), 0, 0));
		afpPanel.add(AFPCodepageTxt,  new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 10, 5), 0, 0));

		afpPanel.add(AFPCodepageLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 5, 10, 5), 0, 0));
		afpPanel.add(AFPCodepage, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 10, 5), 0, 0));

		afpPanel.add(AFPLogLevelLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 5, 10, 5), 0, 0));
		afpPanel.add(AFPLogLevel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 10, 5), 0, 0));

		afpPanel.add(ResolutionLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 5, 10, 5), 0, 0));
		afpPanel.add(Resolution,  new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 10, 5), 0, 0));

		afpPanel.add(AFPGrayImageLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 5, 10, 5), 0, 0));
		afpPanel.add(AFPGrayImage, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 10, 5), 0, 0));

		afpPanel.add(UseShadingPatternsLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 5, 10, 5), 0, 0));						
		afpPanel.add(UseShadingPatterns, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 10, 5), 0, 0));			

		afpPanel.add(UseReplicateAndTrimLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 5, 10, 5), 0, 0));
		afpPanel.add(UseReplicateAndTrim, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 10, 5), 0, 0));

		afpPanel.add(ShadingPatternResolutionLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 5, 10, 5), 0, 0));
		afpPanel.add(ShadingPatternResolution, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 10, 5), 30, 0));

		afpPanel.add(TryUsingTIFFCompressionLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 5, 10, 5), 0, 0));						
		afpPanel.add(TryUsingTIFFCompression, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 10, 5), 0, 0));

		afpPanel.add(AFPFontsLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 5, 10, 5), 0, 0));
		afpPanel.add(AFPFontsCombo, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 10, 5), 0, 0));
		afpPanel.add(addFont, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0
				,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 10, 5), 0, 0));
		afpPanel.add(removeFont, new GridBagConstraints(4, 3, 2, 1, 0.0, 0.0
				,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 10, 5), 0, 0));

		ValueLabel1.setHorizontalAlignment(SwingConstants.RIGHT);
		ValueLabel2.setHorizontalAlignment(SwingConstants.RIGHT);
		ValueLabel3.setHorizontalAlignment(SwingConstants.RIGHT);
		ValueLabel4.setHorizontalAlignment(SwingConstants.RIGHT);
		ValueLabel5.setHorizontalAlignment(SwingConstants.RIGHT);
		ValueLabel6.setHorizontalAlignment(SwingConstants.RIGHT);
		ValueLabel7.setHorizontalAlignment(SwingConstants.RIGHT);
		ValueLabel8.setHorizontalAlignment(SwingConstants.RIGHT);
		ValueLabel9.setHorizontalAlignment(SwingConstants.RIGHT);

		afpFontPanel.setLayout(new GridBagLayout()); 

		afpFontPanel.add(ValueLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0,25, 5), 0, 0));		
		afpFontPanel.add(Value1,  new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 25, 5), 0, 0));

		afpFontPanel.add(ValueLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 25, 5), 0, 0));		
		afpFontPanel.add(Value2,  new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 25, 5), 0, 0));

		afpFontPanel.add(ValueLabel3, new GridBagConstraints(0 , 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 25, 5), 0, 0));								
		afpFontPanel.add(Value3,  new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 25, 5), 0, 0));

		afpFontPanel.add(ValueLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 25, 5), 0, 0));								
		afpFontPanel.add(Value4,  new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 25, 5), 0, 0));

		afpFontPanel.add(ValueLabel5, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 25, 5), 0, 0));								
		afpFontPanel.add(Value5,  new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 25, 10), 0, 0));

		afpFontPanel.add(ValueLabel6, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 25, 5), 0, 0));								
		afpFontPanel.add(Value6,  new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 25, 10), 0, 0));

		afpFontPanel.add(ValueLabel7, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 25, 5), 0, 0));								
		afpFontPanel.add(Value7,  new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 25, 10), 0, 0));

		afpFontPanel.add(ValueLabel8, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 25, 5), 0, 0));								
		afpFontPanel.add(Value8,  new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 25, 10), 0, 0));

		afpFontPanel.add(ValueLabel9, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 25, 5), 0, 0));								
		afpFontPanel.add(Value9,  new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 25, 10), 0, 0));


		afpPanel.add(afpFontPanel, new GridBagConstraints(0, 6, 6, 2, 0.0, 0.0
				,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(15, 25, 0, 0), 0, 0));
*/
		customParamPanel.add(afpPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 25), 0, 0));

		this.add(selectorPanel, BorderLayout.NORTH);
		this.add(parametersPanel, BorderLayout.CENTER);
		parametersPanel.add(customParamPanel, BorderLayout.CENTER);



		//////////customParamPanel.add(psPanel, null);
		parametersPanel.add(commonParamPanel, BorderLayout.NORTH);
		psPanel.add(levelComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
				, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL,
				new Insets(0, 0, 0, 5), 85, 2));
		psPanel.add(cloneCheckBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0
				, GridBagConstraints.CENTER, GridBagConstraints.NONE,
				new Insets(0, 0, 0, 0), 0, 0));
		psPanel.add(levelLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
				, GridBagConstraints.WEST, GridBagConstraints.NONE,
				new Insets(0, 0, 0, 5), 30, 8));
		
		svgPanel.add(svgEmbedImagesCheckBox, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
			, GridBagConstraints.EAST, GridBagConstraints.NONE,
			new Insets(0, 0, 0, 0), 0, 0));
		svgPanel.add(svgBreakPagesCheckBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0
			, GridBagConstraints.EAST, GridBagConstraints.NONE,
			new Insets(0, 0, 0, 0), 0, 0));
		svgPanel.add(svgGenerateFirstNPagesLabel,     new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 5), 0, 0));
		svgPanel.add(svgGenerateFirstNPagesTextField,   new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 0), 0, 0));

		htmlPanel.add(htmlEmbedImagesCheckBox, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
			, GridBagConstraints.EAST, GridBagConstraints.NONE,
			new Insets(0, 0, 0, 0), 0, 0));
		htmlPanel.add(htmlBreakPagesCheckBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0
			, GridBagConstraints.EAST, GridBagConstraints.NONE,
			new Insets(0, 0, 0, 0), 0, 0));
		htmlPanel.add(htmlGenerateFirstNPagesLabel,     new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 5), 0, 0));
		htmlPanel.add(htmlGenerateFirstNPagesTextField,   new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
				,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 0), 0, 0));
		htmlPanel.add(htmlXFormsCheckBox, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0
			, GridBagConstraints.EAST, GridBagConstraints.NONE,
			new Insets(0, 0, 0, 0), 0, 0));

	//////////customParamPanel.add(ppmlPanel, null);
		parametersPanel.add(commonParamPanel, BorderLayout.NORTH);
		ppmlPanel.add(targetComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
				, GridBagConstraints.WEST, GridBagConstraints.NONE,
				new Insets(0, 0, 5, 5), 0, 0));
		ppmlPanel.add(targetLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
				, GridBagConstraints.EAST, GridBagConstraints.NONE,
				new Insets(0, 0, 5, 5), 0, 0));
		ppmlPanel.add(galevelComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
				, GridBagConstraints.WEST, GridBagConstraints.NONE,
				new Insets(0, 0, 5, 5), 0, 0));
		ppmlPanel.add(galevelLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
				, GridBagConstraints.EAST, GridBagConstraints.NONE,
				new Insets(0, 0, 5, 5), 0, 0));

		selectorComboBox.setSelectedIndex(0);
	}
	


	public void actionPerformed(ActionEvent e) {
		String action = e.getActionCommand();
		int ind = selectorComboBox.getSelectedIndex();

		if (action.equals("selectorComboBox")) {
			customParamPanel.removeAll();
			NodeList tmp = DOMWalker.optRoot.getElementsByTagName("generator-options"); //doc.getElementsByTagName("generator-options");
			Element bk = null;
			if (tmp != null){
				for (int i = 0; i < tmp.getLength(); i++) {
					Element nd = (Element)tmp.item(i);
					if (nd.getAttributes().getNamedItem("format").getNodeValue().
							equalsIgnoreCase(selectorComboBox.getSelectedItem().toString())){
						bk = nd;
						break;
					}
				}
			}
			if(bk == null){
				bk = doc.createElement("generator-options");
				bk.setAttribute("format", selectorComboBox.getItemAt(ind).toString());
				DOMWalker.optRoot.appendChild(bk);
			}
			if (bkNode[ind] == null)
				bkNode[ind] = bk;

			switch (ind) {
			case 0:
				parametersPanel.add(commonParamPanel, BorderLayout.NORTH);
				customParamPanel.add(pdfPanel, null);
				break;
			case 1:
				parametersPanel.add(commonParamPanel, BorderLayout.NORTH);
				customParamPanel.add(psPanel, null);
				break;
			case 2:
				customParamPanel.remove(pdfPanel);
				parametersPanel.remove(commonParamPanel);
				customParamPanel.add(afpPanel, null);
				break;
			case 3:
				customParamPanel.remove(pdfPanel);
				parametersPanel.remove(commonParamPanel);
				customParamPanel.add(svgPanel, null);
				break;
			case 4:
				customParamPanel.remove(pdfPanel);
				parametersPanel.remove(commonParamPanel);
				customParamPanel.add(htmlPanel, null);
				break;
			case 5:
				customParamPanel.remove(pdfPanel);
				parametersPanel.remove(commonParamPanel);
				customParamPanel.add(ppmlPanel, null);
				break;
			}
			customParamPanel.updateUI();
			
			fmt = selectorComboBox.getSelectedIndex();
			setValuesFromDOM(bkNode[selectorComboBox.getSelectedIndex()]);

		}
		else {
			if (action.equals("Dropdest"))
				model.setNameValueAttrs(bkNode[ind],"option","DROP_UNUSED_DESTINATIONS",""+dropCheckBox.isSelected());
			else if (action.equals("UNICODE"))
				model.setNameValueAttrs(bkNode[ind],"option","UNICODE_ANNOTATIONS",""+unicodeCheckBox.isSelected());
			else if (action.equals("viewComboBox"))
				model.setNameValueAttrs(bkNode[ind],"option","VIEW_MODE", viewComboBox.getSelectedItem().toString());
			else if (action.equals("zoomTextField"))
				model.setNameValueAttrs(bkNode[ind],"option","INITIAL_ZOOM", zoomTextField.getText().trim());
			else if (action.equals("zoomComboBox")){
				if (zoomComboBox.getSelectedIndex() == (ZOOM_VALUE.length - 1)){
					zoomTextField.setEditable(true);
					zoomTextField.setEnabled(true);
				}
				else {
					model.setNameValueAttrs(bkNode[ind],"option","INITIAL_ZOOM", zoomComboBox.getSelectedItem().toString());
					zoomTextField.setEditable(false);
					zoomTextField.setEnabled(false);
				}
			}
			else if (action.equals("ownerPSWTextField"))
				model.setNameValueAttrs(bkNode[ind],"option","OWNERPASSWORD", ownerPSWTextField.getText().trim());
			else if (action.equals("userPSWTextField"))
				model.setNameValueAttrs(bkNode[ind],"option","USERPASSWORD", userPSWTextField.getText().trim());
			else if (action.equals("privCombo"))
				model.setNameValueAttrs(bkNode[ind],"option","USERPRIVILEGES", privComboBox.getSelectedItem().toString());
			else if (action.equals("compressCheckBox"))
				model.setNameValueAttrs(bkNode[ind],"option","COMPRESS", ""+compressCheckBox.isSelected());
			else if (action.equals("linearizeCheckBox"))
				model.setNameValueAttrs(bkNode[ind],"option","LINEARIZE", ""+linearizeCheckBox.isSelected());
			else if (action.equals("ownerPSWCheckBox")) {
				ownerPSWTextField.setEnabled(ownerPSWCheckBox.isSelected());
				ownerPSWTextField.setEditable(ownerPSWCheckBox.isSelected());
				if(! ownerPSWCheckBox.isSelected())
					model.removeNode(bkNode[ind],"option","name","OWNERPASSWORD");
			}
			else if (action.equals("userPSWCheckBox")) {
				userPSWTextField.setEnabled(userPSWCheckBox.isSelected());
				userPSWTextField.setEditable(userPSWCheckBox.isSelected());
				privComboBox.setEnabled(userPSWCheckBox.isSelected());
				if(! userPSWCheckBox.isSelected()){
					model.removeNode(bkNode[ind], "option", "name", "USERPASSWORD");
					model.removeNode(bkNode[ind], "option", "name", "USERPRIVILEGES");
				}
			}
			////// PostScript options levelComboBox
			else if (action.equals("levelComboBox"))
				model.setNameValueAttrs(bkNode[ind],"option","LANGUAGE_LEVEL", levelComboBox.getSelectedItem().toString());
			else if (action.equals("cloneCheckBox"))
				model.setNameValueAttrs(bkNode[ind],"option","CLONE_EPS",""+cloneCheckBox.isSelected());
			///// SVG options
			else if (action.equals("svgEmbedImagesCheckBox"))
				model.setNameValueAttrs(bkNode[ind],"option","EMBED_IMAGES",""+svgEmbedImagesCheckBox.isSelected());
			else if (action.equals("svgBreakPagesCheckBox"))
				model.setNameValueAttrs(bkNode[ind],"option","BREAK_PAGES",""+svgBreakPagesCheckBox.isSelected());
			else if (action.equals("svgGenerateFirstNPagesTextField")) {
				String v = svgGenerateFirstNPagesTextField.getText().trim();
				try {
					int v1 = new Integer(v).intValue();
				} catch(NumberFormatException nfe) {
					JOptionPane.showMessageDialog( new JFrame(), "The value should be an integer.","Error", JOptionPane.OK_OPTION);
				}
				model.setNameValueAttrs(bkNode[ind],"option","GENERATE_FIRST_N_PAGES", svgGenerateFirstNPagesTextField.getText().trim());
			}
			///// HTML options
			else if (action.equals("htmlEmbedImagesCheckBox"))
				model.setNameValueAttrs(bkNode[ind],"option","EMBED_IMAGES",""+htmlEmbedImagesCheckBox.isSelected());
			else if (action.equals("htmlBreakPagesCheckBox"))
				model.setNameValueAttrs(bkNode[ind],"option","BREAK_PAGES",""+htmlBreakPagesCheckBox.isSelected());
			else if (action.equals("htmlGenerateFirstNPagesTextField")) {
				String v = htmlGenerateFirstNPagesTextField.getText().trim();
				try {
					int v1 = new Integer(v).intValue();
				} catch(NumberFormatException nfe) {
					JOptionPane.showMessageDialog( new JFrame(), "The value should be an integer.","Error", JOptionPane.OK_OPTION);
				}
				model.setNameValueAttrs(bkNode[ind],"option","GENERATE_FIRST_N_PAGES", htmlGenerateFirstNPagesTextField.getText().trim());
			}	
			else if (action.equals("htmlXFormsCheckBox"))
				model.setNameValueAttrs(bkNode[ind],"option","XFORMS",""+htmlXFormsCheckBox.isSelected());

			////// PPML options targetComboBox
			else if (action.equals("targetComboBox"))
				model.setNameValueAttrs(bkNode[ind],"option","TARGET_FORMAT", targetComboBox.getSelectedItem().toString());
			else if (action.equals("galevelComboBox"))
				model.setNameValueAttrs(bkNode[ind],"option","GA_LEVEL", galevelComboBox.getSelectedItem().toString());
			////// AFP options
			else if (action.equals("afpLogLevel"))
				model.setNameValueAttrs(bkNode[ind],"option","AFPLogLevel", ""+AFPLogLevel.getSelectedIndex());
			else if (action.equals("resolution"))
				model.setNameValueAttrs(bkNode[ind],"option","RESOLUTION", Resolution.getSelectedItem().toString());
			else if (action.equals("afpGrayImage"))
				model.setNameValueAttrs(bkNode[ind],"option","AFPGrayImage", ""+AFPGrayImage.isSelected());
			else if (action.equals("useShadingPatterns")){
				model.setNameValueAttrs(bkNode[ind],"option","USE_SHADING_PATTERNS", ""+UseShadingPatterns.isSelected());
				if(! UseShadingPatterns.isSelected()){

					// Do not need to remove nodes from tree;
					//model.removeNode(bkNode[ind], "option", "name", "USE_REPLICATE_AND_TRIM");
					//model.removeNode(bkNode[ind], "option", "name", "SHADING_PATTERN_RESOLUTION");
					//model.removeNode(bkNode[ind], "option", "name", "TRY_USING_TIFF_COMPRESSION");

					UseReplicateAndTrim.setEnabled(false);
					UseReplicateAndTrimLabel.setEnabled(false);
					ShadingPatternResolution.setEnabled(false);
					ShadingPatternResolutionLabel.setEnabled(false);
					TryUsingTIFFCompression.setEnabled(false);
					TryUsingTIFFCompressionLabel.setEnabled(false);						
				}else{
					UseReplicateAndTrim.setEnabled(true);
					UseReplicateAndTrimLabel.setEnabled(true);
					model.setNameValueAttrs(bkNode[ind],"option","USE_REPLICATE_AND_TRIM", ""+UseReplicateAndTrim.isSelected());					
					if (!UseReplicateAndTrim.isSelected()){
						ShadingPatternResolution.setEnabled(true);
						ShadingPatternResolutionLabel.setEnabled(true);
						TryUsingTIFFCompression.setEnabled(true);
						TryUsingTIFFCompressionLabel.setEnabled(true);
						model.setNameValueAttrs(bkNode[ind],"option","SHADING_PATTERN_RESOLUTION", ShadingPatternResolution.getText().trim());
						model.setNameValueAttrs(bkNode[ind],"option","TRY_USING_TIFF_COMPRESSION", ""+TryUsingTIFFCompression.isSelected());						
					}
				}
			}
			else if (action.equals("useReplicateAndTrim")){
				model.setNameValueAttrs(bkNode[ind],"option","USE_REPLICATE_AND_TRIM", ""+UseReplicateAndTrim.isSelected());
				if (UseShadingPatterns.isSelected() && !UseReplicateAndTrim.isSelected()){
					ShadingPatternResolution.setEnabled(true);
					ShadingPatternResolutionLabel.setEnabled(true);
					TryUsingTIFFCompression.setEnabled(true);
					TryUsingTIFFCompressionLabel.setEnabled(true);
					model.setNameValueAttrs(bkNode[ind],"option","SHADING_PATTERN_RESOLUTION", ShadingPatternResolution.getText().trim());
					model.setNameValueAttrs(bkNode[ind],"option","TRY_USING_TIFF_COMPRESSION", ""+TryUsingTIFFCompression.isSelected());		
				} else {

					// Do not need to remove nodes from tree;
					//model.removeNode(bkNode[ind], "option", "name", "SHADING_PATTERN_RESOLUTION");
					//model.removeNode(bkNode[ind], "option", "name", "TRY_USING_TIFF_COMPRESSION");

					ShadingPatternResolution.setEnabled(false);
					ShadingPatternResolutionLabel.setEnabled(false);
					TryUsingTIFFCompression.setEnabled(false);
					TryUsingTIFFCompressionLabel.setEnabled(false);				
				}
			}
			else if (action.equals("shadingPatternResolution")){
				model.setNameValueAttrs(bkNode[ind],"option","SHADING_PATTERN_RESOLUTION", ShadingPatternResolution.getText().trim());
				try {					
					float res = new Float(ShadingPatternResolution.getText()).floatValue();
					if (res<=0 || res>1.0){
						JOptionPane.showMessageDialog( new JFrame(), "The SHADING_PATTERN_RESOLUTION option value should be a float ( >0 and <=1.0 ).","Error", JOptionPane.OK_OPTION);
					}
				}catch (NumberFormatException nfe){
					JOptionPane.showMessageDialog( new JFrame(), "The SHADING_PATTERN_RESOLUTION option value should be a float ( >0 and <=1.0 ).","Error", JOptionPane.OK_OPTION);
				}

			}
			else if (action.equals("tryUsingTIFFCompression"))
				model.setNameValueAttrs(bkNode[ind], "option", "TRY_USING_TIFF_COMPRESSION", "" + TryUsingTIFFCompression.isSelected());			
			else if (action.equals("useBcocaLevel"))
				model.setNameValueAttrs(bkNode[ind], "option", "USE_BCOCA_LEVEL", "" + useBcocaLevel.isSelected());
			else if (action.equals("useGocaLevel"))
				model.setNameValueAttrs(bkNode[ind], "option", "USE_GOCA_LEVEL", "" + useGocaLevel.isSelected());
			else if (action.equals("afpFontsCombo")){
				char[] ch = Value9.getText().toCharArray();
				for (int i=0; i<ch.length; i++){
					if (!Character.isDigit(ch[i])){
						JOptionPane.showMessageDialog( new JFrame(), "The word spacing value should be an integer.","Error", JOptionPane.OK_OPTION);
						break;
					}
				}
				fmt = ind;
				setValuesFromDOM(bkNode[ind]);
				afpFontPanel.updateUI();
				afpPanel.updateUI();
			}
			else if (action.startsWith("Value")){
				if (AFPFontsCombo.getItemCount()!=0) {
					if (action.equals("Value9")) {
						char[] ch = Value9.getText().toCharArray();
						for (int i=0; i<ch.length; i++){
							if (!Character.isDigit(ch[i])){
								JOptionPane.showMessageDialog( new JFrame(), "The word spacing value should be an integer.","Error", JOptionPane.OK_OPTION);
								break;
							}
						}
					}
					String val = Value1.getText().toUpperCase()+", "+Value2.getText().toUpperCase()+", "+Value3.getText().toUpperCase()+", "
					+Value4.getText().toUpperCase()+", "+Value5.getText().toUpperCase()+", "+Value6.getText().toUpperCase()+", "
					+Value7.getText().toUpperCase()+", "+Value8.getText().toUpperCase()+", "+Value9.getText().toUpperCase();
					model.setNameValueAttrs(bkNode[ind],"option",AFPFontsCombo.getSelectedItem().toString(), val);

				}
			}
			else if (action.equals("ADD_AFP_FONT")){
				removeFont.setEnabled(true);
				NodeList temp = DOMWalker.fntRoot.getElementsByTagName("font-family");
				java.util.Vector fonts = new java.util.Vector();
				if (temp != null){
					for (int i = 0; i < temp.getLength(); i++) {
						Element nd = (Element)temp.item(i);
						fonts.add(nd.getAttributes().getNamedItem("name").getNodeValue());
					}
				}
				String s = null;
				if (fonts.isEmpty()) 
					JOptionPane.showMessageDialog( new JFrame(), "No fonts found!","Error", JOptionPane.OK_OPTION);
				else
					s = (String)JOptionPane.showInputDialog(
							new JFrame(),"Select font", "Select font", JOptionPane.INFORMATION_MESSAGE, null, fonts.toArray(), fonts.toArray()[0]);
				if (s!=null) {
					if (vec.indexOf("AFPFont,"+s)==-1) {
						AFPFontsCombo.addItem("AFPFont,"+s);
						AFPFontsCombo.updateUI();
						AFPFontsCombo.setSelectedItem("AFPFont,"+s);
						AFPFontsCombo.updateUI();

						Element bk = null;
						bk = doc.createElement("option");
						bk.setAttribute("name", s);
						bk.setAttribute("value", " ");

						Value1.setText("");
						Value2.setText("");
						Value3.setText("");
						Value4.setText("");
						Value5.setText("");
						Value6.setText("");
						Value7.setText("");
						Value8.setText("");
						Value9.setText("");
						String val = Value1.getText().toUpperCase()+", "+Value2.getText().toUpperCase()+", "+Value3.getText().toUpperCase()+", "
						+Value4.getText().toUpperCase()+", "+Value5.getText().toUpperCase()+", "+Value6.getText().toUpperCase()+", "
						+Value7.getText().toUpperCase()+", "+Value8.getText().toUpperCase()+", "+Value9.getText().toUpperCase();
						model.setNameValueAttrs(bkNode[ind],"option",AFPFontsCombo.getSelectedItem().toString(), val);
					} else {
						JOptionPane.showMessageDialog( new JFrame(), "The font is already mapped.","Error", JOptionPane.OK_OPTION);
					}
				}
			} else if (action.equals("REMOVE_AFP_FONT")){
				int count = AFPFontsCombo.getItemCount();
				if (count!=0) {
					model.removeNode(bkNode[ind],"option","name",AFPFontsCombo.getSelectedItem().toString());

					String i = AFPFontsCombo.getSelectedItem().toString();
					AFPFontsCombo.removeItem(i);
					AFPFontsCombo.updateUI();
					--count;
					if (count==0) {
						removeFont.setEnabled(false);
						Value1.setText("");
						Value2.setText("");
						Value3.setText("");
						Value4.setText("");
						Value5.setText("");
						Value6.setText("");
						Value7.setText("");
						Value8.setText("");
						Value9.setText("");
					} else {
						AFPFontsCombo.setSelectedIndex(count-1);
					}
				}
				if (count==0) {
					removeFont.setEnabled(false);
					AFPFontsCombo.setEditable(false);
					Value1.setText("");
					Value2.setText("");
					Value3.setText("");
					Value4.setText("");
					Value5.setText("");
					Value6.setText("");
					Value7.setText("");
					Value8.setText("");
					Value9.setText("");
				}
				AFPFontsCombo.updateUI();
			}
		}
	}



	void setValuesFromDOM(Node bRoot){		
		NodeList lst = bRoot.getChildNodes();
		for (int i = 0; i < lst.getLength(); i++) {
		    	if(lst.item(i).getNodeName().equalsIgnoreCase("charsets"))
		    	{		    	    
		    	    //charsetsPanel.setNode(lst.item(i));
		    	    //String name  = lst.item(i).getAttributes().getNamedItem("name").getNodeValue();
		    	    //String value = lst.item(i).getAttributes().getNamedItem("value").getNodeValue();

		    	    //System.out.println("Name: " + name);
		    	}
		    	    
			if(lst.item(i).getNodeName().equalsIgnoreCase("option")){
				String name  = lst.item(i).getAttributes().getNamedItem("name").getNodeValue();
				String value = lst.item(i).getAttributes().getNamedItem("value").getNodeValue();
				if (value == null) continue;
				boolean state = (value.length() > 0);

				//System.out.println("Name: " + name);
				if(name.equalsIgnoreCase("OWNERPASSWORD")){
					ownerPSWCheckBox.setSelected(state);
					ownerPSWTextField.setText(value);
					ownerPSWTextField.setEnabled(state);
					ownerPSWTextField.setEditable(state);
				}
				else if(name.equalsIgnoreCase("USERPASSWORD")){
					userPSWCheckBox.setSelected(state);
					userPSWTextField.setText(value);
					userPSWTextField.setEnabled(state);
					userPSWTextField.setEditable(state);
					privComboBox.setEnabled(state);
				}
				else if(name.equalsIgnoreCase("USERPRIVILEGES")){
					privComboBox.setSelectedItem(value);
				}
				else if(name.equalsIgnoreCase("COMPRESS")){
					compressCheckBox.setSelected(state && value.equalsIgnoreCase("true"));
				}
				else if(name.equalsIgnoreCase("LINEARIZE")){
					linearizeCheckBox.setSelected(state && value.equalsIgnoreCase("true"));
				}
				else if(name.equalsIgnoreCase("UNICODE_ANNOTATIONS")){
					unicodeCheckBox.setSelected(state && value.equalsIgnoreCase("true"));}
				else if(name.equalsIgnoreCase("DROP_UNUSED_DESTINATIONS")){
					dropCheckBox.setSelected(state && value.equalsIgnoreCase("true"));}
				else if(name.equalsIgnoreCase("INITIAL_ZOOM")){
					if(! Arrays.asList(ZOOM_VALUE).contains(value)){
						zoomTextField.setText(" "+value+" ");
						zoomTextField.setEditable(true);
						zoomTextField.setEnabled(true);
						zoomComboBox.setSelectedIndex(ZOOM_VALUE.length - 1);
					}
					else zoomComboBox.setSelectedItem(value);
				}
				else if(name.equalsIgnoreCase("VIEW_MODE")){
					viewComboBox.setSelectedItem(value);
				}
				else if(name.equalsIgnoreCase("LANGUAGE_LEVEL")){
					levelComboBox.setSelectedItem(value);
				}
				else if(name.equalsIgnoreCase("CLONE_EPS")){
					cloneCheckBox.setSelected(value.equalsIgnoreCase("true"));
				}
				else if(fmt==3 && name.equalsIgnoreCase("EMBED_IMAGES")){
					svgEmbedImagesCheckBox.setSelected(value.equalsIgnoreCase("true"));
				}
				else if(fmt==3 && name.equalsIgnoreCase("BREAK_PAGES")){
					svgBreakPagesCheckBox.setSelected(value.equalsIgnoreCase("true"));
				}
				else if(fmt==3 && name.equalsIgnoreCase("GENERATE_FIRST_N_PAGES")){
					svgGenerateFirstNPagesTextField.setText(value);
				}
				else if(fmt==4 && name.equalsIgnoreCase("EMBED_IMAGES")){
					htmlEmbedImagesCheckBox.setSelected(value.equalsIgnoreCase("true"));
				}
				else if(fmt==4 && name.equalsIgnoreCase("BREAK_PAGES")){
					htmlBreakPagesCheckBox.setSelected(value.equalsIgnoreCase("true"));
				}
				else if(fmt==4 && name.equalsIgnoreCase("GENERATE_FIRST_N_PAGES")){
					htmlGenerateFirstNPagesTextField.setText(value);
				}
				else if(fmt==4 && name.equalsIgnoreCase("XFORMS")){
					htmlXFormsCheckBox.setSelected(value.equalsIgnoreCase("true"));
				}
				else if(name.equalsIgnoreCase("TARGET_FORMAT")){
					targetComboBox.setSelectedItem(value);
				}
				else if(name.equalsIgnoreCase("GA_LEVEL")){
					galevelComboBox.setSelectedItem(value);
				}
				else if(name.equalsIgnoreCase("AFPLogLevel")){
					AFPLogLevel.setSelectedIndex(new Integer(value).intValue());
				}
				else if(name.equalsIgnoreCase("RESOLUTION")){
					Resolution.setSelectedItem(value);
				}
				else if(name.equalsIgnoreCase("AFPGrayImage")){
					AFPGrayImage.setSelected(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") ||value.equalsIgnoreCase("yes"));
				}
				else if(name.equalsIgnoreCase("USE_SHADING_PATTERNS")){
					UseShadingPatterns.setSelected(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") ||value.equalsIgnoreCase("yes"));

					UseReplicateAndTrimLabel.setEnabled(UseShadingPatterns.isSelected());
					UseReplicateAndTrim.setEnabled(UseShadingPatterns.isSelected());
					ShadingPatternResolutionLabel.setEnabled(UseShadingPatterns.isSelected() && !UseReplicateAndTrim.isSelected());
					ShadingPatternResolution.setEnabled(UseShadingPatterns.isSelected() && !UseReplicateAndTrim.isSelected());
					TryUsingTIFFCompressionLabel.setEnabled(UseShadingPatterns.isSelected() && !UseReplicateAndTrim.isSelected());
					TryUsingTIFFCompression.setEnabled(UseShadingPatterns.isSelected() && !UseReplicateAndTrim.isSelected());					
				}
				else if(name.equalsIgnoreCase("USE_REPLICATE_AND_TRIM")){
					UseReplicateAndTrim.setSelected(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") ||value.equalsIgnoreCase("yes"));
					UseReplicateAndTrimLabel.setEnabled(UseShadingPatterns.isSelected());
					UseReplicateAndTrim.setEnabled(UseShadingPatterns.isSelected());
					ShadingPatternResolutionLabel.setEnabled(UseShadingPatterns.isSelected() && !UseReplicateAndTrim.isSelected());
					ShadingPatternResolution.setEnabled(UseShadingPatterns.isSelected() && !UseReplicateAndTrim.isSelected());
					TryUsingTIFFCompressionLabel.setEnabled(UseShadingPatterns.isSelected() && !UseReplicateAndTrim.isSelected());
					TryUsingTIFFCompression.setEnabled(UseShadingPatterns.isSelected() && !UseReplicateAndTrim.isSelected());					
				}
				else if(name.equalsIgnoreCase("SHADING_PATTERN_RESOLUTION")){
					if (value==null) ShadingPatternResolution.setText("1.0");
					else ShadingPatternResolution.setText(value);
					ShadingPatternResolutionLabel.setEnabled(UseShadingPatterns.isSelected() && !UseReplicateAndTrim.isSelected());
					ShadingPatternResolution.setEnabled(UseShadingPatterns.isSelected() && !UseReplicateAndTrim.isSelected());
				}
				else if(name.equalsIgnoreCase("TRY_USING_TIFF_COMPRESSION")){
					TryUsingTIFFCompression.setSelected(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") ||value.equalsIgnoreCase("yes"));
					TryUsingTIFFCompressionLabel.setEnabled(UseShadingPatterns.isSelected() && !UseReplicateAndTrim.isSelected());
					TryUsingTIFFCompression.setEnabled(UseShadingPatterns.isSelected() && !UseReplicateAndTrim.isSelected());

				}
				else if(name.equalsIgnoreCase("USE_BCOCA_LEVEL")){
					useBcocaLevel.setSelected(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") ||value.equalsIgnoreCase("yes"));
				}
				else if(name.equalsIgnoreCase("USE_GOCA_LEVEL")){
					useGocaLevel.setSelected(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") ||value.equalsIgnoreCase("yes"));
				}
				else if(name.equalsIgnoreCase("charsets")){
					useGocaLevel.setSelected(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") ||value.equalsIgnoreCase("yes"));
				}				
				else if(!"AFPBetaStamp".equalsIgnoreCase(name)) {
					if (AFPFontsCombo.getItemCount()!=0) {
						if (name.equalsIgnoreCase(AFPFontsCombo.getSelectedItem().toString())) {
							if (value!=null){
								java.util.StringTokenizer tokens = new StringTokenizer(value, ",", true);

								String t1="", t2="", t3="", t4="", t5="", t6="", t7="", t8="", t9="";

								java.util.ArrayList arr = new java.util.ArrayList();
								String t = "";
								boolean chk = true;

								while (tokens.hasMoreTokens()) {
									t = tokens.nextToken();
									if (chk) {
										if (t.equals(",")){
											arr.add(" ");
											chk = true;
										}	else {
											arr.add(t);
											chk=false;
										}
									} else chk = true;
								}

								if (arr.size()>=1) t1=arr.get(0).toString();
								if (arr.size()>=2) t2=arr.get(1).toString();
								if (arr.size()>=3) t3=arr.get(2).toString();
								if (arr.size()>=4) t4=arr.get(3).toString();
								if (arr.size()>=5) t5=arr.get(4).toString();
								if (arr.size()>=6) t6=arr.get(5).toString();
								if (arr.size()>=7) t7=arr.get(6).toString();
								if (arr.size()>=8) t8=arr.get(7).toString();
								if (arr.size()>=9) t9=arr.get(8).toString();


								java.util.StringTokenizer tokens1 = new StringTokenizer(t1, " ");
								if (tokens1.hasMoreTokens()) Value1.setText(tokens1.nextToken());
								else Value1.setText("");

								java.util.StringTokenizer tokens2 = new StringTokenizer(t2, " ");
								if (tokens2.hasMoreTokens()) Value2.setText(tokens2.nextToken());
								else Value2.setText("");

								java.util.StringTokenizer tokens3 = new StringTokenizer(t3, " ");
								if (tokens3.hasMoreTokens()) Value3.setText(tokens3.nextToken());
								else Value3.setText("");								

								java.util.StringTokenizer tokens4 = new StringTokenizer(t4, " ");
								if (tokens4.hasMoreTokens()) Value4.setText(tokens4.nextToken());
								else Value4.setText("");

								java.util.StringTokenizer tokens5 = new StringTokenizer(t5, " ");
								if (tokens5.hasMoreTokens()) Value5.setText(tokens5.nextToken());
								else Value5.setText("");								

								java.util.StringTokenizer tokens6 = new StringTokenizer(t6, " ");
								if (tokens6.hasMoreTokens()) Value6.setText(tokens6.nextToken());
								else Value6.setText("");								

								java.util.StringTokenizer tokens7 = new StringTokenizer(t7, " ");
								if (tokens7.hasMoreTokens()) Value7.setText(tokens7.nextToken());
								else Value7.setText("");								

								java.util.StringTokenizer tokens8 = new StringTokenizer(t8, " ");
								if (tokens8.hasMoreTokens()) Value8.setText(tokens8.nextToken());
								else Value8.setText("");								

								java.util.StringTokenizer tokens9 = new StringTokenizer(t9, " ");
								if (tokens9.hasMoreTokens()) Value9.setText(tokens9.nextToken());
								else Value9.setText("");
								//break;
							} else {	
								Value1.setText("");
								Value2.setText("");
								Value3.setText("");
								Value4.setText("");
								Value5.setText("");
								Value6.setText("");
								Value7.setText("");
								Value8.setText("");
								Value9.setText("");
							}
						}
					} else {
						Value1.setText("");
						Value2.setText("");
						Value3.setText("");
						Value4.setText("");
						Value5.setText("");
						Value6.setText("");
						Value7.setText("");
						Value8.setText("");
						Value9.setText("");
					}
				}

			}
		}
	}
	
	private String createToolTip(String header, String weight, String style) {
	    StringBuffer sb = new StringBuffer();
	    sb.append("<html><body><table>");
	    sb.append("<tr><td align='center' border='1' cellspacing='0' cellpadding='1' colspan='2'>");
	    sb.append(header);
	    sb.append("</td></tr>");
	    sb.append("<tr><td align='right' cellspacing='0' cellpadding='1'>Weight:</td>");
	    sb.append("<td align='left' cellspacing='0' cellpadding='1' color='blue'>");
	    sb.append(weight);
	    sb.append("</td></tr>");
	    sb.append("<tr><td align='right' cellspacing='0' cellpadding='1'>Style:</td>");
	    sb.append("<td align='left' cellspacing='0' cellpadding='1' color='blue'>");
	    sb.append(style);
	    sb.append("</td></tr>");
	    sb.append("</table></body></html>");
	    return sb.toString();
	}


	/**
	 * @return the border
	 */
	public Border getBorder()
	{
	    return border;
	}
}

