package com.renderx.xepx.x4u.as;

import javax.swing.*;
import java.awt.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.io.*;

class RootFrame extends JFrame {
	
	JMenuBar menu = new JMenuBar();
  JMenuItem stop,start;
	JMenu options;

	private Settings settings;
	private Formatter formatter;
	private UI ui;
	private Help helps = new Help();
	
  private JTabbedPane tabbedPane = new JTabbedPane();  
	private SourceTab srctab;
	private boolean fileIsOpened;
	
	
	RootFrame(Settings settings,Formatter formatter,UI ui) {
		this.settings = settings;
		this.formatter = formatter;
		this.ui = ui;

		ActionListener menuListener = new MenuListener();

		addWindowListener(new java.awt.event.WindowAdapter () {
			public void windowClosing(WindowEvent evt) { 
				try {
					if (!RootFrame.this.settings.source.equals("")) RootFrame.this.settings.save();
				} catch(Exception ex) {
					JOptionPane.showMessageDialog(RootFrame.this,
						"Could not save settings for future runs:\n"+ex.getMessage(),
						"Error", JOptionPane.OK_OPTION);
				}
				dispose();
			}
		});
//Setting frame's view
		setSize(new Dimension(800, 600));
    setTitle("XEP Assistant");
		setJMenuBar(menu);
		JPanel mainPanel = new JPanel();
		getContentPane().add(mainPanel,  BorderLayout.CENTER);
		mainPanel.setLayout(new BorderLayout());
		mainPanel.add(tabbedPane,  BorderLayout.CENTER);

//File menu with it's submenus
		JMenu file = new JMenu("<html><u>F</u>ile");
		JMenuItem open = new JMenuItem("<html><u>0</u>pen...");
		JMenuItem close = new JMenuItem("<html><u>C</u>lose");
		JMenuItem quit = new JMenuItem("<html><u>Q</u>uit");
		file.add(open);
		file.add(close); 
		file.add(quit); 
		
//Hot Keys: File menu - Alt+F; Close submenu - C+C; Open submenu - C+O; Quit submenu - C+Q
		file.setMnemonic(KeyEvent.VK_F);
		open.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK));
		close.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, Event.CTRL_MASK));
		quit.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q, Event.CTRL_MASK));
		
//Adding action listener to File menu items
		open.setActionCommand("OPEN");
		close.setActionCommand("CLOSE");
		quit.setActionCommand("QUIT");
		open.addActionListener(menuListener);
		close.addActionListener(menuListener);
		quit.addActionListener(menuListener);
		
//Formatting menu with it's submenus
		JMenu formatting = new JMenu("<html>For<u>m</u>atting");
		start = new JMenuItem("<html><u>S</u>tart");
		stop = new JMenuItem("<html>S<u>t</u>op");
		formatting.add(start);
		formatting.add(stop);
		
		
//Hot keys: Formatting menu - Alt+M; Run submenu - C+R; Stop submenu - C+T; Settings submenu - C+S
		formatting.setMnemonic(KeyEvent.VK_M);
		stop.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_T, Event.CTRL_MASK));
		start.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, Event.CTRL_MASK));
		
//Adding action listener to Formatting menu with items
		stop.setActionCommand("STOP");
		start.setActionCommand("START");
		stop.addActionListener(menuListener);
		start.addActionListener(menuListener);
		
//Options menu: hot key: Alt+O; Edit submenu - C+E
		options = new JMenu("<html><u>O</u>ptions");
		options.setMnemonic(KeyEvent.VK_O);
		JMenuItem edit = new JMenuItem("<html><u>E</u>dit");
		edit.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E, Event.CTRL_MASK));
		edit.setActionCommand("EDIT");
		edit.addActionListener(menuListener);
		options.add(edit);
		
//Help menu with it's submenus
		JMenu help = new JMenu("<html><u>H</u>elp");
		JMenuItem contents = new JMenuItem("<html>Conte<u>n</u>ts");
		JMenuItem about = new JMenuItem("<html><u>A</u>bout...");
		help.add(contents);
		help.add(about);
		
//Hot keys: Help menu - Alt+H; Contents submenu - C+N; About submenu - C+A;
		help.setMnemonic(KeyEvent.VK_H);
		contents.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, Event.CTRL_MASK));
		about.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_A, Event.CTRL_MASK));
		
//Adding action listener to Help menu
		contents.setActionCommand("CONTENTS");
		about.setActionCommand("ABOUT");
		contents.addActionListener(menuListener);
		about.addActionListener(menuListener);

//MenuBar		
		menu.add(file);
		menu.add(formatting);
		menu.add(options);
		menu.add(help);
		setJMenuBar(menu);
		
//Open previous file
		//openFileWithoutChoose();
  }
	
    private void openFileWithoutChoose()
    {
	tabbedPane.removeAll();
	ui.logtab.clear();

	File selectedFile = new File(settings.source);

	settings.source = selectedFile.getAbsolutePath();
	try
	{
	    srctab = new SourceTab(selectedFile.toURL());
	} catch (Exception ex)
	{
	    JOptionPane.showMessageDialog(tabbedPane, "Cannot open "
		    + selectedFile + ", the problem source is "
		    + ex.getMessage(), "Error", JOptionPane.OK_OPTION);
	    return;
	}
	tabbedPane.addTab(settings.source, srctab);
	tabbedPane.addTab("Event Log", ui.logtab);
	tabbedPane.setSelectedComponent(srctab);
	settings.result = Util.replext(settings.source, settings.format);

    }
    
	class MenuListener implements ActionListener {

		public void openFile() {
				fileIsOpened = true;
				tabbedPane.removeAll();
				ui.logtab.clear();
				
				FileChooser filechooser = new FileChooser(settings.dir, new String[] {"xml", "dbx", "fo"});
				if	(filechooser.showOpenDialog(RootFrame.this)==JFileChooser.APPROVE_OPTION) {
					File selectedFile = filechooser.getSelectedFile();
					settings.source = selectedFile.getAbsolutePath();
					settings.dir = settings.source;
					try
					{
						srctab = new SourceTab(selectedFile.toURL());
					}
					catch(Exception ex)
					{
						JOptionPane.showMessageDialog(tabbedPane, "Cannot open "+selectedFile+", the problem source is "+ex.getMessage(), "Error", JOptionPane.OK_OPTION);
						fileIsOpened = false;
						return;
					}
					tabbedPane.addTab(settings.source, srctab);
					tabbedPane.addTab("Event Log",ui.logtab);
					tabbedPane.setSelectedComponent(srctab);
					settings.result = Util.replext(settings.source, settings.format);
				} else fileIsOpened = false;
		}
		
		public void start() {
			tabbedPane.setSelectedComponent(ui.logtab);
			SettingsPanel sp = new SettingsPanel(RootFrame.this, settings);
			if(sp.startFormatting) {
				start.setEnabled(false);
				ui.logtab.clear();
				formatter.start(settings.getXEPConfigPath());
				ui.timer.start();
			}
		}
		

		public void actionPerformed(ActionEvent e) {
			String command = e.getActionCommand();
			

			if(command.equals("OPEN")) {
				openFile();
			} else if (command.equals("CLOSE")) {
				tabbedPane.removeAll();
			} else if (command.equals("QUIT")) {
				try {
					settings.save();
				} catch(Exception ex) {
					JOptionPane.showMessageDialog(tabbedPane,
						"Could not save settings for future runs:\n"+ex.getMessage(),
						"Error", JOptionPane.OK_OPTION);
				}
				System.exit(0);
			} else if (command.equals("START")) {
				try{
					start();
				}catch(IllegalArgumentException ex){
					openFile();
					if (fileIsOpened) start();
					//JOptionPane.showMessageDialog(tabbedPane, "Nothing reasonable to format", "Error", JOptionPane.OK_OPTION);
				}
			} else if (command.equals("STOP")) {
				start.setEnabled(true);
				formatter.stop();
				ui.timer.stop();
			} else if (command.equals("EDIT")) {
				com.renderx.xepx.x4u.ct.ConfigTools config = new com.renderx.xepx.x4u.ct.ConfigTools(RootFrame.this, settings.getXEPConfigPath(), false); 
			} else if (command.equals("CONTENTS")) {
				helps.contents(RootFrame.this);
			} else if (command.equals("ABOUT")) {
				helps.about(RootFrame.this);
			}
		}
		
		
	}
	
}
