/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xepout;

import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.SvgLevelParams;
import com.renderx.graphics.XMLVectorImage;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.sax.SAXStorage;
import com.renderx.xepout.ParseTerminationException;
import com.renderx.xepout.Parser;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XEPOUTImage
extends XMLVectorImage {
    private SAXStorage storage = null;

    public XEPOUTImage() {
        this.mimetype = "application/xepout";
    }

    public void parse(XMLReader xMLReader, InputSource inputSource) throws IOException, ImageFormatException, SAXException {
        try {
            xMLReader.setContentHandler(new XEPOUTReader());
            xMLReader.parse(inputSource);
        }
        catch (ParseTerminationException parseTerminationException) {
            // empty catch block
        }
        this.supportsVectorRendering = true;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.storage.setContentHandler(contentHandler);
    }

    public void play() throws SAXException {
        this.storage.play();
    }

    public ImageTree getImageTree(XMLReader xMLReader, InputSource inputSource, int n, SvgLevelParams svgLevelParams) throws IOException, ImageFormatException, SAXException {
        return new Parser(this.factory, this.factory.fontCatalog, this.factory.errHandler).parse(xMLReader, inputSource, this.source.getBase(), this.width, this.height);
    }

    class XEPOUTReader
    extends DefaultHandler {
        final String XEPOUTURI = "http://www.renderx.com/XEP/xep";

        XEPOUTReader() {
        }

        public void startDocument() {
            XEPOUTImage.this.storage = new SAXStorage();
        }

        public void endDocument() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!"http://www.renderx.com/XEP/xep".equals(string)) {
                throw new SAXException("Root element in a 'watermark' image " + XEPOUTImage.this.toDisplayString() + " is not in the XEPOUT namespace (" + "http://www.renderx.com/XEP/xep" + ")");
            }
            if (!"document".equals(string2)) {
                if ("page".equals(string2)) {
                    XEPOUTImage.this.width = this.parseLength(attributes.getValue("width"));
                    XEPOUTImage.this.height = this.parseLength(attributes.getValue("height"));
                } else {
                    XEPOUTImage.this.storage.startElement(string, string2, string3, attributes);
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("page".equals(string2)) {
                throw new ParseTerminationException();
            }
            XEPOUTImage.this.storage.endElement(string, string2, string3);
        }

        private final float parseLength(String string) {
            return Float.valueOf(string).floatValue() / 1000.0f;
        }
    }
}

