/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.gen.backends;

import com.renderx.graphics.ImageFactory;
import com.renderx.util.ErrorHandler;
import com.renderx.util.URLSpec;
import com.renderx.xep.gen.H4base;
import com.renderx.xep.gen.backends.Stamp;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.LicenseException;
import com.renderx.xep.lib.Session;
import com.renderx.xpslib.XPSDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class H4XPS
extends H4base {
    private XPSDocument xps = null;
    private boolean emptyPage = false;
    private boolean PAGE_REORDERING;
    private float fontStretch = 1.0f;
    public String XEPURI = "http://www.renderx.com/XEP/xep";
    private Hashtable Targets = new Hashtable();
    private int currentPageNumber = 0;
    private float SCALE = 1000.0f;
    private int skip = 0;
    private static final short O_PAGE_REORDERING = 0;
    private static final Hashtable optab = new Hashtable();

    public H4XPS(OutputStream outputStream, Session session, Properties properties) throws IOException, LicenseException {
        super(outputStream, session, properties);
        if (!session.config.XPS && !session.config.XPSTrial) {
            session.error("XPS support is not licensed for this installation.");
            throw new LicenseException("XPS support is not licensed for this installation.");
        }
        this.SCALE = 1000.0f;
    }

    private static final float parseLengthSpecifier(String string) throws NumberFormatException {
        double d = 1.0;
        if (string.endsWith("pt")) {
            d = 1.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("in")) {
            d = 72.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("px")) {
            d = 0.6;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("pc")) {
            d = 12.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("cm")) {
            d = 28.346456692913385;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("mm")) {
            d = 2.834645669291339;
            string = string.substring(0, string.length() - 2);
        } else {
            throw new NumberFormatException("Unknown measurement units in '" + string + "'");
        }
        return (float)(Double.valueOf(string.trim()) * d);
    }

    private final String resolveURL(String string, String string2) {
        String string3;
        if (string2 != null && string2.trim().startsWith("url") && (string3 = string2.trim().substring(3).trim()).length() > 2 && string3.charAt(0) == '(' && string3.charAt(string3.length() - 1) == ')' && (string3 = string3.substring(1, string3.length() - 1).trim()).length() > 2) {
            if (string3.charAt(0) == '\'' && string3.charAt(string3.length() - 1) == '\'' || string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                string3 = string3.substring(1, string3.length() - 1);
            }
            return string3;
        }
        this.session.warning("Incorrect syntax in " + string + "; should be: url('<sorce name>')");
        return string2;
    }

    protected void setOption(String string, String string2) {
        Object v = optab.get(string);
        if (v == null) {
            this.session.warning("Unrecognized XPS option " + string + ": setting ignored.");
            return;
        }
        switch ((Short)v) {
            case 0: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.PAGE_REORDERING = true;
                    this.currentPageNumber = -1;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.PAGE_REORDERING = false;
                    break;
                }
                this.session.warning("Invalid PAGE_REORDERING value: " + string2 + "; setting ignored");
            }
        }
    }

    protected void resetDefaultOptions() {
        this.PAGE_REORDERING = false;
    }

    public String outFormat() {
        return "xps";
    }

    protected String getPropertyPrefix() {
        return "com.renderx.xep.H4XPS.";
    }

    protected String getProcessingInstructionPrefix() {
        return "xep-xps-";
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        try {
            this.xps = new XPSDocument(this.outstream, (ImageFactory)this.session.config.imageFactory, this.session.config.fontCatalog, (ErrorHandler)this.session, this.session, this.SCALE, this);
        }
        catch (RuntimeException runtimeException) {
            throw new XPSException(runtimeException);
        }
        catch (Exception exception) {
            throw new InternalException("fatal error at the start of document " + exception);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.xps.endDocument();
        }
        catch (RuntimeException runtimeException) {
            throw new XPSException(runtimeException);
        }
        catch (Exception exception) {
            throw new InternalException("fatal error at the end of document " + exception);
        }
        super.endDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.skip > 0) {
            ++this.skip;
            return;
        }
        if (!this.XEPURI.equals(string)) {
            this.skip = 1;
            return;
        }
        if (this.emptyPage) {
            return;
        }
        try {
            switch ((Short)H4base.idtab.get(string2)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.fontStretch = 1.0f;
                    this.currentPageNumber = this.PAGE_REORDERING ? H4XPS.parseInteger(attributes.getValue("page-number")) : ++this.currentPageNumber;
                    float f = H4XPS.parseLength(attributes.getValue("height")) * 96.0f / this.SCALE / 72.0f;
                    float f2 = H4XPS.parseLength(attributes.getValue("width")) * 96.0f / this.SCALE / 72.0f;
                    if (f < 48.0f) {
                        f = 48.0f;
                    }
                    if (f2 < 48.0f) {
                        f2 = 48.0f;
                    }
                    this.xps.beginPage(this.currentPageNumber, f2, f);
                    if (this.session.config.XPSTrial && this.currentPageNumber > 10 && this.currentPageNumber % 2 == 1) {
                        this.emptyPage = true;
                        break;
                    }
                    this.xps.transform(0.0013333334f, 0.0f, 0.0f, -0.0013333334f, 0.0f, f);
                    break;
                }
                case 2: {
                    this.xps.rotate(H4XPS.parseAngle(attributes.getValue("phi")));
                    break;
                }
                case 3: {
                    this.xps.translate(H4XPS.parseLength(attributes.getValue("x")), H4XPS.parseLength(attributes.getValue("y")));
                    break;
                }
                case 4: {
                    this.xps.transform(H4XPS.parseFloat(attributes.getValue("a")), H4XPS.parseFloat(attributes.getValue("b")), H4XPS.parseFloat(attributes.getValue("c")), H4XPS.parseFloat(attributes.getValue("d")), H4XPS.parseFloat(attributes.getValue("e")) * this.SCALE, H4XPS.parseFloat(attributes.getValue("f")) * this.SCALE);
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    this.fontStretch = H4XPS.parseFloat(attributes.getValue("value"));
                    break;
                }
                case 9: {
                    this.xps.selectFont(attributes.getValue("family"), H4XPS.parseInteger(attributes.getValue("weight")), attributes.getValue("style"), attributes.getValue("variant"), H4XPS.parseLength(attributes.getValue("size")));
                    break;
                }
                case 10: 
                case 45: {
                    float f = H4XPS.parseLength(attributes.getValue("x"));
                    float f3 = H4XPS.parseLength(attributes.getValue("y"));
                    this.xps.transform(this.fontStretch, 0.0f, 0.0f, -1.0f, f, f3);
                    this.xps.printText(0.0f, 0.0f, attributes.getValue("value"));
                    this.xps.closeCanvas();
                    break;
                }
                case 11: {
                    float f = H4XPS.parseLength(attributes.getValue("thickness"));
                    if (f <= 0.0f) break;
                    float f4 = H4XPS.parseLength(attributes.getValue("x-from"));
                    float f5 = H4XPS.parseLength(attributes.getValue("y-from"));
                    float f6 = H4XPS.parseLength(attributes.getValue("x-till"));
                    float f7 = H4XPS.parseLength(attributes.getValue("y-till"));
                    this.xps.putLine(f4, f5, f6, f7, f, attributes.getValue("style"));
                    break;
                }
                case 15: {
                    String string4 = attributes.getValue("nocache");
                    String string5 = attributes.getValue("type");
                    float f = H4XPS.parseFloat(attributes.getValue("scale-x"));
                    float f8 = H4XPS.parseFloat(attributes.getValue("scale-y"));
                    if (f != 0.0f) {
                        if (f8 == 0.0f) break;
                        float f9 = H4XPS.parseLength(attributes.getValue("x-from"));
                        float f10 = H4XPS.parseLength(attributes.getValue("y-from"));
                        String string6 = attributes.getValue("src");
                        String string7 = attributes.getValue("base");
                        URLSpec uRLSpec = string7 == null ? new URLSpec(string6) : new URLSpec(new URLSpec(string7), string6);
                        this.xps.drawImage(uRLSpec, string5, f9, f10, f, f8, string4 == null);
                    }
                    break;
                }
                case 17: {
                    this.xps.setGreyColor(H4XPS.parseFloat(attributes.getValue("gray")));
                    break;
                }
                case 16: {
                    this.xps.setRGBColor(H4XPS.parseFloat(attributes.getValue("red")), H4XPS.parseFloat(attributes.getValue("green")), H4XPS.parseFloat(attributes.getValue("blue")));
                    break;
                }
                case 18: {
                    this.xps.setCMYKColor(H4XPS.parseFloat(attributes.getValue("cyan")), H4XPS.parseFloat(attributes.getValue("magenta")), H4XPS.parseFloat(attributes.getValue("yellow")), H4XPS.parseFloat(attributes.getValue("black")));
                    break;
                }
                case 19: {
                    float f = H4XPS.parseFloat(attributes.getValue("tint"));
                    if (attributes.getValue("alt-gray") != null) {
                        f = 1.0f - f;
                        this.xps.setGreyColor(f * H4XPS.parseFloat(attributes.getValue("alt-gray")));
                        break;
                    }
                    if (attributes.getValue("alt-red") != null) {
                        f = 1.0f - f;
                        this.xps.setRGBColor(f * H4XPS.parseFloat(attributes.getValue("alt-red")), f * H4XPS.parseFloat(attributes.getValue("alt-green")), f * H4XPS.parseFloat(attributes.getValue("alt-blue")));
                        break;
                    }
                    if (attributes.getValue("alt-cyan") != null) {
                        this.xps.setCMYKColor(f * H4XPS.parseFloat(attributes.getValue("alt-black")), f * H4XPS.parseFloat(attributes.getValue("alt-cyan")), f * H4XPS.parseFloat(attributes.getValue("alt-magenta")), f * H4XPS.parseFloat(attributes.getValue("alt-yellow")));
                    }
                    break;
                }
                case 20: {
                    this.xps.setGreyColor(1.0f - H4XPS.parseFloat(attributes.getValue("tint")));
                    break;
                }
                case 12: {
                    float f;
                    float f11 = H4XPS.parseLength(attributes.getValue("x-from"));
                    float f12 = H4XPS.parseLength(attributes.getValue("y-from"));
                    float f13 = H4XPS.parseLength(attributes.getValue("x-till"));
                    float f14 = H4XPS.parseLength(attributes.getValue("y-till"));
                    if (f13 < f11) {
                        f = f13;
                        f13 = f11;
                        f11 = f;
                    }
                    if (f14 < f12) {
                        f = f14;
                        f14 = f12;
                        f12 = f;
                    }
                    this.xps.putRectangle(f11, f12, f13, f14);
                    break;
                }
                case 5: {
                    float f;
                    float f15 = H4XPS.parseLength(attributes.getValue("x-from"));
                    float f16 = H4XPS.parseLength(attributes.getValue("y-from"));
                    float f17 = H4XPS.parseLength(attributes.getValue("x-till"));
                    float f18 = H4XPS.parseLength(attributes.getValue("y-till"));
                    if (f17 < f15) {
                        f = f17;
                        f17 = f15;
                        f15 = f;
                    }
                    if (f18 < f16) {
                        f = f18;
                        f18 = f16;
                        f16 = f;
                    }
                    this.xps.startClip(f15, f16, f17, f18);
                    break;
                }
                case 13: {
                    this.xps.startPolygon(H4XPS.parseLength(attributes.getValue("x-from")), H4XPS.parseLength(attributes.getValue("y-from")));
                    break;
                }
                case 14: {
                    this.xps.addPolygonPoint(H4XPS.parseLength(attributes.getValue("x-till")), H4XPS.parseLength(attributes.getValue("y-till")));
                    break;
                }
                case 22: {
                    float f;
                    float f19 = H4XPS.parseLength(attributes.getValue("x-from"));
                    float f20 = H4XPS.parseLength(attributes.getValue("y-from"));
                    float f21 = H4XPS.parseLength(attributes.getValue("x-till"));
                    float f22 = H4XPS.parseLength(attributes.getValue("y-till"));
                    if (f21 < f19) {
                        f = f21;
                        f21 = f19;
                        f19 = f;
                    }
                    if (f22 < f20) {
                        f = f22;
                        f22 = f20;
                        f20 = f;
                    }
                    this.xps.putInternalLink(f19, f20, f21, f22, H4XPS.parseInteger(attributes.getValue("destination")), attributes.getValue("destination-id"));
                    break;
                }
                case 23: {
                    float f;
                    float f23 = H4XPS.parseLength(attributes.getValue("x-from"));
                    float f24 = H4XPS.parseLength(attributes.getValue("y-from"));
                    float f25 = H4XPS.parseLength(attributes.getValue("x-till"));
                    float f26 = H4XPS.parseLength(attributes.getValue("y-till"));
                    if (f25 < f23) {
                        f = f25;
                        f25 = f23;
                        f23 = f;
                    }
                    if (f26 < f24) {
                        f = f26;
                        f26 = f24;
                        f24 = f;
                    }
                    this.xps.putExternalLink(f23, f24, f25, f26, attributes.getValue("destination"));
                    break;
                }
                case 24: {
                    this.xps.rememberBookmark(H4XPS.parseInteger(attributes.getValue("id")), H4XPS.parseInteger(attributes.getValue("parent-id")), H4XPS.parseInteger(attributes.getValue("destination")), attributes.getValue("label"), attributes.getValue("destination-id"), false);
                    break;
                }
                case 25: {
                    this.xps.rememberBookmark(H4XPS.parseInteger(attributes.getValue("id")), H4XPS.parseInteger(attributes.getValue("parent-id")), 0, attributes.getValue("label"), attributes.getValue("destination"), true);
                    break;
                }
                case 26: {
                    break;
                }
                case 21: {
                    if (!this.xps.putAnchor(H4XPS.parseLength(attributes.getValue("x")), H4XPS.parseLength(attributes.getValue("y")), 1.0f, 1.0f, attributes.getValue("name"))) {
                        this.session.warning("Duplicate target name used, ignoring.");
                    }
                    break;
                }
                case 27: {
                    this.skip = 1;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 46: {
                    break;
                }
                default: {
                    throw new InternalException("unknown instruction '" + string2 + "'");
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new XPSException(runtimeException);
        }
        catch (Exception exception) {
            throw new InternalException("fatal error at element: " + string2 + " : " + exception);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.skip > 0) {
            --this.skip;
            return;
        }
        if (!this.XEPURI.equals(string)) {
            return;
        }
        if (string2 == "page") {
            this.emptyPage = false;
        }
        if (this.emptyPage) {
            return;
        }
        try {
            switch ((Short)H4base.idtab.get(string2)) {
                case 0: {
                    if (this.currentPageNumber == -1 && this.PAGE_REORDERING || this.currentPageNumber == 0 && !this.PAGE_REORDERING) {
                        this.xps.beginPage(++this.currentPageNumber, 48.0f, 48.0f);
                        this.xps.endPage();
                    }
                    break;
                }
                case 1: {
                    if (this.session.config.CUSTOM_STAMP == null && (this.session.config.XPSTrial || this.session.config.PUT_STAMP)) {
                        Stamp.put(this, this.session, false);
                    }
                    if (this.session.config.CUSTOM_STAMP != null) {
                        this.putCustomStamp();
                    }
                    this.xps.endPage();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                case 5: {
                    this.xps.endClip();
                    break;
                }
                case 13: {
                    this.xps.endPolygon();
                    break;
                }
                case 14: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    break;
                }
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    break;
                }
                default: {
                    throw new InternalException("unknown instruction '" + string2 + "'");
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new XPSException(runtimeException);
        }
        catch (Exception exception) {
            throw new InternalException("fatal error at element: " + string2 + " : " + exception);
        }
    }

    private static final int parseInteger(String string) {
        return Integer.valueOf(string);
    }

    private static final float parseFloat(String string) {
        return Float.valueOf(string).floatValue();
    }

    private static final float parseAngle(String string) {
        return (float)(Math.PI * (double)H4XPS.parseFloat(string)) / 180.0f;
    }

    public static final float parseLength(String string) {
        return H4XPS.parseFloat(string);
    }

    static {
        optab.put("PAGE_REORDERING", new Short(0));
    }

    public class XPSException
    extends RuntimeException {
        public XPSException() {
        }

        public XPSException(Exception exception) {
            super(exception.toString());
        }

        public XPSException(String string) {
            super(string);
        }
    }
}

