/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.svg;

import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.SvgLevelParams;
import com.renderx.graphics.XMLVectorImage;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.svg.Parser;
import com.renderx.svg.SVGAttrValue;
import com.renderx.svg.SVGParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SVGImage
extends XMLVectorImage {
    private static final int[] gzip_magic = new int[]{31, 139};

    public InputStream openImageStream() throws IOException {
        InputStream inputStream = super.openImageStream();
        boolean bl = false;
        try {
            bl = gzip_magic[0] == inputStream.read() && gzip_magic[1] == inputStream.read();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return bl ? new GZIPInputStream(super.openImageStream()) : super.openImageStream();
    }

    public void parse(XMLReader xMLReader, InputSource inputSource) throws IOException, ImageFormatException, SAXException {
        try {
            xMLReader.setContentHandler(new SizeReader());
            xMLReader.parse(inputSource);
        }
        catch (ParseTerminationException parseTerminationException) {
            // empty catch block
        }
        this.supportsVectorRendering = true;
    }

    public ImageTree getImageTree(XMLReader xMLReader, InputSource inputSource, int n, SvgLevelParams svgLevelParams) throws IOException, ImageFormatException, SAXException {
        return new Parser(this.factory, this.factory.fontCatalog, this.factory.errHandler).parse(xMLReader, inputSource, this.source.getBase(), n, svgLevelParams, this.width, this.height);
    }

    static class ParseTerminationException
    extends SAXException {
        public ParseTerminationException() {
            super("");
        }
    }

    class SizeReader
    extends DefaultHandler {
        final String svgURI = "http://www.w3.org/2000/svg";

        SizeReader() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            block11: {
                if (!"http://www.w3.org/2000/svg".equals(string)) {
                    throw new SAXException("Root element in an SVG image " + SVGImage.this.toDisplayString() + " is not in the SVG namespace (" + "http://www.w3.org/2000/svg" + ")");
                }
                if (!"svg".equals(string2)) {
                    throw new SAXException("Root element is not 'svg' in SVG image " + SVGImage.this.toDisplayString());
                }
                try {
                    SVGImage.this.width = this.parseLength(attributes.getValue("", "width"));
                    SVGImage.this.height = this.parseLength(attributes.getValue("", "height"));
                }
                catch (SVGParseException sVGParseException) {
                    String string4 = attributes.getValue("", "viewBox");
                    if (string4 == null) {
                        throw sVGParseException;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, ", \t\n\r");
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new SVGParseException("Invalid viewBox attribute: no data");
                    }
                    double d = new SVGAttrValue.Length((String)stringTokenizer.nextToken()).len;
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new SVGParseException("Invalid viewBox attribute: required 4 numbers, only 1 found");
                    }
                    double d2 = new SVGAttrValue.Length((String)stringTokenizer.nextToken()).len;
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new SVGParseException("Invalid viewBox attribute: required 4 numbers, only 2 found");
                    }
                    SVGImage.this.width = new SVGAttrValue.Length((String)stringTokenizer.nextToken()).len;
                    if (SVGImage.this.width == 0.0) {
                        throw new SVGParseException("Invalid viewBox attribute: width is 0");
                    }
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new SVGParseException("Invalid viewBox attribute: required 4 numbers, only 3 found");
                    }
                    SVGImage.this.height = new SVGAttrValue.Length((String)stringTokenizer.nextToken()).len;
                    if (SVGImage.this.height == 0.0) {
                        throw new SVGParseException("Invalid viewBox attribute: height is 0");
                    }
                    if (!stringTokenizer.hasMoreTokens()) break block11;
                    throw new SVGParseException("Invalid viewBox attribute: extra data after 4 numbers");
                }
            }
            throw new ParseTerminationException();
        }

        private double parseLength(String string) throws SAXException {
            if (string == null) {
                throw new SVGParseException("Missing either 'height' or 'width' on root element of SVG image " + SVGImage.this.toDisplayString());
            }
            SVGAttrValue.Length length = new SVGAttrValue.Length(string);
            if (length.len == 0.0) {
                throw new SVGParseException("Zero-sized SVG: either 'height' or 'width' on root element of SVG image has value of '0'" + SVGImage.this.toDisplayString());
            }
            if (length.base == 1) {
                throw new SVGParseException("Em units are not supported in dimensions of a top-level 'svg' element");
            }
            if (length.base == 2) {
                throw new SVGParseException("Ex units are not supported in dimensions of a top-level 'svg' element");
            }
            if (length.base == 3) {
                throw new SVGParseException("Percentages are not supported in dimensions of a top-level 'svg' element");
            }
            return length.len;
        }
    }
}

