/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.FontConfigurationException;
import com.renderx.graphics.BitmapImage;
import com.renderx.graphics.EPSImage;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.graphics.VectorImage;
import com.renderx.graphics.vector.Contour;
import com.renderx.graphics.vector.ExternalImage;
import com.renderx.graphics.vector.GraphicGroup;
import com.renderx.graphics.vector.GraphicObject;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.graphics.vector.Link;
import com.renderx.graphics.vector.OpaqueColor;
import com.renderx.graphics.vector.PaintServer;
import com.renderx.graphics.vector.PaintSpec;
import com.renderx.graphics.vector.Path;
import com.renderx.graphics.vector.StrokeSpec;
import com.renderx.graphics.vector.Subpath;
import com.renderx.graphics.vector.Text;
import com.renderx.pslib.ASCII85_Encode;
import com.renderx.pslib.EPS;
import com.renderx.pslib.InternalException;
import com.renderx.pslib.PSDocument;
import com.renderx.pslib.PSOutputStream;
import com.renderx.pslib.RunLength_Encode;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.DeflaterOutputStream;
import com.renderx.util.ErrorHandler;
import com.renderx.util.List;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import com.renderx.util.User;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import junit.framework.Assert;
import junit.framework.TestCase;

public class Image {
    static final int MAX_SOURCE_LENGTH = 220;
    com.renderx.graphics.Image image = null;
    final String id;
    final String source;
    final boolean isInstream;
    List subimages = new List();
    boolean clippingPending = false;
    boolean simpleClipping = false;
    VectorImage lastSubobj;
    double[] clipMatrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    double[] contentMatrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    ImageTree imageTree = null;

    public Image(com.renderx.graphics.Image image, String string) throws InternalException, IOException, ImageFormatException {
        Object object;
        this.id = string;
        this.image = image;
        boolean bl = this.isInstream = image.source.scheme != 3;
        if (this.isInstream) {
            this.source = null;
        } else {
            object = image.source.toString();
            if (((String)object).length() > 220) {
                object = "..." + ((String)object).substring(((String)object).length() + 3 - 220);
            }
            this.source = object;
        }
        if (image instanceof BitmapImage) {
            return;
        }
        if (image instanceof VectorImage) {
            object = (VectorImage)image;
            if (object instanceof EPSImage) {
                return;
            }
            if (((VectorImage)object).supportsVectorRendering) {
                this.imageTree = ((VectorImage)object).getImageTree();
                return;
            }
            if (((VectorImage)object).hasBitmapPreview) {
                this.image = ((VectorImage)object).getBitmapPreview();
                return;
            }
            if (((VectorImage)object).supportsRasterizing) {
                this.image = ((VectorImage)object).rasterize(300.0);
                return;
            }
        }
        throw new ImageFormatException("Unsupported format " + image.mimetype + " for image '" + image.toDisplayString() + "'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void write(PSOutputStream pSOutputStream) throws IOException, ImageFormatException {
        block8: {
            block7: {
                if (this.isInstream) {
                    pSOutputStream.println("%RNDRXBeginInstreamImage");
                } else {
                    pSOutputStream.println("%RNDRXBeginExternalImage: " + this.source);
                }
                pSOutputStream.doc.curimage = this;
                try {
                    if (this.image instanceof BitmapImage) {
                        this.writeBitmapImage(pSOutputStream, (BitmapImage)this.image);
                    } else {
                        if (!(this.image instanceof VectorImage)) throw new InternalException("Invalid image type: neither bitmap nor vector");
                        this.writeVectorImage(pSOutputStream, (VectorImage)this.image);
                    }
                    Object var3_2 = null;
                    if (!this.isInstream) break block7;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.isInstream) {
                        pSOutputStream.println("%RNDRXEndInstreamImage");
                        throw throwable;
                    }
                    pSOutputStream.println("%RNDRXEndExternalImage");
                    throw throwable;
                }
                pSOutputStream.println("%RNDRXEndInstreamImage");
                break block8;
            }
            pSOutputStream.println("%RNDRXEndExternalImage");
        }
        this.writeSubImages(pSOutputStream);
    }

    void writeSubImages(PSOutputStream pSOutputStream) throws IOException, ImageFormatException {
        Enumeration enumeration = this.subimages.elements();
        while (enumeration.hasMoreElements()) {
            com.renderx.graphics.Image image;
            String string = (String)enumeration.nextElement();
            com.renderx.graphics.Image image2 = image = pSOutputStream.doc.images.getImageById(string);
            synchronized (image2) {
                boolean bl = false;
                URLSpec uRLSpec = null;
                if (image.source == null) {
                    uRLSpec = image.getFactory().getSource(image);
                    if (image.source == null) {
                        bl = true;
                        image.source = uRLSpec;
                    }
                }
                Image image3 = new Image(image, string);
                image3.write(pSOutputStream);
                if (bl) {
                    image.source = null;
                }
            }
        }
    }

    void writeVectorImage(PSOutputStream pSOutputStream, VectorImage vectorImage) throws IOException, ImageFormatException {
        if (vectorImage instanceof EPSImage) {
            this.writeEPSImage(pSOutputStream, new EPS((EPSImage)vectorImage));
        } else if (vectorImage.supportsVectorRendering) {
            this.writeImageTree(pSOutputStream, this.imageTree);
        } else {
            throw new InternalException("Unsupported image type, erroneously passed here");
        }
    }

    void writeEPSImage(PSOutputStream pSOutputStream, EPS ePS) throws IOException {
        pSOutputStream.println("/ImageForm" + this.id + " <<");
        pSOutputStream.println("/FormType 1");
        pSOutputStream.println("/BBox [" + (float)ePS.bbox[0] + " " + (float)ePS.bbox[1] + " " + (float)ePS.bbox[2] + " " + (float)ePS.bbox[3] + "]");
        pSOutputStream.println("/Matrix [1 0 0 1 " + (float)(-ePS.bbox[0]) + " " + (float)(-ePS.bbox[1]) + " ]");
        pSOutputStream.println("/PaintProc {");
        pSOutputStream.println("BeginEPSF");
        ePS.writeEPS(pSOutputStream);
        pSOutputStream.println("EndEPSF");
        pSOutputStream.println("} bind >> def");
    }

    void writeBitmapImage(PSOutputStream pSOutputStream, BitmapImage bitmapImage) throws IOException {
        boolean bl;
        boolean bl2 = bl = bitmapImage.canCopyData && bitmapImage.compressionMethod != 0 && (bitmapImage.compressionMethod != 2 || pSOutputStream.doc.LANGUAGE_LEVEL != 2);
        if (!bl && !bitmapImage.canExpandData) {
            pSOutputStream.doc.errorHandler.error("cannot use neither raw nor expanded bitmap data in file '" + bitmapImage.toDisplayString() + "'.");
            return;
        }
        pSOutputStream.println("/ImageForm" + this.id + " <<");
        pSOutputStream.println("/FormType 1");
        pSOutputStream.println("/BBox [0 0 1 1]");
        pSOutputStream.println("/Matrix [" + (float)bitmapImage.width + " 0 0 " + (float)bitmapImage.height + " 0 0 ]");
        pSOutputStream.println("/PaintProc {");
        pSOutputStream.println("pop");
        pSOutputStream.println("gsave");
        pSOutputStream.println((pSOutputStream.doc.LANGUAGE_LEVEL == 3 ? "ImageData" + this.id + " 0 setfileposition" : "userdict /i 0 put") + "             % rewind our image data");
        switch (bitmapImage.colorSpace) {
            case 1: {
                pSOutputStream.println("/DeviceRGB setcolorspace");
                break;
            }
            case 2: 
            case 3: {
                pSOutputStream.println("/DeviceCMYK setcolorspace");
                break;
            }
            case 4: 
            case 5: {
                pSOutputStream.println("/DeviceGray setcolorspace");
                break;
            }
            case 6: {
                int n = bitmapImage.colorTable.length / 3;
                pSOutputStream.println("[/Indexed /DeviceRGB " + (n - 1));
                pSOutputStream.print("<");
                int n2 = 0;
                while (n2 < bitmapImage.colorTable.length) {
                    if (n2 != 0) {
                        if (n2 % 30 == 0) {
                            pSOutputStream.println();
                        } else if (n2 % 3 == 0) {
                            pSOutputStream.print(" ");
                        }
                    }
                    pSOutputStream.writeHexByte(bitmapImage.colorTable[n2]);
                    ++n2;
                }
                pSOutputStream.println(">");
                pSOutputStream.println("] setcolorspace");
            }
        }
        pSOutputStream.println("<< /ImageType 1");
        pSOutputStream.println("/Width " + bitmapImage.pxWidth);
        pSOutputStream.println("/Height " + bitmapImage.pxHeight);
        pSOutputStream.println("/ImageMatrix [ " + bitmapImage.pxWidth + " 0 0 -" + bitmapImage.pxHeight + " 0 " + bitmapImage.pxHeight + " ]");
        pSOutputStream.println("/BitsPerComponent " + bitmapImage.bitsPerComponent);
        if (pSOutputStream.doc.LANGUAGE_LEVEL == 3) {
            pSOutputStream.println("/DataSource ImageData" + this.id);
        } else {
            pSOutputStream.println("/DataSource {");
            pSOutputStream.println("ImageData" + this.id + " i get");
            pSOutputStream.println("/i i 1 add store ");
            pSOutputStream.println("} bind");
        }
        switch (bitmapImage.colorSpace) {
            case 4: {
                pSOutputStream.println("/Decode [0 1]");
                break;
            }
            case 5: {
                pSOutputStream.println("/Decode [1 0]");
                break;
            }
            case 1: {
                pSOutputStream.println("/Decode [0 1 0 1 0 1]");
                break;
            }
            case 2: {
                pSOutputStream.println("/Decode [0 1 0 1 0 1 0 1]");
                break;
            }
            case 3: {
                pSOutputStream.println("/Decode [1 0 1 0 1 0 1 0]");
                break;
            }
            case 6: {
                pSOutputStream.println("/Decode [0 " + ((1 << bitmapImage.bitsPerComponent) - 1) + "]");
            }
        }
        pSOutputStream.println(">> image");
        pSOutputStream.println();
        pSOutputStream.println("grestore");
        pSOutputStream.println("} bind");
        pSOutputStream.println(">> def");
        pSOutputStream.println("/ImageData" + this.id);
        pSOutputStream.print("currentfile /ASCII85Decode filter ");
        if (bl) {
            switch (bitmapImage.compressionMethod) {
                case 7: {
                    pSOutputStream.print("<</EarlyChange 0");
                    this.writePredictor(pSOutputStream, bitmapImage, true);
                    pSOutputStream.print(">> /LZWDecode");
                    break;
                }
                case 8: {
                    this.writePredictor(pSOutputStream, bitmapImage, false);
                    pSOutputStream.print("/LZWDecode");
                    break;
                }
                case 2: {
                    this.writePredictor(pSOutputStream, bitmapImage, false);
                    pSOutputStream.print("/FlateDecode");
                    break;
                }
                case 4: {
                    pSOutputStream.print("<</K 0 /Columns " + bitmapImage.pxWidth + " /Rows " + bitmapImage.pxHeight + ">> /CCITTFaxDecode");
                    break;
                }
                case 5: {
                    pSOutputStream.print("<</K 1 /Columns " + bitmapImage.pxWidth + " /Rows " + bitmapImage.pxHeight + ">> /CCITTFaxDecode");
                    break;
                }
                case 6: {
                    pSOutputStream.print("<</K -1 /Columns " + bitmapImage.pxWidth + " /Rows " + bitmapImage.pxHeight + ">> /CCITTFaxDecode");
                    break;
                }
                case 3: {
                    pSOutputStream.print("/DCTDecode");
                    break;
                }
                case 1: {
                    pSOutputStream.print("/RunLengthDecode");
                }
            }
        } else {
            pSOutputStream.print(pSOutputStream.doc.LANGUAGE_LEVEL == 2 ? "/RunLengthDecode" : "/FlateDecode");
        }
        pSOutputStream.print(" filter ");
        pSOutputStream.println(pSOutputStream.doc.LANGUAGE_LEVEL == 3 ? "/ReusableStreamDecode filter" : "CreateDataArray");
        try {
            ASCII85_Encode aSCII85_Encode = new ASCII85_Encode(pSOutputStream);
            if (bl) {
                bitmapImage.copyData(aSCII85_Encode);
            } else if (pSOutputStream.doc.LANGUAGE_LEVEL == 3) {
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(aSCII85_Encode);
                bitmapImage.expandData(deflaterOutputStream);
                deflaterOutputStream.finish();
            } else {
                RunLength_Encode runLength_Encode = new RunLength_Encode(aSCII85_Encode);
                bitmapImage.expandData(runLength_Encode);
                runLength_Encode.EOD();
            }
            aSCII85_Encode.EOD();
        }
        catch (Exception exception) {
            pSOutputStream.doc.errorHandler.exception("Cannot insert image '" + this.image.toDisplayString() + "'.", exception);
        }
        pSOutputStream.println("\ndef");
    }

    private void writePredictor(PSOutputStream pSOutputStream, BitmapImage bitmapImage, boolean bl) throws IOException {
        if (bitmapImage.predictor == 0) {
            return;
        }
        pSOutputStream.print(bl ? " " : "<<");
        switch (bitmapImage.predictor) {
            case 1: {
                pSOutputStream.print("/Predictor 2");
                break;
            }
            case 2: {
                pSOutputStream.print("/Predictor 15");
            }
        }
        pSOutputStream.print(" /Columns " + bitmapImage.pxWidth);
        if (bitmapImage.bitsPerComponent != 8) {
            pSOutputStream.print(" /BitsPerComponent " + bitmapImage.bitsPerComponent);
        }
        switch (bitmapImage.colorSpace) {
            case 1: {
                pSOutputStream.print(" /Colors 3");
                break;
            }
            case 2: 
            case 3: {
                pSOutputStream.print(" /Colors 4");
            }
        }
        if (!bl) {
            pSOutputStream.print(">> ");
        }
    }

    void writeImageTree(PSOutputStream pSOutputStream, ImageTree imageTree) throws IOException {
        pSOutputStream.println("/ImageForm" + this.id + " <<");
        pSOutputStream.println("/FormType 1");
        pSOutputStream.println("/BBox [" + (float)imageTree.startX + " " + (float)imageTree.startY + " " + ((float)imageTree.startX + (float)imageTree.width) + " " + ((float)imageTree.startY + (float)imageTree.height) + "]");
        pSOutputStream.println("/Matrix [1 0 0 1 0 0]");
        pSOutputStream.println("/PaintProc {");
        pSOutputStream.doc.setCharSpacing(0.0f);
        pSOutputStream.doc.setWordSpacing(0.0f);
        this.PaintGraphicObject(pSOutputStream, imageTree.root);
        pSOutputStream.println("} bind >> def");
    }

    void PaintGraphicObject(PSOutputStream pSOutputStream, GraphicObject graphicObject) throws IOException {
        if (graphicObject instanceof GraphicGroup) {
            GraphicGroup graphicGroup = (GraphicGroup)graphicObject;
            boolean bl = false;
            boolean bl2 = false;
            pSOutputStream.doc.setFontSize(0.0f);
            double[] dArray = this.contentMatrix;
            double[] dArray2 = this.contentMatrix;
            if (!this.clippingPending) {
                boolean bl3 = bl = !graphicGroup.isIdentityTransform() || graphicGroup.clippath != null;
                if (bl) {
                    pSOutputStream.println("gsave");
                }
                if (!graphicGroup.isIdentityTransform()) {
                    this.printMatrix(pSOutputStream, graphicGroup.matrix);
                    dArray2 = GraphicObject.multipleMatrix(this.contentMatrix, graphicGroup.matrix);
                }
                if (graphicGroup.clippath != null) {
                    bl2 = !this.clippingPending;
                    this.clippingPending = true;
                    GraphicGroup graphicGroup2 = graphicGroup.clippath;
                    this.simpleClipping = graphicGroup2.isSimple();
                    graphicGroup = (GraphicGroup)graphicGroup.clone();
                    graphicGroup.clippath = null;
                    graphicGroup.matrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                    if (!this.simpleClipping) {
                        this.lastSubobj = this.getVectorImageSubObject(graphicGroup, dArray2);
                    }
                    this.PaintGraphicObject(pSOutputStream, graphicGroup2);
                    if (this.simpleClipping) {
                        this.clippingPending = false;
                        this.PaintGraphicObject(pSOutputStream, graphicGroup);
                    }
                } else {
                    Enumeration enumeration = graphicGroup.children.elements();
                    while (enumeration.hasMoreElements()) {
                        this.contentMatrix = dArray2;
                        this.PaintGraphicObject(pSOutputStream, (GraphicObject)enumeration.nextElement());
                    }
                    this.contentMatrix = dArray;
                }
                if (bl2) {
                    this.clippingPending = false;
                }
                if (bl) {
                    pSOutputStream.println("grestore");
                }
            } else {
                double[] dArray3;
                if (graphicGroup.clippath != null) {
                    // empty if block
                }
                double[] dArray4 = this.clipMatrix;
                double[] dArray5 = dArray3 = graphicGroup.isIdentityTransform() ? this.clipMatrix : GraphicObject.multipleMatrix(this.clipMatrix, graphicGroup.matrix);
                if (this.simpleClipping && graphicGroup.children.length() > 1) {
                    pSOutputStream.doc.errorHandler.error("Unexpected number of elements in the clipPath; expected zero or one, found: " + graphicGroup.children.length());
                }
                Enumeration enumeration = graphicGroup.children.elements();
                while (enumeration.hasMoreElements()) {
                    this.clipMatrix = dArray3;
                    GraphicObject graphicObject2 = (GraphicObject)enumeration.nextElement();
                    if (graphicObject2 instanceof Contour) {
                        if (!this.simpleClipping) {
                            pSOutputStream.println("gsave");
                        }
                        if (!GraphicObject.isIdentityTransform(this.clipMatrix)) {
                            this.printMatrix(pSOutputStream, this.clipMatrix);
                        }
                        this.PaintGraphicObject(pSOutputStream, graphicObject2);
                        if (!GraphicObject.isIdentityTransform(this.clipMatrix)) {
                            this.printMatrix(pSOutputStream, GraphicObject.reverseMatrix(this.clipMatrix));
                        }
                        if (!this.simpleClipping) {
                            pSOutputStream.doc.placeImage(this.lastSubobj, false);
                        }
                        if (this.simpleClipping) continue;
                        pSOutputStream.println("grestore");
                        continue;
                    }
                    if (graphicObject2 instanceof GraphicGroup) {
                        this.PaintGraphicObject(pSOutputStream, graphicObject2);
                        continue;
                    }
                    pSOutputStream.doc.errorHandler.warning("Unexpected element in the clipPath: " + graphicObject2.getClass() + " skipping...");
                }
                this.clipMatrix = dArray4;
            }
        } else if (graphicObject instanceof Contour) {
            boolean bl;
            Contour contour = (Contour)graphicObject;
            boolean bl4 = contour.fill != null;
            boolean bl5 = bl = contour.stroke != null && contour.stroke.paint != null;
            if (!(bl4 || bl || this.clippingPending)) {
                return;
            }
            if (this.isNewGS(contour)) {
                pSOutputStream.println("gsave");
            }
            if (contour instanceof Path) {
                Path path = (Path)contour;
                pSOutputStream.println("newpath");
                Enumeration enumeration = path.subs.elements();
                while (enumeration.hasMoreElements()) {
                    this.PaintSubpath(pSOutputStream, (Subpath)enumeration.nextElement());
                }
                if (bl4 && !this.clippingPending) {
                    if (bl) {
                        pSOutputStream.println("gsave");
                    }
                    this.PaintFillSpec(pSOutputStream, path.fill);
                    pSOutputStream.println(path.fillRule == 0 ? "fill" : "eofill");
                    if (bl) {
                        pSOutputStream.println("grestore");
                    }
                }
                if (bl && !this.clippingPending) {
                    this.PaintStrokeSpec(pSOutputStream, path.stroke);
                    pSOutputStream.println("stroke");
                }
            } else if (graphicObject instanceof Text) {
                Text text = (Text)contour;
                if (this.clippingPending || bl) {
                    pSOutputStream.println("newpath");
                }
                pSOutputStream.println("" + (float)text.x + " " + (float)text.y + " moveto");
                pSOutputStream.doc.setFontStretch((float)text.font.stretch);
                pSOutputStream.doc.u28.selectFont(text.font.family, text.font.weight, text.font.style, text.font.variant);
                if (this.clippingPending) {
                    int n = pSOutputStream.doc.textRenderMode;
                    pSOutputStream.doc.textRenderMode = 2;
                    pSOutputStream.doc.setFontSize((float)text.font.size);
                    pSOutputStream.doc.u28.processText(new String(text.value));
                    pSOutputStream.doc.textRenderMode = n;
                } else {
                    int n;
                    if (bl4) {
                        if (bl) {
                            pSOutputStream.println("gsave");
                        }
                        this.PaintFillSpec(pSOutputStream, text.fill);
                        n = pSOutputStream.doc.textRenderMode;
                        pSOutputStream.doc.textRenderMode = 0;
                        pSOutputStream.doc.setFontSize((float)text.font.size);
                        pSOutputStream.doc.u28.processText(new String(text.value));
                        pSOutputStream.doc.textRenderMode = n;
                        if (bl) {
                            pSOutputStream.println("grestore");
                        }
                    }
                    if (bl) {
                        this.PaintStrokeSpec(pSOutputStream, text.stroke);
                        n = pSOutputStream.doc.textRenderMode;
                        pSOutputStream.doc.textRenderMode = 1;
                        pSOutputStream.doc.setFontSize((float)text.font.size);
                        pSOutputStream.doc.u28.processText(new String(text.value));
                        pSOutputStream.doc.textRenderMode = n;
                        pSOutputStream.println("stroke");
                    }
                }
            }
            if (this.clippingPending) {
                pSOutputStream.println(contour.clipRule == 0 ? "clip" : "eoclip");
            }
            if (this.isNewGS(contour)) {
                pSOutputStream.println("grestore");
            }
        } else if (graphicObject instanceof ExternalImage) {
            ExternalImage externalImage = (ExternalImage)graphicObject;
            pSOutputStream.doc.placeImage(externalImage.image, true);
        } else if (graphicObject instanceof Link) {
            Link link = (Link)graphicObject;
            pSOutputStream.doc.addWebLink((float)link.xfrom, (float)link.yfrom, (float)link.xtill, (float)link.ytill, link.dest, link.show);
        }
    }

    void PaintSubpath(PSOutputStream pSOutputStream, Subpath subpath) throws IOException {
        pSOutputStream.println("" + (float)subpath.startX + " " + (float)subpath.startY + " moveto");
        Enumeration enumeration = subpath.segs.elements();
        while (enumeration.hasMoreElements()) {
            Subpath.Segment segment;
            Subpath.Segment segment2 = (Subpath.Segment)enumeration.nextElement();
            if (segment2 instanceof Subpath.Line) {
                segment = (Subpath.Line)segment2;
                pSOutputStream.println("" + (float)segment.xend + " " + (float)segment.yend + " lineto");
                continue;
            }
            if (!(segment2 instanceof Subpath.Curve)) continue;
            segment = (Subpath.Curve)segment2;
            pSOutputStream.println("" + (float)((Subpath.Curve)segment).cpx1 + " " + (float)((Subpath.Curve)segment).cpy1 + " " + (float)((Subpath.Curve)segment).cpx2 + " " + (float)((Subpath.Curve)segment).cpy2 + " " + (float)((Subpath.Curve)segment).xend + " " + (float)((Subpath.Curve)segment).yend + " curveto");
        }
        if (subpath.closed) {
            pSOutputStream.println("closepath");
        }
    }

    void PaintStrokeSpec(PSOutputStream pSOutputStream, StrokeSpec strokeSpec) throws IOException {
        pSOutputStream.println("" + (float)strokeSpec.thickness + " setlinewidth ");
        pSOutputStream.println("" + strokeSpec.lineCap + " setlinecap");
        pSOutputStream.println("" + strokeSpec.lineJoin + " setlinejoin");
        if (strokeSpec.lineJoin == 0) {
            pSOutputStream.println("" + (float)strokeSpec.miterLimit + " setmiterlimit");
        }
        this.PaintFillSpec(pSOutputStream, strokeSpec.paint);
        if (strokeSpec.dashArray == null) {
            pSOutputStream.println("[] 0 setdash");
        } else {
            pSOutputStream.print("[");
            int n = 0;
            while (n < strokeSpec.dashArray.length) {
                if (n > 0) {
                    pSOutputStream.print(" ");
                }
                pSOutputStream.print("" + (float)strokeSpec.dashArray[n]);
                ++n;
            }
            pSOutputStream.println("] " + (float)strokeSpec.dashPhase + " setdash");
        }
    }

    void PaintFillSpec(PSOutputStream pSOutputStream, PaintSpec paintSpec) throws IOException {
        if (paintSpec instanceof OpaqueColor.Grayscale) {
            OpaqueColor.Grayscale grayscale = (OpaqueColor.Grayscale)paintSpec;
            pSOutputStream.doc.setGrayColor((float)grayscale.g);
        } else if (paintSpec instanceof OpaqueColor.RGB) {
            OpaqueColor.RGB rGB = (OpaqueColor.RGB)paintSpec;
            pSOutputStream.doc.setRGBColor((float)rGB.r, (float)rGB.g, (float)rGB.b);
        } else if (paintSpec instanceof OpaqueColor.CMYK) {
            OpaqueColor.CMYK cMYK = (OpaqueColor.CMYK)paintSpec;
            pSOutputStream.doc.setCMYKColor((float)cMYK.c, (float)cMYK.m, (float)cMYK.y, (float)cMYK.k);
        } else if (paintSpec instanceof OpaqueColor.SpotColor) {
            OpaqueColor.SpotColor spotColor = (OpaqueColor.SpotColor)paintSpec;
            float[] fArray = new float[]{0.0f};
            if (spotColor.altcolor != null) {
                if (spotColor.altcolor instanceof OpaqueColor.Grayscale) {
                    OpaqueColor.Grayscale grayscale = (OpaqueColor.Grayscale)spotColor.altcolor;
                    fArray = new float[]{(float)grayscale.g};
                } else if (spotColor.altcolor instanceof OpaqueColor.RGB) {
                    OpaqueColor.RGB rGB = (OpaqueColor.RGB)spotColor.altcolor;
                    fArray = new float[]{(float)rGB.r, (float)rGB.g, (float)rGB.b};
                } else if (spotColor.altcolor instanceof OpaqueColor.CMYK) {
                    OpaqueColor.CMYK cMYK = (OpaqueColor.CMYK)spotColor.altcolor;
                    fArray = new float[]{(float)cMYK.c, (float)cMYK.m, (float)cMYK.y, (float)cMYK.k};
                }
            }
            pSOutputStream.doc.setSpotColor((float)spotColor.tint, spotColor.colorant, fArray);
        } else if (paintSpec instanceof OpaqueColor.Registration) {
            OpaqueColor.Registration registration = (OpaqueColor.Registration)paintSpec;
            pSOutputStream.doc.setSpotColor((float)registration.tint, "All", new float[]{0.0f});
        } else if (paintSpec instanceof PaintServer) {
            try {
                pSOutputStream.doc.setPattern((PaintServer)paintSpec);
            }
            catch (ImageFormatException imageFormatException) {
                paintSpec = null;
                pSOutputStream.doc.errorHandler.error("Internal error: cannot create a pattern. " + imageFormatException.getMessage());
                return;
            }
        }
    }

    private void printMatrix(PSOutputStream pSOutputStream, double[] dArray) throws IOException {
        if (dArray[0] == 1.0 && dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[3] == 1.0) {
            pSOutputStream.println("" + (float)dArray[4] + " " + (float)dArray[5] + " translate");
        } else if (dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[4] == 0.0 && dArray[5] == 0.0) {
            pSOutputStream.println("" + (float)dArray[0] + " " + (float)dArray[3] + " scale");
        } else {
            pSOutputStream.println("[" + (float)dArray[0] + " " + (float)dArray[1] + " " + (float)dArray[2] + " " + (float)dArray[3] + " " + (float)dArray[4] + " " + (float)dArray[5] + "] concat");
        }
    }

    private VectorImage getVectorImageSubObject(GraphicGroup graphicGroup, double[] dArray) throws IOException {
        double[] dArray2 = Image.calcBBox(this.imageTree.startX, this.imageTree.startY, this.imageTree.width, this.imageTree.height, GraphicObject.reverseMatrix(dArray));
        ImageTree imageTree = new ImageTree(dArray2[0], dArray2[1], dArray2[2] - dArray2[0], dArray2[3] - dArray2[1]);
        imageTree.root = graphicGroup;
        SubTreeVectorImage subTreeVectorImage = new SubTreeVectorImage(imageTree);
        subTreeVectorImage.supportsVectorRendering = true;
        return subTreeVectorImage;
    }

    private static boolean isPaintServer(PaintSpec paintSpec) {
        if (paintSpec == null) {
            return false;
        }
        return paintSpec instanceof PaintServer;
    }

    private boolean isNewGS(Contour contour) {
        return Image.isPaintServer(contour.fill) || contour.stroke != null && Image.isPaintServer(contour.stroke.paint);
    }

    private static double[] calcBBox(double d, double d2, double d3, double d4, double[] dArray) {
        double[] dArray2;
        double[] dArray3 = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] dArray4 = GraphicObject.transformPoint(dArray, d, d2);
        if (dArray4[0] < (dArray2 = GraphicObject.transformPoint(dArray, d + d3, d2 + d4))[0]) {
            dArray3[0] = dArray4[0];
            dArray3[2] = dArray2[0];
        } else {
            dArray3[0] = dArray2[0];
            dArray3[2] = dArray4[0];
        }
        if (dArray4[1] < dArray2[1]) {
            dArray3[1] = dArray4[1];
            dArray3[3] = dArray2[1];
        } else {
            dArray3[1] = dArray2[1];
            dArray3[3] = dArray4[1];
        }
        return dArray3;
    }

    public static final class Test
    extends TestCase {
        ErrorHandler errorHandler = new DefaultErrorHandler();
        URLCache urlcache = new URLCache();
        FontCatalog fontCatalog;
        ImageFactory imageFactory;

        public void setUp() {
            try {
                this.fontCatalog = new FontCatalog(this.urlcache, this.errorHandler);
                this.imageFactory = new ImageFactory(this.fontCatalog, this.urlcache, this.errorHandler);
            }
            catch (IOException iOException) {
                Assert.fail((String)("Cann't create fontCatalog or imageFactory: " + iOException));
            }
            catch (FontConfigurationException fontConfigurationException) {
                Assert.fail((String)("Cannot create font catalog: " + fontConfigurationException));
            }
        }

        public void test_write(String string, String string2, int n) throws IOException, ImageFormatException, UnregisteredMIMETypeException {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string3 = string2;
            if (string2.equals("tiff")) {
                string3 = "tif";
            } else if (string2.equals("jpeg")) {
                string3 = "jpg";
            }
            PSDocument pSDocument = new PSDocument((OutputStream)byteArrayOutputStream, new File(User.getProperty("user.dir")), this.imageFactory, this.fontCatalog, this.errorHandler);
            pSDocument.setLanguageLevel(n);
            String string4 = "com/renderx/pslib/TEST_DATA/" + string + "." + string3;
            String string5 = "com/renderx/pslib/TEST_DATA/" + string + ".test" + n;
            Image image = new Image(pSDocument.imageFactory.makeImage(new URLSpec("resource:" + string4), "image/" + string2), "_" + string + ".test" + n);
            image.write(pSDocument.out);
            pSDocument.out.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string5);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n2 = inputStream.read(byArray2, 0, 1024)) >= 0) {
                byteArrayOutputStream2.write(byArray2, 0, n2);
            }
            byteArrayOutputStream2.close();
            inputStream.close();
            byte[] byArray3 = byteArrayOutputStream2.toByteArray();
            Assert.assertEquals((String)"Size isn't valid: ", (int)byArray3.length, (int)byArray.length);
            int n3 = 0;
            while (n3 < byArray3.length) {
                Assert.assertEquals((byte)byArray3[n3], (byte)byArray[n3]);
                ++n3;
            }
        }

        public void test_write2_gif() throws IOException, ImageFormatException, UnregisteredMIMETypeException {
            this.test_write("test_gif", "gif", 2);
        }

        public void test_write3_gif() throws IOException, ImageFormatException, UnregisteredMIMETypeException {
            this.test_write("test_gif", "gif", 3);
        }

        public void test_write2_tiff() throws IOException, ImageFormatException, UnregisteredMIMETypeException {
            this.test_write("test_tiff", "tiff", 2);
        }

        public void test_write3_tiff() throws IOException, ImageFormatException, UnregisteredMIMETypeException {
            this.test_write("test_tiff", "tiff", 3);
        }

        public void test_write2_png() throws IOException, ImageFormatException, UnregisteredMIMETypeException {
            this.test_write("test_png", "png", 2);
        }

        public void test_write3_png() throws IOException, ImageFormatException, UnregisteredMIMETypeException {
            this.test_write("test_png", "png", 3);
        }

        public void test_write2_jpeg() throws IOException, ImageFormatException, UnregisteredMIMETypeException {
            this.test_write("test_jpeg", "jpeg", 2);
        }

        public void test_write3_jpeg() throws IOException, ImageFormatException, UnregisteredMIMETypeException {
            this.test_write("test_jpeg", "jpeg", 3);
        }
    }

    static class SubTreeVectorImage
    extends VectorImage {
        ImageTree imageTree = null;

        public void parse() throws IOException, ImageFormatException {
        }

        public SubTreeVectorImage(ImageTree imageTree) throws IOException {
            this.imageTree = imageTree;
            this.source = new URLSpec("data:,");
        }

        public ImageTree getImageTree() throws IOException, ImageFormatException {
            return this.imageTree;
        }
    }
}

