/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.hyphen;

import com.renderx.hyphen.Hyphenator;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class TeXHyphenator
implements Hyphenator {
    private final Hashtable exceptions = new Hashtable();
    private final List[] entrytab = new List[256];
    private final ErrorHandler errHandler;
    static /* synthetic */ Class class$com$renderx$hyphen$TeXHyphenator;

    TeXHyphenator(Reader reader, ErrorHandler errorHandler) throws IOException {
        this.errHandler = errorHandler;
        int n = 0;
        while (n != 256) {
            this.entrytab[n] = new List();
            ++n;
        }
        Scanner scanner = new Scanner(reader, this.errHandler);
        int n2 = 0;
        block11: while (true) {
            short s = scanner.getSym();
            switch (s) {
                case 0: {
                    break block11;
                }
                case 3: 
                case 4: {
                    if (scanner.getSym() != 1) {
                        scanner.error("'{' expected");
                    }
                    n2 = s == 3 ? 2 : 1;
                    continue block11;
                }
                case 2: {
                    n2 = 0;
                    continue block11;
                }
                case 5: {
                    switch (n2) {
                        case 2: {
                            this.readPattern(scanner);
                            break;
                        }
                        case 1: {
                            this.readException(scanner);
                            break;
                        }
                    }
                    continue block11;
                }
                default: {
                    scanner.error("problem parsing input");
                    continue block11;
                }
            }
            break;
        }
    }

    public String hyphenate(String string, int n, int n2) {
        if (n < 1) {
            n = 1;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (string.length() < n2 + n) {
            return string;
        }
        char[] cArray = new char[string.length() + 1];
        cArray[cArray.length - 1] = '\u0000';
        string.getChars(0, string.length(), cArray, 0);
        char[] cArray2 = new char[cArray.length * 2 - 1];
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        while (true) {
            if (bl) {
                int n6;
                int n7;
                int n8;
                if (Character.isLetter(cArray[n4])) {
                    ++n4;
                    continue;
                }
                int n9 = n4 - n3;
                String string2 = new String(cArray, n3, n9).toLowerCase();
                int[] nArray = (int[])this.exceptions.get(string2);
                if (nArray == null) {
                    char[] cArray3 = new char[n9 + 2];
                    nArray = new int[cArray3.length + 1];
                    cArray3[cArray3.length - 1] = 46;
                    cArray3[0] = 46;
                    n8 = 0;
                    while (n8 != n9) {
                        cArray3[1 + n8] = Character.toLowerCase(cArray[n3 + n8]);
                        ++n8;
                    }
                    n7 = 0;
                    while (n7 != n9) {
                        int n10 = cArray3[n7] % 256;
                        List list = this.entrytab[n10];
                        int n11 = n7;
                        Enumeration enumeration = list.elements();
                        while (enumeration.hasMoreElements()) {
                            list = (List)enumeration.nextElement();
                            if (((Character)list.car()).charValue() != cArray3[n11]) continue;
                            list = list.cdr();
                            int[] nArray2 = (int[])list.car();
                            int n12 = 0;
                            while (n12 != nArray2.length) {
                                if (nArray2[n12] > nArray[n7 + n12]) {
                                    nArray[n7 + n12] = nArray2[n12];
                                }
                                ++n12;
                            }
                            if (++n11 == cArray3.length) break;
                            enumeration = list.cdr().elements();
                        }
                        ++n7;
                    }
                    int[] nArray3 = new int[n9];
                    System.arraycopy(nArray, 2, nArray3, 0, n9);
                    nArray = nArray3;
                }
                if (n + n2 <= n9) {
                    n6 = 0;
                    while (n6 != n - 1) {
                        cArray2[n5++] = cArray[n3++];
                        ++n6;
                    }
                    n8 = n - 1;
                    while (n8 != n9 - n2) {
                        cArray2[n5++] = cArray[n3++];
                        if (nArray[n8] % 2 == 1) {
                            cArray2[n5++] = 173;
                        }
                        ++n8;
                    }
                    n7 = n9 - n2;
                    while (n7 != n9) {
                        cArray2[n5++] = cArray[n3++];
                        ++n7;
                    }
                } else {
                    n6 = 0;
                    while (n6 != n9) {
                        cArray2[n5++] = cArray[n3++];
                        ++n6;
                    }
                }
                bl = false;
                continue;
            }
            if (Character.isLetter(cArray[n4])) {
                n3 = n4;
                bl = true;
            } else {
                if (cArray[n4] == '\u0000') break;
                cArray2[n5++] = cArray[n4];
                if (cArray[n4] == '-' || cArray[n4] == '\u2010') {
                    cArray2[n5++] = 8203;
                }
            }
            ++n4;
        }
        return new String(cArray2, 0, n5);
    }

    void readPattern(Scanner scanner) {
        int n;
        int[] nArray;
        List list;
        block6: {
            list = null;
            List list2 = this.entrytab[scanner.pattern[Character.isDigit(scanner.pattern[0]) ? 1 : 0] % 256];
            nArray = new int[scanner.patlen + 1];
            int n2 = 0;
            n = 0;
            Enumeration enumeration = list2.elements();
            block0: do {
                if (Character.isDigit(scanner.pattern[n2])) {
                    nArray[n++] = scanner.pattern[n2++] - 48;
                    if (n2 == scanner.patlen) {
                        break block6;
                    }
                } else {
                    nArray[n++] = 0;
                }
                do {
                    if (enumeration.hasMoreElements()) continue;
                    int[] nArray2 = new int[n + 1];
                    int n3 = 0;
                    while (n3 != nArray2.length) {
                        nArray2[n3] = 0;
                        ++n3;
                    }
                    list = new List().snoc(new Character(scanner.pattern[n2])).snoc(nArray2);
                    list2.snoc(list);
                    list2 = list;
                    enumeration = list2.elements();
                    enumeration.nextElement();
                    enumeration.nextElement();
                    continue block0;
                } while (((Character)(list = (List)enumeration.nextElement()).car()).charValue() != scanner.pattern[n2]);
                list2 = list;
                enumeration = list2.elements();
                enumeration.nextElement();
                enumeration.nextElement();
            } while (++n2 != scanner.patlen);
            nArray[n++] = 0;
        }
        System.arraycopy(nArray, 0, (int[])list.cdr().car(), 0, n);
    }

    void readException(Scanner scanner) {
        int n = 0;
        int n2 = scanner.patlen;
        while (true) {
            if (n2 == n) {
                return;
            }
            if (scanner.pattern[n] == '-') {
                ++n;
                continue;
            }
            if (scanner.pattern[n2 - 1] != '-') break;
            --n2;
        }
        int[] nArray = new int[n2 - n];
        int n3 = 0;
        int n4 = n;
        while (n4 != n2) {
            if (scanner.pattern[n4] == '-') {
                nArray[n3 - 1] = 1;
            } else {
                scanner.pattern[n3] = scanner.pattern[n4];
                nArray[n3] = 0;
                ++n3;
            }
            ++n4;
        }
        this.exceptions.put(new String(scanner.pattern, 0, n3), nArray);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1 && stringArray.length != 2) {
            System.err.println("Usage: java " + (class$com$renderx$hyphen$TeXHyphenator == null ? (class$com$renderx$hyphen$TeXHyphenator = TeXHyphenator.class$("com.renderx.hyphen.TeXHyphenator")) : class$com$renderx$hyphen$TeXHyphenator).getName() + " table.tex [encoding]");
            System.exit(1);
        }
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, stringArray.length == 1 ? "ISO-8859-1" : stringArray[1]));
        TeXHyphenator teXHyphenator = new TeXHyphenator(bufferedReader, new DefaultErrorHandler());
        ((Reader)bufferedReader).close();
        char[] cArray = new char[8192];
        int n = 0;
        while (true) {
            Object object;
            try {
                object = new InputStreamReader(System.in);
                n = ((Reader)object).read(cArray);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                System.exit(1);
            }
            if (n < 0) {
                System.exit(0);
            }
            object = new StringTokenizer(new String(cArray, 0, n));
            while (((StringTokenizer)object).hasMoreTokens()) {
                System.out.print(teXHyphenator.hyphenate(((StringTokenizer)object).nextToken(), 1, 1).replace('\u00ad', '-'));
                if (!((StringTokenizer)object).hasMoreTokens()) continue;
                System.out.print(" ");
            }
            System.out.println();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Scanner {
        static final short EOF = 0;
        static final short LBRAC = 1;
        static final short RBRAC = 2;
        static final short PATTERNS = 3;
        static final short EXCEPTIONS = 4;
        static final short PATTERN = 5;
        char[] pattern = new char[0];
        int patlen;
        private Reader in;
        private ErrorHandler errHandler;
        private int cc = 10;
        private int cc1 = -1;
        private int prevlno = -1;
        private int lno = 0;
        private int cno = 0;
        private static final Hashtable acctab = new Hashtable();

        private static final int cp2i(int n, int n2) {
            return (n << 8) + n2;
        }

        Scanner(Reader reader, ErrorHandler errorHandler) throws IOException {
            this.in = reader;
            this.errHandler = errorHandler;
            this.read();
        }

        short getSym() {
            block7: while (true) {
                if (this.isSpace()) {
                    this.read();
                    continue;
                }
                switch (this.cc) {
                    case 37: {
                        do {
                            this.read();
                        } while (!this.isNL() && this.cc != -1);
                        continue block7;
                    }
                    case 92: {
                        this.read();
                        if (this.isLetter()) {
                            this.patlen = 0;
                            do {
                                this.cc2pat();
                            } while (this.isLetter());
                            String string = new String(this.pattern, 0, this.patlen);
                            if (string.equals("patterns")) {
                                return 3;
                            }
                            if (string.equals("hyphenation")) {
                                return 4;
                            }
                            if (string.equals("endinput")) {
                                return 0;
                            }
                            this.warning("shamelessly skipping \\" + string);
                            continue block7;
                        }
                    }
                    case 123: {
                        this.read();
                        return 1;
                    }
                    case 125: {
                        this.read();
                        return 2;
                    }
                    case -1: {
                        return 0;
                    }
                }
                if (this.isPatChar()) {
                    this.patlen = 0;
                    do {
                        this.cc2pat();
                    } while (this.isPatChar());
                    if (this.patlen <= 1) continue;
                    return 5;
                }
                this.read();
            }
        }

        private void read() {
            if (this.cc != -1) {
                if (this.isNL()) {
                    ++this.lno;
                    this.cno = 0;
                }
                try {
                    if (this.cc1 != -1) {
                        this.cc = this.cc1;
                        this.cc1 = -1;
                    } else {
                        this.cc = this.in.read();
                    }
                    block1 : switch (this.cc) {
                        case 94: {
                            int n;
                            this.cc1 = this.in.read();
                            if (this.cc1 != 94) break;
                            int n2 = this.in.read();
                            this.cc1 = this.in.read();
                            int n3 = this.hexval(n2);
                            if (n3 != -1 && (n = this.hexval(this.cc1)) != -1) {
                                this.cc = n3 * 16 + n;
                                this.cc1 = -1;
                                break;
                            }
                            this.cc = n2 + 64 & 0x7F;
                            break;
                        }
                        case 92: {
                            this.cc1 = this.in.read();
                            switch (this.cc1) {
                                case 34: 
                                case 39: 
                                case 46: 
                                case 61: 
                                case 72: 
                                case 94: 
                                case 96: 
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 105: 
                                case 107: 
                                case 108: 
                                case 111: 
                                case 114: 
                                case 115: 
                                case 117: 
                                case 118: 
                                case 126: {
                                    Object object;
                                    int n = this.cc1 << 8;
                                    int n4 = -1;
                                    int n5 = this.in.read();
                                    if (n5 == 32 && this.cc1 != 108 && this.cc1 != 111 && this.cc1 != 105 || n5 == 123 || n5 == 92) {
                                        n4 = n5;
                                        n5 = this.in.read();
                                        if (n4 == 123 && n5 == 125) {
                                            n4 = -1;
                                            n5 = 32;
                                        }
                                    }
                                    this.cc1 = -1;
                                    n += n5;
                                    if (n4 == 123) {
                                        this.in.read();
                                    }
                                    this.cc = (object = acctab.get(new Integer(n))) != null ? (Integer)object : n5;
                                    break block1;
                                }
                            }
                            break;
                        }
                    }
                }
                catch (IOException iOException) {
                    this.error(iOException.toString());
                    this.cc = -1;
                }
                ++this.cno;
            }
        }

        private int hexval(int n) {
            switch (n) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return n - 48;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    return n - 97 + 10;
                }
            }
            return -1;
        }

        private void cc2pat() {
            if (this.patlen == this.pattern.length) {
                char[] cArray = new char[this.patlen * 2 + 1];
                System.arraycopy(this.pattern, 0, cArray, 0, this.patlen);
                this.pattern = cArray;
            }
            this.pattern[this.patlen++] = Character.toLowerCase((char)this.cc);
            this.read();
        }

        private boolean isLetter() {
            if (this.cc == -1) {
                return false;
            }
            return Character.isLetter((char)this.cc);
        }

        private boolean isSpace() {
            if (this.cc == -1) {
                return false;
            }
            return Character.isSpaceChar((char)this.cc) || this.isNL();
        }

        private boolean isNL() {
            if (this.cc == 10) {
                return true;
            }
            if (this.cc == 13) {
                if (this.cc1 == -1) {
                    try {
                        this.cc = this.in.read();
                    }
                    catch (IOException iOException) {
                        this.error(iOException.toString());
                        this.cc = -1;
                    }
                } else {
                    this.cc = this.cc1;
                    this.cc1 = -1;
                }
                if (this.cc != 10) {
                    this.cc1 = this.cc;
                }
                return true;
            }
            return false;
        }

        private boolean isPatChar() {
            if (this.cc == -1) {
                return false;
            }
            char c = (char)this.cc;
            return Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '\'';
        }

        private void error(String string) {
            if (this.prevlno == this.lno) {
                return;
            }
            this.prevlno = this.lno;
            this.errHandler.error("(" + this.lno + "," + this.cno + "): " + string);
        }

        private void warning(String string) {
            if (this.prevlno == this.lno) {
                return;
            }
            this.prevlno = this.lno;
            this.errHandler.warning("(" + this.lno + "," + this.cno + "): " + string);
        }

        static {
            acctab.put(new Integer(Scanner.cp2i(96, 97)), new Integer(224));
            acctab.put(new Integer(Scanner.cp2i(96, 101)), new Integer(232));
            acctab.put(new Integer(Scanner.cp2i(96, 105)), new Integer(236));
            acctab.put(new Integer(Scanner.cp2i(96, 111)), new Integer(242));
            acctab.put(new Integer(Scanner.cp2i(96, 117)), new Integer(249));
            acctab.put(new Integer(Scanner.cp2i(96, 119)), new Integer(7809));
            acctab.put(new Integer(Scanner.cp2i(96, 121)), new Integer(7923));
            acctab.put(new Integer(Scanner.cp2i(39, 97)), new Integer(225));
            acctab.put(new Integer(Scanner.cp2i(39, 99)), new Integer(263));
            acctab.put(new Integer(Scanner.cp2i(39, 101)), new Integer(233));
            acctab.put(new Integer(Scanner.cp2i(39, 103)), new Integer(501));
            acctab.put(new Integer(Scanner.cp2i(39, 105)), new Integer(237));
            acctab.put(new Integer(Scanner.cp2i(39, 107)), new Integer(7729));
            acctab.put(new Integer(Scanner.cp2i(39, 108)), new Integer(314));
            acctab.put(new Integer(Scanner.cp2i(39, 109)), new Integer(7743));
            acctab.put(new Integer(Scanner.cp2i(39, 110)), new Integer(324));
            acctab.put(new Integer(Scanner.cp2i(39, 111)), new Integer(243));
            acctab.put(new Integer(Scanner.cp2i(39, 112)), new Integer(7765));
            acctab.put(new Integer(Scanner.cp2i(39, 114)), new Integer(341));
            acctab.put(new Integer(Scanner.cp2i(39, 115)), new Integer(347));
            acctab.put(new Integer(Scanner.cp2i(39, 117)), new Integer(250));
            acctab.put(new Integer(Scanner.cp2i(39, 119)), new Integer(7811));
            acctab.put(new Integer(Scanner.cp2i(39, 121)), new Integer(253));
            acctab.put(new Integer(Scanner.cp2i(39, 122)), new Integer(378));
            acctab.put(new Integer(Scanner.cp2i(94, 97)), new Integer(226));
            acctab.put(new Integer(Scanner.cp2i(94, 99)), new Integer(265));
            acctab.put(new Integer(Scanner.cp2i(94, 101)), new Integer(234));
            acctab.put(new Integer(Scanner.cp2i(94, 103)), new Integer(285));
            acctab.put(new Integer(Scanner.cp2i(94, 104)), new Integer(293));
            acctab.put(new Integer(Scanner.cp2i(94, 105)), new Integer(238));
            acctab.put(new Integer(Scanner.cp2i(94, 106)), new Integer(309));
            acctab.put(new Integer(Scanner.cp2i(94, 111)), new Integer(244));
            acctab.put(new Integer(Scanner.cp2i(94, 115)), new Integer(349));
            acctab.put(new Integer(Scanner.cp2i(94, 117)), new Integer(251));
            acctab.put(new Integer(Scanner.cp2i(94, 119)), new Integer(373));
            acctab.put(new Integer(Scanner.cp2i(94, 121)), new Integer(375));
            acctab.put(new Integer(Scanner.cp2i(94, 122)), new Integer(7825));
            acctab.put(new Integer(Scanner.cp2i(34, 97)), new Integer(228));
            acctab.put(new Integer(Scanner.cp2i(34, 101)), new Integer(235));
            acctab.put(new Integer(Scanner.cp2i(34, 104)), new Integer(7719));
            acctab.put(new Integer(Scanner.cp2i(34, 105)), new Integer(239));
            acctab.put(new Integer(Scanner.cp2i(34, 111)), new Integer(246));
            acctab.put(new Integer(Scanner.cp2i(34, 116)), new Integer(7831));
            acctab.put(new Integer(Scanner.cp2i(34, 117)), new Integer(252));
            acctab.put(new Integer(Scanner.cp2i(34, 119)), new Integer(7813));
            acctab.put(new Integer(Scanner.cp2i(34, 120)), new Integer(7821));
            acctab.put(new Integer(Scanner.cp2i(34, 121)), new Integer(255));
            acctab.put(new Integer(Scanner.cp2i(72, 111)), new Integer(337));
            acctab.put(new Integer(Scanner.cp2i(72, 117)), new Integer(369));
            acctab.put(new Integer(Scanner.cp2i(126, 97)), new Integer(227));
            acctab.put(new Integer(Scanner.cp2i(126, 101)), new Integer(7869));
            acctab.put(new Integer(Scanner.cp2i(126, 105)), new Integer(297));
            acctab.put(new Integer(Scanner.cp2i(126, 110)), new Integer(241));
            acctab.put(new Integer(Scanner.cp2i(126, 111)), new Integer(245));
            acctab.put(new Integer(Scanner.cp2i(126, 117)), new Integer(361));
            acctab.put(new Integer(Scanner.cp2i(126, 118)), new Integer(7805));
            acctab.put(new Integer(Scanner.cp2i(126, 121)), new Integer(7929));
            acctab.put(new Integer(Scanner.cp2i(117, 97)), new Integer(259));
            acctab.put(new Integer(Scanner.cp2i(117, 101)), new Integer(277));
            acctab.put(new Integer(Scanner.cp2i(117, 103)), new Integer(287));
            acctab.put(new Integer(Scanner.cp2i(117, 105)), new Integer(301));
            acctab.put(new Integer(Scanner.cp2i(117, 111)), new Integer(335));
            acctab.put(new Integer(Scanner.cp2i(117, 117)), new Integer(365));
            acctab.put(new Integer(Scanner.cp2i(118, 97)), new Integer(462));
            acctab.put(new Integer(Scanner.cp2i(118, 32)), new Integer(711));
            acctab.put(new Integer(Scanner.cp2i(118, 99)), new Integer(269));
            acctab.put(new Integer(Scanner.cp2i(118, 100)), new Integer(271));
            acctab.put(new Integer(Scanner.cp2i(118, 101)), new Integer(283));
            acctab.put(new Integer(Scanner.cp2i(118, 103)), new Integer(487));
            acctab.put(new Integer(Scanner.cp2i(118, 105)), new Integer(464));
            acctab.put(new Integer(Scanner.cp2i(118, 106)), new Integer(496));
            acctab.put(new Integer(Scanner.cp2i(118, 107)), new Integer(489));
            acctab.put(new Integer(Scanner.cp2i(118, 108)), new Integer(318));
            acctab.put(new Integer(Scanner.cp2i(118, 110)), new Integer(328));
            acctab.put(new Integer(Scanner.cp2i(118, 111)), new Integer(466));
            acctab.put(new Integer(Scanner.cp2i(118, 114)), new Integer(345));
            acctab.put(new Integer(Scanner.cp2i(118, 115)), new Integer(353));
            acctab.put(new Integer(Scanner.cp2i(118, 116)), new Integer(357));
            acctab.put(new Integer(Scanner.cp2i(118, 117)), new Integer(468));
            acctab.put(new Integer(Scanner.cp2i(118, 122)), new Integer(382));
            acctab.put(new Integer(Scanner.cp2i(99, 99)), new Integer(231));
            acctab.put(new Integer(Scanner.cp2i(99, 100)), new Integer(7697));
            acctab.put(new Integer(Scanner.cp2i(99, 103)), new Integer(291));
            acctab.put(new Integer(Scanner.cp2i(99, 104)), new Integer(7721));
            acctab.put(new Integer(Scanner.cp2i(99, 107)), new Integer(311));
            acctab.put(new Integer(Scanner.cp2i(99, 108)), new Integer(316));
            acctab.put(new Integer(Scanner.cp2i(99, 110)), new Integer(326));
            acctab.put(new Integer(Scanner.cp2i(99, 114)), new Integer(343));
            acctab.put(new Integer(Scanner.cp2i(99, 115)), new Integer(351));
            acctab.put(new Integer(Scanner.cp2i(99, 116)), new Integer(355));
            acctab.put(new Integer(Scanner.cp2i(100, 97)), new Integer(7841));
            acctab.put(new Integer(Scanner.cp2i(100, 98)), new Integer(7685));
            acctab.put(new Integer(Scanner.cp2i(100, 100)), new Integer(7693));
            acctab.put(new Integer(Scanner.cp2i(100, 101)), new Integer(7865));
            acctab.put(new Integer(Scanner.cp2i(100, 104)), new Integer(7717));
            acctab.put(new Integer(Scanner.cp2i(100, 105)), new Integer(7883));
            acctab.put(new Integer(Scanner.cp2i(100, 107)), new Integer(7731));
            acctab.put(new Integer(Scanner.cp2i(100, 108)), new Integer(7735));
            acctab.put(new Integer(Scanner.cp2i(100, 109)), new Integer(7747));
            acctab.put(new Integer(Scanner.cp2i(100, 110)), new Integer(7751));
            acctab.put(new Integer(Scanner.cp2i(100, 111)), new Integer(7885));
            acctab.put(new Integer(Scanner.cp2i(100, 114)), new Integer(7771));
            acctab.put(new Integer(Scanner.cp2i(100, 115)), new Integer(7779));
            acctab.put(new Integer(Scanner.cp2i(100, 116)), new Integer(7789));
            acctab.put(new Integer(Scanner.cp2i(100, 117)), new Integer(7909));
            acctab.put(new Integer(Scanner.cp2i(100, 118)), new Integer(7807));
            acctab.put(new Integer(Scanner.cp2i(100, 119)), new Integer(7817));
            acctab.put(new Integer(Scanner.cp2i(100, 121)), new Integer(7925));
            acctab.put(new Integer(Scanner.cp2i(100, 122)), new Integer(7827));
            acctab.put(new Integer(Scanner.cp2i(46, 99)), new Integer(267));
            acctab.put(new Integer(Scanner.cp2i(46, 101)), new Integer(279));
            acctab.put(new Integer(Scanner.cp2i(46, 103)), new Integer(289));
            acctab.put(new Integer(Scanner.cp2i(46, 108)), new Integer(320));
            acctab.put(new Integer(Scanner.cp2i(46, 122)), new Integer(380));
            acctab.put(new Integer(Scanner.cp2i(114, 97)), new Integer(229));
            acctab.put(new Integer(Scanner.cp2i(114, 117)), new Integer(367));
            acctab.put(new Integer(Scanner.cp2i(114, 119)), new Integer(7832));
            acctab.put(new Integer(Scanner.cp2i(114, 121)), new Integer(7833));
            acctab.put(new Integer(Scanner.cp2i(107, 97)), new Integer(261));
            acctab.put(new Integer(Scanner.cp2i(107, 101)), new Integer(281));
            acctab.put(new Integer(Scanner.cp2i(107, 105)), new Integer(303));
            acctab.put(new Integer(Scanner.cp2i(107, 111)), new Integer(491));
            acctab.put(new Integer(Scanner.cp2i(107, 117)), new Integer(371));
            acctab.put(new Integer(Scanner.cp2i(97, 97)), new Integer(229));
            acctab.put(new Integer(Scanner.cp2i(97, 101)), new Integer(230));
            acctab.put(new Integer(Scanner.cp2i(105, 32)), new Integer(305));
            acctab.put(new Integer(Scanner.cp2i(108, 32)), new Integer(322));
            acctab.put(new Integer(Scanner.cp2i(111, 32)), new Integer(248));
            acctab.put(new Integer(Scanner.cp2i(111, 101)), new Integer(339));
            acctab.put(new Integer(Scanner.cp2i(115, 115)), new Integer(223));
        }
    }
}

