/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics.vector;

import com.renderx.graphics.vector.PaintSpec;
import java.io.IOException;
import java.io.PrintStream;

public abstract class OpaqueColor
extends PaintSpec {
    public abstract double[] values();

    public abstract RGB toRGB();

    public static class Registration
    extends OpaqueColor {
        public double tint;

        public Registration(double d) {
            this.tint = d;
        }

        public double[] values() {
            return new double[]{this.tint};
        }

        public RGB toRGB() {
            return new RGB(this.tint, this.tint, this.tint);
        }

        public void dump(PrintStream printStream, String string) throws IOException {
            printStream.println(string + "%<registration-color tint=\"" + this.tint + "\">");
            printStream.println(string + "  " + (1.0 - this.tint) + " setgray");
            printStream.println(string + "%</registration-color>");
        }
    }

    public static class SpotColor
    extends OpaqueColor {
        public double tint;
        public OpaqueColor altcolor;
        public String colorant;

        public SpotColor(double d, String string, double d2, double d3, double d4, double d5) {
            this.colorant = string;
            this.tint = d;
            this.altcolor = new CMYK(d2, d3, d4, d5);
        }

        public SpotColor(double d, String string, double d2) {
            this.colorant = string;
            this.tint = d;
            this.altcolor = new Grayscale(d2);
        }

        public SpotColor(double d, String string) {
            this.colorant = string;
            this.tint = d;
            this.altcolor = new Grayscale(0.0);
        }

        public double[] values() {
            return this.altcolor.values();
        }

        public RGB toRGB() {
            return this.altcolor.toRGB();
        }

        public void dump(PrintStream printStream, String string) throws IOException {
            printStream.println(string + "%<spot-color colorant=\"" + this.colorant + "\" tint=\"" + this.tint + "\">");
            printStream.println(string + "   0 0 0 " + this.tint + " setcmykcolor");
            printStream.println(string + "%</spot-color>");
        }
    }

    public static class CMYK
    extends OpaqueColor {
        public double c;
        public double m;
        public double y;
        public double k;

        public CMYK(double d, double d2, double d3, double d4) {
            this.c = d;
            this.m = d2;
            this.y = d3;
            this.k = d4;
        }

        public double[] values() {
            return new double[]{this.c, this.m, this.y, this.k};
        }

        public RGB toRGB() {
            double d = 1.0 - this.k;
            return new RGB(d > this.c ? d - this.c : 0.0, d > this.m ? d - this.m : 0.0, d > this.y ? d - this.y : 0.0);
        }

        public void dump(PrintStream printStream, String string) throws IOException {
            printStream.println(string + "%<cmyk-color cyan=\"" + this.c + "\" magenta=\"" + this.m + "\" yellow=\"" + this.y + "\" black=\"" + this.k + "\">");
            printStream.println(string + "  " + this.c + " " + this.m + " " + this.y + " " + this.k + " setcmykcolor");
            printStream.println(string + "%</cmyk-color>");
        }
    }

    public static class Grayscale
    extends OpaqueColor {
        public double g;

        public Grayscale(double d) {
            this.g = d;
        }

        public double[] values() {
            return new double[]{this.g};
        }

        public RGB toRGB() {
            return new RGB(this.g, this.g, this.g);
        }

        public void dump(PrintStream printStream, String string) throws IOException {
            printStream.println(string + "%<grayscale gray=\"" + this.g + "\">");
            printStream.println(string + "  " + this.g + " setgray");
            printStream.println(string + "%</grayscale>");
        }
    }

    public static class RGB
    extends OpaqueColor {
        public double r;
        public double g;
        public double b;

        public RGB(double d, double d2, double d3) {
            this.r = d;
            this.g = d2;
            this.b = d3;
        }

        public double[] values() {
            return new double[]{this.r, this.g, this.b};
        }

        public RGB toRGB() {
            return this;
        }

        public void dump(PrintStream printStream, String string) throws IOException {
            printStream.println(string + "%<rgb-color red=\"" + this.r + "\" green=\"" + this.g + "\" blue=\"" + this.b + "\">");
            printStream.println(string + "  " + this.r + " " + this.g + " " + this.b + " setrgbcolor");
            printStream.println(string + "%</rgb-color>");
        }
    }
}

