/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.Media;
import com.renderx.graphics.ObjectRecordCoordinator;
import com.renderx.util.SeekableInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class MPEG
extends Media {
    private static final int pictureStartCode = 0;
    private static final int sliceStartCodeFirst = 1;
    private static final int sliceStartCodeLast = 175;
    private static final Hashtable reserved = new Hashtable();
    private static final int userDataCode = 178;
    private static final int sequenceHeaderCode = 179;
    private static final int sequenceErrorCode = 180;
    private static final int extensionStartCode = 181;
    private static final int sequenceEndCode = 183;
    private static final int groupOfPicturesStartCode = 184;
    private static final int programEnd = 185;
    private static final int packStartCode = 186;
    private static final int systemStartCodesFirst = 187;
    private static final int systemStartCodesLast = 255;
    private static final int videoStreamCodesFirst = 224;
    private static final int videoStreamCodesLast = 239;

    public MPEG() {
        this.mimetype = "video/mpeg";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse() throws IOException, ImageFormatException {
        long l = 0L;
        this.canCopyData = true;
        SeekableInput seekableInput = this.openSeekableImageStream();
        try {
            try {
                seekableInput.seek(0L);
                byte[] byArray = new byte[3];
                seekableInput.readFully(byArray);
                if (byArray[0] != 0 || byArray[1] != 0 || byArray[2] != 1) {
                    throw new ImageFormatException("Invalid MPEG signature in file '" + this.toDisplayString() + "'");
                }
                int n = seekableInput.read();
                int[] nArray = new int[3];
                int[] nArray2 = new int[]{0, 0, 1};
                while (n != 183 || n != 185 || seekableInput.getFilePointer() < seekableInput.length() || n != -1) {
                    long[] lArray;
                    if (n == 179) {
                        lArray = this.readBits(seekableInput, 12L, 0L, 0L);
                        this.pxWidth = lArray[0];
                        lArray = this.readBits(seekableInput, 12L, lArray[1], lArray[2]);
                        this.pxHeight = lArray[0];
                        break;
                    }
                    if (n >= 187 && n < 224 || n > 239 && n <= 255) {
                        lArray = this.readBits(seekableInput, 16L, 0L, 0L);
                        seekableInput.seek(seekableInput.getFilePointer() + lArray[0]);
                        if (this.nextStartCode(seekableInput)) {
                            n = seekableInput.read();
                            continue;
                        }
                    } else if (this.nextStartCode(seekableInput)) {
                        n = seekableInput.read();
                        continue;
                    }
                    break;
                }
            }
            catch (EOFException eOFException) {
                throw new ImageFormatException("Premature end of file or corrupt data in MPEG media " + this.toDisplayString(), this.mimetype);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
        this.setDimensions();
    }

    /*
     * Unable to fully structure code
     */
    boolean nextStartCode(SeekableInput var1_1) throws IOException {
        var2_2 = new int[3];
        var3_3 = new int[]{0, 0, 1};
        var2_2[0] = var1_1.read();
        if (var2_2[0] == -1) {
            return false;
        }
        var2_2[1] = var1_1.read();
        if (var2_2[1] == -1) {
            return false;
        }
        var2_2[2] = var1_1.read();
        if (var2_2[2] != -1) ** GOTO lbl17
        return false;
lbl-1000:
        // 1 sources

        {
            var2_2[0] = var2_2[1];
            var2_2[1] = var2_2[2];
            var2_2[2] = var1_1.read();
            if (var2_2[2] != -1) continue;
            return false;
lbl17:
            // 2 sources

            ** while (var2_2[0] != var3_3[0] || var2_2[1] != var3_3[1] || var2_2[2] != var3_3[2])
        }
lbl18:
        // 1 sources

        return true;
    }

    long[] readBits(SeekableInput seekableInput, long l, long l2, long l3) throws IOException {
        long l4 = 0L;
        if (l <= l2) {
            l4 = l3 >> (int)(l2 - l);
            l3 &= (long)((1 << (int)(l2 -= l)) - 1);
        } else {
            int n;
            l4 = l3;
            long l5 = (l - l2) / 8L;
            int n2 = 0;
            while ((long)n2 < l5) {
                n = seekableInput.read();
                if (n < 0) {
                    throw new EOFException();
                }
                l4 = (l4 << 8) + (long)n;
                ++n2;
            }
            if ((l2 = (8L - (l - l2) % 8L) % 8L) > 0L) {
                n = seekableInput.read();
                if (n < 0) {
                    throw new EOFException();
                }
                l3 = n & (1 << (int)l2) - 1;
                l4 = (l4 << (int)(8L - l2)) + (long)(n >> (int)l2);
            } else {
                l3 = 0L;
            }
        }
        return new long[]{l4, l2, l3};
    }

    public void copyData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        InputStream inputStream = this.openImageStream();
        try {
            int n;
            byte[] byArray = new byte[objectRecordCoordinator != null ? objectRecordCoordinator.getRecordLength() : 8192];
            while ((n = inputStream.read(byArray)) != -1) {
                if (objectRecordCoordinator != null) {
                    objectRecordCoordinator.beginRecord(outputStream, n);
                }
                outputStream.write(byArray, 0, n);
                if (objectRecordCoordinator == null) continue;
                objectRecordCoordinator.endRecord(outputStream, n);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    static {
        reserved.put("176", "176");
        reserved.put("177", "177");
        reserved.put("182", "182");
        reserved.put("250", "250");
        reserved.put("251", "251");
        reserved.put("252", "252");
        reserved.put("253", "253");
        reserved.put("254", "254");
    }
}

