/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

import com.renderx.fonts.CFFMetric;
import com.renderx.fonts.FontFileFormatError;
import com.renderx.fonts.UsedGlyphs;
import com.renderx.util.Array;
import com.renderx.util.SeekableFileInputStream;
import com.renderx.util.SeekableInput;
import com.renderx.util.SeekableInputOffsetFilter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import junit.framework.TestCase;

public class CFFFont {
    public UsedGlyphs used = new UsedGlyphs();
    public final int format;
    private final CFFMetric cffm;
    private final SeekableInput in;
    private static final int TYPE1 = 1;
    private static final int TYPE2 = 2;
    private Array charstrings = new Array();
    private Array lsubrs = new Array();

    public CFFFont(SeekableInput seekableInput, CFFMetric cFFMetric) throws IOException, FontFileFormatError {
        this.in = seekableInput;
        this.cffm = cFFMetric;
        this.used.clearGlyphs();
        this.format = cFFMetric.charstringType;
        this.init();
        this.addGlyph(0);
    }

    public void init() throws IOException, FontFileFormatError {
        this.in.seek(this.cffm.charstringsOffset);
        this.charstrings = this.cffm.readINDEXData(this.in);
        if (!this.cffm.isCIDFont) {
            this.in.seek(this.cffm.privateDictOffset + this.cffm.localSubrsOffset);
            if (this.cffm.localSubrsOffset != -1L) {
                this.lsubrs = this.cffm.readINDEXData(this.in);
            }
        }
    }

    public void addGlyph(int n) throws FontFileFormatError {
        if (this.used.checkGlyph((char)n)) {
            return;
        }
        this.used.markGlyph((char)n);
        if (this.format == 1) {
            // empty if block
        }
        if (this.format == 2) {
            byte[] byArray = (byte[])this.charstrings.get(n);
            int[] nArray = null;
            nArray = this.cffm.composeGlyphs(byArray, this.lsubrs, this.cffm.globalSubrs);
            if (nArray != null) {
                this.addGlyph(nArray[0]);
                this.addGlyph(nArray[1]);
            }
        }
    }

    public byte[] createSubset() throws IOException, FontFileFormatError {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.in.seek(0L);
        byte[] byArray = new byte[(int)this.cffm.charstringsOffset];
        this.in.readFully(byArray);
        byteArrayOutputStream.write(byArray);
        int n2 = this.cffm.readINDEXElementsCount(this.in);
        int n3 = this.cffm.readINDEXOffsetElementSize(this.in);
        byteArrayOutputStream.write(this.int2short(n2));
        byteArrayOutputStream.write(n3);
        this.writeIn2Out(this.in, byteArrayOutputStream, (n2 + 1) * n3);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            n = this.cffm.isCIDFont ? this.cffm.getGlyphCID(n5) : n5;
            byte[] byArray2 = (byte[])this.charstrings.get(n5);
            n4 += byArray2.length;
            if (!this.used.checkGlyph((char)n)) {
                int n6 = 0;
                while (n6 < byArray2.length) {
                    byArray2[n6] = 14;
                    ++n6;
                }
            }
            byteArrayOutputStream.write(byArray2);
            ++n5;
        }
        this.in.skipBytes(n4);
        byArray = new byte[16384];
        n = -1;
        while ((n = this.in.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    byte[] int2short(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    void writeIn2Out(SeekableInput seekableInput, OutputStream outputStream, long l) throws IOException, FontFileFormatError {
        if (l < 0L) {
            throw new FontFileFormatError("Trying to write data of negative length; CFF subsetting is broken");
        }
        long l2 = l;
        byte[] byArray = new byte[16384];
        while (l2 > 0L) {
            int n = l2 > (long)byArray.length ? byArray.length : (int)l2;
            seekableInput.read(byArray, 0, n);
            outputStream.write(byArray, 0, n);
            l2 -= (long)n;
        }
    }

    public static class Test
    extends TestCase {
        public void testCFFMetricCreation() throws IOException, FontFileFormatError {
            try {
                this.resourceToFile("com/renderx/fonts/TEST_DATA/TimesRoman.test", "temp.tst");
                CFFMetric cFFMetric = new CFFMetric(new SeekableInputOffsetFilter(new SeekableFileInputStream("temp.tst"), 0L), null);
                Assert.assertTrue((boolean)true);
            }
            catch (FontFileFormatError fontFileFormatError) {
                Assert.assertTrue((boolean)"Support for OpenType/CFF fonts with predefined charset not implemented yet".equals(fontFileFormatError.getMessage()));
            }
        }

        private void resourceToFile(String string, String string2) throws IOException {
            int n;
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray, 0, 1024)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
        }
    }
}

