/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib.orders;

import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.XImage;
import com.renderx.afplib.orders.Orders;
import com.renderx.util.ErrorHandler;
import java.io.IOException;

public class IocaOrders
extends Orders {
    private static final int END_IMAGE_CONTENT_ORDER_CODE = 147;
    private static final int IMAGE_SIZE_PARAMETERS_ORDER_CODE = 148;
    private static final short BEGIN_IMAGE_CONTENT_ORDER_CODE = 145;

    public IocaOrders(AFP aFP, ErrorHandler errorHandler) {
        super(aFP, errorHandler);
    }

    public void writeBeginImageContent() throws IOException, AFPInternalException {
        this.afp.writeIocaLSDF(145, 1);
        this.afp.writeByte(255);
    }

    public void writeEndImageContent() throws IOException {
        this.afp.writeIocaLSDF(147, 0);
    }

    public void writeImageSize(XImage xImage) throws IOException, AFPInternalException {
        this.afp.writeIocaLSDF(148, 9);
        this.afp.writeByte(1);
        this.afp.writeResolution(xImage.getResolution());
        this.afp.writePoint2bytes(xImage.pixelSize);
    }

    public void writeImageEncoding(XImage xImage) throws IOException, AFPInternalException {
        this.afp.writeIocaLSDF(149, 2);
        this.afp.writeByte(xImage.getIOCAEncodingCode());
        this.afp.writeByte(1);
    }

    public void writeFunctionSetIdentification(int n) throws IOException, AFPInternalException {
        this.afp.writeIocaLSDF(247, 2);
        this.afp.writeByte(1);
        this.afp.writeByte(n);
    }

    public void writeTOC() throws IllegalArgumentException, AFPInternalException, IOException {
        this.afp.writeNBytes(28672L, 2);
        this.afp.writeNBytes(9503231L, 3);
        this.afp.writeNBytes(-19421764803064832L, 8);
    }
}

