/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.TIFFFaxEncoder;
import com.renderx.afplib.XImage;
import com.renderx.graphics.Image;
import java.io.IOException;
import java.net.MalformedURLException;

public class XTIFFFaxImage
extends XImage {
    protected static int[] NEGATIVE_BITMASK = new int[]{127, 191, 223, 239, 247, 251, 253, 254};

    protected XTIFFFaxImage(Image image) {
        super(image);
    }

    public void loadImage() throws MalformedURLException, IOException {
        int n;
        int n2;
        if (this.raster != null) {
            return;
        }
        super.loadImage();
        int n3 = this.pixelSize.x / 8;
        if (n3 * 8 < this.pixelSize.x) {
            ++n3;
        }
        byte[] byArray = new byte[this.pixelSize.y * n3];
        int n4 = 0;
        for (int i = 0; i < this.pixelSize.y; ++i) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n5;
                n = n2 * 8;
                int n6 = 255;
                for (n5 = 0; n5 < 8; ++n5) {
                    if (n + n5 >= this.pixelSize.x) {
                        n6 &= NEGATIVE_BITMASK[n5];
                        continue;
                    }
                    if (XTIFFFaxImage.grayWeight(this.raster, i, n + n5) <= 127) continue;
                    n6 &= NEGATIVE_BITMASK[n5];
                    ++n4;
                }
                n5 = n3 * i + n2;
                byArray[n5] = (byte)(n6 & 0xFF);
            }
        }
        this.pixelSize.x = n3 * 8;
        byte[] byArray2 = new byte[this.pixelSize.y * n3 * 3];
        n2 = new TIFFFaxEncoder(false).encodeT6(byArray, n3, 0, this.pixelSize.x, this.pixelSize.y, byArray2);
        this.data = new byte[n2];
        for (n = 0; n < n2; ++n) {
            this.data[n] = byArray2[n];
        }
    }

    public short getIOCAEncodingCode() {
        return 130;
    }

    public short getIDESize() {
        return 1;
    }
}

